/*
 * Decompiled with CFR 0.152.
 */
package com.sunyard.client.bean;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfGState;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfStamper;
import com.sunyard.exception.SunECMException;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import org.apache.log4j.Logger;

public class MarkContentBean {
    private static Logger log = Logger.getLogger(MarkContentBean.class);

    public void fillFullWarterMark(String srcPdfAddress, String tarPdfAddress, ArrayList<String> waterMarkContentList) {
        log.debug((Object)"\u5f00\u59cb\u4e3a\u6bcf\u4e00\u9875\u6dfb\u52a0\u6c34\u5370");
        PdfReader reader = null;
        FileOutputStream outPdfStream = null;
        PdfStamper stamper = null;
        try {
            try {
                reader = new PdfReader(srcPdfAddress);
                outPdfStream = new FileOutputStream(tarPdfAddress);
                stamper = new PdfStamper(reader, (OutputStream)outPdfStream);
                BaseFont base = BaseFont.createFont((String)"STSong-Light", (String)"UniGB-UCS2-H", (boolean)false);
                int total = reader.getNumberOfPages() + 1;
                int i = 1;
                while (i < total) {
                    Rectangle pageRect = reader.getPageSize(i);
                    PdfContentByte under = stamper.getOverContent(i);
                    PdfGState gs = new PdfGState();
                    gs.setFillOpacity(0.5f);
                    under.setGState(gs);
                    under.beginText();
                    under.setFontAndSize(base, 18.0f);
                    under.setTextMatrix(30.0f, 30.0f);
                    under.setColorFill(BaseColor.BLUE);
                    int length = waterMarkContentList.size() / 2;
                    int j = 0;
                    while (j < waterMarkContentList.size()) {
                        if (j == length) {
                            under.showTextAligned(1, waterMarkContentList.get(j), pageRect.getWidth() / 2.0f, pageRect.getHeight() / 2.0f, -45.0f);
                        } else if (j < length) {
                            under.showTextAligned(1, waterMarkContentList.get(j), pageRect.getWidth() / 2.0f, pageRect.getHeight() / 2.0f + (float)(50 * (length - j)), -45.0f);
                        } else if (j > length) {
                            under.showTextAligned(1, waterMarkContentList.get(j), pageRect.getWidth() / 2.0f, pageRect.getHeight() / 2.0f - (float)(50 * (j - length)), -45.0f);
                        }
                        ++j;
                    }
                    under.endText();
                    ++i;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                try {
                    stamper.close();
                    outPdfStream.close();
                    reader.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        finally {
            try {
                stamper.close();
                outPdfStream.close();
                reader.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void fillOnePageWarterMark(String srcPdfAddress, String tarPdfAddress, ArrayList<String> waterMarkContentList, int pageNum) {
        PdfReader reader = null;
        FileOutputStream outPdfStream = null;
        PdfStamper stamper = null;
        try {
            try {
                reader = new PdfReader(srcPdfAddress);
                int total = reader.getNumberOfPages() + 1;
                if (pageNum > total) {
                    throw new SunECMException("\u8bbe\u7f6e\u6c34\u5370\u7684\u9875\u7801\u8d85\u51faPDF\u7684\u9875\u7801\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e");
                }
                outPdfStream = new FileOutputStream(tarPdfAddress);
                stamper = new PdfStamper(reader, (OutputStream)outPdfStream);
                BaseFont base = BaseFont.createFont((String)"STSong-Light", (String)"UniGB-UCS2-H", (boolean)false);
                Rectangle pageRect = reader.getPageSize(pageNum);
                PdfContentByte under = stamper.getOverContent(pageNum);
                PdfGState gs = new PdfGState();
                gs.setFillOpacity(0.5f);
                under.setGState(gs);
                under.beginText();
                under.setFontAndSize(base, 18.0f);
                under.setTextMatrix(30.0f, 30.0f);
                under.setColorFill(BaseColor.BLUE);
                int length = waterMarkContentList.size() / 2;
                int j = 0;
                while (j < waterMarkContentList.size()) {
                    if (j == length) {
                        under.showTextAligned(1, waterMarkContentList.get(j), pageRect.getWidth() / 2.0f, pageRect.getHeight() / 2.0f, -45.0f);
                    } else if (j < length) {
                        under.showTextAligned(1, waterMarkContentList.get(j), pageRect.getWidth() / 2.0f, pageRect.getHeight() / 2.0f + (float)(50 * (length - j)), -45.0f);
                    } else if (j > length) {
                        under.showTextAligned(1, waterMarkContentList.get(j), pageRect.getWidth() / 2.0f, pageRect.getHeight() / 2.0f - (float)(50 * (j - length)), -45.0f);
                    }
                    ++j;
                }
                under.endText();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                try {
                    stamper.close();
                    outPdfStream.close();
                    reader.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        finally {
            try {
                stamper.close();
                outPdfStream.close();
                reader.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void addWarterContent(String srcPdfAddress, String tarPdfAddress, ArrayList<String> waterMarkContentList, boolean fillPage, int pageNum) throws SunECMException {
        log.debug((Object)("\u5f00\u59cb\u4e3a\u6307\u5b9a\u9875\u6dfb\u52a0\u6c34\u5370\uff0c\u6307\u5b9a\u7684\u9875\u7801\uff1a" + pageNum));
        if (srcPdfAddress == null || "".equals(srcPdfAddress)) {
            throw new SunECMException("\u539f\u6587\u4ef6\u8def\u5f84\u4e3a\u7a7a\uff0c\u8bf7\u8bbe\u7f6e\u539f\u6587\u4ef6\u7684\u8def\u5f84");
        }
        if (tarPdfAddress == null || "".equals(tarPdfAddress)) {
            throw new SunECMException("\u4f20\u5165\u7684\u5b58\u653ePDF\u6587\u4ef6\u5730\u5740\u4e3a\u7a7a\uff0c\u8bf7\u8bbe\u7f6ePDF\u6587\u4ef6\u8def\u5f84");
        }
        if (waterMarkContentList == null || waterMarkContentList.size() == 0) {
            throw new SunECMException("\u8bbe\u7f6e\u6c34\u5370\u7684\u5185\u5bb9\u4e3a\u7a7a\uff0c\u8bf7\u8bbe\u7f6e\u6dfb\u52a0\u6c34\u5370\u7684\u5185\u5bb9");
        }
        if (fillPage) {
            log.debug((Object)"\u5f00\u59cb\u4e3a\u6bcf\u4e00\u9875\u6dfb\u52a0\u6c34\u5370");
            this.fillFullWarterMark(srcPdfAddress, tarPdfAddress, waterMarkContentList);
        } else {
            log.debug((Object)("\u5f00\u59cb\u4e3a\u6307\u5b9a\u9875\u6dfb\u52a0\u6c34\u5370\uff0c\u6307\u5b9a\u7684\u9875\u7801\uff1a" + pageNum));
            this.fillOnePageWarterMark(srcPdfAddress, tarPdfAddress, waterMarkContentList, pageNum);
        }
    }

    private static int getContentWidth(Font font, String waterMarkContent, Graphics2D g) {
        FontMetrics metrics = g.getFontMetrics(font);
        int width = 0;
        int i = 0;
        while (i < waterMarkContent.length()) {
            width += metrics.charWidth(waterMarkContent.charAt(i));
            ++i;
        }
        return width;
    }

    private static int getContentHeight(Font font, String waterMarkContent, Graphics2D g) {
        FontMetrics metrics = g.getFontMetrics(font);
        int height = metrics.getHeight();
        return height;
    }

    public void addWaterMark(String srcImagePath, String tarImgPath, ArrayList<String> contentList, Color markContentColor, Font font) {
        try {
            log.debug((Object)"\u5f00\u59cb\u4e3a\u6307\u5b9a\u56fe\u7247\u6dfb\u52a0\u6c34\u5370");
            File srcImgFile = new File(srcImagePath);
            BufferedImage srcImg = ImageIO.read(srcImgFile);
            int srcImgWidth = ((Image)srcImg).getWidth(null);
            int srcImgHeight = ((Image)srcImg).getHeight(null);
            BufferedImage bufImg = new BufferedImage(srcImgWidth, srcImgHeight, 1);
            Graphics2D g = bufImg.createGraphics();
            g.drawImage(srcImg, 0, 0, srcImgWidth, srcImgHeight, null);
            g.rotate(Math.toRadians(0.0), bufImg.getWidth() / 2, bufImg.getHeight() / 2);
            g.setColor(markContentColor);
            g.setFont(font);
            g.setComposite(AlphaComposite.getInstance(10, 0.5f));
            int count = 0;
            for (String waterMarkContent : contentList) {
                int l = 0;
                if (count == 0) {
                    l = 100;
                } else if (count == 1) {
                    l = 0;
                } else if (count == 2) {
                    l = -100;
                }
                g.drawString(waterMarkContent, (srcImgWidth - MarkContentBean.getContentWidth(font, waterMarkContent, g)) / 2, (srcImgHeight - MarkContentBean.getContentHeight(font, waterMarkContent, g) - l) / 2);
                ++count;
            }
            g.dispose();
            FileOutputStream outImgStream = new FileOutputStream(tarImgPath);
            ImageIO.write((RenderedImage)bufImg, "jpg", outImgStream);
            outImgStream.flush();
            outImgStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

