/*
 * Decompiled with CFR 0.152.
 */
package com.sunyard.client.conn;

import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class FlowController
extends FilterInputStream {
    private long timestamp;
    private int maxbps;
    private int currentbps;
    private int bytesread;

    public static void main(String[] args) {
        try {
            byte[] buffer = new byte[1024];
            long start = System.currentTimeMillis();
            FileInputStream in = new FileInputStream("F:\\tmp\\PMBOK2008\u4e2d\u6587\u7248.pdf");
            FlowController fin = new FlowController(in, 1000000);
            System.out.println("\u5f53\u524d\u901f\u7387" + fin.check() / 1000 + "kbps");
            System.out.println("\u6587\u4ef6\u5927\u5c0f" + fin.available() / 1024 + "kb");
            while (fin.read(buffer) > 0) {
            }
            in.close();
            fin.close();
            long end = System.currentTimeMillis();
            System.out.println("\u8bfb\u53d6\u6587\u4ef6\u8017\u65f6" + (end - start) / 600L + "\u79d2");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public FlowController(InputStream in, int maxbps) {
        super(in);
        this.maxbps = maxbps;
        this.currentbps = 0;
        this.bytesread = 0;
        this.timestamp = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() throws IOException {
        InputStream inputStream = this.in;
        synchronized (inputStream) {
            int avaliable = this.check();
            if (avaliable == 0) {
                this.waitForAvailable();
                avaliable = this.check();
            }
            int value = this.in.read();
            this.update(1);
            return value;
        }
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        InputStream inputStream = this.in;
        synchronized (inputStream) {
            int avaliable = this.check();
            if (avaliable == 0) {
                this.waitForAvailable();
                avaliable = this.check();
            }
            int n = this.in.read(b, off, Math.min(len, avaliable));
            this.update(n);
            return n;
        }
    }

    public int check() {
        long now = System.currentTimeMillis();
        if (now - this.timestamp >= 1000L) {
            this.timestamp = now;
            this.currentbps = this.bytesread;
            this.bytesread = 0;
            return this.maxbps;
        }
        return this.maxbps - this.bytesread;
    }

    private void waitForAvailable() {
        long time = System.currentTimeMillis() - this.timestamp;
        boolean isInterrupted = false;
        while (time < 1000L) {
            try {
                Thread.sleep(1000L - time);
            }
            catch (InterruptedException e) {
                isInterrupted = true;
            }
            time = System.currentTimeMillis() - this.timestamp;
        }
        if (isInterrupted) {
            Thread.currentThread().interrupt();
        }
    }

    private void update(int n) {
        this.bytesread += n;
    }

    public int getCurrentbps() {
        return this.currentbps;
    }
}

