/*
 * Decompiled with CFR 0.152.
 */
package com.sunyard.client.connQueueControl;

import com.sunyard.client.conn.SocketConn;
import com.sunyard.client.connQueueControl.SocketConnThreadControl;
import com.sunyard.common.Configuration;
import com.sunyard.ecm.util.net.JSSEClientSocketFactory;
import com.sunyard.exception.SunECMException;
import com.sunyard.util.CodeUtil;
import java.net.Socket;
import javax.net.SocketFactory;
import org.apache.log4j.Logger;

public class SocketConnObject
extends Thread {
    private Logger log = Logger.getLogger(SocketConnObject.class);
    private boolean runStatus = false;
    private String threadName = "";
    private long runTime = 0L;
    private long notRunTime = 0L;
    private String ip = "";
    private String port = "";
    private boolean flag = true;
    private SocketConn connObject = null;

    public SocketConnObject(String ip, String port) throws SunECMException {
        this(ip, port, Configuration.getBoolean((String)"ssl.client.enable", (boolean)false));
    }

    public SocketConnObject(String ip, String port, boolean sslEnable) throws SunECMException {
        SocketFactory scf;
        this.ip = ip = CodeUtil.changeIp(ip);
        this.port = port;
        this.runTime = System.currentTimeMillis();
        this.notRunTime = System.currentTimeMillis();
        this.log.debug((Object)(String.valueOf(this.ip) + "======" + this.port));
        int iport = 0;
        if (sslEnable) {
            iport = Configuration.getInt((String)"ssl.client.port", (int)8025);
            scf = new JSSEClientSocketFactory();
        } else {
            iport = Integer.parseInt(port);
            scf = SocketFactory.getDefault();
        }
        try {
            Socket socket = scf.createSocket(ip, iport);
            this.connObject = new SocketConn(socket);
        }
        catch (Exception e) {
            this.log.error((Object)("\u8fde\u63a5\u670d\u52a1\u5668" + ip + ":" + port + "\u53d1\u751f\u95ee\u9898"), (Throwable)e);
            throw new SunECMException(705, "IO exception ip=" + ip + ";port = " + port, e);
        }
        this.start();
    }

    @Override
    public void run() {
        while (this.flag) {
            if (this.runStatus) {
                this.timeOutRemoveConn();
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private void notRunCommunication() {
        if ((System.currentTimeMillis() - this.notRunTime) / 1000L >= 30L) {
            this.notRunTime = System.currentTimeMillis();
        } else {
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException e) {
                this.log.error((Object)("--notRunCommunication-->InterruptedException:" + e.toString()));
            }
        }
    }

    private void timeOutRemoveConn() {
        if ((System.currentTimeMillis() - this.runTime) / 1000L / 60L >= 30L) {
            this.log.debug((Object)"\u8fde\u63a5\u8d85\u65f6\u5173\u95ed\u8fde\u63a5");
            SocketConnThreadControl.removeConn(this);
            this.closeConn();
        } else {
            try {
                Thread.sleep(60000L);
            }
            catch (InterruptedException e) {
                this.log.error((Object)("--timeOutRemoveConn-->InterruptedException:" + e.toString()));
            }
        }
    }

    public boolean isRunStatus(String ip) {
        return this.runStatus || !ip.equals(this.ip);
    }

    public void setRunStatus(boolean runStatus) {
        this.runStatus = runStatus;
    }

    public String getThreadName() {
        return this.threadName;
    }

    public void setThreadName(String threadName) {
        this.threadName = threadName;
    }

    public void resetRunTime() {
        this.runTime = System.currentTimeMillis();
    }

    public void closeConn() {
        try {
            try {
                this.connObject.sendMsg("0009");
            }
            catch (Exception e) {
                this.log.error((Object)("socket ip=" + this.ip + "; port = " + this.port + " close fail , error info-->" + e.getMessage()));
            }
        }
        finally {
            this.connObject.destroy();
            this.flag = false;
        }
    }

    public void returnConn() {
        SocketConnThreadControl.returnSocketConn(this);
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public SocketConn getClientTrans() {
        return this.connObject;
    }
}

