/*
 * Decompiled with CFR 0.152.
 */
package com.sunyard.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.log4j.Logger;

public class FileMD5Verify {
    private Logger log = Logger.getLogger(FileMD5Verify.class);
    protected static char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    protected MessageDigest messagedigest = null;

    public FileMD5Verify() {
        try {
            this.messagedigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException nsaex) {
            this.log.error((Object)(String.valueOf(FileMD5Verify.class.getName()) + "\u521d\u59cb\u5316\u5931\u8d25\uff0cMessageDigest\u4e0d\u652f\u6301MD5Util?"));
            nsaex.printStackTrace();
        }
    }

    public String getFileMD5String(File file) {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            byte[] buffer = new byte[8192];
            int length = -1;
            while ((length = fis.read(buffer)) != -1) {
                this.messagedigest.update(buffer, 0, length);
            }
            String string = this.bufferToHex(this.messagedigest.digest()).toUpperCase();
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return "";
    }

    private String bufferToHex(byte[] bytes) {
        return this.bufferToHex(bytes, 0, bytes.length);
    }

    private String bufferToHex(byte[] bytes, int m, int n) {
        StringBuffer stringbuffer = new StringBuffer(2 * n);
        int k = m + n;
        int l = m;
        while (l < k) {
            this.appendHexPair(bytes[l], stringbuffer);
            ++l;
        }
        return stringbuffer.toString();
    }

    private void appendHexPair(byte bt, StringBuffer stringbuffer) {
        char c0 = hexDigits[(bt & 0xF0) >> 4];
        char c1 = hexDigits[bt & 0xF];
        stringbuffer.append(c0);
        stringbuffer.append(c1);
    }

    public String aa(File file) {
        String md5 = this.getFileMD5String(file);
        return md5;
    }

    public static void main(String[] args) {
        File file1 = new File("D://123/1.jpg");
        File file2 = new File("D://123/2.jpg");
        File file3 = new File("D://123/3.jpg");
        File file4 = new File("D://123/4.jpg");
        File file5 = new File("D://123/5.jpg");
        int i = 0;
        while (i < 10) {
            new Thread(new FileMD5Verify().aa(file1)).start();
            new Thread(new FileMD5Verify().aa(file2)).start();
            new Thread(new FileMD5Verify().aa(file3)).start();
            new Thread(new FileMD5Verify().aa(file4)).start();
            new Thread(new FileMD5Verify().aa(file5)).start();
            ++i;
        }
    }
}

