/*
 * Decompiled with CFR 0.152.
 */
package com.sunyard.util;

import com.sunyard.ecm.server.bean.DMLogRuleBean;
import com.sunyard.exception.SunECMException;
import com.sunyard.util.DateUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class Log4jConfigOperUtil {
    private static Logger log = Logger.getLogger(Log4jConfigOperUtil.class);

    public Properties readProperties(String filePath) {
        Properties properties;
        block12: {
            properties = new Properties();
            FileInputStream inputStream = null;
            try {
                try {
                    inputStream = new FileInputStream(filePath);
                    properties.load(inputStream);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (inputStream == null) break block12;
                    try {
                        ((InputStream)inputStream).close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                if (inputStream != null) {
                    try {
                        ((InputStream)inputStream).close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return properties;
    }

    public Properties writeProperties(Properties properties, String path, String key, String value) throws SunECMException {
        FileOutputStream fos = null;
        try {
            try {
                fos = new FileOutputStream(path);
                String rootKey = "log4j.logger." + key;
                properties.setProperty(rootKey, value);
                properties.store(fos, "Update '" + rootKey + "' value: " + value);
            }
            catch (IOException e) {
                throw new SunECMException(714, "Log4jConfigOperUtil-->writeProperties: " + e.toString());
            }
        }
        finally {
            if (fos != null) {
                try {
                    ((OutputStream)fos).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        PropertyConfigurator.configure((String)path);
        return properties;
    }

    public void writeDMLogRule(Properties properties, String path, DMLogRuleBean dmLogRule) throws SunECMException {
        FileOutputStream fos = null;
        String logPathName = dmLogRule.getSave_path();
        File file = new File(properties.getProperty("log4j.appender.File.file"));
        String logFilePath = file.getParent();
        log.debug((Object)("\u65e5\u5fd7\u8def\u5f84:" + logFilePath));
        try {
            try {
                fos = new FileOutputStream(path);
                properties.setProperty("log4j.logger." + dmLogRule.getClass_path(), String.valueOf(this.convertLogLevel(dmLogRule.getLevel())) + "," + logPathName);
                properties.setProperty("log4j.appender." + logPathName, "org.apache.log4j.RollingFileAppender");
                properties.setProperty("log4j.appender." + logPathName + ".File", String.valueOf(logFilePath) + File.separator + logPathName + "-log4j.log");
                properties.setProperty("log4j.appender." + logPathName + ".MaxFileSize", String.valueOf(dmLogRule.getLog_size()) + "MB");
                properties.setProperty("log4j.appender." + logPathName + ".MaxBackupIndex", "30");
                properties.setProperty("log4j.appender." + logPathName + ".layout", "org.apache.log4j.PatternLayout");
                properties.setProperty("log4j.appender." + logPathName + ".layout.ConversionPattern", "%d{hh:mm:ss.SSS} [%-5p] %c-%L: %m%n");
                properties.store(fos, "Log File Update Time Is: [" + DateUtil.get12bitDateStr() + "]");
            }
            catch (IOException e) {
                throw new SunECMException(714, "Log4jConfigOperUtil-->writeProperties: " + e.toString());
            }
        }
        finally {
            if (fos != null) {
                try {
                    fos.flush();
                    ((OutputStream)fos).close();
                }
                catch (IOException e) {
                    log.error((Object)"\u5185\u5bb9\u5b58\u50a8\u670d\u52a1\u5668\u8bb0\u5f55\u65e5\u5fd7\u6587\u4ef6\u5173\u95ed\u6587\u4ef6\u6d41\u51fa\u9519");
                }
            }
        }
        PropertyConfigurator.configure((String)path);
    }

    private String convertLogLevel(String level) {
        if ("1".equals(level)) {
            return "DEBUG";
        }
        if ("2".equals(level)) {
            return "INFO";
        }
        if ("3".equals(level)) {
            return "WARN";
        }
        if ("4".equals(level)) {
            return "ERROR";
        }
        if ("5".equals(level)) {
            return "OFF";
        }
        return null;
    }

    public static void main(String[] args) {
        System.out.println("begin");
        int i = 0;
        while (i < 1000) {
            log.debug((Object)"111111111111111");
            ++i;
        }
        System.out.println("over");
    }
}

