/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.text.pdf.security;

import com.timevale.tgtext.text.log.c;
import com.timevale.tgtext.text.log.d;
import com.timevale.tgtext.text.pdf.security.ac;
import com.timevale.tgtext.text.pdf.security.aj;
import com.timevale.tgtext.text.pdf.security.ak;
import com.timevale.tgtext.text.pdf.security.f;
import com.timevale.tgtext.text.pdf.security.w;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.CertificateStatus;
import org.bouncycastle.cert.ocsp.OCSPException;
import org.bouncycastle.cert.ocsp.SingleResp;
import org.bouncycastle.operator.ContentVerifierProvider;
import org.bouncycastle.operator.DigestCalculatorProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.bc.BcDigestCalculatorProvider;
import org.bouncycastle.operator.jcajce.JcaContentVerifierProviderBuilder;

public class u
extends ac {
    protected static final c a = com.timevale.tgtext.text.log.d.a(u.class);
    protected List<BasicOCSPResp> b;

    public u(f verifier, List<BasicOCSPResp> ocsps) {
        super(verifier);
        this.b = ocsps;
    }

    @Override
    public List<ak> a(X509Certificate signCert, X509Certificate issuerCert, Date signDate) throws GeneralSecurityException, IOException {
        ArrayList<ak> result = new ArrayList<ak>();
        int validOCSPsFound = 0;
        if (this.b != null) {
            for (BasicOCSPResp ocspResp : this.b) {
                if (!this.a(ocspResp, signCert, issuerCert, signDate)) continue;
                ++validOCSPsFound;
            }
        }
        boolean online = false;
        if (this.d && validOCSPsFound == 0 && this.a(this.a(signCert, issuerCert), signCert, issuerCert, signDate)) {
            ++validOCSPsFound;
            online = true;
        }
        a.e("Valid OCSPs found: " + validOCSPsFound);
        if (validOCSPsFound > 0) {
            result.add(new ak(signCert, this.getClass(), "Valid OCSPs Found: " + validOCSPsFound + (online ? " (online)" : "")));
        }
        if (this.c != null) {
            result.addAll(this.c.a(signCert, issuerCert, signDate));
        }
        return result;
    }

    public boolean a(BasicOCSPResp ocspResp, X509Certificate signCert, X509Certificate issuerCert, Date signDate) throws GeneralSecurityException, IOException {
        if (ocspResp == null) {
            return false;
        }
        SingleResp[] resp = ocspResp.getResponses();
        for (int i2 = 0; i2 < resp.length; ++i2) {
            if (!signCert.getSerialNumber().equals(resp[i2].getCertID().getSerialNumber())) continue;
            try {
                if (issuerCert == null) {
                    issuerCert = signCert;
                }
                if (!resp[i2].getCertID().matchesIssuer(new X509CertificateHolder(issuerCert.getEncoded()), (DigestCalculatorProvider)new BcDigestCalculatorProvider())) {
                    a.e("OCSP: Issuers doesn't match.");
                }
            }
            catch (OCSPException oCSPException) {}
            continue;
            Date nextUpdate = resp[i2].getNextUpdate();
            if (nextUpdate == null) {
                nextUpdate = new Date(resp[i2].getThisUpdate().getTime() + 180000L);
                a.e(String.format("No 'next update' for OCSP Response; assuming %s", nextUpdate));
            }
            if (signDate.after(nextUpdate)) {
                a.e(String.format("OCSP no longer valid: %s after %s", signDate, nextUpdate));
                continue;
            }
            CertificateStatus status = resp[i2].getCertStatus();
            if (status != CertificateStatus.GOOD) continue;
            this.a(ocspResp, issuerCert);
            return true;
        }
        return false;
    }

    public void a(BasicOCSPResp ocspResp, X509Certificate issuerCert) throws GeneralSecurityException, IOException {
        X509Certificate responderCert;
        block4: {
            responderCert = issuerCert;
            X509CertificateHolder[] certHolders = ocspResp.getCerts();
            if (certHolders.length > 0) {
                responderCert = new JcaX509CertificateConverter().setProvider("BC").getCertificate(certHolders[0]);
                try {
                    responderCert.verify(issuerCert.getPublicKey());
                }
                catch (GeneralSecurityException generalSecurityException) {
                    if (super.a(responderCert, issuerCert, null).size() != 0) break block4;
                    throw new aj(responderCert, "Responder certificate couldn't be verified");
                }
            }
        }
        if (!this.b(ocspResp, responderCert)) {
            throw new aj(responderCert, "OCSP response could not be verified");
        }
    }

    public boolean b(BasicOCSPResp ocspResp, X509Certificate responderCert) {
        if (this.a(ocspResp, (Certificate)responderCert)) {
            return true;
        }
        if (this.n == null) {
            return false;
        }
        try {
            Enumeration<String> aliases = this.n.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                try {
                    X509Certificate anchor;
                    if (!this.n.isCertificateEntry(alias) || !this.a(ocspResp, (Certificate)(anchor = (X509Certificate)this.n.getCertificate(alias)))) continue;
                    return true;
                }
                catch (GeneralSecurityException generalSecurityException) {
                }
            }
        }
        catch (GeneralSecurityException generalSecurityException) {
            return false;
        }
        return false;
    }

    public boolean a(BasicOCSPResp ocspResp, Certificate responderCert) {
        try {
            ContentVerifierProvider verifierProvider = new JcaContentVerifierProviderBuilder().setProvider("BC").build(responderCert.getPublicKey());
            return ocspResp.isSignatureValid(verifierProvider);
        }
        catch (OperatorCreationException operatorCreationException) {
            return false;
        }
        catch (OCSPException oCSPException) {
            return false;
        }
    }

    public BasicOCSPResp a(X509Certificate signCert, X509Certificate issuerCert) {
        if (signCert == null && issuerCert == null) {
            return null;
        }
        w ocsp = new w();
        BasicOCSPResp ocspResp = ocsp.b(signCert, issuerCert, null);
        if (ocspResp == null) {
            return null;
        }
        SingleResp[] resp = ocspResp.getResponses();
        for (int i2 = 0; i2 < resp.length; ++i2) {
            CertificateStatus status = resp[i2].getCertStatus();
            if (status != CertificateStatus.GOOD) continue;
            return ocspResp;
        }
        return null;
    }
}

