/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.text.pdf.security;

import com.timevale.tgtext.text.error_messages.a;
import com.timevale.tgtext.text.io.n;
import com.timevale.tgtext.text.log.Level;
import com.timevale.tgtext.text.log.c;
import com.timevale.tgtext.text.pdf.cj;
import com.timevale.tgtext.text.pdf.security.d;
import com.timevale.tgtext.text.pdf.security.v;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.ocsp.OCSPObjectIdentifiers;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.CertificateID;
import org.bouncycastle.cert.ocsp.CertificateStatus;
import org.bouncycastle.cert.ocsp.OCSPException;
import org.bouncycastle.cert.ocsp.OCSPReq;
import org.bouncycastle.cert.ocsp.OCSPReqBuilder;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.bouncycastle.cert.ocsp.SingleResp;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.ocsp.RevokedStatus;
import org.bouncycastle.operator.OperatorException;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;

public class w
implements v {
    private static final c a = com.timevale.tgtext.text.log.d.a(w.class);

    private static OCSPReq a(X509Certificate issuerCert, BigInteger serialNumber) throws OCSPException, IOException, OperatorException, CertificateEncodingException {
        if (null != Security.getProvider(BouncyCastleProvider.PROVIDER_NAME)) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        CertificateID id = new CertificateID(new JcaDigestCalculatorProviderBuilder().build().get(CertificateID.HASH_SHA1), (X509CertificateHolder)new JcaX509CertificateHolder(issuerCert), serialNumber);
        OCSPReqBuilder gen = new OCSPReqBuilder();
        gen.addRequest(id);
        Extension ext = new Extension(OCSPObjectIdentifiers.id_pkix_ocsp_nonce, false, (ASN1OctetString)new DEROctetString(new DEROctetString(cj.e()).getEncoded()));
        gen.setRequestExtensions(new Extensions(new Extension[]{ext}));
        return gen.build();
    }

    private OCSPResp c(X509Certificate checkCert, X509Certificate rootCert, String url) throws GeneralSecurityException, OCSPException, IOException, OperatorException {
        if (checkCert == null || rootCert == null) {
            return null;
        }
        if (url == null) {
            url = d.c(checkCert);
        }
        if (url == null) {
            return null;
        }
        a.e("Getting OCSP from " + url);
        OCSPReq request = w.a(rootCert, checkCert.getSerialNumber());
        byte[] array = request.getEncoded();
        URL urlt = new URL(url);
        HttpURLConnection con = (HttpURLConnection)urlt.openConnection();
        con.setRequestProperty("Content-Type", "application/ocsp-request");
        con.setRequestProperty("Accept", "application/ocsp-response");
        con.setDoOutput(true);
        OutputStream out = con.getOutputStream();
        DataOutputStream dataOut = new DataOutputStream(new BufferedOutputStream(out));
        dataOut.write(array);
        dataOut.flush();
        dataOut.close();
        if (con.getResponseCode() / 100 != 2) {
            throw new IOException(com.timevale.tgtext.text.error_messages.a.a("invalid.http.response.1", con.getResponseCode()));
        }
        InputStream in = (InputStream)con.getContent();
        return new OCSPResp(n.a(in));
    }

    public BasicOCSPResp b(X509Certificate checkCert, X509Certificate rootCert, String url) {
        try {
            OCSPResp ocspResponse = this.c(checkCert, rootCert, url);
            if (ocspResponse == null) {
                return null;
            }
            if (ocspResponse.getStatus() != 0) {
                return null;
            }
            return (BasicOCSPResp)ocspResponse.getResponseObject();
        }
        catch (Exception ex2) {
            if (a.a(Level.ERROR)) {
                a.f(ex2.getMessage());
            }
            return null;
        }
    }

    @Override
    public byte[] a(X509Certificate checkCert, X509Certificate rootCert, String url) {
        block5: {
            try {
                SingleResp[] responses;
                BasicOCSPResp basicResponse = this.b(checkCert, rootCert, url);
                if (basicResponse != null && (responses = basicResponse.getResponses()).length == 1) {
                    SingleResp resp = responses[0];
                    CertificateStatus status = resp.getCertStatus();
                    if (status == CertificateStatus.GOOD) {
                        return basicResponse.getEncoded();
                    }
                    if (status instanceof RevokedStatus) {
                        throw new IOException(com.timevale.tgtext.text.error_messages.a.a("ocsp.status.is.revoked", new Object[0]));
                    }
                    throw new IOException(com.timevale.tgtext.text.error_messages.a.a("ocsp.status.is.unknown", new Object[0]));
                }
            }
            catch (Exception ex2) {
                if (!a.a(Level.ERROR)) break block5;
                a.f(ex2.getMessage());
            }
        }
        return null;
    }
}

