/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.emp.ext.tag;

import com.ecc.emp.core.Context;
import com.ecc.emp.core.EMPConstance;
import com.ecc.emp.data.IndexedCollection;
import com.ecc.emp.data.KeyedCollection;
import com.ecc.emp.log.EMPLog;
import com.ecc.emp.web.jsptags.EMPTagSupport;
import com.yucheng.cmis.cache.CacheClient;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;

public abstract class EMPExtTagSupport
extends EMPTagSupport {
    public static String ATTR_DICTDATANAME = "dictColl";
    public static String ATTR_ENNAME = "enname";
    public static String ATTR_CNNAME = "cnname";

    protected IndexedCollection getDictMapCollection(String dictname) {
        IndexedCollection iColl = null;
        boolean isFilter = false;
        String filterStr = null;
        if (dictname != null && dictname.indexOf("?") != -1) {
            isFilter = true;
            filterStr = dictname.substring(dictname.indexOf("?") + 1);
            dictname = dictname.substring(0, dictname.indexOf("?"));
        }
        try {
            iColl = (IndexedCollection)this.getDataElement(dictname);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (iColl == null) {
            try {
                HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
                Context context = (Context)request.getAttribute(EMPConstance.ATTR_CONTEXT);
                iColl = CacheClient.getDictByType((Context)context, (String)dictname);
            }
            catch (Exception request) {
                // empty catch block
            }
        }
        try {
            if (isFilter) {
                iColl = this.filterCollection(iColl, filterStr);
            }
        }
        catch (Exception e) {
            return iColl;
        }
        return iColl;
    }

    private IndexedCollection filterCollection(IndexedCollection iColl, String filterStr) {
        if (iColl == null) {
            return null;
        }
        IndexedCollection retIColl = new IndexedCollection();
        try {
            boolean filterModel = false;
            String filterName = null;
            String filterValue = null;
            String filterNamePatter = "[E|e][N|n][N|n][A|a][M|m][E|e]|[C|c][N|n][N|n][A|a][M|m][E|e]";
            String filterModelInPatter = "[I|i][N|n]";
            String filterModelNotInPatter = "[N|n][O|o][T|t]\\s*[I|i][N|n]";
            String filterValuePatter = "\\(.*\\)";
            String patterStr = "(" + filterNamePatter + ")\\s*(" + filterModelInPatter + " | " + filterModelNotInPatter + ")\\s*(" + filterValuePatter + ")";
            Pattern p = Pattern.compile(patterStr);
            Matcher m = p.matcher(filterStr);
            if (m.find()) {
                filterName = m.group(1);
                filterModel = !m.group(2).contains("not");
                filterValue = m.group(3);
            }
            if (filterModel) {
                for (KeyedCollection kColl : iColl) {
                    String value = (String)kColl.getDataValue(filterName.toLowerCase());
                    if (filterValue == null || !filterValue.contains(value)) continue;
                    retIColl.add((Object)kColl);
                }
            } else {
                for (KeyedCollection kColl : iColl) {
                    String value = (String)kColl.getDataValue(filterName.toLowerCase());
                    if (filterValue == null || filterValue.contains(value)) continue;
                    retIColl.add((Object)kColl);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retIColl;
    }

    protected String getDecoratedValue(String value, String dictname, boolean languageResouce) {
        if (value == null || dictname == null) {
            return value;
        }
        String decoratedValue = value;
        IndexedCollection iColl = this.getDictMapCollection(dictname);
        if (iColl == null) {
            EMPLog.log((String)"CMIS", (int)EMPLog.WARNING, (int)0, (String)("\u4f7f\u7528\u5b57\u5178\u4fee\u9970\u6570\u636e\u65f6\u51fa\u9519\uff01\u4e0d\u5b58\u5728\u540d\u4e3a" + dictname + "\u7684\u5b57\u5178\u9879\uff01"));
            return value;
        }
        try {
            String language = this.getLanguage();
            int i = 0;
            while (i < iColl.size()) {
                KeyedCollection kColl = (KeyedCollection)iColl.get(i);
                String enname = (String)kColl.getDataValue(ATTR_ENNAME);
                if (value.equals(enname)) {
                    String cnname = null;
                    if (languageResouce) {
                        try {
                            cnname = (String)kColl.getDataValue(String.valueOf(ATTR_CNNAME) + "_" + language);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (cnname == null) {
                        cnname = (String)kColl.getDataValue(ATTR_CNNAME);
                    }
                    decoratedValue = cnname;
                    break;
                }
                ++i;
            }
        }
        catch (Exception e) {
            EMPLog.log((String)"CMIS", (int)EMPLog.WARNING, (int)0, (String)"\u4f7f\u7528\u5b57\u5178\u4fee\u9970\u6570\u636e\u65f6\u51fa\u9519\uff01", (Throwable)e);
        }
        return decoratedValue;
    }

    protected boolean judgeReadPermission(String fieldId) {
        String canread = (String)this.pageContext.getRequest().getAttribute("canread");
        if (canread == null) {
            return true;
        }
        String[] canreads = canread.split(";");
        int i = 0;
        while (i < canreads.length) {
            if (canreads[i].equals(fieldId)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean judgeWritePermission(String fieldId) {
        String canwrite = (String)this.pageContext.getRequest().getAttribute("canwrite");
        if (canwrite == null) {
            return true;
        }
        String[] canwrites = canwrite.split(";");
        int i = 0;
        while (i < canwrites.length) {
            if (canwrites[i].equals(fieldId)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void writeAttribute(StringBuffer buffer, String name, Object value) {
        String valueStr;
        if (value != null && (valueStr = value.toString()) != null) {
            valueStr = valueStr.replaceAll("'", "&#39;");
            buffer.append(" ").append(name).append("='").append(valueStr).append("'");
        }
    }

    protected String encodeUrl(String url) {
        url = this.parsePamaterStr(url);
        url = this.getGetURL(url);
        return url;
    }
}

