/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.emp.ext.tag.eui.field;

import com.ecc.emp.ext.tag.eui.field.FieldBase;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Text
extends FieldBase {
    private static final long serialVersionUID = 4180336458419059695L;
    private String type = "text";
    protected String width = "200";
    protected String height = "26";
    protected String onblur = "";
    protected String onfocus = "";
    protected String beforeOnchange;
    protected String afterOnchange;

    public Object clone() {
        Text tag = new Text();
        this.cloneDafaultAttributes(tag);
        tag.editable = this.editable;
        tag.type = this.type;
        tag.width = this.width;
        tag.height = this.height;
        tag.onblur = this.onblur;
        tag.onfocus = this.onfocus;
        tag.beforeOnchange = this.beforeOnchange;
        tag.afterOnchange = this.afterOnchange;
        return tag;
    }

    public void renderInnerHtml(StringBuffer sb) {
        sb.append("    <input id=\"").append(this.getId()).append("\" name=\"").append(this.getId()).append("\" type=\"").append(this.getType()).append("\" ").append(" class=\"").append(this.getCssClass()).append("\" cssClass=\"").append(this.getCssClass()).append("\" ");
        String rStyle = "";
        rStyle = String.valueOf(rStyle) + (this.getWidth().equals("") ? "" : "width:" + this.getWidth() + (this.getWidth().endsWith("px") ? "" : "px") + ";");
        rStyle = String.valueOf(rStyle) + (this.getHeight().equals("") ? "" : "height:" + this.getHeight() + (this.getHeight().endsWith("px") ? "" : "px") + ";");
        rStyle = String.valueOf(rStyle) + this.getStyle();
        sb.append("style=\"").append(rStyle).append("\" ");
        sb.append("dType=\"").append(this.getDataType()).append("\" dSpace=\"").append(this.getDataSpace()).append("\" ");
        sb.append(this.isRequired() != false ? "required " : "").append(this.getDisabled() != false ? "disabled " : "").append(this.getReadonly() != false ? "readonly " : "");
        if (this.useOnchangeExt()) {
            sb.append("onchange=\"$.textOnchangeExt(this)\"");
        } else {
            this.writeAttribute(sb, "onchange", this.getOnchange());
        }
        this.addDefaultAttributes(sb);
        if (!this.getOnblur().equals("")) {
            sb.append(" onblur=\"").append(this.getOnblur()).append(this.getOnblur().indexOf("(") == -1 ? "()" : "").append("\"");
        }
        if (!this.getOnfocus().equals("")) {
            sb.append(" onfocus=\"").append(this.getOnfocus()).append(this.getOnfocus().indexOf("(") == -1 ? "()" : "").append("\"");
        }
        StringBuffer options = new StringBuffer();
        this.addDataOptions(options);
        sb.append(" data-options=\"").append(this.getOptions(options)).append("\" ");
        sb.append(" value=\"").append(this.getValue()).append("\" >");
        sb.append("</input>\n");
    }

    protected void beforeStartTag() {
        this.setCssClass("easyui-validatebox");
        String clickfn = this.getOnclick();
        if (clickfn != null && !clickfn.equals("") && clickfn.indexOf("(") == -1) {
            clickfn = String.valueOf(clickfn) + "()";
        }
        this.setOnclick(clickfn);
    }

    protected void addDataOptions(StringBuffer options) {
        options.append(this.getDataOptions());
        String validTypeStr = "";
        if (this.getDataType() != null && !"Text".equals(this.getDataType().trim())) {
            validTypeStr = "'" + this.getDataType() + "'";
        }
        if (this.getMaxLength() >= 0 && this.getMinLength() >= 0) {
            validTypeStr = String.valueOf(validTypeStr) + ",'Length[" + this.getMinLength() + "," + this.getMaxLength() + "]'";
        } else if (this.getMinLength() >= 0 && this.getMaxLength() == -1) {
            validTypeStr = String.valueOf(validTypeStr) + ",'MinLength[" + this.getMinLength() + "]'";
        } else if (this.getMaxLength() >= 0 && this.getMinLength() == -1) {
            validTypeStr = String.valueOf(validTypeStr) + ",'MaxLength[" + this.getMaxLength() + "]'";
        }
        if (validTypeStr.startsWith(",")) {
            validTypeStr = validTypeStr.substring(1);
        }
        if (validTypeStr.contains(",")) {
            validTypeStr = "[" + validTypeStr + "]";
        }
        this.addAttributeToDataOptions(options, "validType", validTypeStr, false);
        this.addAttributeToDataOptions(options, "tipPosition", this.getTipPosition(), true);
        if (this.getOnchange() != null && this.useOnchangeExt()) {
            String newOnchange = this.getOnchange().replaceAll("\\(.*\\)", "");
            this.addAttributeToDataOptions(options, "useOnchangeExt", "true", false);
            this.addAttributeToDataOptions(options, "onchange", newOnchange, false);
        } else {
            this.addAttributeToDataOptions(options, "useOnchangeExt", "false", false);
            this.addAttributeToDataOptions(options, "onchange", this.eventFunctionFormat(this.getOnchange()), true);
        }
        this.addAttributeToDataOptions(options, "beforeOnchange", this.getBeforeOnchange(), false);
        this.addAttributeToDataOptions(options, "afterOnchange", this.getAfterOnchange(), false);
        this.addAttributeToDataOptions(options, "onclick", this.eventFunctionFormat(this.getOnclick()), true);
        this.addAttributeToDataOptions(options, "onfocus", this.eventFunctionFormat(this.getOnfocus()), true);
        this.addAttributeToDataOptions(options, "onblur", this.eventFunctionFormat(this.getOnblur()), true);
        this.addAttributeToDataOptions(options, "onmouseover", this.eventFunctionFormat(this.getOnmouseover()), true);
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getWidth() {
        return this.width;
    }

    public void setWidth(String width) {
        this.width = width;
    }

    public String getHeight() {
        return this.height;
    }

    public void setHeight(String height) {
        this.height = height;
    }

    public String getOnblur() {
        return this.onblur;
    }

    public void setOnblur(String onblur) {
        this.onblur = onblur;
    }

    public String getOnfocus() {
        return this.onfocus;
    }

    public void setOnfocus(String onfocus) {
        this.onfocus = onfocus;
    }

    public void setOnchange(String onchange) {
        if (onchange != null && !onchange.equals("") && onchange.indexOf("(") == -1) {
            onchange = String.valueOf(onchange) + "()";
        }
        this.onchange = onchange;
    }

    public void setOnmouseover(String onmouseover) {
        if (onmouseover != null && !onmouseover.equals("") && onmouseover.indexOf("(") == -1) {
            onmouseover = String.valueOf(onmouseover) + "()";
        }
        this.onmouseover = onmouseover;
    }

    public String getBeforeOnchange() {
        return this.beforeOnchange;
    }

    public void setBeforeOnchange(String beforeOnchange) {
        this.beforeOnchange = beforeOnchange = beforeOnchange.replaceAll("\\(.*\\)", "");
    }

    public String getAfterOnchange() {
        return this.afterOnchange;
    }

    public void setAfterOnchange(String afterOnchange) {
        this.afterOnchange = afterOnchange = afterOnchange.replaceAll("\\(.*\\)", "");
    }

    public String eventFunctionFormat(String funName) {
        if (funName != null && !funName.equals("")) {
            if (funName.indexOf("(") == -1) {
                funName = String.valueOf(funName) + "()";
            }
            funName = funName.replaceAll("'", "\\\\&#39;");
            funName = funName.replaceAll("\"", "\\\\&#39;");
        }
        return funName;
    }

    private boolean useOnchangeExt() {
        Object onchangeExtUser = this.pageContext.getRequest().getAttribute("emp_text.useOnchangeExt");
        if (onchangeExtUser != null && "false".equals(onchangeExtUser.toString().trim())) {
            return false;
        }
        String thisOnchange = this.getOnchange();
        if (thisOnchange != null && !thisOnchange.equals("")) {
            Pattern pattern = Pattern.compile(".*\\(.+\\)");
            Matcher matcher = pattern.matcher(thisOnchange);
            return !matcher.matches();
        }
        return true;
    }
}

