/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.emp.ext.tag.field;

import com.ecc.emp.core.Context;
import com.ecc.emp.core.EMPConstance;
import com.ecc.emp.data.IndexedCollection;
import com.ecc.emp.data.KeyedCollection;
import com.ecc.emp.datatype.EMPDataType;
import com.ecc.emp.datatype.EMPDataTypeDef;
import com.ecc.emp.ext.tag.EMPExtDataTable;
import com.ecc.emp.ext.tag.EMPExtGridLayout;
import com.ecc.emp.ext.tag.EMPExtTagSupport;
import com.ecc.emp.ext.tag.page.EMPExtPageObjects;
import java.lang.reflect.Method;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.Tag;

public abstract class EMPExtFieldBase
extends EMPExtTagSupport {
    private static final long serialVersionUID = 1L;
    protected Tag parent = null;
    protected String id = null;
    protected String label = null;
    protected String defvalue = "";
    protected String dictname = null;
    protected String fieldErrorDataName = null;
    protected String cssClass = "emp_field";
    protected String cssRequiredClass = "emp_field_required";
    protected String cssErrorClass = "emp_field_error";
    protected String cssLabelClass = "emp_field_label";
    protected String cssFlatClass = "emp_field_flat";
    protected String cssElementClass = null;
    protected String cssTDClass = "emp_field_td";
    protected String cssTDClassNumber = "emp_field_td_number";
    protected String tabindex = null;
    protected String accesskey = null;
    protected boolean languageResouce = false;
    protected String help = null;
    protected Boolean required = null;
    protected Boolean hidden = null;
    protected Boolean disabled = null;
    protected Boolean flat = null;
    protected Boolean readonly = null;
    protected String dataType = null;
    protected Boolean statistic = null;
    protected String colSpan = "1";
    protected boolean onlyControlElement = false;
    protected String onclick = null;
    protected String ondblclick = null;
    protected String onmousedown = null;
    protected String onmouseup = null;
    protected String onmouseover = null;
    protected String onmousemove = null;
    protected String onmouseout = null;
    protected String onkeypress = null;
    protected String onkeyup = null;
    protected String onkeydown = null;

    protected abstract String getType();

    public abstract Object clone();

    protected abstract void renderInnerHtml(StringBuffer var1, KeyedCollection var2);

    protected abstract void renderOtherAttribute(StringBuffer var1, KeyedCollection var2, boolean var3);

    public int doStartTag() throws JspException {
        if (!this.judgeReadPermission(this.id)) {
            return 0;
        }
        boolean flat = false;
        if (this.parent != null && this.parent instanceof EMPExtDataTable) {
            if (!((EMPExtDataTable)this.parent).isEditable() && this.flat == null) {
                flat = true;
            }
            EMPExtFieldBase newfield = (EMPExtFieldBase)((Object)this.clone());
            newfield.setFlat(flat);
            newfield.setOnlyControlElement(false);
            ((EMPExtDataTable)this.parent).addCMISDataField(newfield);
        } else if (this.parent != null && this.parent instanceof EMPExtGridLayout) {
            EMPExtFieldBase newfield = (EMPExtFieldBase)((Object)this.clone());
            newfield.setOnlyControlElement(false);
            ((EMPExtGridLayout)this.parent).addCMISDataField(newfield);
            EMPExtPageObjects pageObjs = (EMPExtPageObjects)this.pageContext.getRequest().getAttribute("EMP_PAGE_OBJECTS");
            if (pageObjs != null) {
                pageObjs.addDataField(this.id);
            }
        } else {
            EMPExtPageObjects pageObjs;
            if (this.flat != null) {
                flat = this.flat;
            }
            if ((pageObjs = (EMPExtPageObjects)this.pageContext.getRequest().getAttribute("EMP_PAGE_OBJECTS")) != null) {
                pageObjs.addDataField(this.id);
            }
            StringBuffer sb = new StringBuffer();
            this.renderFieldTag(sb, null, flat);
            this.outputContent(sb.toString());
        }
        return 0;
    }

    public void renderFieldTag(StringBuffer sb, KeyedCollection kColl, boolean flat) {
        this.renderFieldTag(sb, kColl, flat, false);
    }

    public void renderFieldTag(StringBuffer sb, KeyedCollection kColl, boolean flat, boolean groupTitle) {
        HttpServletRequest request;
        Map dataTypeDefMap;
        EMPDataType empDataType;
        IndexedCollection dicIColl;
        EMPExtPageObjects pageObjs = (EMPExtPageObjects)this.pageContext.getRequest().getAttribute("EMP_PAGE_OBJECTS");
        if (pageObjs != null && this.dictname != null && !pageObjs.hasDataDic(this.dictname) && (dicIColl = this.getDictMapCollection(this.dictname)) != null) {
            pageObjs.addDataDic(this.dictname, dicIColl, "cn");
        }
        sb.append("<span");
        this.writeAttribute(sb, "id", "emp_field_" + this.id);
        this.writeAttribute(sb, "title", this.label);
        if (flat) {
            this.writeAttribute(sb, "type", "Base");
        } else {
            this.writeAttribute(sb, "type", this.getType());
        }
        this.writeAttribute(sb, "tooltip", this.getHelp());
        this.writeAttribute(sb, "class", this.cssClass);
        this.writeAttribute(sb, "cssErrorClass", this.cssErrorClass);
        this.writeAttribute(sb, "cssRequiredClass", this.cssRequiredClass);
        this.writeAttribute(sb, "required", this.required);
        if (groupTitle) {
            this.writeAttribute(sb, "hidden", "false");
        } else {
            this.writeAttribute(sb, "hidden", this.hidden);
        }
        this.writeAttribute(sb, "colSpan", this.colSpan);
        this.writeAttribute(sb, "disabled", this.disabled);
        this.writeAttribute(sb, "readonly", new Boolean(this.isReadonly()));
        this.writeAttribute(sb, "onlyControlElement", new Boolean(this.onlyControlElement));
        this.writeAttribute(sb, "dictname", this.dictname);
        if (kColl != null) {
            this.writeAttribute(sb, "statistic", this.statistic);
        }
        if (this.fieldErrorDataName != null) {
            String fieldErrorValue = this.getDataValue(String.valueOf(EMPConstance.ERROR_MSG_KCOLL) + "." + this.fieldErrorDataName);
            if (fieldErrorValue != null) {
                fieldErrorValue = this.getResourceValue(fieldErrorValue);
            }
            this.writeAttribute(sb, "fieldErrorValue", fieldErrorValue);
        }
        if (this.dataType != null && (empDataType = (EMPDataType)(dataTypeDefMap = (Map)(request = (HttpServletRequest)this.pageContext.getRequest()).getAttribute(EMPConstance.ATTR_DATA_TYPE)).get(this.dataType)) != null) {
            EMPDataTypeDef typeDef = empDataType.getDataTypeDef();
            this.writeAttribute(sb, "dataType", this.dataType);
            this.writeAttribute(sb, "validateJS", this.parseScriptStr(this.getLabel(), typeDef.getValidateJS().getFunction(), empDataType));
            this.writeAttribute(sb, "convertorJS", this.parseScriptStr(this.getLabel(), typeDef.getConvertorJS().getFunction(), empDataType));
            String rangeErrorMsg = "rangeErrorInfo";
            String formatErrorMsg = "formatErrorInfo";
            if (empDataType.getRangeErrorMsg() != null) {
                rangeErrorMsg = empDataType.getRangeErrorMsg();
            }
            if (empDataType.getFormatErrorMsg() != null) {
                formatErrorMsg = empDataType.getFormatErrorMsg();
            }
            rangeErrorMsg = this.getResourceValue(rangeErrorMsg);
            formatErrorMsg = this.getResourceValue(formatErrorMsg);
            if ("rangeErrorInfo".equals(rangeErrorMsg)) {
                rangeErrorMsg = "please input [$fieldName;] between [$max;] and [$min;]!";
            }
            if ("formatErrorInfo".equals(formatErrorMsg)) {
                formatErrorMsg = "input field [$fieldName;] format error,the right format as: [$format;]!";
            }
            rangeErrorMsg = this.parseScriptStr(this.getLabel(), rangeErrorMsg, empDataType);
            formatErrorMsg = this.parseScriptStr(this.getLabel(), formatErrorMsg, empDataType);
            this.writeAttribute(sb, "rangeErrorMsg", rangeErrorMsg);
            this.writeAttribute(sb, "formatErrorMsg", formatErrorMsg);
        }
        this.writeAttribute(sb, "value", this.getValue(kColl));
        sb.append(" ");
        this.renderOtherAttribute(sb, kColl, flat);
        this.writeAttribute(sb, "rendered", new Boolean(false));
        sb.append(">");
        if (flat) {
            this.renderFlatInnerHtml(sb, kColl);
        } else {
            this.renderInnerHtml(sb, kColl);
        }
        sb.append("</span>\n");
    }

    protected void renderFlatInnerHtml(StringBuffer sb, KeyedCollection kColl) {
        sb.append("<span");
        if (this.dataType != null) {
            if (this.dataType.equals("Currency") || this.dataType.equals("Rate") || this.dataType.equals("Rate4Month") || this.dataType.equals("Percent") || this.dataType.equals("Percent2") || this.dataType.equals("Permille") || this.dataType.equals("Short") || this.dataType.equals("Int") || this.dataType.equals("Long") || this.dataType.equals("Float") || this.dataType.equals("Double") || this.dataType.equals("Decimal5") || this.dataType.equals("DecimalA")) {
                this.writeAttribute(sb, "class", this.cssTDClassNumber);
            }
        } else {
            this.writeAttribute(sb, "class", this.cssFlatClass);
        }
        sb.append(">");
        String decoratedValue = this.getDecoratedValue(this.getValue(kColl), this.dictname, this.languageResouce);
        sb.append(decoratedValue);
        sb.append("</span>");
    }

    protected void addDefaultAttributes(StringBuffer sb, KeyedCollection kColl) {
        this.writeAttribute(sb, "tabindex", this.tabindex);
        this.writeAttribute(sb, "accesskey", this.accesskey);
        this.writeAttribute(sb, "onclick", this.onclick);
        this.writeAttribute(sb, "ondblclick", this.ondblclick);
        this.writeAttribute(sb, "onkeydown", this.onkeydown);
        this.writeAttribute(sb, "onkeypress", this.onkeypress);
        this.writeAttribute(sb, "onkeyup", this.onkeyup);
        this.writeAttribute(sb, "onmousedown", this.onmousedown);
        this.writeAttribute(sb, "onmousemove", this.onmousemove);
        this.writeAttribute(sb, "onmouseout", this.onmouseout);
        this.writeAttribute(sb, "onmouseover", this.onmouseover);
        this.writeAttribute(sb, "onmouseup", this.onmouseup);
    }

    protected String getValue(KeyedCollection kColl) {
        String value = null;
        if (kColl != null) {
            try {
                Object obj = kColl.getDataValue(this.id);
                if (obj != null) {
                    value = obj.toString();
                }
            }
            catch (Exception exception) {}
        } else {
            value = this.getDataValue(this.id);
        }
        if (value == null) {
            value = this.getDefvalue();
        }
        return value;
    }

    public String getTableHead() {
        return this.getLabel();
    }

    protected void cloneDafaultAttributes(EMPExtFieldBase target) {
        target.label = this.label;
        target.id = this.id;
        target.defvalue = this.defvalue;
        target.dictname = this.dictname;
        target.cssClass = this.cssClass;
        target.cssElementClass = this.cssElementClass;
        target.cssErrorClass = this.cssErrorClass;
        target.cssLabelClass = this.cssLabelClass;
        target.cssRequiredClass = this.cssRequiredClass;
        target.cssTDClass = this.cssTDClass;
        target.cssFlatClass = this.cssFlatClass;
        target.help = this.help;
        target.required = this.required;
        target.hidden = this.hidden;
        target.readonly = this.readonly;
        target.flat = this.flat;
        target.disabled = this.disabled;
        target.colSpan = this.colSpan;
        target.fieldErrorDataName = this.fieldErrorDataName;
        target.onlyControlElement = this.onlyControlElement;
        target.parent = this.parent;
        target.dataType = this.dataType;
        target.statistic = this.statistic;
        target.languageResouce = this.languageResouce;
        target.tabindex = this.tabindex;
        target.accesskey = this.accesskey;
        target.onclick = this.onclick;
        target.ondblclick = this.ondblclick;
        target.onkeydown = this.onkeydown;
        target.onkeypress = this.onkeypress;
        target.onkeyup = this.onkeyup;
        target.onmousedown = this.onmousedown;
        target.onmousemove = this.onmousemove;
        target.onmouseout = this.onmouseout;
        target.onmouseover = this.onmouseover;
        target.onmouseup = this.onmouseup;
        target.setPageContext(this.pageContext);
    }

    protected String parseScriptStr(String fieldLabel, String funcStr, EMPDataType dataType) {
        int idx = 0;
        StringBuffer dstStr = new StringBuffer();
        String tmp = funcStr;
        while (true) {
            idx = tmp.indexOf(36);
            int idx2 = tmp.indexOf(59, idx);
            if (idx == -1 || idx2 == -1) break;
            String paramName = tmp.substring(idx + 1, idx2);
            if (paramName.equals("fieldName")) {
                dstStr.append(tmp.substring(0, idx));
                dstStr.append(fieldLabel);
            } else {
                try {
                    dstStr.append(tmp.substring(0, idx));
                    String methodName = "get" + paramName.substring(0, 1).toUpperCase() + paramName.substring(1);
                    Class<?> aClass = dataType.getClass();
                    Method method = aClass.getMethod(methodName, null);
                    Object valueObj = method.invoke((Object)dataType, null);
                    String value = valueObj.toString();
                    dstStr.append(value);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            tmp = tmp.substring(idx2 + 1);
        }
        dstStr.append(tmp);
        String retValue = dstStr.toString();
        return retValue;
    }

    public void setParent(Tag tag) {
        this.parent = tag;
    }

    public String getCnname() {
        return this.getLabel();
    }

    public void setCnname(String cnname) {
        this.label = cnname;
    }

    public String getDefvalue() {
        String st_return = "";
        String value = this.defvalue;
        if (value != null && value.startsWith("$")) {
            HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
            Context context = (Context)request.getAttribute(EMPConstance.ATTR_CONTEXT);
            if (context != null) {
                try {
                    st_return = (String)context.getDataValue(value.substring(1));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (st_return == null) {
                st_return = request.getParameter(value.substring(1));
            }
        } else {
            st_return = this.defvalue;
        }
        return st_return;
    }

    public boolean isReadonly() {
        if (this.readonly != null) {
            return this.readonly;
        }
        return !this.judgeWritePermission(this.id);
    }

    public void setDefvalue(String defvalue) {
        this.defvalue = defvalue;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getLabel() {
        return this.getResourceValue(this.label);
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setHelp(String help) {
        this.help = help;
    }

    public String getHelp() {
        return this.help;
    }

    public void setColSpan(String colSpan) {
        this.colSpan = colSpan;
    }

    public String getColSpan() {
        return this.colSpan;
    }

    public String getDictname() {
        return this.dictname;
    }

    public void setDictname(String dictname) {
        this.dictname = dictname;
    }

    public boolean isStatistic() {
        if (this.statistic == null) {
            return false;
        }
        return this.statistic;
    }

    public void setStatistic(boolean statistic) {
        this.statistic = new Boolean(statistic);
    }

    public String getDataType() {
        return this.dataType;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public String getAccesskey() {
        return this.accesskey;
    }

    public void setAccesskey(String accesskey) {
        this.accesskey = accesskey;
    }

    public boolean isDisabled() {
        if (this.disabled == null) {
            return false;
        }
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = new Boolean(disabled);
    }

    public boolean isFlat() {
        if (this.flat == null) {
            return false;
        }
        return this.flat;
    }

    public void setFlat(boolean flat) {
        this.flat = new Boolean(flat);
    }

    public boolean isHidden() {
        if (this.hidden == null) {
            return false;
        }
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = new Boolean(hidden);
    }

    public boolean isLanguageResouce() {
        return this.languageResouce;
    }

    public void setLanguageResouce(boolean languageResouce) {
        this.languageResouce = languageResouce;
    }

    public String getOnclick() {
        return this.onclick;
    }

    public void setOnclick(String onclick) {
        this.onclick = onclick;
    }

    public String getOndblclick() {
        return this.ondblclick;
    }

    public void setOndblclick(String ondblclick) {
        this.ondblclick = ondblclick;
    }

    public String getOnkeydown() {
        return this.onkeydown;
    }

    public void setOnkeydown(String onkeydown) {
        this.onkeydown = onkeydown;
    }

    public String getOnkeypress() {
        return this.onkeypress;
    }

    public void setOnkeypress(String onkeypress) {
        this.onkeypress = onkeypress;
    }

    public String getOnkeyup() {
        return this.onkeyup;
    }

    public void setOnkeyup(String onkeyup) {
        this.onkeyup = onkeyup;
    }

    public String getOnmousedown() {
        return this.onmousedown;
    }

    public void setOnmousedown(String onmousedown) {
        this.onmousedown = onmousedown;
    }

    public String getOnmousemove() {
        return this.onmousemove;
    }

    public void setOnmousemove(String onmousemove) {
        this.onmousemove = onmousemove;
    }

    public String getOnmouseout() {
        return this.onmouseout;
    }

    public void setOnmouseout(String onmouseout) {
        this.onmouseout = onmouseout;
    }

    public String getOnmouseover() {
        return this.onmouseover;
    }

    public void setOnmouseover(String onmouseover) {
        this.onmouseover = onmouseover;
    }

    public String getOnmouseup() {
        return this.onmouseup;
    }

    public void setOnmouseup(String onmouseup) {
        this.onmouseup = onmouseup;
    }

    public void setReadonly(boolean readonly) {
        this.readonly = new Boolean(readonly);
    }

    public boolean isRequired() {
        if (this.required == null) {
            return false;
        }
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = new Boolean(required);
    }

    public String getTabindex() {
        return this.tabindex;
    }

    public void setTabindex(String tabindex) {
        this.tabindex = tabindex;
    }

    public Tag getParent() {
        return this.parent;
    }

    public String getCssClass() {
        return this.cssClass;
    }

    public void setCssClass(String cssClass) {
        this.cssClass = cssClass;
    }

    public String getCssErrorClass() {
        return this.cssErrorClass;
    }

    public void setCssErrorClass(String cssErrorClass) {
        this.cssErrorClass = cssErrorClass;
    }

    public String getCssLabelClass() {
        return this.cssLabelClass;
    }

    public void setCssLabelClass(String cssLabelClass) {
        this.cssLabelClass = cssLabelClass;
    }

    public String getCssRequiredClass() {
        return this.cssRequiredClass;
    }

    public void setCssRequiredClass(String cssRequiredClass) {
        this.cssRequiredClass = cssRequiredClass;
    }

    public String getCssTDClass() {
        return this.cssTDClass;
    }

    public void setCssTDClass(String cssTDClass) {
        this.cssTDClass = cssTDClass;
    }

    public String getCssElementClass() {
        return this.cssElementClass;
    }

    public void setCssElementClass(String cssElementClass) {
        this.cssElementClass = cssElementClass;
    }

    public String getCssFlatClass() {
        return this.cssFlatClass;
    }

    public void setCssFlatClass(String cssFlatClass) {
        this.cssFlatClass = cssFlatClass;
    }

    public String getFieldErrorDataName() {
        return this.fieldErrorDataName;
    }

    public void setFieldErrorDataName(String fieldErrorDataName) {
        this.fieldErrorDataName = fieldErrorDataName;
    }

    public boolean isOnlyControlElement() {
        return this.onlyControlElement;
    }

    public void setOnlyControlElement(boolean onlyControlElement) {
        this.onlyControlElement = onlyControlElement;
    }
}

