/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.emp.dao;

import com.ecc.emp.core.Context;
import com.ecc.emp.core.EMPConstance;
import com.ecc.emp.core.EMPException;
import com.ecc.emp.data.DataElement;
import com.ecc.emp.data.IndexedCollection;
import com.ecc.emp.data.KeyedCollection;
import com.ecc.emp.jdbc.ConnectionManager;
import com.ecc.emp.jdbc.EMPJDBCException;
import com.ecc.emp.log.EMPLog;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;

public class SqlOperator {
    private String sql;
    private DataSource dataSource;

    private SqlOperator(String sql, DataSource dataSource) {
        this.sql = sql;
        this.dataSource = dataSource;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public KeyedCollection executeSQL(List inputValue) throws EMPJDBCException {
        KeyedCollection keyedCollection;
        Connection connection;
        block23: {
            connection = null;
            Statement pState = null;
            try {
                KeyedCollection retKColl;
                block22: {
                    EMPLog.log((String)EMPConstance.EMP_JDBC, (int)EMPLog.DEBUG, (int)0, (String)("Execute SQL: " + this.sql));
                    this.checkSql(this.sql);
                    connection = ConnectionManager.getConnection((DataSource)this.dataSource);
                    pState = connection.prepareStatement(this.sql);
                    if (inputValue != null) {
                        int i = 0;
                        while (i < inputValue.size()) {
                            Object obj = inputValue.get(i);
                            if (obj != null) {
                                EMPLog.log((String)EMPConstance.EMP_JDBC, (int)EMPLog.DEBUG, (int)0, (String)("Set param[" + (i + 1) + "]'s value = " + obj));
                                pState.setObject(i + 1, obj);
                            } else {
                                EMPLog.log((String)EMPConstance.EMP_JDBC, (int)EMPLog.DEBUG, (int)0, (String)("Set param[" + (i + 1) + "]'s value with null"));
                                pState.setString(i + 1, "");
                            }
                            ++i;
                        }
                    }
                    boolean isRS = pState.execute();
                    retKColl = new KeyedCollection();
                    if (isRS) {
                        ResultSet rs = pState.getResultSet();
                        ResultSetMetaData metaData = rs.getMetaData();
                        IndexedCollection iColl = new IndexedCollection("resultSet");
                        KeyedCollection kColl = new KeyedCollection();
                        ArrayList<String> columnList = new ArrayList<String>();
                        int i = 1;
                        while (true) {
                            if (i > metaData.getColumnCount()) break;
                            String column = metaData.getColumnName(i).toLowerCase();
                            kColl.addDataField(column, null);
                            columnList.add(column);
                            ++i;
                        }
                        iColl.setDataElement((DataElement)kColl);
                        block11: while (true) {
                            if (!rs.next()) {
                                rs.close();
                                retKColl.addDataElement((DataElement)iColl);
                                break block22;
                            }
                            KeyedCollection aKColl = (KeyedCollection)kColl.clone();
                            int i2 = 0;
                            while (true) {
                                if (i2 >= columnList.size()) {
                                    iColl.addDataElement((DataElement)aKColl);
                                    continue block11;
                                }
                                String column = (String)columnList.get(i2);
                                String value = rs.getString(column);
                                aKColl.setDataValue(column, (Object)value);
                                ++i2;
                            }
                            break;
                        }
                    }
                    int retValue = pState.getUpdateCount();
                    retKColl.addDataField("retValue", (Object)String.valueOf(retValue));
                }
                pState.close();
                pState = null;
                keyedCollection = retKColl;
                if (pState == null) break block23;
            }
            catch (SQLException se) {
                try {
                    EMPLog.log((String)EMPConstance.EMP_JDBC, (int)EMPLog.ERROR, (int)0, (String)("Failed to Execute SQL [" + this.sql + "] due to SQLException !"), (Throwable)se);
                    throw new EMPJDBCException("Failed to Execute SQL [" + this.sql + "] due to SQLException !", (Throwable)se);
                    catch (EMPException ee) {
                        EMPLog.log((String)EMPConstance.EMP_JDBC, (int)EMPLog.ERROR, (int)0, (String)("Failed to Execute SQL [" + this.sql + "] !"), (Throwable)ee);
                        throw new EMPJDBCException("Failed to Execute SQL [" + this.sql + "] !", (Throwable)ee);
                    }
                }
                catch (Throwable throwable) {
                    if (pState != null) {
                        try {
                            pState.close();
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                    }
                    if (connection != null) {
                        ConnectionManager.releaseConnection((DataSource)this.dataSource, connection);
                    }
                    throw throwable;
                }
            }
            try {
                pState.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (connection != null) {
            ConnectionManager.releaseConnection((DataSource)this.dataSource, (Connection)connection);
        }
        return keyedCollection;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public KeyedCollection executeSQL(List[] inputValues) throws EMPJDBCException {
        KeyedCollection keyedCollection;
        Connection connection;
        block24: {
            connection = null;
            Statement pState = null;
            try {
                EMPLog.log((String)EMPConstance.EMP_JDBC, (int)EMPLog.DEBUG, (int)0, (String)("Execute SQL: " + this.sql));
                this.checkSql(this.sql);
                connection = ConnectionManager.getConnection((DataSource)this.dataSource);
                pState = connection.prepareStatement(this.sql);
                KeyedCollection retKColl = new KeyedCollection();
                int j = 0;
                while (true) {
                    block26: {
                        boolean isRS;
                        if (j >= inputValues.length) {
                            pState.close();
                            pState = null;
                            keyedCollection = retKColl;
                            if (pState == null) break block24;
                            break;
                        }
                        List inputValue = inputValues[j];
                        if (inputValue != null) {
                            int i = 0;
                            while (i < inputValue.size()) {
                                Object obj = inputValue.get(i);
                                if (obj != null) {
                                    EMPLog.log((String)EMPConstance.EMP_JDBC, (int)EMPLog.DEBUG, (int)0, (String)("Set param[" + (i + 1) + "]'s value = " + obj));
                                    pState.setObject(i + 1, obj);
                                } else {
                                    EMPLog.log((String)EMPConstance.EMP_JDBC, (int)EMPLog.DEBUG, (int)0, (String)("Set param[" + (i + 1) + "]'s value with null"));
                                    pState.setString(i + 1, "");
                                }
                                ++i;
                            }
                        }
                        if (isRS = pState.execute()) {
                            ResultSet rs = pState.getResultSet();
                            ResultSetMetaData metaData = rs.getMetaData();
                            IndexedCollection iColl = new IndexedCollection("resultSet[" + j + "]");
                            KeyedCollection kColl = new KeyedCollection();
                            ArrayList<String> columnList = new ArrayList<String>();
                            int i = 1;
                            while (true) {
                                if (i > metaData.getColumnCount()) break;
                                String column = metaData.getColumnName(i).toLowerCase();
                                kColl.addDataField(column, null);
                                columnList.add(column);
                                ++i;
                            }
                            iColl.setDataElement((DataElement)kColl);
                            block12: while (true) {
                                if (!rs.next()) {
                                    rs.close();
                                    retKColl.addDataElement((DataElement)iColl);
                                    break block26;
                                }
                                KeyedCollection aKColl = (KeyedCollection)kColl.clone();
                                int i2 = 0;
                                while (true) {
                                    if (i2 >= columnList.size()) {
                                        iColl.addDataElement((DataElement)aKColl);
                                        continue block12;
                                    }
                                    String column = (String)columnList.get(i2);
                                    String value = rs.getString(column);
                                    aKColl.setDataValue(column, (Object)value);
                                    ++i2;
                                }
                                break;
                            }
                        }
                        int retValue = pState.getUpdateCount();
                        retKColl.addDataField("retValue[" + j + "]", (Object)String.valueOf(retValue));
                    }
                    ++j;
                }
            }
            catch (SQLException se) {
                try {
                    EMPLog.log((String)EMPConstance.EMP_JDBC, (int)EMPLog.ERROR, (int)0, (String)("Failed to Execute SQL [" + this.sql + "] due to SQLException !"), (Throwable)se);
                    throw new EMPJDBCException("Failed to Execute SQL [" + this.sql + "] due to SQLException !", (Throwable)se);
                    catch (EMPException ee) {
                        EMPLog.log((String)EMPConstance.EMP_JDBC, (int)EMPLog.ERROR, (int)0, (String)("Failed to Execute SQL [" + this.sql + "] !"), (Throwable)ee);
                        throw new EMPJDBCException("Failed to Execute SQL [" + this.sql + "] !", (Throwable)ee);
                    }
                }
                catch (Throwable throwable) {
                    if (pState != null) {
                        try {
                            pState.close();
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                    }
                    if (connection != null) {
                        ConnectionManager.releaseConnection((DataSource)this.dataSource, connection);
                    }
                    throw throwable;
                }
            }
            try {
                pState.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (connection != null) {
            ConnectionManager.releaseConnection((DataSource)this.dataSource, (Connection)connection);
        }
        return keyedCollection;
    }

    protected void checkSql(String sql) throws EMPJDBCException {
        String tmpSql;
        int idx = sql.indexOf("--");
        if (idx != -1 && (tmpSql = sql.substring(0, idx)) != null && ((tmpSql = tmpSql.trim()).endsWith("'") || tmpSql.endsWith("\""))) {
            throw new EMPJDBCException("Invalid SQL with mark \"--\" !");
        }
        idx = sql.indexOf("/*");
        if (idx != -1 && (sql = sql.substring(idx + 2)) != null && sql.indexOf("*/") > -1) {
            throw new EMPJDBCException("Invalid SQL with mark \"/*\" !");
        }
    }

    public static SqlOperator createSqlOperator(String sql, String dataSourceName, Context context) throws EMPException {
        DataSource dataSource = (DataSource)context.getService(dataSourceName);
        if (dataSource == null) {
            throw new EMPException("DataSource [" + dataSourceName + "] not found!");
        }
        return new SqlOperator(sql, dataSource);
    }

    public static SqlOperator createSqlOperator(String sql, DataSource dataSource) throws EMPException {
        return new SqlOperator(sql, dataSource);
    }
}

