/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.emp.dbmodel.service;

import com.ecc.emp.core.EMPConstance;
import com.ecc.emp.core.EMPException;
import com.ecc.emp.data.DataElement;
import com.ecc.emp.data.DataField;
import com.ecc.emp.data.IndexedCollection;
import com.ecc.emp.data.InvalidArgumentException;
import com.ecc.emp.data.KeyedCollection;
import com.ecc.emp.dbmodel.One2MultiRef;
import com.ecc.emp.dbmodel.One2OneRef;
import com.ecc.emp.dbmodel.PageInfo;
import com.ecc.emp.dbmodel.TableModel;
import com.ecc.emp.dbmodel.TableModelField;
import com.ecc.emp.dbmodel.service.EncryptService;
import com.ecc.emp.dbmodel.service.TableModelLoader;
import com.ecc.emp.dbmodel.service.pkgenerator.AbstractPkGenerator;
import com.ecc.emp.dbmodel.service.pkgenerator.PkGeneratorSet;
import com.ecc.emp.jdbc.EMPJDBCException;
import com.ecc.emp.log.EMPLog;
import com.ecc.emp.service.EMPService;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class TableModelDAO
extends EMPService {
    protected EncryptService encryptService = null;
    protected TableModelLoader modelLoader = null;
    protected PkGeneratorSet pkGeneratorSet = null;

    public void setTableModelLoader(TableModelLoader modelLoader) {
        this.modelLoader = modelLoader;
    }

    public TableModelLoader getTableModelLoader() {
        return this.modelLoader;
    }

    public void setPkGeneratorSet(PkGeneratorSet pkGeneratorSet) {
        this.pkGeneratorSet = pkGeneratorSet;
    }

    public void setEncryptService(EncryptService encryptService) {
        this.encryptService = encryptService;
    }

    public int insert(KeyedCollection modelKcoll, Connection con) throws EMPJDBCException {
        String modelId = modelKcoll.getName();
        TableModel model = this.modelLoader.getTableModel(modelId);
        if (model == null) {
            throw new EMPJDBCException("TableModel[" + modelId + "]\u672a\u5b9a\u4e49\uff01");
        }
        HashMap<String, Object> pFieldMap = new HashMap<String, Object>();
        for (DataElement element : modelKcoll.values()) {
            if (!(element instanceof DataField)) continue;
            DataField aField = (DataField)element;
            pFieldMap.put(aField.getName(), aField.getValue());
        }
        this.generatePkValue(model, pFieldMap, modelKcoll);
        HashMap<TableModel, Cloneable> refModelData = new HashMap<TableModel, Cloneable>();
        for (DataElement element2 : modelKcoll.values()) {
            TableModel refModel;
            String refId;
            if (element2 instanceof KeyedCollection) {
                KeyedCollection kcoll = (KeyedCollection)element2;
                refId = kcoll.getName();
                One2OneRef oneRef = model.getOne2OneRef(refId);
                if (oneRef == null) {
                    EMPLog.log((String)EMPConstance.EMP_JDBC, (int)EMPLog.WARNING, (int)0, (String)("Insert\u64cd\u4f5c\u4e2d\u53d1\u73b0\u6570\u636e\u5197\u4f59:KColl[" + refId + "]."));
                    continue;
                }
                refModel = this.modelLoader.getTableModel(oneRef.getRefModelId());
                if (refModel == null) {
                    throw new EMPJDBCException("One2OneRef\u5f15\u7528\u5173\u7cfb\u5b9a\u4e49\u6709\u8bef\uff0cTableModel[" + oneRef.getRefModelId() + "]\u672a\u5b9a\u4e49\uff01");
                }
                HashMap<String, Object> sFieldMap = new HashMap<String, Object>();
                for (DataElement element2 : kcoll.values()) {
                    if (!(element2 instanceof DataField)) continue;
                    DataField aField = (DataField)element2;
                    sFieldMap.put(aField.getName(), aField.getValue());
                }
                Object refValue = null;
                try {
                    refValue = pFieldMap.get(oneRef.getFromField());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (sFieldMap.get(oneRef.getToField()) == null || sFieldMap.get(oneRef.getToField()).equals(refValue)) {
                    sFieldMap.remove(oneRef.getToField());
                    sFieldMap.put(oneRef.getToField(), refValue);
                } else if (!oneRef.isFKRef(model) || refValue != null) {
                    throw new EMPJDBCException("Insert\u64cd\u4f5c\u4e2d\u53d1\u73b0\u4ece\u8868[" + refModel.getId() + "]\u7684\u5173\u8054\u5b57\u6bb5\u6570\u636e\u51b2\u7a81\uff01");
                }
                this.generatePkValue(refModel, sFieldMap, kcoll);
                if (oneRef.isFKRef(model)) {
                    this.insertSingleRecord(refModel, sFieldMap, con);
                } else {
                    refModelData.put(refModel, sFieldMap);
                }
                if (!oneRef.isFKRef(model) || pFieldMap.get(oneRef.getFromField()) != null) continue;
                pFieldMap.remove(oneRef.getFromField());
                pFieldMap.put(oneRef.getFromField(), sFieldMap.get(oneRef.getToField()));
                continue;
            }
            if (!(element2 instanceof IndexedCollection)) continue;
            IndexedCollection icoll = (IndexedCollection)element2;
            refId = icoll.getName();
            One2MultiRef multiRef = model.getOne2MultiRef(refId);
            if (multiRef == null) {
                EMPLog.log((String)EMPConstance.EMP_JDBC, (int)EMPLog.WARNING, (int)0, (String)("Insert\u64cd\u4f5c\u4e2d\u53d1\u73b0\u6570\u636e\u5197\u4f59:IColl[" + refId + "]."));
                continue;
            }
            refModel = this.modelLoader.getTableModel(multiRef.getRefModelId());
            if (refModel == null) {
                throw new EMPJDBCException("One2MultiRef\u5f15\u7528\u5173\u7cfb\u5b9a\u4e49\u6709\u8bef\uff0cTableModel[" + multiRef.getRefModelId() + "]\u672a\u5b9a\u4e49\uff01");
            }
            ArrayList refDataList = new ArrayList();
            int i = 0;
            while (i < icoll.size()) {
                KeyedCollection kcoll = (KeyedCollection)icoll.get(i);
                HashMap<String, Object> sFieldMap = new HashMap<String, Object>();
                for (DataElement element2 : kcoll.values()) {
                    if (!(element2 instanceof DataField)) continue;
                    DataField aField = (DataField)element2;
                    sFieldMap.put(aField.getName(), aField.getValue());
                }
                Object refValue = null;
                try {
                    refValue = pFieldMap.get(multiRef.getFromField());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (refValue == null) {
                    throw new EMPJDBCException("Insert\u64cd\u4f5c\u4e2d\u53d1\u73b0\u5b50\u8868[" + refModel.getId() + "]\u7684\u5173\u8054\u5b57\u6bb5\u6570\u636e\u503c\u4e3aNULL\uff01");
                }
                if (sFieldMap.get(multiRef.getToField()) != null && !sFieldMap.get(multiRef.getToField()).equals(refValue)) {
                    throw new EMPJDBCException("Insert\u64cd\u4f5c\u4e2d\u53d1\u73b0\u5b50\u8868[" + refModel.getId() + "]\u7684\u5173\u8054\u5b57\u6bb5\u6570\u636e\u503c\u51b2\u7a81\uff01");
                }
                sFieldMap.remove(multiRef.getToField());
                sFieldMap.put(multiRef.getToField(), refValue);
                this.generatePkValue(refModel, sFieldMap, kcoll);
                refDataList.add(sFieldMap);
                ++i;
            }
            refModelData.put(refModel, refDataList);
        }
        int result = this.insertSingleRecord(model, pFieldMap, con);
        for (TableModel refModel : refModelData.keySet()) {
            Object valueObj = refModelData.get(refModel);
            if (valueObj instanceof Map) {
                this.insertSingleRecord(refModel, (Map)valueObj, con);
                continue;
            }
            if (!(valueObj instanceof List)) continue;
            List valueList = (List)valueObj;
            int i = 0;
            while (i < valueList.size()) {
                this.insertSingleRecord(refModel, (Map)valueList.get(i), con);
                ++i;
            }
        }
        return result;
    }

    private Map generatePkValue(TableModel model, Map insertValues, KeyedCollection modelKcoll) throws EMPJDBCException {
        for (TableModelField field : model.getModelFields().values()) {
            if (!field.isPK()) continue;
            Object insertObj = insertValues.get(field.getId());
            if (insertObj == null || "".equals(insertObj)) {
                if (field.getPkGenerator() == null) {
                    throw new EMPJDBCException("\u6a21\u578b\u5b57\u6bb5[" + field.getId() + "]\u672a\u914d\u7f6ePk\u751f\u6210\u5668\uff0c\u65e0\u6cd5\u81ea\u52a8\u751f\u6210\u4e3b\u952e\u503c\uff01");
                }
                AbstractPkGenerator pkGenerator = this.pkGeneratorSet.getGenerator(field.getPkGenerator());
                if (pkGenerator == null) {
                    throw new EMPJDBCException("PkGenerator[" + field.getPkGenerator() + "]\u672a\u5b9a\u4e49\uff01");
                }
                String pk_value = pkGenerator.generatePkValue(null);
                insertValues.remove(field.getId());
                insertValues.put(field.getId(), pk_value);
                try {
                    modelKcoll.setDataValue(field.getId(), (Object)pk_value);
                }
                catch (Exception e) {
                    try {
                        modelKcoll.addDataField(field.getId(), (Object)pk_value);
                    }
                    catch (Exception exception) {}
                }
                continue;
            }
            if (field.getPkGenerator() == null) continue;
            EMPLog.log((String)EMPConstance.EMP_JDBC, (int)EMPLog.WARNING, (int)0, (String)("\u6a21\u578b\u5b57\u6bb5[" + field.getId() + "]\u4f20\u5165\u503c[" + insertObj.toString() + "]\u88ab\u63a5\u53d7\uff0cPk\u751f\u6210\u5668\u672a\u8c03\u7528."));
        }
        return insertValues;
    }

    protected int insertSingleRecord(TableModel model, Map insertValues, Connection con) throws EMPJDBCException {
        Statement state = null;
        try {
            ArrayList<TableModelField> insertFieldList = new ArrayList<TableModelField>();
            Iterator<Object> iterator = insertValues.keySet().iterator();
            String strSQL = null;
            StringBuffer strSQLBuf = new StringBuffer("INSERT INTO " + model.getDbTableName() + "( ");
            while (iterator.hasNext()) {
                String fieldId = (String)iterator.next();
                TableModelField modelField = model.getModelField(fieldId);
                if (modelField == null) {
                    EMPLog.log((String)EMPConstance.EMP_JDBC, (int)EMPLog.WARNING, (int)0, (String)("Insert\u64cd\u4f5c\u4e2d\u53d1\u73b0\u6570\u636e\u5197\u4f59:Field[" + fieldId + "]."));
                    continue;
                }
                insertFieldList.add(modelField);
            }
            if (insertFieldList.isEmpty()) {
                throw new EMPJDBCException("Insert\u64cd\u4f5c\u4e2d\u53d1\u73b0TableModel[" + model.getId() + "]\u672a\u63d0\u4f9b\u5f85\u63d2\u5165\u5b57\u6bb5.");
            }
            iterator = insertFieldList.iterator();
            while (iterator.hasNext()) {
                TableModelField field = (TableModelField)iterator.next();
                if (iterator.hasNext()) {
                    strSQLBuf.append(String.valueOf(field.getColumnName()) + ",");
                    continue;
                }
                strSQLBuf.append(String.valueOf(field.getColumnName()) + ")");
            }
            strSQLBuf.append(" VALUES(");
            int j = 0;
            while (j < insertFieldList.size()) {
                if (j < insertFieldList.size() - 1) {
                    strSQLBuf.append("?,");
                } else {
                    strSQLBuf.append("?)");
                }
                ++j;
            }
            strSQL = strSQLBuf.toString();
            state = con.prepareStatement(strSQL);
            int i = 0;
            while (i < insertFieldList.size()) {
                TableModelField field = (TableModelField)insertFieldList.get(i);
                Object fieldValue = insertValues.get(field.getId());
                if (fieldValue != null) {
                    if (!field.isCharType() && fieldValue.toString().trim().length() == 0) {
                        EMPLog.log((String)EMPConstance.EMP_JDBC, (int)EMPLog.DEBUG, (int)0, (String)("Set column [" + field.getColumnName() + "]'s value with null"));
                        state.setNull(i + 1, field.getColumnType());
                    } else {
                        if (this.encryptService != null && field.isEncrypted()) {
                            fieldValue = this.encryptService.encrypt(fieldValue, field.getColumnType());
                        }
                        EMPLog.log((String)EMPConstance.EMP_JDBC, (int)EMPLog.DEBUG, (int)0, (String)("Set column [" + field.getColumnName() + "]'s value = " + fieldValue));
                        state.setObject(i + 1, fieldValue);
                    }
                } else {
                    EMPLog.log((String)EMPConstance.EMP_JDBC, (int)EMPLog.DEBUG, (int)0, (String)("Set column [" + field.getColumnName() + "]'s value with null"));
                    state.setNull(i + 1, field.getColumnType());
                }
                ++i;
            }
            int result = state.executeUpdate();
            EMPLog.log((String)EMPConstance.EMP_JDBC, (int)EMPLog.DEBUG, (int)0, (String)(String.valueOf(result) + " records in tableModel [" + model.getId() + "] has been INSERT."));
            state.close();
            int n = result;
            return n;
        }
        catch (SQLException se) {
            EMPLog.log((String)EMPConstance.EMP_JDBC, (int)EMPLog.ERROR, (int)0, (String)("Failed to INSERT record in tableModel [" + model.getId() + "] due to SQLException !"), (Throwable)se);
            throw new EMPJDBCException("Failed to INSERT record in tableModel [" + model.getId() + "] due to SQLException !", (Throwable)se);
        }
        finally {
            if (state != null) {
                try {
                    state.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    public int deleteByPk(String modelId, String pk_value, Connection con) throws EMPJDBCException {
        TableModel model = this.modelLoader.getTableModel(modelId);
        if (model == null) {
            throw new EMPJDBCException("TableModel[" + modelId + "]\u672a\u5b9a\u4e49\uff01");
        }
        HashMap<String, String> pk_values = new HashMap<String, String>();
        for (TableModelField field : model.getModelFields().values()) {
            if (!field.isPK()) continue;
            if (pk_values.isEmpty()) {
                pk_values.put(field.getId(), pk_value);
                continue;
            }
            throw new EMPJDBCException("TableModel[" + modelId + "]\u5b58\u5728\u8054\u5408\u4e3b\u952e\uff0c\u8be5\u65b9\u6cd5\u4e0d\u652f\u6301!");
        }
        return this.deleteByPks(modelId, pk_values, con);
    }

    public int deleteByPks(String modelId, Map pk_values, Connection con) throws EMPJDBCException {
        TableModel model = this.modelLoader.getTableModel(modelId);
        if (model == null) {
            throw new EMPJDBCException("TableModel[" + modelId + "]\u672a\u5b9a\u4e49\uff01");
        }
        HashMap pkFieldMap = new HashMap();
        for (TableModelField field : model.getModelFields().values()) {
            if (!field.isPK()) continue;
            Object objValue = pk_values.get(field.getId());
            if (objValue == null) {
                throw new EMPJDBCException("TableModel[" + modelId + "]\u7684\u4e3b\u952e[" + field.getId() + "]\u503c\u4e3aNULL!");
            }
            pkFieldMap.put(field.getId(), objValue);
        }
        int result = this.deleteByField(model, pkFieldMap, con);
        return result;
    }

    public int deleteAllByPk(String modelId, String pk_value, Connection con) throws EMPJDBCException {
        TableModel model = this.modelLoader.getTableModel(modelId);
        if (model == null) {
            throw new EMPJDBCException("TableModel[" + modelId + "]\u672a\u5b9a\u4e49\uff01");
        }
        HashMap<String, String> pk_values = new HashMap<String, String>();
        for (TableModelField field : model.getModelFields().values()) {
            if (!field.isPK()) continue;
            if (pk_values.isEmpty()) {
                pk_values.put(field.getId(), pk_value);
                continue;
            }
            throw new EMPJDBCException("TableModel[" + modelId + "]\u5b58\u5728\u8054\u5408\u4e3b\u952e\uff0c\u8be5\u65b9\u6cd5\u4e0d\u652f\u6301!");
        }
        return this.deleteAllByPks(modelId, pk_values, con);
    }

    public int deleteAllByPks(String modelId, Map pk_values, Connection con) throws EMPJDBCException {
        TableModel model = this.modelLoader.getTableModel(modelId);
        if (model == null) {
            throw new EMPJDBCException("TableModel[" + modelId + "]\u672a\u5b9a\u4e49\uff01");
        }
        HashMap pkFieldMap = new HashMap();
        for (TableModelField field : model.getModelFields().values()) {
            if (!field.isPK()) continue;
            Object objValue = pk_values.get(field.getId());
            if (objValue == null) {
                throw new EMPJDBCException("TableModel[" + modelId + "]\u7684\u4e3b\u952e[" + field.getId() + "]\u503c\u4e3aNULL!");
            }
            pkFieldMap.put(field.getId(), objValue);
        }
        HashMap fkRefModels = new HashMap();
        if (model.isComplex()) {
            HashMap refFields;
            TableModel refModel;
            TableModelField field;
            Map fkFieldMap = new HashMap<String, TableModelField>();
            for (One2OneRef oneRef : model.getOne2OneModels().values()) {
                if (!oneRef.isFKRef(model) || fkFieldMap.containsKey((field = model.getModelField(oneRef.getFromField())).getId())) continue;
                fkFieldMap.put(field.getId(), field);
            }
            for (One2MultiRef multiRef : model.getOne2MultiModels().values()) {
                if (!multiRef.isFKRef(model) || fkFieldMap.containsKey((field = model.getModelField(multiRef.getFromField())).getId())) continue;
                fkFieldMap.put(field.getId(), field);
            }
            if (!fkFieldMap.isEmpty()) {
                ArrayList refFieldList = new ArrayList();
                refFieldList.addAll(fkFieldMap.keySet());
                refFieldList.addAll(pkFieldMap.keySet());
                String pkCondition = this.makeConditionByFields(model, pkFieldMap);
                IndexedCollection icoll = this.queryByCondition(model, refFieldList, pkCondition, con);
                fkFieldMap = icoll.isEmpty() ? (Map)icoll.getDataElement() : (Map)icoll.get(0);
            } else {
                fkFieldMap = pkFieldMap;
            }
            for (One2OneRef oneRef : model.getOne2OneModels().values()) {
                refModel = this.modelLoader.getTableModel(oneRef.getRefModelId());
                if (refModel == null) {
                    throw new EMPJDBCException("One2OneRef\u5f15\u7528\u5173\u7cfb\u5b9a\u4e49\u6709\u8bef\uff0cTableModel[" + oneRef.getRefModelId() + "]\u672a\u5b9a\u4e49\uff01");
                }
                refFields = new HashMap();
                refFields.put(oneRef.getToField(), fkFieldMap.get(oneRef.getFromField()));
                if (oneRef.isFKRef(model)) {
                    fkRefModels.put(refModel, refFields);
                    continue;
                }
                this.deleteByField(refModel, refFields, con);
            }
            for (One2MultiRef multiRef : model.getOne2MultiModels().values()) {
                refModel = this.modelLoader.getTableModel(multiRef.getRefModelId());
                if (refModel == null) {
                    throw new EMPJDBCException("One2MultiRef\u5f15\u7528\u5173\u7cfb\u5b9a\u4e49\u6709\u8bef\uff0cTableModel[" + multiRef.getRefModelId() + "]\u672a\u5b9a\u4e49\uff01");
                }
                refFields = new HashMap();
                refFields.put(multiRef.getToField(), fkFieldMap.get(multiRef.getFromField()));
                this.deleteByField(refModel, refFields, con);
            }
        }
        int result = this.deleteByField(model, pkFieldMap, con);
        for (TableModel refModel : fkRefModels.keySet()) {
            Map refFields = (Map)fkRefModels.get(refModel);
            this.deleteByField(refModel, refFields, con);
        }
        return result;
    }

    protected String makeConditionByFields(TableModel model, Map fieldValues) {
        if (fieldValues.isEmpty()) {
            return null;
        }
        StringBuffer buffer = new StringBuffer(" WHERE ");
        Iterator it = fieldValues.keySet().iterator();
        while (it.hasNext()) {
            String fieldId = (String)it.next();
            TableModelField field = model.getModelField(fieldId);
            if (field == null) continue;
            if (field.isCharType()) {
                buffer.append(String.valueOf(field.getColumnName()) + " = '" + fieldValues.get(fieldId) + "' ");
            } else {
                buffer.append(String.valueOf(field.getColumnName()) + " = " + fieldValues.get(fieldId) + " ");
            }
            if (!it.hasNext()) continue;
            buffer.append(" AND ");
        }
        return buffer.toString();
    }

    protected int deleteByField(TableModel model, Map conditionFields, Connection con) throws EMPJDBCException {
        Statement state = null;
        try {
            ArrayList<TableModelField> deleteFieldList = new ArrayList<TableModelField>();
            String strSQL = null;
            StringBuffer strSQLBuf = new StringBuffer("DELETE FROM " + model.getDbTableName() + " WHERE ");
            Iterator iterator = conditionFields.keySet().iterator();
            while (iterator.hasNext()) {
                String fieldId = (String)iterator.next();
                TableModelField modelField = model.getModelField(fieldId);
                if (modelField == null) continue;
                deleteFieldList.add(modelField);
                if (iterator.hasNext()) {
                    strSQLBuf.append(String.valueOf(modelField.getColumnName()) + " = ? AND ");
                    continue;
                }
                strSQLBuf.append(String.valueOf(modelField.getColumnName()) + " = ? ");
            }
            if (deleteFieldList.isEmpty()) {
                throw new EMPJDBCException("Delete\u64cd\u4f5c\u4e2d\u53d1\u73b0TableModel[" + model.getId() + "]\u672a\u63d0\u4f9b\u6761\u4ef6\u5b57\u6bb5\uff0c\u64cd\u4f5c\u672a\u6267\u884c\uff01");
            }
            strSQL = strSQLBuf.toString();
            state = con.prepareStatement(strSQL);
            int i = 0;
            while (i < deleteFieldList.size()) {
                TableModelField field = (TableModelField)deleteFieldList.get(i);
                Object fieldValue = conditionFields.get(field.getId());
                if (fieldValue != null) {
                    EMPLog.log((String)EMPConstance.EMP_JDBC, (int)EMPLog.DEBUG, (int)0, (String)("Set condition's field [" + field.getColumnName() + "]'s value = " + fieldValue));
                    state.setObject(i + 1, fieldValue);
                } else {
                    EMPLog.log((String)EMPConstance.EMP_JDBC, (int)EMPLog.DEBUG, (int)0, (String)("Set condition's field [" + field.getColumnName() + "]'s value with null"));
                    state.setNull(i + 1, field.getColumnType());
                }
                ++i;
            }
            int result = state.executeUpdate();
            EMPLog.log((String)EMPConstance.EMP_JDBC, (int)EMPLog.DEBUG, (int)0, (String)(String.valueOf(result) + " records in tableModel [" + model.getId() + "] has been DELETE."));
            state.close();
            int n = result;
            return n;
        }
        catch (SQLException se) {
            EMPLog.log((String)EMPConstance.EMP_JDBC, (int)EMPLog.ERROR, (int)0, (String)("Failed to DELETE record in tableModel [" + model.getId() + "] due to SQLException !"), (Throwable)se);
            throw new EMPJDBCException("Failed to DELETE record in tableModel [" + model.getId() + "] due to SQLException !", (Throwable)se);
        }
        finally {
            if (state != null) {
                try {
                    state.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    protected IndexedCollection queryByCondition(TableModel model, List selectFields, String condition, Connection con) throws EMPJDBCException {
        Statement state = null;
        ResultSet rs = null;
        try {
            KeyedCollection kColl = new KeyedCollection(model.getId());
            String strSQL = null;
            StringBuffer strSQLBuf = new StringBuffer("SELECT ");
            Iterator<Object> iterator = null;
            iterator = selectFields == null || selectFields.isEmpty() ? model.getModelFields().keySet().iterator() : selectFields.iterator();
            while (iterator.hasNext()) {
                String fieldId = (String)iterator.next();
                TableModelField field = model.getModelField(fieldId);
                if (field == null) continue;
                if (iterator.hasNext()) {
                    strSQLBuf.append(String.valueOf(field.getColumnName()) + ",");
                } else {
                    strSQLBuf.append(String.valueOf(field.getColumnName()) + " ");
                }
                kColl.addDataField(fieldId, null);
            }
            strSQLBuf.append(" FROM " + model.getDbTableName());
            if (condition != null && condition.trim().length() != 0) {
                strSQLBuf.append(" " + condition + " ");
            }
            strSQL = strSQLBuf.toString();
            IndexedCollection iColl = new IndexedCollection(model.getId());
            iColl.setDataElement((DataElement)kColl);
            EMPLog.log((String)EMPConstance.EMP_JDBC, (int)EMPLog.DEBUG, (int)0, (String)("SELECT SQL: " + strSQL));
            this.checkSql(strSQL);
            state = con.createStatement();
            rs = state.executeQuery(strSQL);
            int idx = 0;
            while (rs.next()) {
                KeyedCollection akColl = (KeyedCollection)kColl.clone();
                iColl.addDataElement((DataElement)akColl);
                ++idx;
                Iterator iterator2 = akColl.keySet().iterator();
                while (iterator2.hasNext()) {
                    TableModelField field = model.getModelField((String)iterator2.next());
                    Object obj = rs.getObject(field.getColumnName());
                    String value = null;
                    if (obj != null) {
                        value = obj.toString();
                    }
                    if (this.encryptService != null && field.isEncrypted()) {
                        value = this.encryptService.decrypt(value, field.getColumnType());
                    }
                    EMPLog.log((String)EMPConstance.EMP_JDBC, (int)EMPLog.DEBUG, (int)0, (String)("iColl [" + iColl.getName() + "] record [" + idx + "] Set dataField [" + field.getId() + "]'s value = " + value));
                    akColl.setDataValue(field.getId(), (Object)value);
                }
            }
            rs.close();
            state.close();
            IndexedCollection indexedCollection = iColl;
            return indexedCollection;
        }
        catch (SQLException se) {
            EMPLog.log((String)EMPConstance.EMP_JDBC, (int)EMPLog.ERROR, (int)0, (String)("Failed to SELECT records in tableModel [" + model.getId() + "] due to SQLException !"), (Throwable)se);
            throw new EMPJDBCException("Failed to SELECT records in tableModel [" + model.getId() + "] due to SQLException !", (Throwable)se);
        }
        catch (EMPException ee) {
            EMPLog.log((String)EMPConstance.EMP_JDBC, (int)EMPLog.ERROR, (int)0, (String)("Failed to SELECT records in tableModel [" + model.getId() + "] !"), (Throwable)ee);
            throw new EMPJDBCException("Failed to SELECT records in tableModel [" + model.getId() + "] !", (Throwable)ee);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (state != null) {
                try {
                    state.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    protected IndexedCollection queryByCondition2(TableModel model, List selectFieldObjs, String condition, Connection con) throws EMPJDBCException {
        Statement state = null;
        ResultSet rs = null;
        try {
            HashMap<String, TableModel> tableNames = new HashMap<String, TableModel>();
            KeyedCollection kColl = new KeyedCollection(model.getId());
            String strSQL = null;
            StringBuffer strSQLBuf = new StringBuffer("SELECT ");
            if (selectFieldObjs == null || selectFieldObjs.isEmpty()) {
                selectFieldObjs.addAll(model.getModelFields().values());
            }
            int i = 0;
            while (i < selectFieldObjs.size()) {
                TableModelField field = (TableModelField)selectFieldObjs.get(i);
                strSQLBuf.append(field.getColumnFullName());
                if (i < selectFieldObjs.size() - 1) {
                    strSQLBuf.append(",");
                } else {
                    strSQLBuf.append(" ");
                }
                TableModel pModel = field.getParentModel();
                if (pModel == model) {
                    kColl.addDataField(field.getId(), null);
                } else {
                    KeyedCollection aKcoll = null;
                    try {
                        aKcoll = (KeyedCollection)kColl.getDataElement(pModel.getId());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (aKcoll == null) {
                        aKcoll = new KeyedCollection(pModel.getId());
                        kColl.addKeyedCollection(aKcoll);
                    }
                    aKcoll.addDataField(field.getId(), null);
                }
                if (!tableNames.containsKey(pModel.getDbTableName())) {
                    tableNames.put(pModel.getDbTableName(), pModel);
                }
                ++i;
            }
            strSQLBuf.append(" FROM ");
            Iterator<Object> iterator = tableNames.keySet().iterator();
            while (iterator.hasNext()) {
                strSQLBuf.append((String)iterator.next());
                if (iterator.hasNext()) {
                    strSQLBuf.append(",");
                    continue;
                }
                strSQLBuf.append(" ");
            }
            tableNames.remove(model.getDbTableName());
            if (tableNames.isEmpty()) {
                if (condition != null && condition.trim().length() != 0) {
                    strSQLBuf.append(" " + condition + " ");
                }
            } else {
                String condition2;
                boolean hasWhere = false;
                if (condition != null && condition.trim().length() != 0 && (condition2 = condition.toUpperCase()).indexOf("WHERE") > -1) {
                    hasWhere = true;
                    String flag = condition.substring(condition2.indexOf("WHERE"), condition2.indexOf("WHERE") + 5);
                    condition = condition.replaceFirst(flag, " ");
                }
                if ((iterator = tableNames.values().iterator()).hasNext()) {
                    strSQLBuf.append(" WHERE ");
                }
                while (iterator.hasNext()) {
                    TableModel aModel = (TableModel)iterator.next();
                    One2OneRef oneRef = model.getOne2OneRef(aModel.getId());
                    String s1 = model.getModelField(oneRef.getFromField()).getColumnFullName();
                    String s2 = aModel.getModelField(oneRef.getToField()).getColumnFullName();
                    strSQLBuf.append(" " + s1 + " = " + s2 + " ");
                    if (!iterator.hasNext()) continue;
                    strSQLBuf.append(" AND ");
                }
                if (condition != null && condition.trim().length() != 0) {
                    if (hasWhere) {
                        strSQLBuf.append(" AND ");
                    }
                    strSQLBuf.append(" " + condition + " ");
                }
            }
            strSQL = strSQLBuf.toString();
            IndexedCollection iColl = new IndexedCollection(model.getId());
            iColl.setDataElement((DataElement)kColl);
            EMPLog.log((String)EMPConstance.EMP_JDBC, (int)EMPLog.DEBUG, (int)0, (String)("SELECT SQL: " + strSQL));
            this.checkSql(strSQL);
            state = con.createStatement();
            rs = state.executeQuery(strSQL);
            int idx = 0;
            while (rs.next()) {
                KeyedCollection akColl = (KeyedCollection)kColl.clone();
                iColl.addDataElement((DataElement)akColl);
                ++idx;
                int i2 = 0;
                while (i2 < selectFieldObjs.size()) {
                    TableModelField field = (TableModelField)selectFieldObjs.get(i2);
                    Object obj = rs.getObject(i2 + 1);
                    String value = null;
                    if (obj != null) {
                        value = obj.toString();
                    }
                    if (this.encryptService != null && field.isEncrypted()) {
                        value = this.encryptService.decrypt(value, field.getColumnType());
                    }
                    String fieldFullName = field.getId();
                    if (field.getParentModel() != model) {
                        fieldFullName = String.valueOf(field.getParentModel().getId()) + "." + fieldFullName;
                    }
                    EMPLog.log((String)EMPConstance.EMP_JDBC, (int)EMPLog.DEBUG, (int)0, (String)("iColl [" + iColl.getName() + "] record [" + idx + "] Set dataField [" + fieldFullName + "]'s value = " + value));
                    akColl.setDataValue(fieldFullName, (Object)value);
                    ++i2;
                }
            }
            rs.close();
            state.close();
            IndexedCollection indexedCollection = iColl;
            return indexedCollection;
        }
        catch (SQLException se) {
            EMPLog.log((String)EMPConstance.EMP_JDBC, (int)EMPLog.ERROR, (int)0, (String)("Failed to SELECT records in tableModel [" + model.getId() + "] due to SQLException !"), (Throwable)se);
            throw new EMPJDBCException("Failed to SELECT records in tableModel [" + model.getId() + "] due to SQLException !", (Throwable)se);
        }
        catch (EMPException ee) {
            EMPLog.log((String)EMPConstance.EMP_JDBC, (int)EMPLog.ERROR, (int)0, (String)("Failed to SELECT records in tableModel [" + model.getId() + "] !"), (Throwable)ee);
            throw new EMPJDBCException("Failed to SELECT records in tableModel [" + model.getId() + "] !", (Throwable)ee);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (state != null) {
                try {
                    state.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    public int update(KeyedCollection modelKcoll, Connection con) throws EMPJDBCException {
        IndexedCollection icoll;
        String modelId = modelKcoll.getName();
        TableModel model = this.modelLoader.getTableModel(modelId);
        if (model == null) {
            throw new EMPJDBCException("TableModel[" + modelId + "]\u672a\u5b9a\u4e49\uff01");
        }
        HashMap<String, Object> fieldMap = new HashMap<String, Object>();
        for (DataElement element : modelKcoll.values()) {
            if (!(element instanceof DataField)) continue;
            DataField aField = (DataField)element;
            fieldMap.put(aField.getName(), aField.getValue());
        }
        HashMap pkFieldMap = new HashMap();
        for (TableModelField field : model.getModelFields().values()) {
            if (!field.isPK()) continue;
            Object objValue = fieldMap.get(field.getId());
            if (objValue == null) {
                throw new EMPJDBCException("TableModel[" + modelId + "]\u7684\u4e3b\u952e[" + field.getId() + "]\u503c\u4e3aNULL!");
            }
            pkFieldMap.put(field.getId(), objValue);
        }
        KeyedCollection fkFieldMap = new HashMap();
        if (model.isComplex()) {
            TableModelField field;
            DataElement e;
            for (One2OneRef oneRef : model.getOne2OneModels().values()) {
                try {
                    e = modelKcoll.getDataElement(oneRef.getRefModelId());
                    if (e == null) continue;
                    if (!(e instanceof KeyedCollection)) {
                    }
                }
                catch (InvalidArgumentException e1) {}
                continue;
                if (!oneRef.isFKRef(model) || fkFieldMap.containsKey((field = model.getModelField(oneRef.getFromField())).getId())) continue;
                fkFieldMap.put(field.getId(), field);
            }
            for (One2MultiRef multiRef : model.getOne2MultiModels().values()) {
                try {
                    e = modelKcoll.getDataElement(multiRef.getRefModelId());
                    if (e == null) continue;
                    if (!(e instanceof IndexedCollection)) {
                    }
                }
                catch (InvalidArgumentException e1) {}
                continue;
                if (!multiRef.isFKRef(model) || fkFieldMap.containsKey((field = model.getModelField(multiRef.getFromField())).getId())) continue;
                fkFieldMap.put(field.getId(), field);
            }
            if (!fkFieldMap.isEmpty()) {
                ArrayList refFieldList = new ArrayList();
                refFieldList.addAll(fkFieldMap.keySet());
                refFieldList.addAll(pkFieldMap.keySet());
                String pkCondition = this.makeConditionByFields(model, pkFieldMap);
                icoll = this.queryByCondition(model, refFieldList, pkCondition, con);
                KeyedCollection kcoll = null;
                kcoll = icoll.isEmpty() ? (KeyedCollection)icoll.getDataElement() : (KeyedCollection)icoll.get(0);
                int i = 0;
                while (i < kcoll.size()) {
                    DataField aField = null;
                    try {
                        aField = (DataField)kcoll.getDataElement(i);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (aField != null && fieldMap.get(aField.getName()) != null && !fieldMap.get(aField.getName()).equals(aField.getValue())) {
                        throw new EMPJDBCException("Update\u64cd\u4f5c\u4e2d\u53d1\u73b0\u63d0\u4f9b\u7684\u4e3b\u4ece\uff08\u5b50\uff09\u5173\u8054\u5b57\u6bb5\u503c\u4e0e\u7269\u7406\u8868\u4e0d\u7b26\uff01");
                    }
                    ++i;
                }
                fkFieldMap = kcoll;
            } else {
                fkFieldMap = pkFieldMap;
            }
        }
        int result = this.updateByField(model, fieldMap, pkFieldMap, con);
        for (DataElement element2 : modelKcoll.values()) {
            One2MultiRef multiRef;
            TableModel refModel;
            String refId;
            if (element2 instanceof KeyedCollection) {
                KeyedCollection kcoll = (KeyedCollection)element2;
                refId = kcoll.getName();
                One2OneRef oneRef = model.getOne2OneRef(refId);
                if (oneRef == null) continue;
                refModel = this.modelLoader.getTableModel(oneRef.getRefModelId());
                if (refModel == null) {
                    throw new EMPJDBCException("One2OneRef\u5f15\u7528\u5173\u7cfb\u5b9a\u4e49\u6709\u8bef\uff0cTableModel[" + oneRef.getRefModelId() + "]\u672a\u5b9a\u4e49\uff01");
                }
                fieldMap = new HashMap();
                for (DataElement element2 : kcoll.values()) {
                    if (!(element2 instanceof DataField)) continue;
                    DataField aField = (DataField)element2;
                    fieldMap.put(aField.getName(), aField.getValue());
                }
                Object refValue = null;
                refValue = fkFieldMap.get(oneRef.getFromField());
                if (fieldMap.get(oneRef.getToField()) != null && !fieldMap.get(oneRef.getToField()).equals(refValue)) {
                    throw new EMPJDBCException("Update\u64cd\u4f5c\u4e2d\u53d1\u73b0\u4ece\u8868[" + oneRef.getRefModelId() + "]\u5173\u8054\u5b57\u6bb5[" + oneRef.getToField() + "]\u7684\u503c\u4e0e\u4e3b\u8868\u4e0d\u5339\u914d\uff01");
                }
                HashMap<String, Object> refFields = new HashMap<String, Object>();
                refFields.put(oneRef.getToField(), refValue);
                int r = this.updateByField(refModel, fieldMap, refFields, con);
                if (r != 0) continue;
                fieldMap.remove(oneRef.getToField());
                fieldMap.put(oneRef.getToField(), refValue);
                this.insertSingleRecord(refModel, fieldMap, con);
                continue;
            }
            if (!(element2 instanceof IndexedCollection) || (multiRef = model.getOne2MultiRef(refId = (icoll = (IndexedCollection)element2).getName())) == null) continue;
            refModel = this.modelLoader.getTableModel(multiRef.getRefModelId());
            if (refModel == null) {
                throw new EMPJDBCException("One2MultiRef\u5f15\u7528\u5173\u7cfb\u5b9a\u4e49\u6709\u8bef\uff0cTableModel[" + multiRef.getRefModelId() + "]\u672a\u5b9a\u4e49\uff01");
            }
            Object refValue = fkFieldMap.get(multiRef.getFromField());
            HashMap refFields = new HashMap();
            refFields.put(multiRef.getToField(), refValue);
            this.deleteByField(refModel, refFields, con);
            int i = 0;
            while (i < icoll.size()) {
                KeyedCollection kcoll = (KeyedCollection)icoll.getElementAt(i);
                fieldMap = new HashMap();
                for (DataElement element2 : kcoll.values()) {
                    if (!(element2 instanceof DataField)) continue;
                    DataField aField = (DataField)element2;
                    fieldMap.put(aField.getName(), aField.getValue());
                }
                if (fieldMap.get(multiRef.getToField()) != null && !fieldMap.get(multiRef.getToField()).equals(refValue)) {
                    throw new EMPJDBCException("Update\u64cd\u4f5c\u4e2d\u53d1\u73b0\u4ece\u8868[" + multiRef.getRefModelId() + "]\u5173\u8054\u5b57\u6bb5[" + multiRef.getToField() + "]\u7684\u503c\u4e0e\u4e3b\u8868\u4e0d\u5339\u914d\uff01");
                }
                fieldMap.remove(multiRef.getToField());
                fieldMap.put(multiRef.getToField(), refValue);
                this.insertSingleRecord(refModel, fieldMap, con);
                ++i;
            }
        }
        return result;
    }

    protected int updateByField(TableModel model, Map updateValues, Map conditionFields, Connection con) throws EMPJDBCException {
        Statement state = null;
        try {
            Object fieldValue;
            TableModelField field;
            TableModelField modelField;
            String strSQL = null;
            ArrayList<TableModelField> updateFieldList = new ArrayList<TableModelField>();
            ArrayList<TableModelField> conditionFieldList = new ArrayList<TableModelField>();
            StringBuffer strSQLBuf = new StringBuffer("UPDATE " + model.getDbTableName() + " SET ");
            for (String fieldId : updateValues.keySet()) {
                modelField = model.getModelField(fieldId);
                if (modelField == null) continue;
                updateFieldList.add(modelField);
            }
            if (updateFieldList.isEmpty()) {
                throw new EMPJDBCException("Update\u64cd\u4f5c\u4e2d\u53d1\u73b0TableModel[" + model.getId() + "]\u672a\u63d0\u4f9b\u5f85\u66f4\u65b0\u5b57\u6bb5\uff0c\u64cd\u4f5c\u672a\u6267\u884c\uff01");
            }
            Iterator<Object> iterator = updateFieldList.iterator();
            while (iterator.hasNext()) {
                field = (TableModelField)iterator.next();
                if (iterator.hasNext()) {
                    strSQLBuf.append(String.valueOf(field.getColumnName()) + " = ?, ");
                    continue;
                }
                strSQLBuf.append(String.valueOf(field.getColumnName()) + " = ? ");
            }
            strSQLBuf.append(" WHERE ");
            iterator = conditionFields.keySet().iterator();
            while (iterator.hasNext()) {
                String fieldId;
                fieldId = (String)iterator.next();
                modelField = model.getModelField(fieldId);
                if (modelField == null) continue;
                conditionFieldList.add(modelField);
                if (iterator.hasNext()) {
                    strSQLBuf.append(String.valueOf(modelField.getColumnName()) + " = ? AND ");
                    continue;
                }
                strSQLBuf.append(String.valueOf(modelField.getColumnName()) + " = ? ");
            }
            if (conditionFieldList.isEmpty()) {
                throw new EMPJDBCException("Update\u64cd\u4f5c\u4e2d\u53d1\u73b0TableModel[" + model.getId() + "]\u672a\u63d0\u4f9b\u6761\u4ef6\u5b57\u6bb5\uff0c\u64cd\u4f5c\u672a\u6267\u884c\uff01");
            }
            strSQL = strSQLBuf.toString();
            state = con.prepareStatement(strSQL);
            int idx = updateFieldList.size();
            int i = 0;
            while (i < updateFieldList.size()) {
                field = (TableModelField)updateFieldList.get(i);
                fieldValue = updateValues.get(field.getId());
                if (fieldValue != null) {
                    if (!field.isCharType() && fieldValue.toString().trim().length() == 0) {
                        EMPLog.log((String)EMPConstance.EMP_JDBC, (int)EMPLog.DEBUG, (int)0, (String)("Set column [" + field.getColumnName() + "]'s value with null"));
                        state.setNull(i + 1, field.getColumnType());
                    } else {
                        if (this.encryptService != null && field.isEncrypted()) {
                            fieldValue = this.encryptService.encrypt(fieldValue, field.getColumnType());
                        }
                        EMPLog.log((String)EMPConstance.EMP_JDBC, (int)EMPLog.DEBUG, (int)0, (String)("Set column [" + field.getColumnName() + "]'s value = " + fieldValue));
                        state.setObject(i + 1, fieldValue);
                    }
                } else {
                    EMPLog.log((String)EMPConstance.EMP_JDBC, (int)EMPLog.DEBUG, (int)0, (String)("Set column [" + field.getColumnName() + "]'s value with null"));
                    state.setNull(i + 1, field.getColumnType());
                }
                ++i;
            }
            i = 0;
            while (i < conditionFieldList.size()) {
                field = (TableModelField)conditionFieldList.get(i);
                fieldValue = conditionFields.get(field.getId());
                if (fieldValue != null) {
                    if (!field.isCharType() && fieldValue.toString().trim().length() == 0) {
                        EMPLog.log((String)EMPConstance.EMP_JDBC, (int)EMPLog.DEBUG, (int)0, (String)("Set column [" + field.getColumnName() + "]'s value with null"));
                        state.setNull(i + idx + 1, field.getColumnType());
                    } else {
                        EMPLog.log((String)EMPConstance.EMP_JDBC, (int)EMPLog.DEBUG, (int)0, (String)("Set column [" + field.getColumnName() + "]'s value = " + fieldValue));
                        state.setObject(i + idx + 1, fieldValue);
                    }
                } else {
                    EMPLog.log((String)EMPConstance.EMP_JDBC, (int)EMPLog.DEBUG, (int)0, (String)("Set column [" + field.getColumnName() + "]'s value with null"));
                    state.setNull(i + idx + 1, field.getColumnType());
                }
                ++i;
            }
            int result = state.executeUpdate();
            EMPLog.log((String)EMPConstance.EMP_JDBC, (int)EMPLog.DEBUG, (int)0, (String)(String.valueOf(result) + " records in tableModel [" + model.getId() + "] has been UPDATE."));
            state.close();
            int n = result;
            return n;
        }
        catch (SQLException se) {
            EMPLog.log((String)EMPConstance.EMP_JDBC, (int)EMPLog.ERROR, (int)0, (String)("Failed to UPDATE record in tableModel [" + model.getId() + "] due to SQLException !"), (Throwable)se);
            throw new EMPJDBCException("Failed to UPDATE record in tableModel [" + model.getId() + "] due to SQLException !", (Throwable)se);
        }
        catch (EMPException ee) {
            EMPLog.log((String)EMPConstance.EMP_JDBC, (int)EMPLog.ERROR, (int)0, (String)("Failed to UPDATE record in tableModel [" + model.getId() + "] !"), (Throwable)ee);
            throw new EMPJDBCException("Failed to UPDATE record in tableModel [" + model.getId() + "] !", (Throwable)ee);
        }
        finally {
            if (state != null) {
                try {
                    state.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    public KeyedCollection queryDetail(String modelId, String pk_value, Connection con) throws EMPJDBCException {
        TableModel model = this.modelLoader.getTableModel(modelId);
        if (model == null) {
            throw new EMPJDBCException("TableModel[" + modelId + "]\u672a\u5b9a\u4e49\uff01");
        }
        HashMap<String, String> pk_values = new HashMap<String, String>();
        for (TableModelField field : model.getModelFields().values()) {
            if (!field.isPK()) continue;
            if (pk_values.isEmpty()) {
                pk_values.put(field.getId(), pk_value);
                continue;
            }
            throw new EMPJDBCException("TableModel[" + modelId + "]\u5b58\u5728\u8054\u5408\u4e3b\u952e\uff0c\u8be5\u65b9\u6cd5\u4e0d\u652f\u6301!");
        }
        return this.queryDetail(modelId, pk_values, con);
    }

    public KeyedCollection queryDetail(String modelId, Map pk_values, Connection con) throws EMPJDBCException {
        TableModel model = this.modelLoader.getTableModel(modelId);
        if (model == null) {
            throw new EMPJDBCException("TableModel[" + modelId + "]\u672a\u5b9a\u4e49\uff01");
        }
        HashMap pkFieldMap = new HashMap();
        for (TableModelField field : model.getModelFields().values()) {
            if (!field.isPK()) continue;
            Object objValue = pk_values.get(field.getId());
            if (objValue == null) {
                throw new EMPJDBCException("TableModel[" + modelId + "]\u7684\u4e3b\u952e[" + field.getId() + "]\u503c\u4e3aNULL!");
            }
            pkFieldMap.put(field.getId(), objValue);
        }
        String condition = this.makeConditionByFields(model, pkFieldMap);
        IndexedCollection icoll = this.queryByCondition(model, null, condition, con);
        KeyedCollection retKcoll = null;
        retKcoll = icoll.isEmpty() ? (KeyedCollection)icoll.getDataElement() : (KeyedCollection)icoll.get(0);
        return retKcoll;
    }

    public KeyedCollection queryAllDetail(String modelId, String pk_value, Connection con) throws EMPJDBCException {
        TableModel model = this.modelLoader.getTableModel(modelId);
        if (model == null) {
            throw new EMPJDBCException("TableModel[" + modelId + "]\u672a\u5b9a\u4e49\uff01");
        }
        HashMap<String, String> pk_values = new HashMap<String, String>();
        for (TableModelField field : model.getModelFields().values()) {
            if (!field.isPK()) continue;
            if (pk_values.isEmpty()) {
                pk_values.put(field.getId(), pk_value);
                continue;
            }
            throw new EMPJDBCException("TableModel[" + modelId + "]\u5b58\u5728\u8054\u5408\u4e3b\u952e\uff0c\u8be5\u65b9\u6cd5\u4e0d\u652f\u6301!");
        }
        return this.queryAllDetail(modelId, pk_values, con);
    }

    public KeyedCollection queryAllDetail(String modelId, Map pk_values, Connection con) throws EMPJDBCException {
        return this.queryAllDetail(modelId, pk_values, null, con);
    }

    public KeyedCollection queryAllDetail(String modelId, String pk_value, List selectModels, Connection con) throws EMPJDBCException {
        TableModel model = this.modelLoader.getTableModel(modelId);
        if (model == null) {
            throw new EMPJDBCException("TableModel[" + modelId + "]\u672a\u5b9a\u4e49\uff01");
        }
        HashMap<String, String> pk_values = new HashMap<String, String>();
        for (TableModelField field : model.getModelFields().values()) {
            if (!field.isPK()) continue;
            if (pk_values.isEmpty()) {
                pk_values.put(field.getId(), pk_value);
                continue;
            }
            throw new EMPJDBCException("TableModel[" + modelId + "]\u5b58\u5728\u8054\u5408\u4e3b\u952e\uff0c\u8be5\u65b9\u6cd5\u4e0d\u652f\u6301!");
        }
        return this.queryAllDetail(modelId, pk_values, selectModels, con);
    }

    public KeyedCollection queryAllDetail(String modelId, Map pk_values, List selectModels, Connection con) throws EMPJDBCException {
        Iterator<Object> iterator;
        TableModel model = this.modelLoader.getTableModel(modelId);
        if (model == null) {
            throw new EMPJDBCException("TableModel[" + modelId + "]\u672a\u5b9a\u4e49\uff01");
        }
        HashMap pkFieldMap = new HashMap();
        for (TableModelField field : model.getModelFields().values()) {
            if (!field.isPK()) continue;
            Object objValue = pk_values.get(field.getId());
            if (objValue == null) {
                throw new EMPJDBCException("TableModel[" + modelId + "]\u7684\u4e3b\u952e[" + field.getId() + "]\u503c\u4e3aNULL!");
            }
            pkFieldMap.put(field.getId(), objValue);
        }
        String condition = this.makeConditionByFields(model, pkFieldMap);
        IndexedCollection icoll = this.queryByCondition(model, null, condition, con);
        KeyedCollection retKcoll = null;
        if (icoll.isEmpty()) {
            retKcoll = (KeyedCollection)icoll.getDataElement();
            return retKcoll;
        }
        retKcoll = (KeyedCollection)icoll.get(0);
        if (selectModels == null || selectModels.isEmpty()) {
            ArrayList refModels = new ArrayList();
            refModels.addAll(model.getOne2OneModels().keySet());
            refModels.addAll(model.getOne2MultiModels().keySet());
            iterator = refModels.iterator();
        } else {
            iterator = selectModels.iterator();
        }
        while (iterator.hasNext()) {
            HashMap<String, Object> refFieldMap;
            TableModel refModel;
            String refId = (String)iterator.next();
            if (model.getOne2OneRef(refId) != null) {
                One2OneRef oneRef = model.getOne2OneRef(refId);
                refModel = this.modelLoader.getTableModel(oneRef.getRefModelId());
                if (refModel == null) {
                    throw new EMPJDBCException("One2OneRef\u5f15\u7528\u5173\u7cfb\u5b9a\u4e49\u6709\u8bef\uff0cTableModel[" + oneRef.getRefModelId() + "]\u672a\u5b9a\u4e49\uff01");
                }
                refFieldMap = new HashMap<String, Object>();
                try {
                    refFieldMap.put(oneRef.getToField(), retKcoll.getDataValue(oneRef.getFromField()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                condition = this.makeConditionByFields(refModel, refFieldMap);
                icoll = this.queryByCondition(refModel, null, condition, con);
                KeyedCollection aKcoll = null;
                aKcoll = icoll.isEmpty() ? (KeyedCollection)icoll.getDataElement() : (KeyedCollection)icoll.get(0);
                try {
                    retKcoll.addKeyedCollection(aKcoll);
                }
                catch (Exception exception) {}
                continue;
            }
            if (model.getOne2MultiRef(refId) != null) {
                One2MultiRef multiRef = model.getOne2MultiRef(refId);
                refModel = this.modelLoader.getTableModel(multiRef.getRefModelId());
                if (refModel == null) {
                    throw new EMPJDBCException("One2MultiRef\u5f15\u7528\u5173\u7cfb\u5b9a\u4e49\u6709\u8bef\uff0cTableModel[" + multiRef.getRefModelId() + "]\u672a\u5b9a\u4e49\uff01");
                }
                refFieldMap = new HashMap();
                try {
                    refFieldMap.put(multiRef.getToField(), retKcoll.getDataValue(multiRef.getFromField()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                condition = this.makeConditionByFields(refModel, refFieldMap);
                icoll = this.queryByCondition(refModel, null, condition, con);
                try {
                    retKcoll.addIndexedCollection(icoll);
                }
                catch (Exception exception) {}
                continue;
            }
            EMPLog.log((String)EMPConstance.EMP_JDBC, (int)EMPLog.WARNING, (int)0, (String)("QueryDetail\u64cd\u4f5c\u4e2d\u53d1\u73b0\u9009\u5b9a\u7684TableModel[" + refId + "]\u4e0d\u5b58\u5728\uff01"));
        }
        return retKcoll;
    }

    public IndexedCollection queryList(String modelId, Connection con) throws EMPJDBCException {
        return this.queryList(modelId, null, null, con);
    }

    public IndexedCollection queryList(String modelId, List selectFields, Connection con) throws EMPJDBCException {
        return this.queryList(modelId, selectFields, null, con);
    }

    public IndexedCollection queryList(String modelId, String condition, Connection con) throws EMPJDBCException {
        return this.queryList(modelId, null, condition, con);
    }

    public IndexedCollection queryList(String modelId, List selectFields, String condition, Connection con) throws EMPJDBCException {
        TableModel model = this.modelLoader.getTableModel(modelId);
        if (model == null) {
            throw new EMPJDBCException("TableModel[" + modelId + "]\u672a\u5b9a\u4e49\uff01");
        }
        if (selectFields == null || selectFields.isEmpty()) {
            return this.queryByCondition(model, null, condition, con);
        }
        ArrayList<TableModelField> fieldList = new ArrayList<TableModelField>();
        TableModelField field = null;
        int i = 0;
        while (i < selectFields.size()) {
            String sFieldId = (String)selectFields.get(i);
            int idx = sFieldId.indexOf(46);
            if (idx > -1) {
                String refModelId = sFieldId.substring(0, idx);
                One2OneRef oneRef = model.getOne2OneRef(refModelId);
                if (oneRef == null) {
                    throw new EMPJDBCException("QueryList\u64cd\u4f5c\u4e2d\u53d1\u73b0\u8fc7\u6ee4\u5b57\u6bb5\u4e2d\u5305\u542b\u5197\u4f59\u7684TableModel[" + refModelId + "]\u5f15\u7528!");
                }
                TableModel refModel = this.modelLoader.getTableModel(oneRef.getRefModelId());
                if (refModel == null) {
                    throw new EMPJDBCException("One2OneRef\u5f15\u7528\u5173\u7cfb\u5b9a\u4e49\u6709\u8bef\uff0cTableModel[" + oneRef.getRefModelId() + "]\u672a\u5b9a\u4e49\uff01");
                }
                sFieldId = sFieldId.substring(idx + 1);
                field = refModel.getModelField(sFieldId);
            } else {
                field = model.getModelField(sFieldId);
            }
            if (field == null) {
                throw new EMPJDBCException("QueryList\u64cd\u4f5c\u4e2d\u53d1\u73b0\u8fc7\u6ee4\u5b57\u6bb5\u4e2d\u5305\u542b\u5197\u4f59\u7684\u5b57\u6bb5[" + selectFields.get(i) + "]\u5f15\u7528!");
            }
            fieldList.add(field);
            ++i;
        }
        return this.queryByCondition2(model, fieldList, condition, con);
    }

    public IndexedCollection queryList(String modelId, List selectFields, String condition, PageInfo pageInfo, Connection con) throws EMPJDBCException {
        throw new EMPJDBCException("\u5f53\u524d\u4f7f\u7528\u7684\u7ec4\u4ef6\u4e0d\u652f\u6301\u8be5\u529f\u80fd\uff0c\u8bf7\u66f4\u6362\u5176\u5b83\u7ec4\u4ef6\uff01");
    }

    public KeyedCollection queryFirst(String modelId, List selectFields, String condition, Connection con) throws EMPJDBCException {
        IndexedCollection icoll = this.queryList(modelId, selectFields, condition, con);
        KeyedCollection retKcoll = null;
        retKcoll = icoll.isEmpty() ? (KeyedCollection)icoll.getDataElement() : (KeyedCollection)icoll.get(0);
        return retKcoll;
    }

    protected void checkSql(String sql) throws EMPJDBCException {
        String tmpSql;
        int idx = sql.indexOf("--");
        if (idx != -1 && (tmpSql = sql.substring(0, idx)) != null && ((tmpSql = tmpSql.trim()).endsWith("'") || tmpSql.endsWith("\""))) {
            throw new EMPJDBCException("Invalid SQL with mark \"--\" !");
        }
        idx = sql.indexOf("/*");
        if (idx != -1 && (sql = sql.substring(idx + 2)) != null && sql.indexOf("*/") > -1) {
            throw new EMPJDBCException("Invalid SQL with mark \"/*\" !");
        }
    }

    protected String trimOnRight(TableModelField field, String value) {
        if (value == null) {
            return null;
        }
        try {
            if (field == null || field.getColumnType() != 1) {
                return value;
            }
            StringBuffer buf = new StringBuffer(value);
            int idx = buf.length() - 1;
            while (idx >= 0) {
                if (buf.charAt(idx) > ' ') break;
                --idx;
            }
            if (idx >= 0) {
                return buf.substring(0, idx + 1);
            }
            return buf.toString();
        }
        catch (Exception e) {
            return value.trim();
        }
    }
}

