/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.emp.dbmodel.service;

import com.ecc.emp.core.EMPConstance;
import com.ecc.emp.core.EMPException;
import com.ecc.emp.data.DataElement;
import com.ecc.emp.data.IndexedCollection;
import com.ecc.emp.data.KeyedCollection;
import com.ecc.emp.dbmodel.One2OneRef;
import com.ecc.emp.dbmodel.PageInfo;
import com.ecc.emp.dbmodel.TableModel;
import com.ecc.emp.dbmodel.TableModelField;
import com.ecc.emp.dbmodel.service.TableModelDAO;
import com.ecc.emp.jdbc.EMPJDBCException;
import com.ecc.emp.log.EMPLog;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class TableModelDAO4Derby
extends TableModelDAO {
    protected int insertSingleRecord(TableModel model, Map insertValues, Connection con) throws EMPJDBCException {
        Statement state = null;
        try {
            ArrayList<TableModelField> insertFieldList = new ArrayList<TableModelField>();
            Iterator<Object> iterator = insertValues.keySet().iterator();
            String strSQL = null;
            StringBuffer strSQLBuf = new StringBuffer("INSERT INTO " + model.getDbTableName() + "( ");
            while (iterator.hasNext()) {
                String fieldId = (String)iterator.next();
                TableModelField modelField = model.getModelField(fieldId);
                if (modelField == null) {
                    EMPLog.log((String)EMPConstance.EMP_JDBC, (int)EMPLog.WARNING, (int)0, (String)("Insert\u64cd\u4f5c\u4e2d\u53d1\u73b0\u6570\u636e\u5197\u4f59:Field[" + fieldId + "]."));
                    continue;
                }
                insertFieldList.add(modelField);
            }
            if (insertFieldList.isEmpty()) {
                throw new EMPJDBCException("Insert\u64cd\u4f5c\u4e2d\u53d1\u73b0TableModel[" + model.getId() + "]\u672a\u63d0\u4f9b\u5f85\u63d2\u5165\u5b57\u6bb5.");
            }
            iterator = insertFieldList.iterator();
            while (iterator.hasNext()) {
                TableModelField field = (TableModelField)iterator.next();
                if (iterator.hasNext()) {
                    strSQLBuf.append(String.valueOf(field.getColumnName()) + ",");
                    continue;
                }
                strSQLBuf.append(String.valueOf(field.getColumnName()) + ")");
            }
            strSQLBuf.append(" VALUES(");
            int j = 0;
            while (j < insertFieldList.size()) {
                if (j < insertFieldList.size() - 1) {
                    strSQLBuf.append("?,");
                } else {
                    strSQLBuf.append("?)");
                }
                ++j;
            }
            strSQL = strSQLBuf.toString();
            state = con.prepareStatement(strSQL);
            int i = 0;
            while (i < insertFieldList.size()) {
                TableModelField field = (TableModelField)insertFieldList.get(i);
                Object fieldValue = insertValues.get(field.getId());
                if (fieldValue != null) {
                    if (!field.isCharType() && fieldValue.toString().trim().length() == 0) {
                        EMPLog.log((String)EMPConstance.EMP_JDBC, (int)EMPLog.DEBUG, (int)0, (String)("Set column [" + field.getColumnName() + "]'s value with null"));
                        state.setNull(i + 1, field.getColumnType());
                    } else {
                        if (this.encryptService != null && field.isEncrypted()) {
                            fieldValue = this.encryptService.encrypt(fieldValue, field.getColumnType());
                        }
                        EMPLog.log((String)EMPConstance.EMP_JDBC, (int)EMPLog.DEBUG, (int)0, (String)("Set column [" + field.getColumnName() + "]'s value = " + fieldValue));
                        if (fieldValue.toString().trim().length() == 0) {
                            state.setNull(i + 1, field.getColumnType());
                        } else {
                            state.setObject(i + 1, fieldValue);
                        }
                    }
                } else {
                    EMPLog.log((String)EMPConstance.EMP_JDBC, (int)EMPLog.DEBUG, (int)0, (String)("Set column [" + field.getColumnName() + "]'s value with null"));
                    state.setNull(i + 1, field.getColumnType());
                }
                ++i;
            }
            int result = state.executeUpdate();
            EMPLog.log((String)EMPConstance.EMP_JDBC, (int)EMPLog.DEBUG, (int)0, (String)(String.valueOf(result) + " records in tableModel [" + model.getId() + "] has been INSERT."));
            state.close();
            int n = result;
            return n;
        }
        catch (SQLException se) {
            EMPLog.log((String)EMPConstance.EMP_JDBC, (int)EMPLog.ERROR, (int)0, (String)("Failed to INSERT record in tableModel [" + model.getId() + "] due to SQLException !"), (Throwable)se);
            throw new EMPJDBCException("Failed to INSERT record in tableModel [" + model.getId() + "] due to SQLException !", (Throwable)se);
        }
        finally {
            if (state != null) {
                try {
                    state.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    public IndexedCollection queryList(String modelId, List selectFields, String condition, PageInfo pageInfo, Connection con) throws EMPJDBCException {
        TableModel model = this.modelLoader.getTableModel(modelId);
        if (model == null) {
            throw new EMPJDBCException("TableModel[" + modelId + "]\u672a\u5b9a\u4e49\uff01");
        }
        ArrayList<TableModelField> fieldList = new ArrayList<TableModelField>();
        TableModelField field = null;
        Iterator<Object> iterator = null;
        iterator = selectFields == null || selectFields.isEmpty() ? model.getModelFields().keySet().iterator() : selectFields.iterator();
        while (iterator.hasNext()) {
            String sFieldId = (String)iterator.next();
            int idx = sFieldId.indexOf(46);
            if (idx > -1) {
                String refModelId = sFieldId.substring(0, idx);
                One2OneRef oneRef = model.getOne2OneRef(refModelId);
                if (oneRef == null) {
                    throw new EMPJDBCException("QueryList\u64cd\u4f5c\u4e2d\u53d1\u73b0\u8fc7\u6ee4\u5b57\u6bb5\u4e2d\u5305\u542b\u5197\u4f59\u7684TableModel[" + refModelId + "]\u5f15\u7528!");
                }
                TableModel refModel = this.modelLoader.getTableModel(oneRef.getRefModelId());
                if (refModel == null) {
                    throw new EMPJDBCException("One2OneRef\u5f15\u7528\u5173\u7cfb\u5b9a\u4e49\u6709\u8bef\uff0cTableModel[" + oneRef.getRefModelId() + "]\u672a\u5b9a\u4e49\uff01");
                }
                sFieldId = sFieldId.substring(idx + 1);
                field = refModel.getModelField(sFieldId);
            } else {
                field = model.getModelField(sFieldId);
            }
            if (field == null) {
                throw new EMPJDBCException("QueryList\u64cd\u4f5c\u4e2d\u53d1\u73b0\u8fc7\u6ee4\u5b57\u6bb5\u4e2d\u5305\u542b\u5197\u4f59\u7684\u5b57\u6bb5[" + selectFields + "]\u5f15\u7528!");
            }
            fieldList.add(field);
        }
        if (pageInfo.recordSize < 0) {
            pageInfo.recordSize = this.countRecordsSize(model, fieldList, condition, con);
        }
        return this.queryByCondition2(model, fieldList, condition, pageInfo, con);
    }

    private int countRecordsSize(TableModel model, List selectFieldObjs, String condition, Connection con) throws EMPJDBCException {
        int recordSize;
        block35: {
            recordSize = 0;
            Statement state = null;
            ResultSet rs = null;
            try {
                try {
                    StringBuffer strSQLBuf = new StringBuffer(" SELECT COUNT(*) FROM ");
                    HashMap<String, TableModel> tableNames = new HashMap<String, TableModel>();
                    if (selectFieldObjs == null || selectFieldObjs.isEmpty()) {
                        tableNames.put(model.getDbTableName(), model);
                    } else {
                        int i = 0;
                        while (i < selectFieldObjs.size()) {
                            TableModelField field = (TableModelField)selectFieldObjs.get(i);
                            TableModel pModel = field.getParentModel();
                            if (!tableNames.containsKey(pModel.getDbTableName())) {
                                tableNames.put(pModel.getDbTableName(), pModel);
                            }
                            ++i;
                        }
                    }
                    Iterator<Object> iterator = tableNames.keySet().iterator();
                    while (iterator.hasNext()) {
                        strSQLBuf.append((String)iterator.next());
                        if (iterator.hasNext()) {
                            strSQLBuf.append(",");
                            continue;
                        }
                        strSQLBuf.append(" ");
                    }
                    tableNames.remove(model.getDbTableName());
                    if (tableNames.isEmpty()) {
                        if (condition != null && condition.trim().length() != 0) {
                            strSQLBuf.append(" " + condition + " ");
                        }
                    } else {
                        String condition2;
                        boolean hasWhere = false;
                        if (condition != null && condition.trim().length() != 0 && (condition2 = condition.toUpperCase()).indexOf("WHERE") > -1) {
                            hasWhere = true;
                            String flag = condition.substring(condition2.indexOf("WHERE"), condition2.indexOf("WHERE") + 5);
                            condition = condition.replaceFirst(flag, " ");
                        }
                        if ((iterator = tableNames.values().iterator()).hasNext()) {
                            strSQLBuf.append(" WHERE ");
                        }
                        while (iterator.hasNext()) {
                            TableModel aModel = (TableModel)iterator.next();
                            One2OneRef oneRef = model.getOne2OneRef(aModel.getId());
                            String s1 = model.getModelField(oneRef.getFromField()).getColumnFullName();
                            String s2 = aModel.getModelField(oneRef.getToField()).getColumnFullName();
                            strSQLBuf.append(" " + s1 + " = " + s2 + " ");
                            if (!iterator.hasNext()) continue;
                            strSQLBuf.append(" AND ");
                        }
                        if (condition != null && condition.trim().length() != 0) {
                            if (hasWhere) {
                                strSQLBuf.append(" AND ");
                            }
                            strSQLBuf.append(" " + condition + " ");
                        }
                    }
                    if ((rs = (state = con.createStatement()).executeQuery(strSQLBuf.toString())).next()) {
                        recordSize = rs.getInt(1);
                    }
                    rs.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                    }
                    if (state == null) break block35;
                    try {
                        state.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException sQLException) {}
                }
                if (state != null) {
                    try {
                        state.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }
        return recordSize;
    }

    private IndexedCollection queryByCondition2(TableModel model, List selectFieldObjs, String condition, PageInfo pageInfo, Connection con) {
        IndexedCollection iColl = null;
        Statement state = null;
        ResultSet rs = null;
        try {
            try {
                HashMap<String, TableModel> tableNames = new HashMap<String, TableModel>();
                KeyedCollection kColl = new KeyedCollection(model.getId());
                String strSQL = null;
                StringBuffer strSQLBuf = new StringBuffer("SELECT ");
                if (selectFieldObjs == null || selectFieldObjs.isEmpty()) {
                    selectFieldObjs.addAll(model.getModelFields().values());
                }
                int i = 0;
                while (i < selectFieldObjs.size()) {
                    TableModelField field = (TableModelField)selectFieldObjs.get(i);
                    strSQLBuf.append(String.valueOf(field.getColumnFullName()) + " as " + field.getColumnName());
                    if (i < selectFieldObjs.size() - 1) {
                        strSQLBuf.append(",");
                    } else {
                        strSQLBuf.append(" ");
                    }
                    TableModel pModel = field.getParentModel();
                    if (pModel == model) {
                        kColl.addDataField(field.getId(), null);
                    } else {
                        KeyedCollection aKcoll = null;
                        try {
                            aKcoll = (KeyedCollection)kColl.getDataElement(pModel.getId());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (aKcoll == null) {
                            aKcoll = new KeyedCollection(pModel.getId());
                            kColl.addKeyedCollection(aKcoll);
                        }
                        aKcoll.addDataField(field.getId(), null);
                    }
                    if (!tableNames.containsKey(pModel.getDbTableName())) {
                        tableNames.put(pModel.getDbTableName(), pModel);
                    }
                    ++i;
                }
                strSQLBuf.append(" FROM ");
                Iterator<Object> iterator = tableNames.keySet().iterator();
                while (iterator.hasNext()) {
                    strSQLBuf.append((String)iterator.next());
                    if (iterator.hasNext()) {
                        strSQLBuf.append(",");
                        continue;
                    }
                    strSQLBuf.append(" ");
                }
                tableNames.remove(model.getDbTableName());
                if (tableNames.isEmpty()) {
                    if (condition != null && condition.trim().length() != 0) {
                        strSQLBuf.append(" " + condition + " ");
                    }
                } else {
                    String condition2;
                    boolean hasWhere = false;
                    if (condition != null && condition.trim().length() != 0 && (condition2 = condition.toUpperCase()).indexOf("WHERE") > -1) {
                        hasWhere = true;
                        String flag = condition.substring(condition2.indexOf("WHERE"), condition2.indexOf("WHERE") + 5);
                        condition = condition.replaceFirst(flag, " ");
                    }
                    if ((iterator = tableNames.values().iterator()).hasNext()) {
                        strSQLBuf.append(" WHERE ");
                    }
                    while (iterator.hasNext()) {
                        TableModel aModel = (TableModel)iterator.next();
                        One2OneRef oneRef = model.getOne2OneRef(aModel.getId());
                        String s1 = model.getModelField(oneRef.getFromField()).getColumnFullName();
                        String s2 = aModel.getModelField(oneRef.getToField()).getColumnFullName();
                        strSQLBuf.append(" " + s1 + " = " + s2 + " ");
                        if (!iterator.hasNext()) continue;
                        strSQLBuf.append(" AND ");
                    }
                    if (condition != null && condition.trim().length() != 0) {
                        if (hasWhere) {
                            strSQLBuf.append(" AND ");
                        }
                        strSQLBuf.append(" " + condition + " ");
                    }
                }
                pageInfo.beginIdx = (pageInfo.pageIdx - 1) * pageInfo.pageSize;
                pageInfo.endIdx = pageInfo.beginIdx + pageInfo.pageSize - 1;
                strSQLBuf.append(" offset " + pageInfo.beginIdx + " rows fetch next " + pageInfo.pageSize + " rows only ");
                strSQL = strSQLBuf.toString();
                iColl = new IndexedCollection(model.getId());
                iColl.setDataElement((DataElement)kColl);
                EMPLog.log((String)EMPConstance.EMP_JDBC, (int)EMPLog.DEBUG, (int)0, (String)("********DERBY EXECUTE SELECT SQL: " + strSQL));
                this.checkSql(strSQL);
                state = con.createStatement();
                rs = state.executeQuery(strSQL);
                int idx = 0;
                while (rs.next()) {
                    KeyedCollection akColl = (KeyedCollection)kColl.clone();
                    iColl.addDataElement((DataElement)akColl);
                    ++idx;
                    int i2 = 0;
                    while (i2 < selectFieldObjs.size()) {
                        TableModelField field = (TableModelField)selectFieldObjs.get(i2);
                        Object obj = rs.getObject(i2 + 1);
                        String value = null;
                        if (obj != null) {
                            value = obj.toString();
                        }
                        if (this.encryptService != null && field.isEncrypted()) {
                            value = this.encryptService.decrypt(value, field.getColumnType());
                        }
                        String fieldFullName = field.getId();
                        if (field.getParentModel() != model) {
                            fieldFullName = String.valueOf(field.getParentModel().getId()) + "." + fieldFullName;
                        }
                        EMPLog.log((String)EMPConstance.EMP_JDBC, (int)EMPLog.DEBUG, (int)0, (String)("iColl [" + iColl.getName() + "] record [" + idx + "] Set dataField [" + fieldFullName + "]'s value = " + value));
                        akColl.setDataValue(fieldFullName, (Object)value);
                        ++i2;
                    }
                }
                rs.close();
                state.close();
            }
            catch (SQLException se) {
                se.printStackTrace();
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                if (state != null) {
                    try {
                        state.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
            catch (EMPException ee) {
                block54: {
                    ee.printStackTrace();
                    if (rs == null) break block54;
                    try {
                        rs.close();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                if (state != null) {
                    try {
                        state.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (state != null) {
                try {
                    state.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return iColl;
    }
}

