/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.emp.format.String;

import com.ecc.emp.core.EMPConstance;
import com.ecc.emp.data.DataField;
import com.ecc.emp.format.Decorator;
import com.ecc.emp.format.EMPFormatException;
import com.ecc.emp.format.String.FixedLenFormat;
import com.ecc.emp.log.EMPLog;
import java.math.BigDecimal;
import java.util.List;

public class DualbyteCharFixedLenFormat
extends FixedLenFormat {
    private String precision;

    public String getPrecision() {
        return this.precision;
    }

    public void setPrecision(String precision) {
        this.precision = precision;
    }

    public Object format(DataField dataField) throws EMPFormatException {
        String theLen = this.getLen();
        int len = 0;
        len = theLen.lastIndexOf(44) != -1 ? Integer.parseInt(theLen.substring(0, theLen.lastIndexOf(44))) : Integer.parseInt(theLen);
        String pre = null;
        if (theLen.lastIndexOf(44) != -1) {
            pre = theLen.substring(theLen.lastIndexOf(44) + 1);
        }
        if (len <= 0) {
            EMPLog.log((String)EMPConstance.EMP_FORMAT, (int)EMPLog.ERROR, (int)0, (String)"FixedLenFormat format failed! len should not be null or 0!", null);
            throw new EMPFormatException("FixedLenFormat format failed! len should not be null or 0!");
        }
        String valueStr = (String)dataField.getValue();
        int b = 0;
        if (valueStr == null) {
            valueStr = "";
        }
        if (pre != null && !pre.equals("")) {
            String newStr;
            int prec = 0;
            try {
                prec = Integer.parseInt(pre);
            }
            catch (Exception e) {
                EMPLog.log((String)EMPConstance.EMP_FORMAT, (int)EMPLog.ERROR, (int)0, (String)"FixedLenFormat format failed! precision must be Integer!", null);
                throw new EMPFormatException("FixedLenFormat format failed! precision must be Integer!");
            }
            valueStr = newStr = DualbyteCharFixedLenFormat.formatNumber(valueStr, prec);
        }
        int realLen = valueStr.length();
        int idx = 0;
        int max = len;
        int bufflen = len;
        int i = 0;
        while (i < realLen && idx < max) {
            block20: {
                char nc;
                block18: {
                    block19: {
                        char c = valueStr.charAt(i);
                        if (c <= '\u00ff') break block18;
                        --bufflen;
                        idx += 2;
                        if (i != realLen - 1) break block19;
                        max -= 2;
                        break block20;
                    }
                    nc = valueStr.charAt(i + 1);
                    if (max - idx < 4 && nc > '\u00ff') {
                        ++i;
                        break;
                    }
                    if (nc > '\u00ff') break block20;
                    max -= 2;
                    break block20;
                }
                ++idx;
                if (i < realLen - 1) {
                    nc = valueStr.charAt(i + 1);
                    if (max - idx < 4 && nc > '\u00ff') {
                        ++i;
                        break;
                    }
                }
            }
            ++i;
        }
        len = i;
        if ("right".equalsIgnoreCase(this.getAligment())) {
            if (realLen > len) {
                valueStr = valueStr.substring(realLen - len);
                realLen = len;
            }
            b = bufflen - realLen;
        } else if ("center".equalsIgnoreCase(this.getAligment())) {
            if (realLen > len) {
                b = realLen / 2 - len / 2;
                valueStr = valueStr.substring(b, b + len);
                realLen = len;
            }
            b = bufflen / 2 - realLen / 2;
        } else if (realLen > len) {
            valueStr = valueStr.substring(0, len);
            realLen = len;
        }
        StringBuffer buffer = new StringBuffer(bufflen);
        int j = 0;
        while (j < bufflen) {
            buffer.append(this.getPadChar());
            ++j;
        }
        buffer.replace(b, b + realLen, valueStr);
        return buffer.toString();
    }

    public void unformat(Object src, DataField dataField) {
        int i;
        String mySrc = (String)src;
        int realLen = mySrc.length();
        String aligment = this.getAligment();
        String pre = null;
        String theLen = this.getLen();
        if (theLen.lastIndexOf(44) != -1) {
            pre = theLen.substring(theLen.lastIndexOf(44) + 1);
        }
        char padChar = this.getPadChar();
        int b = 0;
        int e = realLen - 1;
        if (aligment != null && ("left".equalsIgnoreCase(aligment) || "center".equalsIgnoreCase(aligment))) {
            i = realLen - 1;
            while (i >= 0) {
                if (mySrc.charAt(i) != padChar) {
                    e = i;
                    break;
                }
                --i;
            }
        }
        if (aligment != null && ("right".equalsIgnoreCase(aligment) || "center".equalsIgnoreCase(aligment))) {
            i = 0;
            while (i < realLen) {
                if (mySrc.charAt(i) != padChar) {
                    b = i;
                    break;
                }
                ++i;
            }
        }
        String value = mySrc.substring(b, e + 1);
        if (pre != null && !pre.equals("")) {
            String newStr;
            int prec = 0;
            try {
                prec = Integer.parseInt(pre);
            }
            catch (Exception ee) {
                EMPLog.log((String)EMPConstance.EMP_FORMAT, (int)EMPLog.ERROR, (int)0, (String)"FixedLenFormat unformat failed! precision must be Integer!", null);
            }
            value = newStr = DualbyteCharFixedLenFormat.unformatNumber(value, prec);
        }
        dataField.setValue(value);
    }

    public int extract(Object src, int offset) throws EMPFormatException {
        List decorators = this.getDecorators();
        int i = 0;
        while (i < decorators.size()) {
            Decorator decorator = (Decorator)decorators.get(i);
            int retValue = decorator.extract(src, offset);
            if (retValue != -1) {
                return retValue;
            }
            ++i;
        }
        String theLen = this.getLen();
        int reallen = 0;
        reallen = theLen.lastIndexOf(44) != -1 ? Integer.parseInt(theLen.substring(0, theLen.lastIndexOf(44))) : Integer.parseInt(theLen);
        int count = 0;
        int i2 = 0;
        while (i2 < reallen) {
            char c = ((String)src).charAt(offset + i2);
            if (c > '\u00ff') {
                ++count;
            }
            if (reallen - count - i2 == 1) break;
            ++i2;
        }
        return reallen - count;
    }

    public static String formatNumber(String src, int len2) {
        if (src == null || src.trim().length() == 0) {
            src = "0";
        }
        BigDecimal bd = new BigDecimal(src).setScale(len2, 1);
        int i = 0;
        while (i < len2) {
            bd = bd.multiply(new BigDecimal(10));
            ++i;
        }
        bd = bd.setScale(0, 3);
        return bd.toString();
    }

    public static String unformatNumber(String src, int len2) {
        if (src.trim().length() == 0) {
            return null;
        }
        StringBuffer sb = new StringBuffer(src = src.trim());
        int nidx = sb.indexOf("-");
        if (nidx != -1) {
            sb.deleteCharAt(nidx);
            sb.insert(0, '-');
        }
        if (len2 > 0) {
            int t = sb.length() - len2;
            while (t < 0) {
                sb.insert(0, "0");
                ++t;
            }
            sb.insert(sb.length() - len2, '.');
        }
        BigDecimal bd = null;
        try {
            bd = new BigDecimal(sb.toString().trim()).setScale(len2, 7);
            return bd.toString();
        }
        catch (Exception e) {
            return sb.toString();
        }
    }
}

