/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.emp.web.util;

import com.ecc.emp.component.xml.XMLDocumentLoader;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FactoryUtil {
    private static Map<String, Object> factoryMap;

    public static synchronized void addToMap(Object o) {
        String key;
        if (factoryMap == null) {
            factoryMap = new HashMap<String, Object>();
        }
        if (factoryMap.containsKey(key = o.getClass().getName())) {
            return;
        }
        factoryMap.put(key, o);
    }

    public static synchronized Object getFactory(String key) {
        if (factoryMap == null) {
            return null;
        }
        return factoryMap.get(key);
    }

    public static Document loadXMLDocument(String fileName) throws Exception {
        XMLDocumentLoader loader = new XMLDocumentLoader();
        Document document = loader.loadXMLDocument(fileName);
        return document;
    }

    public static List<Document> loadAllXMLDocument(String filePath) throws Exception {
        File dir = new File(filePath);
        if (!dir.exists()) {
            return null;
        }
        ArrayList<File> files = new ArrayList<File>();
        FactoryUtil.getFiles("xml", dir, files);
        if (files.size() == 0) {
            return null;
        }
        ArrayList<Document> docs = new ArrayList<Document>();
        for (File f : files) {
            docs.add(FactoryUtil.loadXMLDocument(f.getPath()));
        }
        return docs;
    }

    public static void getFiles(final String filter, File dir, List<File> result) {
        File[] files = dir.listFiles(new FileFilter(){

            public boolean accept(File file) {
                if (file.isFile()) {
                    return file.getName().endsWith(filter);
                }
                return true;
            }
        });
        if (files.length == 0) {
            return;
        }
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.isFile()) {
                result.add(f);
            } else {
                FactoryUtil.getFiles(filter, f, result);
            }
            ++n2;
        }
    }
}

