/*
 * Decompiled with CFR 0.152.
 */
package com.yucheng.cmis.dic;

import com.ecc.emp.core.Context;
import com.ecc.emp.service.EMPService;
import com.yucheng.cmis.dic.CMISTreeDicNode;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;

public class CMISTreeDicService
extends EMPService {
    private String enNameColumn = "enname";
    private String cnNameColumn = "cnname";
    private String parentColumn = "abvenname";
    private String typeColumn = "opttype";
    private String locateColumn = "locate";
    private String levelColumn = "levels";
    private String orderByColumn = "orderid";
    private String tableName = "s_treedic";
    private String displaySeparator = "->";
    private HashMap treeCache = new HashMap();
    private HashMap treeNodeCache = new HashMap();

    public void loadDicData(Context context, Connection connection) throws Exception {
    }

    public String toJsonStringByType(String type, boolean dynamic) {
        CMISTreeDicNode node = (CMISTreeDicNode)this.treeCache.get(type);
        return this.toJsonString(node, dynamic);
    }

    public String toJsonStringById(String type, String nodeId, boolean dynamic) {
        HashMap nodeCache = (HashMap)this.treeNodeCache.get(type);
        if (nodeCache == null) {
            return null;
        }
        CMISTreeDicNode node = (CMISTreeDicNode)nodeCache.get(nodeId);
        return this.toJsonString(node, dynamic);
    }

    public String toJsonString(CMISTreeDicNode node, boolean dynamic) {
        if (node == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        buf.append("{id:\"").append(node.enName).append("\"");
        buf.append(",label:\"").append(node.cnName).append("\"");
        buf.append(",dynamic:\"").append(dynamic).append("\"");
        if (node.locate != null && node.locate.length() > 0) {
            buf.append(",locate:\"").append(node.locate).append("\"");
        }
        if (node.childs != null && node.childs.size() > 0) {
            buf.append(",leaf:\"").append(false).append("\"");
            buf.append(",children:[");
            int i = 0;
            while (i < node.childs.size()) {
                CMISTreeDicNode child = (CMISTreeDicNode)node.childs.get(i);
                this.getSubTreeJsonString(buf, child, dynamic);
                if (i < node.childs.size() - 1) {
                    buf.append(",");
                }
                ++i;
            }
            buf.append("]");
        } else {
            buf.append(",leaf:\"").append(true).append("\"");
        }
        buf.append("}");
        return buf.toString();
    }

    public String toChildrenJsonStringById(String type, String nodeId) {
        HashMap nodeCache = (HashMap)this.treeNodeCache.get(type);
        if (nodeCache == null) {
            return null;
        }
        CMISTreeDicNode node = (CMISTreeDicNode)nodeCache.get(nodeId);
        if (node == null || node.childs == null || node.childs.size() == 0) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        int i = 0;
        while (i < node.childs.size()) {
            CMISTreeDicNode child = (CMISTreeDicNode)node.childs.get(i);
            buf.append("{id:\"").append(child.enName).append("\"");
            buf.append(",label:\"").append(child.cnName).append("\"");
            buf.append(",dynamic:\"").append(true).append("\"");
            if (child.locate != null && child.locate.length() > 0) {
                buf.append(",locate:\"").append(child.locate).append("\"");
            }
            if (child.childs != null && child.childs.size() > 0) {
                buf.append(",leaf:\"").append(false).append("\"");
            } else {
                buf.append(",leaf:\"").append(true).append("\"");
            }
            buf.append("}");
            if (i < node.childs.size() - 1) {
                buf.append(",");
            }
            ++i;
        }
        buf.append("]");
        return buf.toString();
    }

    private void getSubTreeJsonString(StringBuffer buf, CMISTreeDicNode node, boolean dynamic) {
        buf.append("{id:\"").append(node.enName).append("\"");
        buf.append(",label:\"").append(node.cnName).append("\"");
        buf.append(",dynamic:\"").append(dynamic).append("\"");
        if (node.locate != null && node.locate.length() > 0) {
            buf.append(",locate:\"").append(node.locate).append("\"");
        }
        if (node.childs != null && node.childs.size() > 0) {
            buf.append(",leaf:\"").append(false).append("\"");
            if (!dynamic) {
                buf.append(",children:[");
                int i = 0;
                while (i < node.childs.size()) {
                    CMISTreeDicNode child = (CMISTreeDicNode)node.childs.get(i);
                    this.getSubTreeJsonString(buf, child, true);
                    if (i < node.childs.size() - 1) {
                        buf.append(",");
                    }
                    ++i;
                }
                buf.append("]");
            }
        } else {
            buf.append(",leaf:\"").append(true).append("\"");
        }
        buf.append("}");
    }

    public CMISTreeDicNode getTree(String type) {
        CMISTreeDicNode node = (CMISTreeDicNode)this.treeCache.get(type);
        return node;
    }

    public CMISTreeDicNode getNode(String type, String nodeId) {
        HashMap nodeCache = (HashMap)this.treeNodeCache.get(type);
        if (nodeCache == null) {
            return null;
        }
        CMISTreeDicNode node = (CMISTreeDicNode)nodeCache.get(nodeId);
        return node;
    }

    public String getDecoratedValue(String type, String nodeId) {
        StringBuffer buffer = new StringBuffer();
        ArrayList<String> list = new ArrayList<String>();
        HashMap nodeCache = (HashMap)this.treeNodeCache.get(type);
        if (nodeCache == null) {
            return null;
        }
        CMISTreeDicNode node = (CMISTreeDicNode)nodeCache.get(nodeId);
        list.add(node.cnName);
        while (node.parent != null) {
            node = node.parent;
            list.add(node.cnName);
        }
        int i = list.size();
        while (i > 0) {
            if (i != 1) {
                buffer.append(list.get(i - 1)).append(this.displaySeparator);
            } else {
                buffer.append(list.get(1));
            }
            --i;
        }
        return buffer.toString();
    }

    public String getCnNameColumn() {
        return this.cnNameColumn;
    }

    public void setCnNameColumn(String cnNameColumn) {
        this.cnNameColumn = cnNameColumn;
    }

    public String getDisplaySeparator() {
        return this.displaySeparator;
    }

    public void setDisplaySeparator(String displaySeparator) {
        this.displaySeparator = displaySeparator;
    }

    public String getEnNameColumn() {
        return this.enNameColumn;
    }

    public void setEnNameColumn(String enNameColumn) {
        this.enNameColumn = enNameColumn;
    }

    public String getLevelColumn() {
        return this.levelColumn;
    }

    public void setLevelColumn(String levelColumn) {
        this.levelColumn = levelColumn;
    }

    public String getLocateColumn() {
        return this.locateColumn;
    }

    public void setLocateColumn(String locateColumn) {
        this.locateColumn = locateColumn;
    }

    public String getOrderByColumn() {
        return this.orderByColumn;
    }

    public void setOrderByColumn(String orderByColumn) {
        this.orderByColumn = orderByColumn;
    }

    public String getParentColumn() {
        return this.parentColumn;
    }

    public void setParentColumn(String parentColumn) {
        this.parentColumn = parentColumn;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getTypeColumn() {
        return this.typeColumn;
    }

    public void setTypeColumn(String typeColumn) {
        this.typeColumn = typeColumn;
    }
}

