/*
 * Decompiled with CFR 0.152.
 */
package com.yucheng.cmis.operation;

import com.ecc.emp.accesscontrol.AccessInfo;
import com.ecc.emp.accesscontrol.AccessManager;
import com.ecc.emp.core.Context;
import com.ecc.emp.core.EMPConstance;
import com.ecc.emp.core.EMPException;
import com.ecc.emp.data.DataElement;
import com.ecc.emp.data.DataField;
import com.ecc.emp.data.DuplicatedDataNameException;
import com.ecc.emp.data.InvalidArgumentException;
import com.ecc.emp.data.ObjectNotFoundException;
import com.ecc.emp.dbmodel.service.TableModelDAO;
import com.ecc.emp.flow.EMPAction;
import com.ecc.emp.flow.Flow;
import com.ecc.emp.flow.Operation;
import com.ecc.emp.jdbc.ConnectionManager;
import com.ecc.emp.jdbc.EMPJDBCException;
import com.ecc.emp.log.EMPLog;
import com.ecc.emp.transaction.EMPTransaction;
import com.ecc.emp.transaction.EMPTransactionDef;
import com.ecc.emp.transaction.EMPTransactionManager;
import com.yucheng.cmis.dao.restriction.RecordRestrict;
import com.yucheng.cmis.primarykey.CMISPrimaryKeyService;
import com.yucheng.cmis.pub.sequence.CMISSequenceService;
import com.yucheng.cmis.util.CommonUtil;
import com.yucheng.cmis.util.SessionUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import javax.servlet.http.HttpServletRequest;
import javax.sql.DataSource;
import org.apache.log4j.Logger;

public abstract class CMISOperation
extends Operation {
    private Logger log = Logger.getLogger(CMISOperation.class);
    private boolean monitorOpened = false;
    private AccessInfo accessInfo = null;
    private String bizId;
    private String defaultDataSourceName = null;
    private RecordRestrict restrict = new RecordRestrict();
    private String method;

    public String getDefaultDataSourceName() {
        return this.defaultDataSourceName;
    }

    public void setDefaultDataSourceName(String defaultDataSourceName) {
        this.defaultDataSourceName = defaultDataSourceName;
    }

    public final String execute(Context context) throws Exception {
        String string;
        long begin = System.currentTimeMillis();
        AccessManager accessManager = (AccessManager)context.getService(EMPConstance.ACCESS_MANAGER);
        Object accessObj = null;
        String retValue = null;
        Exception te = null;
        try {
            if (accessManager != null) {
                String accessItemId = this.getName();
                if (this.getBizId() != null) {
                    accessItemId = String.valueOf(this.getBizId()) + "." + this.getName();
                }
                if ((accessObj = accessManager.checkAccess(context, null, accessItemId)) != null) {
                    accessManager.beginAccess(accessObj);
                }
            }
            if (this.monitorOpened) {
                this.accessInfo.newAccess();
            }
            EMPLog.log((String)EMPConstance.EMP_FLOW, (int)EMPLog.DEBUG, (int)0, (String)("The flow [" + this.getName() + "] 's context is :"), null);
            EMPLog.log((String)EMPConstance.EMP_FLOW, (int)EMPLog.DEBUG, (int)0, (String)context.toString(), null);
            EMPLog.log((String)EMPConstance.EMP_FLOW, (int)EMPLog.DEBUG, (int)0, (String)("The flow [" + this.getName() + "] 's data is :"), null);
            EMPLog.log((String)EMPConstance.EMP_FLOW, (int)EMPLog.DEBUG, (int)0, (String)context.getDataElement().toString(), null);
            try {
                HttpServletRequest request = (HttpServletRequest)context.getDataValue(EMPConstance.SERVLET_REQUEST);
                String requestUrl = request.getServletPath();
                try {
                    context.addDataField("requestUrl", (Object)requestUrl);
                }
                catch (DuplicatedDataNameException e) {
                    context.setDataValue("requestUrl", (Object)requestUrl);
                }
            }
            catch (Exception request) {
                // empty catch block
            }
            EMPTransactionDef transactionDef = this.getTransactionDef();
            EMPTransactionManager transactionManager = this.getTransactionManager(context);
            if (transactionDef != null && transactionManager != null) {
                transactionManager.getTransaction(transactionDef);
            }
            SessionUtil.session2Local((Context)context);
            CommonUtil.markExcSuccess();
            long start = System.currentTimeMillis();
            retValue = this.doExecute(context);
            long end = System.currentTimeMillis();
            EMPLog.log((String)EMPConstance.EMP_FLOW, (int)EMPLog.INFO, (int)0, (String)("Execute the flow [" + this.getName() + "] end.  retValue=" + retValue + " use " + (end - start) + "ms"), null);
            string = retValue;
        }
        catch (Exception e) {
            try {
                CommonUtil.markExcFailure();
                te = e;
                throw e;
            }
            catch (Throwable throwable) {
                SessionUtil.clear();
                if (this.monitorOpened) {
                    this.accessInfo.setRetValue(retValue);
                    this.accessInfo.setThrowable((Throwable)te);
                    this.accessInfo.endAccess(System.currentTimeMillis() - begin);
                }
                if (accessManager != null && accessObj != null) {
                    accessManager.endAccess(accessObj, begin);
                }
                throw throwable;
            }
        }
        SessionUtil.clear();
        if (this.monitorOpened) {
            this.accessInfo.setRetValue(retValue);
            this.accessInfo.setThrowable((Throwable)te);
            this.accessInfo.endAccess(System.currentTimeMillis() - begin);
        }
        if (accessManager != null && accessObj != null) {
            accessManager.endAccess(accessObj, begin);
        }
        return string;
    }

    protected String doExecute(Context context) throws EMPException {
        String result = "retPage";
        if (this.method != null && !"".equals(this.method)) {
            try {
                Method m = ((Object)((Object)this)).getClass().getMethod(this.method, context.getClass());
                result = (String)m.invoke((Object)this, context);
            }
            catch (SecurityException e) {
                throw new EMPException((Throwable)e);
            }
            catch (NoSuchMethodException e) {
                throw new EMPException((Throwable)e);
            }
            catch (IllegalArgumentException e) {
                throw new EMPException((Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new EMPException((Throwable)e);
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
                EMPLog.log((String)"CMIS", (int)EMPLog.ERROR, (int)0, (String)"\u6267\u884cOP\u65f6\u51fa\u9519:", (Throwable)e);
                if (e.getTargetException() instanceof EMPException) {
                    throw (EMPException)e.getTargetException();
                }
                throw new EMPException(e.getTargetException().getMessage());
            }
        }
        return result;
    }

    public void initialize() {
    }

    protected final String executeAction(Context context, EMPAction action) throws Exception {
        EMPTransaction transaction = null;
        String retValue = null;
        EMPLog.log((String)EMPConstance.EMP_FLOW, (int)EMPLog.DEBUG, (int)0, (String)("Execute the step [" + action.getFullName() + "]..."), null);
        EMPTransactionDef transactionDef = action.getTransactionDef();
        EMPTransactionManager transactionManager = this.getTransactionManager(context);
        if (transactionDef != null && transactionManager != null) {
            transaction = transactionManager.getTransaction(transactionDef);
        }
        try {
            retValue = action.execute(context);
            this.setRetValue(context, retValue);
            if (transactionDef != null && transactionDef.getTrsactionReq() == 1) {
                transactionManager.commit(transaction);
            }
            EMPLog.log((String)EMPConstance.EMP_FLOW, (int)EMPLog.DEBUG, (int)0, (String)("The step [" + action.getFullName() + "] returns value: " + retValue), null);
        }
        catch (Exception e) {
            EMPLog.log((String)EMPConstance.EMP_FLOW, (int)EMPLog.DEBUG, (int)0, (String)("Execute the step [" + action.getFullName() + "] end dure to Exception : " + e), (Throwable)e);
            if (transactionDef != null && transactionDef.getTrsactionReq() == 1) {
                transactionManager.rollback();
            } else if (transactionDef != null) {
                transactionManager.setRollBackOnly();
            }
            throw e;
        }
        return retValue;
    }

    private void setRetValue(Context context, String retValue) {
        DataField field = null;
        try {
            field = (DataField)context.getDataElement("retValue");
        }
        catch (EMPException eMPException) {
            // empty catch block
        }
        try {
            if (field != null) {
                context.setDataValue("retValue", (Object)retValue);
            } else {
                context.addDataField("retValue", (Object)retValue);
            }
        }
        catch (EMPException eMPException) {
            // empty catch block
        }
    }

    protected DataSource getDataSource(Context context) throws EMPJDBCException {
        DataSource dataSource = null;
        if (this.defaultDataSourceName != null) {
            dataSource = (DataSource)context.getService(this.defaultDataSourceName);
        }
        if (dataSource == null) {
            dataSource = (DataSource)context.getService("dataSource");
        }
        return dataSource;
    }

    protected DataSource getDataSource(Context context, String dataSourceName) throws EMPJDBCException {
        DataSource dataSource = (DataSource)context.getService(dataSourceName);
        return dataSource;
    }

    protected Connection getConnection(Context context) throws EMPJDBCException {
        DataSource dataSource = null;
        if (this.defaultDataSourceName != null) {
            dataSource = (DataSource)context.getService(this.defaultDataSourceName);
        } else {
            String dataSourceName = null;
            if (context.containsKey((Object)"multiDataSource")) {
                try {
                    dataSourceName = (String)context.getDataValue("multiDataSource");
                }
                catch (ObjectNotFoundException e) {
                    e.printStackTrace();
                }
                catch (InvalidArgumentException e) {
                    e.printStackTrace();
                }
            }
            if (dataSourceName == null || dataSourceName.equals("")) {
                dataSourceName = "dataSource";
            }
            dataSource = (DataSource)context.getService(dataSourceName);
        }
        return this.getConnection(context, dataSource);
    }

    protected Connection getConnection(Context context, String dataSourceName) throws EMPJDBCException {
        DataSource dataSource = (DataSource)context.getService(dataSourceName);
        return this.getConnection(context, dataSource);
    }

    private Connection getConnection(Context context, DataSource dataSource) throws EMPJDBCException {
        if (dataSource == null) {
            throw new EMPJDBCException("dataSource is null in :" + this.toString());
        }
        Connection connection = null;
        connection = ConnectionManager.getConnection((DataSource)dataSource);
        EMPLog.log((String)EMPConstance.EMP_TRANSACTION, (int)EMPLog.INFO, (int)0, (String)("Apply new connection from data source: " + dataSource + " success!"));
        return connection;
    }

    private void releaseConnection(DataSource dataSource, Connection connection) throws EMPJDBCException {
        ConnectionManager.releaseConnection((DataSource)dataSource, (Connection)connection);
        EMPLog.log((String)EMPConstance.EMP_TRANSACTION, (int)EMPLog.INFO, (int)0, (String)("Do release the connection from data source: " + dataSource + " success!"));
    }

    protected void releaseConnection(Context context, String dataSourceName, Connection connection) throws EMPJDBCException {
        DataSource dataSource = (DataSource)context.getService(dataSourceName);
        this.releaseConnection(dataSource, connection);
    }

    protected void releaseConnection(Context context, Connection connection) throws EMPJDBCException {
        String dataSourceName = this.defaultDataSourceName;
        if (dataSourceName == null || dataSourceName.equals("")) {
            if (context.containsKey((Object)"multiDataSource")) {
                try {
                    dataSourceName = (String)context.getDataValue("multiDataSource");
                }
                catch (ObjectNotFoundException e) {
                    e.printStackTrace();
                }
                catch (InvalidArgumentException e) {
                    e.printStackTrace();
                }
            }
            if (dataSourceName == null || dataSourceName.equals("")) {
                dataSourceName = "dataSource";
            }
        }
        this.releaseConnection(context, dataSourceName, connection);
    }

    protected String getPrimaryKey(Context context) throws EMPException {
        CMISPrimaryKeyService service = (CMISPrimaryKeyService)context.getService("pkGeneratorSet");
        return service.getPrimaryKey();
    }

    protected String getSequence(String aType, String owner, Context context, Connection connection) throws EMPException {
        CMISSequenceService service = (CMISSequenceService)((Object)context.getService("sequenceService"));
        return service.getSequence(aType, owner, context, connection);
    }

    protected String getRequestContextPath(Context context) throws EMPException {
        HttpServletRequest request = null;
        try {
            request = (HttpServletRequest)context.getDataValue(EMPConstance.SERVLET_REQUEST);
        }
        catch (ObjectNotFoundException e) {
            return null;
        }
        if (request == null) {
            return null;
        }
        return request.getContextPath();
    }

    protected HttpServletRequest getHttpServletRequest(Context context) throws EMPException {
        HttpServletRequest request = null;
        try {
            request = (HttpServletRequest)context.getDataValue(EMPConstance.SERVLET_REQUEST);
        }
        catch (ObjectNotFoundException e) {
            return null;
        }
        if (request == null) {
            return null;
        }
        return request;
    }

    protected TableModelDAO getTableModelDAO(Context context) throws EMPException {
        return this.getTableModelDAO("tableModelDAO", context);
    }

    protected TableModelDAO getTableModelDAO(String modelId, Context context) throws EMPException {
        TableModelDAO dao = (TableModelDAO)((Object)context.getService(modelId));
        return dao;
    }

    protected RecordRestrict getRecordRestrict(Context context) throws EMPException {
        return this.getRecordRestrict("recordRestrict", context);
    }

    protected RecordRestrict getRecordRestrict(String serviceId, Context context) throws EMPException {
        return this.restrict;
    }

    protected EMPTransactionManager getTransactionManager(Context context) {
        return (EMPTransactionManager)context.getService(EMPConstance.TRX_SVC_NAME);
    }

    protected void putDataElement2Context(DataElement dataElement, Context context) throws InvalidArgumentException {
        try {
            context.addDataElement(dataElement);
        }
        catch (InvalidArgumentException e) {
            throw e;
        }
        catch (DuplicatedDataNameException e) {
            context.removeDataElement(dataElement.getName());
            try {
                context.addDataElement(dataElement);
            }
            catch (DuplicatedDataNameException duplicatedDataNameException) {
                // empty catch block
            }
        }
    }

    public EMPTransactionDef getTransactionDef() {
        EMPTransactionDef transactionDef = new EMPTransactionDef(0);
        return transactionDef;
    }

    public void setMonitorOpened(boolean value) {
        this.monitorOpened = value;
        String accessItemId = this.getName();
        if (this.getBizId() != null) {
            accessItemId = String.valueOf(this.getBizId()) + "." + this.getName();
        }
        this.accessInfo = this.monitorOpened ? new AccessInfo(accessItemId) : null;
    }

    public AccessInfo getAccessInfo() {
        return this.accessInfo;
    }

    public Flow getFlow() {
        return null;
    }

    public void setFlow(Flow flow) {
    }

    public void setBizId(String bizId) {
        this.bizId = bizId;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }
}

