/*
 * Decompiled with CFR 0.152.
 */
package com.yucheng.cmis.pub;

import com.ecc.emp.core.Context;
import com.ecc.emp.log.EMPLog;
import com.yucheng.cmis.pub.CMISComponent;
import com.yucheng.cmis.pub.exception.ComponentException;
import com.yucheng.cmis.pub.util.CMISPropertyManager;
import com.yucheng.cmis.pub.util.ResourceUtils;
import com.yucheng.cmis.pub.util.XMLFileUtil;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Iterator;

public class CMISComponentFactory {
    private static CMISComponentFactory instance = new CMISComponentFactory();
    private static HashMap componentTable = null;
    private static HashMap interfaceTable = null;
    public static final String CONFIGKEY_MODULEID = "moduleid";
    public static final String CONFIGKEY_CLASSNAME = "classname";
    public static final String CONFIGKEY_DESCRIBE = "describe";

    public static void init() throws ComponentException {
        try {
            XMLFileUtil xmlFileUtil = new XMLFileUtil();
            String dir = CMISPropertyManager.getInstance().getComponentConfigFileDir();
            String CONFIG_FILM_DIR = ResourceUtils.getFile((String)dir).getAbsolutePath();
            componentTable = (HashMap)xmlFileUtil.readComponentFromXMLFile(CONFIG_FILM_DIR);
            interfaceTable = (HashMap)xmlFileUtil.readInterfaceFromXMLFile(CONFIG_FILM_DIR);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new ComponentException("999999", "\u521d\u59cb\u5316\u7ec4\u4ef6\u914d\u7f6e\u5931\u8d25\uff0c" + ex.getMessage());
        }
    }

    public CMISComponent getComponentInstance(String comId) throws ComponentException {
        if (componentTable == null || componentTable.size() <= 0) {
            throw new ComponentException("999999", "\u4e1a\u52a1\u7ec4\u4ef6\u5217\u8868\u5c1a\u672a\u521d\u59cb\u5316\uff0c\u8bf7\u5148\u8c03\u7528\u521d\u59cb\u5316\u65b9\u6cd5\u540e\u518d\u4f7f\u7528getComponentInstance\u65b9\u6cd5");
        }
        if (comId == null || comId.trim().equals("")) {
            throw new ComponentException("999999", "\u4e1a\u52a1\u7ec4\u4ef6\u7f16\u53f7\u4e3a\u7a7a\uff0c \u65e0\u6cd5\u5b9e\u4f8b\u5316\u4e1a\u52a1\u7ec4\u4ef6");
        }
        CMISComponent component = null;
        try {
            String st_describe;
            String st_classname;
            HashMap componentCfg = (HashMap)componentTable.get(comId);
            if (componentCfg != null && componentCfg.size() > 0) {
                st_classname = (String)componentCfg.get(CONFIGKEY_CLASSNAME);
                st_describe = (String)componentCfg.get(CONFIGKEY_DESCRIBE);
                if (st_classname == null || st_classname.trim().equals("")) {
                    throw new ComponentException("999999", "\u4e1a\u52a1\u7ec4\u4ef6[" + comId + "]\u6ca1\u6709\u914d\u7f6e\u5b9e\u73b0\u7c7b\uff08" + CONFIGKEY_CLASSNAME + "\uff09\uff0c \u65e0\u6cd5\u5b9e\u4f8b\u5316\u4e1a\u52a1\u7ec4\u4ef6");
                }
            } else {
                throw new ComponentException("999999", "\u4e1a\u52a1\u7ec4\u4ef6[" + comId + "]\u5c1a\u672a\u914d\u7f6e\uff0c\u65e0\u6cd5\u5b9e\u4f8b\u5316");
            }
            component = (CMISComponent)Class.forName(st_classname).newInstance();
            component.setId(comId);
            component.setDescribe(st_describe);
            component.setParameter(componentCfg);
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            throw new ComponentException(e.getMessage());
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new ComponentException("999999", "\u521d\u59cb\u5316\u4e1a\u52a1\u7ec4\u4ef6[" + comId + "]\u5931\u8d25\uff0c\u65e0\u6743\u8bbf\u95ee\u7c7b" + e.getMessage());
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new ComponentException("999999", "\u521d\u59cb\u5316\u4e1a\u52a1\u7ec4\u4ef6[" + comId + "]\u5931\u8d25\uff0c\u5bf9\u5e94\u7684\u5b9e\u73b0\u7c7b\u4e0d\u5b58\u5728" + e.getMessage());
        }
        return component;
    }

    public CMISComponent getComponentInstance(String comId, Context context, Connection connection) throws ComponentException {
        CMISComponent component = null;
        component = this.getComponentInstance(comId, context, true, connection);
        return component;
    }

    public CMISComponent getComponentInstance(String comId, Context context, boolean setConnInd, Connection connection) throws ComponentException {
        CMISComponent component;
        block9: {
            if (componentTable == null || componentTable.size() <= 0) {
                throw new ComponentException("999999", "\u4e1a\u52a1\u7ec4\u4ef6\u5217\u8868\u5c1a\u672a\u521d\u59cb\u5316\uff0c\u8bf7\u5148\u8c03\u7528\u521d\u59cb\u5316\u65b9\u6cd5\u540e\u518d\u4f7f\u7528getComponentInstance\u65b9\u6cd5");
            }
            if (comId == null || comId.trim().equals("")) {
                throw new ComponentException("999999", "\u4e1a\u52a1\u7ec4\u4ef6\u7f16\u53f7\u4e3a\u7a7a\uff0c \u65e0\u6cd5\u5b9e\u4f8b\u5316\u4e1a\u52a1\u7ec4\u4ef6");
            }
            component = null;
            try {
                HashMap componentCfg = (HashMap)componentTable.get(comId);
                if (componentCfg != null && componentCfg.size() > 0) {
                    String st_classname = (String)componentCfg.get(CONFIGKEY_CLASSNAME);
                    String st_describe = (String)componentCfg.get(CONFIGKEY_DESCRIBE);
                    if (st_classname != null && !st_classname.trim().equals("")) {
                        component = (CMISComponent)Class.forName(st_classname).newInstance();
                        component.setId(comId);
                        component.setDescribe(st_describe);
                        component.setParameter(componentCfg);
                        component.setContext(context);
                        if (setConnInd) {
                            component.setConnection(connection);
                        }
                        break block9;
                    }
                    throw new ComponentException("999999", "\u4e1a\u52a1\u7ec4\u4ef6[" + comId + "]\u6ca1\u6709\u914d\u7f6e\u5b9e\u73b0\u7c7b\uff08" + CONFIGKEY_CLASSNAME + "\uff09\uff0c \u65e0\u6cd5\u5b9e\u4f8b\u5316\u4e1a\u52a1\u7ec4\u4ef6");
                }
                throw new ComponentException("999999", "\u4e1a\u52a1\u7ec4\u4ef6[" + comId + "]\u5c1a\u672a\u914d\u7f6e\uff0c\u65e0\u6cd5\u5b9e\u4f8b\u5316");
            }
            catch (InstantiationException e) {
                e.printStackTrace();
                throw new ComponentException(e.getMessage());
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                throw new ComponentException("999999", "\u521d\u59cb\u5316\u4e1a\u52a1\u7ec4\u4ef6[" + comId + "]\u5931\u8d25\uff0c\u65e0\u6743\u8bbf\u95ee\u7c7b" + e.getMessage());
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                throw new ComponentException("999999", "\u521d\u59cb\u5316\u4e1a\u52a1\u7ec4\u4ef6[" + comId + "]\u5931\u8d25\uff0c\u5bf9\u5e94\u7684\u5b9e\u73b0\u7c7b\u4e0d\u5b58\u5728" + e.getMessage());
            }
        }
        return component;
    }

    public CMISComponent getComponentInterface(String interfaceId, Context context, Connection connection) throws ComponentException {
        CMISComponent component = null;
        component = this.getComponentInterface(interfaceId, context, true, connection);
        return component;
    }

    public CMISComponent getComponentInterface(String interfaceId, Context context, boolean setConnInd, Connection connection) throws ComponentException {
        CMISComponent component;
        block9: {
            if (interfaceTable == null || interfaceTable.size() <= 0) {
                throw new ComponentException("999999", "\u4e1a\u52a1\u7ec4\u4ef6\u63a5\u53e3\u5217\u8868\u5c1a\u672a\u521d\u59cb\u5316\uff0c\u8bf7\u5148\u8c03\u7528\u521d\u59cb\u5316\u65b9\u6cd5\u540e\u518d\u4f7f\u7528getComponentInterface\u65b9\u6cd5");
            }
            if (interfaceId == null || interfaceId.trim().equals("")) {
                throw new ComponentException("999999", "\u4e1a\u52a1\u7ec4\u4ef6\u63a5\u53e3\u7f16\u53f7\u4e3a\u7a7a\uff0c \u65e0\u6cd5\u5b9e\u4f8b\u5316\u4e1a\u52a1\u7ec4\u4ef6\u63a5\u53e3");
            }
            component = null;
            try {
                HashMap componentCfg = (HashMap)interfaceTable.get(interfaceId);
                if (componentCfg != null && componentCfg.size() > 0) {
                    String st_classname = (String)componentCfg.get(CONFIGKEY_CLASSNAME);
                    String st_describe = (String)componentCfg.get(CONFIGKEY_DESCRIBE);
                    if (st_classname != null && !st_classname.trim().equals("")) {
                        component = (CMISComponent)Class.forName(st_classname).newInstance();
                        component.setId(interfaceId);
                        component.setDescribe(st_describe);
                        component.setParameter(componentCfg);
                        component.setContext(context);
                        if (setConnInd) {
                            component.setConnection(connection);
                        }
                        break block9;
                    }
                    throw new ComponentException("999999", "\u4e1a\u52a1\u7ec4\u4ef6\u63a5\u53e3[" + interfaceId + "]\u6ca1\u6709\u914d\u7f6e\u5b9e\u73b0\u7c7b\uff08" + CONFIGKEY_CLASSNAME + "\uff09\uff0c \u65e0\u6cd5\u5b9e\u4f8b\u5316\u4e1a\u52a1\u7ec4\u4ef6\u63a5\u53e3");
                }
                throw new ComponentException("999999", "\u4e1a\u52a1\u7ec4\u4ef6\u63a5\u53e3[" + interfaceId + "]\u5c1a\u672a\u914d\u7f6e\uff0c\u65e0\u6cd5\u5b9e\u4f8b\u5316");
            }
            catch (InstantiationException e) {
                e.printStackTrace();
                throw new ComponentException(e.getMessage());
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                throw new ComponentException("999999", "\u521d\u59cb\u5316\u4e1a\u52a1\u7ec4\u4ef6\u63a5\u53e3[" + interfaceId + "]\u5931\u8d25\uff0c\u65e0\u6743\u8bbf\u95ee\u7c7b" + e.getMessage());
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                throw new ComponentException("999999", "\u521d\u59cb\u5316\u4e1a\u52a1\u7ec4\u4ef6\u63a5\u53e3[" + interfaceId + "]\u5931\u8d25\uff0c\u5bf9\u5e94\u7684\u5b9e\u73b0\u7c7b\u4e0d\u5b58\u5728" + e.getMessage());
            }
        }
        return component;
    }

    public static CMISComponentFactory getComponentFactoryInstance() {
        if (instance != null) {
            return instance;
        }
        return new CMISComponentFactory();
    }

    public CMISComponent getComponentByClassName(String className, Context context, Connection connection) throws ComponentException {
        if (className == null || "".equals(className)) {
            throw new ComponentException("component\u7c7b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CMISComponent component = null;
        try {
            component = (CMISComponent)Class.forName(className).newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            throw new ComponentException("999999", "\u521d\u59cb\u5316component[" + className + "]\u5931\u8d25\uff0c\u65e0\u6743\u8bbf\u95ee\u7c7b" + e.getMessage());
        }
        catch (ClassNotFoundException e) {
            throw new ComponentException("999999", "\u521d\u59cb\u5316component[" + className + "]\u5931\u8d25\uff0c\u5bf9\u5e94\u7684\u5b9e\u73b0\u7c7b\u4e0d\u5b58\u5728" + e.getMessage());
        }
        component.setId("className");
        component.setDescribe("className");
        component.setParameter(null);
        component.setContext(context);
        return component;
    }

    public CMISComponent getComponentInterfaceWithOldConnection(String interfaceId, Context context, Connection connection) throws ComponentException {
        if (interfaceTable == null || interfaceTable.size() <= 0) {
            throw new ComponentException("999999", "\u4e1a\u52a1\u7ec4\u4ef6\u63a5\u53e3\u5217\u8868\u5c1a\u672a\u521d\u59cb\u5316\uff0c\u8bf7\u5148\u8c03\u7528\u521d\u59cb\u5316\u65b9\u6cd5\u540e\u518d\u4f7f\u7528getComponentInterface\u65b9\u6cd5");
        }
        if (interfaceId == null || interfaceId.trim().equals("")) {
            throw new ComponentException("999999", "\u4e1a\u52a1\u7ec4\u4ef6\u63a5\u53e3\u7f16\u53f7\u4e3a\u7a7a\uff0c \u65e0\u6cd5\u5b9e\u4f8b\u5316\u4e1a\u52a1\u7ec4\u4ef6\u63a5\u53e3");
        }
        CMISComponent component = null;
        try {
            String st_describe;
            String st_classname;
            HashMap componentCfg = (HashMap)interfaceTable.get(interfaceId);
            if (componentCfg != null && componentCfg.size() > 0) {
                st_classname = (String)componentCfg.get(CONFIGKEY_CLASSNAME);
                st_describe = (String)componentCfg.get(CONFIGKEY_DESCRIBE);
                if (st_classname == null || st_classname.trim().equals("")) {
                    throw new ComponentException("999999", "\u4e1a\u52a1\u7ec4\u4ef6\u63a5\u53e3[" + interfaceId + "]\u6ca1\u6709\u914d\u7f6e\u5b9e\u73b0\u7c7b\uff08" + CONFIGKEY_CLASSNAME + "\uff09\uff0c \u65e0\u6cd5\u5b9e\u4f8b\u5316\u4e1a\u52a1\u7ec4\u4ef6\u63a5\u53e3");
                }
            } else {
                throw new ComponentException("999999", "\u4e1a\u52a1\u7ec4\u4ef6\u63a5\u53e3[" + interfaceId + "]\u5c1a\u672a\u914d\u7f6e\uff0c\u65e0\u6cd5\u5b9e\u4f8b\u5316");
            }
            component = (CMISComponent)Class.forName(st_classname).newInstance();
            component.setId(interfaceId);
            component.setDescribe(st_describe);
            component.setParameter(componentCfg);
            component.setContext(context);
            component.setConnection(connection);
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            throw new ComponentException(e.getMessage());
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new ComponentException("999999", "\u521d\u59cb\u5316\u4e1a\u52a1\u7ec4\u4ef6\u63a5\u53e3[" + interfaceId + "]\u5931\u8d25\uff0c\u65e0\u6743\u8bbf\u95ee\u7c7b" + e.getMessage());
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new ComponentException("999999", "\u521d\u59cb\u5316\u4e1a\u52a1\u7ec4\u4ef6\u63a5\u53e3[" + interfaceId + "]\u5931\u8d25\uff0c\u5bf9\u5e94\u7684\u5b9e\u73b0\u7c7b\u4e0d\u5b58\u5728" + e.getMessage());
        }
        return component;
    }

    public CMISComponent getComponentInstanceWithOldCon(String comId, Context context, Connection connection) throws ComponentException {
        if (componentTable == null || componentTable.size() <= 0) {
            throw new ComponentException("999999", "\u4e1a\u52a1\u7ec4\u4ef6\u5217\u8868\u5c1a\u672a\u521d\u59cb\u5316\uff0c\u8bf7\u5148\u8c03\u7528\u521d\u59cb\u5316\u65b9\u6cd5\u540e\u518d\u4f7f\u7528getComponentInstance\u65b9\u6cd5");
        }
        if (comId == null || comId.trim().equals("")) {
            throw new ComponentException("999999", "\u4e1a\u52a1\u7ec4\u4ef6\u7f16\u53f7\u4e3a\u7a7a\uff0c \u65e0\u6cd5\u5b9e\u4f8b\u5316\u4e1a\u52a1\u7ec4\u4ef6");
        }
        CMISComponent component = null;
        try {
            String st_describe;
            String st_classname;
            HashMap componentCfg = (HashMap)componentTable.get(comId);
            if (componentCfg != null && componentCfg.size() > 0) {
                st_classname = (String)componentCfg.get(CONFIGKEY_CLASSNAME);
                st_describe = (String)componentCfg.get(CONFIGKEY_DESCRIBE);
                if (st_classname == null || st_classname.trim().equals("")) {
                    throw new ComponentException("999999", "\u4e1a\u52a1\u7ec4\u4ef6[" + comId + "]\u6ca1\u6709\u914d\u7f6e\u5b9e\u73b0\u7c7b\uff08" + CONFIGKEY_CLASSNAME + "\uff09\uff0c \u65e0\u6cd5\u5b9e\u4f8b\u5316\u4e1a\u52a1\u7ec4\u4ef6");
                }
            } else {
                throw new ComponentException("999999", "\u4e1a\u52a1\u7ec4\u4ef6[" + comId + "]\u5c1a\u672a\u914d\u7f6e\uff0c\u65e0\u6cd5\u5b9e\u4f8b\u5316");
            }
            component = (CMISComponent)Class.forName(st_classname).newInstance();
            component.setId(comId);
            component.setDescribe(st_describe);
            component.setParameter(componentCfg);
            component.setContext(context);
            component.setConnection(connection);
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            throw new ComponentException(e.getMessage());
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new ComponentException("999999", "\u521d\u59cb\u5316\u4e1a\u52a1\u7ec4\u4ef6[" + comId + "]\u5931\u8d25\uff0c\u65e0\u6743\u8bbf\u95ee\u7c7b" + e.getMessage());
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new ComponentException("999999", "\u521d\u59cb\u5316\u4e1a\u52a1\u7ec4\u4ef6[" + comId + "]\u5931\u8d25\uff0c\u5bf9\u5e94\u7684\u5b9e\u73b0\u7c7b\u4e0d\u5b58\u5728" + e.getMessage());
        }
        return component;
    }

    public static void addAndUnstallComponentTable(String dir) throws Exception {
        XMLFileUtil xmlFileUtil = new XMLFileUtil();
        HashMap installComponentMap = (HashMap)xmlFileUtil.readComponentFromXMLFile(dir);
        if (installComponentMap == null) {
            return;
        }
        Iterator iterator = installComponentMap.keySet().iterator();
        String s = null;
        while (iterator.hasNext()) {
            s = (String)iterator.next();
            if (componentTable.containsKey(s)) {
                componentTable.remove(s);
                EMPLog.log((String)"ComponentTable", (int)EMPLog.INFO, (int)0, (String)("Unstall Component id for [" + s + "]!"));
            }
            componentTable.put(s, installComponentMap.get(s));
            EMPLog.log((String)"ComponentTable", (int)EMPLog.INFO, (int)0, (String)("Install Component id for [" + s + "]!"));
        }
    }
}

