/*
 * Decompiled with CFR 0.152.
 */
package com.yucheng.cmis.pub.fileupload;

import com.ecc.emp.core.EMPConstance;
import com.ecc.emp.log.EMPLog;
import com.ecc.emp.web.multipart.EMPMultipartHttpServletRequest;
import com.ecc.emp.web.multipart.MultipartHttpServletRequest;
import com.ecc.emp.web.multipart.MultipartResolver;
import com.ecc.emp.web.multipart.UploadStatusListener;
import com.ecc.emp.web.multipart.implement.EMPMultipartFile;
import com.yucheng.cmis.util.UNIDProducer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;

public class CMISMultipartResolver
implements MultipartResolver {
    private String tempFileRootPath;
    private String srvFileRootPath;
    private long maxFileSize;
    private String FILESRV_IP;
    private String FILESRV_USER;
    private String FILESRV_PWD;
    private String FILESRV_PORT;
    private boolean seperateViaDate = true;
    private static String FILEPATHSPLIT = ",";
    private static final String DOC_TYPE_TEMP = "990";
    private String dateDirFormat = "yyyy_MM_dd";
    private boolean reserveUploadFile = false;
    private String tableName = "DocBasicinfo";

    public CMISMultipartResolver() {
        ResourceBundle res = ResourceBundle.getBundle("cmis");
        this.tempFileRootPath = res.getString("tempFileRootPath");
        this.srvFileRootPath = res.getString("srvFileRootPath");
        this.maxFileSize = Long.parseLong(res.getString("maxFileSize"));
        this.FILESRV_IP = res.getString("FILESRVIP");
        this.FILESRV_PWD = res.getString("FILESRVPWD");
        this.FILESRV_USER = res.getString("FILESRVUSER");
        this.FILESRV_PORT = res.getString("FILESRVPORT");
    }

    public boolean isMultipart(HttpServletRequest request) {
        String contentType = request.getContentType();
        if (contentType == null) {
            return false;
        }
        int i = contentType.indexOf("boundary=");
        return i != -1;
    }

    public MultipartHttpServletRequest resolverMultipart(HttpServletRequest request, UploadStatusListener listener) throws Exception {
        String[] file = null;
        String encoding = request.getCharacterEncoding();
        String appsrvIp = request.getLocalAddr();
        if (encoding == null) {
            encoding = "utf-8";
        }
        String endBoundary = "";
        String contentType = request.getContentType();
        int i = contentType.indexOf("boundary=");
        if (i != -1) {
            endBoundary = "--" + contentType.substring(i + 9) + "--";
        }
        String boundary = "";
        int length = request.getContentLength();
        if (length == 0) {
            return null;
        }
        HashMap parameters = new HashMap();
        HashMap<String, EMPMultipartFile> fileMap = new HashMap<String, EMPMultipartFile>();
        FileOutputStream fo = null;
        if (this.maxFileSize > 0L && (long)length > this.maxFileSize) {
            this.addParameter(String.valueOf(this.getTableName()) + "__sys_info", "\u6587\u4ef6\u8d85\u8fc7\u5927\u5c0f\u4e0a\u9650" + this.maxFileSize / 1024L + "K", parameters);
            this.addParameter(String.valueOf(this.getTableName()) + "__sys_state", "500", parameters);
        } else {
            if (listener != null) {
                listener.start(length);
            }
            ServletInputStream is = request.getInputStream();
            int bufferSizeInt = 1024;
            byte[] buffer = new byte[bufferSizeInt];
            int readLen = 0;
            int totalLen = 0;
            int bytesReaded = 0;
            Object contentBuffer = new byte[bufferSizeInt];
            int contentLen = 0;
            try {
                String readLine = "";
                LineInfo lInfo = this.readLine(buffer, (InputStream)is);
                readLen = lInfo.len;
                bytesReaded += readLen;
                if (listener != null) {
                    listener.bytesRead(bytesReaded);
                }
                boundary = encoding == null ? new String(buffer, 0, readLen) : new String(buffer, 0, readLen, encoding);
                boolean isEnd = false;
                block8: while (!isEnd) {
                    Object tmp;
                    int fe;
                    int fb;
                    boolean isFile = false;
                    lInfo = this.readLine(buffer, (InputStream)is);
                    readLen = lInfo.len;
                    if (readLen == 0) break;
                    bytesReaded += readLen;
                    String descript = new String(buffer, 0, readLen, encoding);
                    String parameterName = "";
                    String fileName = "";
                    int nb = descript.indexOf("name=");
                    if (nb != -1) {
                        int ne = descript.indexOf("\"", nb + 6);
                        parameterName = descript.substring(nb + 6, ne);
                    }
                    if ((fb = descript.indexOf("filename=")) != -1 && (fileName = descript.substring(fb + 10, fe = descript.indexOf("\"", fb + 10))) != null && !fileName.trim().equals("")) {
                        String st_doc_type = this.getParameter(String.valueOf(this.getTableName()) + ".doc_type", "", parameters);
                        String st_org_no = this.getParameter(String.valueOf(this.getTableName()) + ".register_org_no", "", parameters);
                        String st_doc_no = this.getParameter(String.valueOf(this.getTableName()) + ".doc_no", "", parameters);
                        if (st_doc_no == null || st_doc_no.trim().equals("")) {
                            UNIDProducer uniCode = new UNIDProducer();
                            st_doc_no = uniCode.getUNID();
                            this.addParameter(String.valueOf(this.getTableName()) + "__doc_no", st_doc_no, parameters);
                        }
                        fileName = URLDecoder.decode(fileName);
                        if (st_doc_type == null || st_doc_type.trim().equals("")) {
                            st_doc_type = DOC_TYPE_TEMP;
                        }
                        file = this.getFileName(st_org_no, st_doc_type, st_doc_no, fileName);
                        EMPMultipartFile empMultiPartFile = new EMPMultipartFile(parameterName, file[0], fileName);
                        fileMap.put(parameterName, empMultiPartFile);
                        this.addParameter(parameterName, file[0], parameters);
                        this.addParameter(String.valueOf(this.getTableName()) + "__file_path", file[1], parameters);
                        this.addParameter(String.valueOf(this.getTableName()) + "__file_name", file[2], parameters);
                        fo = this.openFileForWrite(file[0]);
                        isFile = true;
                    }
                    do {
                        lInfo = this.readLine(buffer, (InputStream)is);
                        readLen = lInfo.len;
                        bytesReaded += readLen;
                    } while (((String)(tmp = new String(buffer, 0, readLen, encoding))).trim().length() != 0);
                    if (listener != null) {
                        listener.bytesRead(bytesReaded);
                    }
                    contentLen = 0;
                    while (true) {
                        lInfo = this.readLine(buffer, (InputStream)is);
                        readLen = lInfo.len;
                        bytesReaded += readLen;
                        if (listener != null) {
                            listener.bytesRead(bytesReaded);
                        }
                        if (readLen <= 0) {
                            if (contentLen <= 0 || !isFile) continue block8;
                            this.writeToFile(fo, (byte[])contentBuffer, contentLen);
                            contentLen = 0;
                            continue block8;
                        }
                        if (lInfo.isLine && ((readLine = new String(buffer, 0, readLen, encoding)).equals(boundary) || readLine.trim().equals(endBoundary) || readLine.indexOf(boundary) >= 0 || readLine.trim().indexOf(endBoundary) >= 0)) {
                            if (isFile) {
                                if (contentLen > 2) {
                                    this.writeToFile(fo, (byte[])contentBuffer, contentLen - 2);
                                }
                                try {
                                    EMPLog.log((String)EMPConstance.EMP_MULTIPART, (int)EMPLog.INFO, (int)0, (String)("Receive upload file:" + fileName + " finished!"));
                                    fo.close();
                                    isFile = false;
                                }
                                catch (Exception ee) {
                                    EMPLog.log((String)EMPConstance.EMP_MULTIPART, (int)EMPLog.ERROR, (int)0, (String)("Receive upload file:" + fileName + " failed to close!"), (Throwable)ee);
                                }
                                continue block8;
                            }
                            if (contentLen <= 2) continue block8;
                            String content = new String((byte[])contentBuffer, 0, contentLen - 2, encoding);
                            this.addParameter(parameterName, content, parameters);
                            continue block8;
                        }
                        if (contentLen + readLen > ((byte[])contentBuffer).length) {
                            if (isFile) {
                                this.writeToFile(fo, (byte[])contentBuffer, contentLen);
                                this.writeToFile(fo, buffer, readLen);
                                contentLen = 0;
                                continue;
                            }
                            tmp = new byte[((byte[])contentBuffer).length + 1024];
                            System.arraycopy(contentBuffer, 0, tmp, 0, contentLen);
                            contentBuffer = tmp;
                            continue;
                        }
                        System.arraycopy(buffer, 0, contentBuffer, contentLen, readLen);
                        contentLen += readLen;
                        totalLen += readLen;
                    }
                }
                try {
                    if (fo != null) {
                        fo.close();
                    }
                }
                catch (Exception ee) {
                    ee.printStackTrace();
                }
                this.addParameter(String.valueOf(this.getTableName()) + "__sys_info", "\u6587\u4ef6\u4e0a\u4f20\u5904\u7406\u5b8c\u6bd5", parameters);
                this.addParameter(String.valueOf(this.getTableName()) + "__sys_state", "200", parameters);
            }
            catch (Exception e) {
                try {
                    if (fo != null) {
                        fo.close();
                    }
                }
                catch (Exception ee) {
                    ee.printStackTrace();
                }
                e.printStackTrace();
                this.addParameter(String.valueOf(this.getTableName()) + "__sys_info", "\u6587\u4ef6\u670d\u52a1\u5668\u51fa\u73b0\u672a\u77e5\u5f02\u5e38\uff0c\u8bf7\u4e0e\u7ba1\u7406\u5458\u8054\u7cfb", parameters);
                this.addParameter(String.valueOf(this.getTableName()) + "__sys_state", "500", parameters);
            }
        }
        if (listener != null) {
            listener.done();
        }
        EMPMultipartHttpServletRequest multiRequest = new EMPMultipartHttpServletRequest(request, parameters, fileMap);
        return multiRequest;
    }

    public LineInfo readLine(byte[] buf, InputStream is) throws IOException {
        boolean isLine = false;
        int maxLen = buf.length;
        boolean lineLength = false;
        int off = 0;
        do {
            int chr = 0;
            chr = is.read();
            if (chr == 10) {
                buf[off++] = (byte)chr;
                isLine = true;
                break;
            }
            if (chr == -1) break;
            buf[off++] = (byte)chr;
        } while (off < maxLen);
        LineInfo lInfo = new LineInfo();
        lInfo.isLine = isLine;
        lInfo.len = off;
        lInfo.lineBuf = buf;
        return lInfo;
    }

    private void writeToFile(FileOutputStream fo, byte[] content, int len) throws Exception {
        fo.write(content, 0, len);
        fo.flush();
    }

    private FileOutputStream openFileForWrite(String fileName) throws Exception {
        return new FileOutputStream(fileName);
    }

    protected void addParameter(String key, String value, Map hParams) {
        EMPLog.log((String)EMPConstance.EMP_MULTIPART, (int)EMPLog.DEBUG, (int)0, (String)("Add new parameter " + key + "=" + value));
        Object preValueObj = hParams.get(key);
        if (preValueObj == null) {
            hParams.put(key, new String[]{value});
        } else {
            int len = ((String[])preValueObj).length;
            String[] sArr = new String[len + 1];
            System.arraycopy((String[])preValueObj, 0, sArr, 0, len);
            sArr[len] = value.trim();
            hParams.put(key, sArr);
        }
    }

    protected String getParameter(String key, String defaultval, Map hParams) {
        String[] st_temp;
        String st_return = "";
        st_return = hParams.get(key) == null ? defaultval : ((st_temp = (String[])hParams.get(key))[0] != null ? st_temp[0] : defaultval);
        return st_return;
    }

    private synchronized String getFileName(String uploadFileName) {
        String tmp = uploadFileName.replace('\\', '/');
        int idx = tmp.lastIndexOf(47);
        if (idx != -1) {
            tmp = tmp.substring(idx + 1);
        }
        String fileName = null;
        fileName = !this.seperateViaDate ? String.valueOf(this.tempFileRootPath) + "/" + tmp : String.valueOf(this.tempFileRootPath) + "/" + this.getFolderByDate() + "/" + tmp;
        File file = new File(fileName);
        idx = 0;
        while (file.exists()) {
            fileName = !this.seperateViaDate ? String.valueOf(this.tempFileRootPath) + "/" + idx + "-" + tmp : String.valueOf(this.tempFileRootPath) + "/" + this.getFolderByDate() + "/" + idx + "-" + tmp;
            ++idx;
            file = new File(fileName);
        }
        return fileName;
    }

    private synchronized String[] getFileName(String orgNo, String docType, String docNo, String uploadFileName) {
        File upPath;
        String[] sta_return = new String[4];
        String fileName = uploadFileName.replace('\\', '/');
        String fileExt = "";
        String fileAllName = "";
        String filePath = "";
        String newPathlist = "";
        String rfilepath = "";
        int idx = fileName.lastIndexOf(47);
        if (idx != -1) {
            fileName = fileName.substring(idx + 1);
        }
        if (docNo != null && !docNo.trim().equals("")) {
            idx = fileName.lastIndexOf(46);
            fileExt = idx != -1 ? fileName.substring(idx) : "";
            fileName = String.valueOf(docNo) + fileExt;
        }
        EMPLog.log((String)EMPConstance.EMP_MULTIPART, (int)EMPLog.ERROR, (int)0, (String)"\u5f00\u59cb\u6784\u5efa\u76ee\u5f55\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002");
        filePath = this.tempFileRootPath;
        if (orgNo == null || orgNo.trim().equals("") || orgNo.length() < 2) {
            orgNo = "";
        } else {
            if (orgNo.length() >= 3) {
                orgNo = orgNo.substring(0, 3);
            } else {
                EMPLog.log((String)EMPConstance.EMP_MULTIPART, (int)EMPLog.ERROR, (int)0, (String)"\u673a\u6784\u7801\u592a\u77ed\uff0c\u4e0d\u80fd\u7528\u4e8e\u6784\u5efa\u76ee\u5f55");
            }
            upPath = new File(String.valueOf(this.tempFileRootPath) + "/" + orgNo + "/");
            filePath = String.valueOf(filePath) + "/" + orgNo;
            rfilepath = String.valueOf(rfilepath) + orgNo + "/";
            if (!upPath.exists()) {
                upPath.mkdir();
                this.setFilePermission(filePath);
                newPathlist = String.valueOf(newPathlist) + rfilepath + FILEPATHSPLIT;
            }
        }
        if (docType == null || docType.trim().equals("")) {
            docType = "";
        } else {
            upPath = new File(String.valueOf(this.tempFileRootPath) + "/" + orgNo + "/" + docType + "/");
            filePath = String.valueOf(filePath) + "/" + docType;
            rfilepath = String.valueOf(rfilepath) + docType + "/";
            if (!upPath.exists()) {
                upPath.mkdir();
                this.setFilePermission(filePath);
                newPathlist = String.valueOf(newPathlist) + rfilepath + FILEPATHSPLIT;
            }
        }
        filePath = String.valueOf(filePath) + "/" + this.getFolderByMonth();
        rfilepath = String.valueOf(rfilepath) + this.getFolderByMonth() + "/";
        sta_return[0] = fileAllName = String.valueOf(filePath) + "/" + fileName;
        sta_return[2] = fileName;
        upPath = new File(String.valueOf(filePath) + "/");
        if (!upPath.exists()) {
            upPath.mkdir();
            this.setFilePermission(filePath);
            newPathlist = String.valueOf(newPathlist) + rfilepath + FILEPATHSPLIT;
        }
        if (docNo == null || docNo.trim().equals("")) {
            File file = new File(fileAllName);
            idx = 0;
            while (file.exists()) {
                fileAllName = String.valueOf(filePath) + "/" + idx + "-" + fileName;
                ++idx;
                file = new File(fileAllName);
            }
        }
        sta_return[1] = rfilepath;
        sta_return[3] = newPathlist;
        return sta_return;
    }

    private void setFilePermission(String path) {
    }

    private String getFolderByDate() {
        try {
            SimpleDateFormat dataFmt = new SimpleDateFormat(this.dateDirFormat);
            String date = dataFmt.format(new Date());
            return date;
        }
        catch (Exception exception) {
            return "";
        }
    }

    private String getFolderByMonth(String rootPath) {
        try {
            SimpleDateFormat dataFmt = new SimpleDateFormat(this.dateDirFormat);
            String date = dataFmt.format(new Date());
            date = date.substring(0, 7);
            File rPath = new File(String.valueOf(rootPath) + "/" + date);
            if (!rPath.exists()) {
                rPath.mkdir();
            }
            return date;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    private String getFolderByMonth() {
        SimpleDateFormat dataFmt = new SimpleDateFormat(this.dateDirFormat);
        String date = dataFmt.format(new Date());
        date = date.substring(0, 7);
        return date;
    }

    public void cleanup(MultipartHttpServletRequest request) {
    }

    private void deleteTempFile(String rpath, String upfile) {
        String filename = String.valueOf(this.tempFileRootPath) + "/" + rpath + "/" + upfile;
        EMPLog.log((String)EMPConstance.EMP_MULTIPART, (int)EMPLog.DEBUG, (int)0, (String)("\u5220\u9664\u5e94\u7528\u670d\u52a1\u5668\u4e2d\u7684\u4e34\u65f6\u6587\u4ef6:" + filename));
        File delFile = new File(filename);
        delFile.delete();
    }

    public void setDateDirFormat(String dateDirFormat) {
        this.dateDirFormat = dateDirFormat;
    }

    public void setSeperateViaDate(boolean seperateViaDate) {
        this.seperateViaDate = seperateViaDate;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    private class LineInfo {
        byte[] lineBuf;
        int len;
        boolean isLine = false;

        private LineInfo() {
        }
    }
}

