/*
 * Decompiled with CFR 0.152.
 */
package com.yucheng.cmis.pub.msg;

import com.yucheng.cmis.pub.msg.CMISMessageLoader;
import com.yucheng.cmis.pub.msg.domain.SMsg;

public class CMISMessage {
    public static String MessageLevelError = "ERROR";
    public static String MessageLevelWarn = "WARN";
    public static String MessageLevelInfo = "INFO";
    public static String MessageStatusInvalid = "I";
    public static String MessageStatusActive = "A";

    public static String getMessage(String code) {
        return CMISMessage.getMessage(code, null);
    }

    public static String getMessage(String code, String[] param) {
        SMsg msgCfgInfo = CMISMessageLoader.getMessageCfgPool().get(code);
        if (msgCfgInfo == null) {
            return "";
        }
        String msg = msgCfgInfo.getMsgDesc();
        if (param != null && param.length > 0 && msg != null) {
            int n = 0;
            while (n < param.length) {
                String _p = param[n];
                msg = msg.replaceAll("\\{" + n + "\\}", _p);
                ++n;
            }
        }
        return String.valueOf(code) + " : " + msg;
    }

    public static boolean isNeed(String code) {
        SMsg msgCfgInfo = CMISMessageLoader.getMessageCfgPool().get(code);
        return CMISMessage.isNeed(msgCfgInfo);
    }

    public static boolean isNeed(SMsg msgCfgInfo) {
        if (msgCfgInfo == null || msgCfgInfo.getMsgSts() == null) {
            return false;
        }
        return !msgCfgInfo.getMsgSts().trim().equals(MessageStatusInvalid);
    }
}

