/*
 * Decompiled with CFR 0.152.
 */
package com.yucheng.cmis.pub.sequence;

import com.ecc.emp.core.Context;
import com.ecc.emp.core.EMPConstance;
import com.ecc.emp.core.EMPException;
import com.ecc.emp.log.EMPLog;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.DataSource;

public class CMISSequenceService4JXXD {
    private static String defaultOwner = "0000";
    private static final String OPENDAY = "OPENDAY";

    protected static Connection getConnection(Context context) throws EMPException {
        DataSource dataSource = (DataSource)context.getService("dataSource");
        if (dataSource == null) {
            throw new EMPException("\u83b7\u53d6\u6570\u636e\u5e93\u8fde\u63a5!");
        }
        Connection connection = null;
        try {
            connection = dataSource.getConnection();
        }
        catch (SQLException e) {
            throw new EMPException((Throwable)e);
        }
        EMPLog.log((String)EMPConstance.EMP_TRANSACTION, (int)EMPLog.INFO, (int)0, (String)("Apply new connection from data source: " + dataSource + " success!"));
        return connection;
    }

    protected static void releaseConnection(Connection connection) throws EMPException {
        try {
            connection.close();
        }
        catch (SQLException e) {
            throw new EMPException((Throwable)e);
        }
    }

    public static String querySequenceFromDB(String aType, String owner, Connection connection, Context context) throws EMPException {
        String string;
        String sqlStr = null;
        Connection conn = CMISSequenceService4JXXD.getConnection(context);
        PreparedStatement state = null;
        String cur_sernum = null;
        String initcycle = null;
        String zero_flg = null;
        String serStyle = null;
        String org = "";
        try {
            org = context.getDataValue("organNo").toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        String date = context.getDataValue(OPENDAY).toString();
        ResultSet rs = null;
        try {
            String year_short = date.substring(2, 4);
            String year = date.substring(0, 4);
            String month = date.substring(5, 7);
            sqlStr = "select cur_sernum,initcycle,zero_flg,sequencestyle from s_autocode where atype=? and owner=?";
            state = conn.prepareStatement(sqlStr);
            state.setObject(1, aType);
            state.setObject(2, owner);
            rs = state.executeQuery();
            if (rs.next()) {
                cur_sernum = rs.getString(1);
                initcycle = rs.getString(2);
                zero_flg = rs.getString(3);
                serStyle = rs.getString(4);
            }
            CMISSequenceService4JXXD.closeResource(state, rs);
            if (cur_sernum != null && "1".equals(initcycle)) {
                sqlStr = "select cur_sernum from s_autocode where atype=? and owner=? for update";
                state = conn.prepareStatement(sqlStr);
                state.setObject(1, aType);
                state.setObject(2, owner);
                rs = state.executeQuery();
                if (rs.next()) {
                    cur_sernum = rs.getString(1);
                }
            } else {
                EMPLog.log((String)EMPConstance.EMP_CORE, (int)EMPLog.ERROR, (int)0, (String)("Can not found the sequence style for aType[" + aType + "] and owner[" + owner + "]"));
                throw new EMPException("Can not found the sequence number for aType[" + aType + "] and owner[" + owner + "]");
            }
            CMISSequenceService4JXXD.closeResource(state, rs);
            sqlStr = "update s_autocode set cur_sernum=? where  atype=? and owner=?";
            state = conn.prepareStatement(sqlStr);
            long num = Long.valueOf(cur_sernum);
            state.setObject(1, ++num);
            state.setObject(2, aType);
            state.setObject(3, owner);
            state.executeUpdate();
            CMISSequenceService4JXXD.closeResource(state, null);
            if (serStyle == null || "".equals(serStyle)) {
                EMPLog.log((String)EMPConstance.EMP_CORE, (int)EMPLog.ERROR, (int)0, (String)("Can not found the sequence style for aType[" + aType + "] and owner[" + owner + "]"));
                throw new EMPException("Can not found the sequence style for aType[" + aType + "] and owner[" + owner + "]");
            }
            cur_sernum = CMISSequenceService4JXXD.numFormatToSeq(Integer.parseInt(zero_flg), Integer.parseInt(cur_sernum));
            date = CMISSequenceService4JXXD.replace(date, "-", "");
            if (org == null || "".equals(org)) {
                org = "9350000000";
            }
            org = org.substring(org.length() - 5, org.length());
            serStyle = CMISSequenceService4JXXD.replace(serStyle, "$ORG$", org);
            serStyle = CMISSequenceService4JXXD.replace(serStyle, "$YEAR$", year);
            serStyle = CMISSequenceService4JXXD.replace(serStyle, "$MONTH$", month);
            serStyle = CMISSequenceService4JXXD.replace(serStyle, "$SER$", cur_sernum);
            serStyle = CMISSequenceService4JXXD.replace(serStyle, "$DATE$", date);
            serStyle = CMISSequenceService4JXXD.replace(serStyle, "$ORGAPP$", owner);
            serStyle = CMISSequenceService4JXXD.replace(serStyle, "${OWNER}", org);
            serStyle = CMISSequenceService4JXXD.replace(serStyle, "${CURYEAR_SHORT}", year_short);
            string = serStyle = CMISSequenceService4JXXD.replace(serStyle, "${1F}", cur_sernum);
        }
        catch (Exception e) {
            try {
                EMPLog.log((String)EMPConstance.EMP_CORE, (int)EMPLog.ERROR, (int)0, (String)("The CMISSequenceService4Oracle occur an error:" + e.getMessage()));
                throw new EMPException((Throwable)e);
            }
            catch (Throwable throwable) {
                CMISSequenceService4JXXD.closeResource(state, rs);
                if (conn != null) {
                    CMISSequenceService4JXXD.releaseConnection(conn);
                }
                throw throwable;
            }
        }
        CMISSequenceService4JXXD.closeResource(state, rs);
        if (conn != null) {
            CMISSequenceService4JXXD.releaseConnection(conn);
        }
        return string;
    }

    public static String querySequenceFromSQ(String aType, String owner, String org, Connection connection, Context context) throws EMPException {
        String string;
        String sqlStr = null;
        Connection conn = CMISSequenceService4JXXD.getConnection(context);
        PreparedStatement state = null;
        String cur_sernum = null;
        String initcycle = null;
        String zero_flg = null;
        String serStyle = null;
        String date = context.getDataValue(OPENDAY).toString();
        ResultSet rs = null;
        try {
            sqlStr = "select cur_sernum,initcycle,zero_flg,sequencestyle from s_autocode where atype=? and owner=?";
            state = conn.prepareStatement(sqlStr);
            state.setObject(1, aType);
            state.setObject(2, owner);
            rs = state.executeQuery();
            if (rs.next()) {
                cur_sernum = rs.getString(1);
                initcycle = rs.getString(2);
                zero_flg = rs.getString(3);
                serStyle = rs.getString(4);
            }
            CMISSequenceService4JXXD.closeResource(state, rs);
            if (cur_sernum != null && "1".equals(initcycle)) {
                sqlStr = "select cur_sernum from s_autocode where atype=? and owner=? for update";
                state = conn.prepareStatement(sqlStr);
                state.setObject(1, aType);
                state.setObject(2, owner);
                rs = state.executeQuery();
                if (rs.next()) {
                    cur_sernum = rs.getString(1);
                }
            } else {
                EMPLog.log((String)EMPConstance.EMP_CORE, (int)EMPLog.ERROR, (int)0, (String)("Can not found the sequence style for aType[" + aType + "] and owner[" + owner + "]"));
                throw new EMPException("Can not found the sequence number for aType[" + aType + "] and owner[" + owner + "]");
            }
            CMISSequenceService4JXXD.closeResource(state, rs);
            sqlStr = "update s_autocode set cur_sernum=? where  atype=? and owner=?";
            state = conn.prepareStatement(sqlStr);
            long num = Long.valueOf(cur_sernum);
            state.setObject(1, ++num);
            state.setObject(2, aType);
            state.setObject(3, owner);
            state.executeUpdate();
            CMISSequenceService4JXXD.closeResource(state, null);
            if (serStyle == null || "".equals(serStyle)) {
                EMPLog.log((String)EMPConstance.EMP_CORE, (int)EMPLog.ERROR, (int)0, (String)("Can not found the sequence style for aType[" + aType + "] and owner[" + owner + "]"));
                throw new EMPException("Can not found the sequence style for aType[" + aType + "] and owner[" + owner + "]");
            }
            cur_sernum = CMISSequenceService4JXXD.numFormatToSeq(Integer.parseInt(zero_flg), Integer.parseInt(cur_sernum));
            date = CMISSequenceService4JXXD.replace(date, "-", "");
            org = org.substring(org.length() - 6, org.length());
            serStyle = CMISSequenceService4JXXD.replace(serStyle, "$ORG$", org);
            serStyle = CMISSequenceService4JXXD.replace(serStyle, "$SER$", cur_sernum);
            string = serStyle = CMISSequenceService4JXXD.replace(serStyle, "$DATE$", date);
        }
        catch (Exception e) {
            try {
                EMPLog.log((String)EMPConstance.EMP_CORE, (int)EMPLog.ERROR, (int)0, (String)("The CMISSequenceService4Oracle occur an error:" + e.getMessage()));
                throw new EMPException((Throwable)e);
            }
            catch (Throwable throwable) {
                CMISSequenceService4JXXD.closeResource(state, rs);
                if (conn != null) {
                    CMISSequenceService4JXXD.releaseConnection(conn);
                }
                throw throwable;
            }
        }
        CMISSequenceService4JXXD.closeResource(state, rs);
        if (conn != null) {
            CMISSequenceService4JXXD.releaseConnection(conn);
        }
        return string;
    }

    public static String querySequenceFromED(String aType, String owner, Connection connection, Context context) throws EMPException {
        String string;
        String sqlStr = null;
        Connection conn = CMISSequenceService4JXXD.getConnection(context);
        PreparedStatement state = null;
        String cur_sernum = null;
        String initcycle = null;
        String zero_flg = null;
        String serStyle = null;
        String date = context.getDataValue(OPENDAY).toString();
        ResultSet rs = null;
        try {
            sqlStr = "select cur_sernum,initcycle,zero_flg,sequencestyle from s_autocode where atype=? and owner=?";
            state = conn.prepareStatement(sqlStr);
            state.setObject(1, aType);
            state.setObject(2, owner);
            rs = state.executeQuery();
            if (rs.next()) {
                cur_sernum = rs.getString(1);
                initcycle = rs.getString(2);
                zero_flg = rs.getString(3);
                serStyle = rs.getString(4);
            }
            CMISSequenceService4JXXD.closeResource(state, rs);
            if (cur_sernum != null && "1".equals(initcycle)) {
                sqlStr = "select cur_sernum from s_autocode where atype=? and owner=? for update";
                state = conn.prepareStatement(sqlStr);
                state.setObject(1, aType);
                state.setObject(2, owner);
                rs = state.executeQuery();
                if (rs.next()) {
                    cur_sernum = rs.getString(1);
                }
            } else {
                EMPLog.log((String)EMPConstance.EMP_CORE, (int)EMPLog.ERROR, (int)0, (String)("Can not found the sequence style for aType[" + aType + "] and owner[" + owner + "]"));
                throw new EMPException("Can not found the sequence number for aType[" + aType + "] and owner[" + owner + "]");
            }
            CMISSequenceService4JXXD.closeResource(state, rs);
            sqlStr = "update s_autocode set cur_sernum=? where  atype=? and owner=?";
            state = conn.prepareStatement(sqlStr);
            long num = Long.valueOf(cur_sernum);
            state.setObject(1, ++num);
            state.setObject(2, aType);
            state.setObject(3, owner);
            state.executeUpdate();
            CMISSequenceService4JXXD.closeResource(state, null);
            if (serStyle == null || "".equals(serStyle)) {
                EMPLog.log((String)EMPConstance.EMP_CORE, (int)EMPLog.ERROR, (int)0, (String)("Can not found the sequence style for aType[" + aType + "] and owner[" + owner + "]"));
                throw new EMPException("Can not found the sequence style for aType[" + aType + "] and owner[" + owner + "]");
            }
            cur_sernum = CMISSequenceService4JXXD.numFormatToSeq(Integer.parseInt(zero_flg), Integer.parseInt(cur_sernum));
            date = CMISSequenceService4JXXD.replace(date, "-", "");
            serStyle = CMISSequenceService4JXXD.replace(serStyle, "$SER$", cur_sernum);
            string = serStyle = CMISSequenceService4JXXD.replace(serStyle, "$DATE$", date);
        }
        catch (Exception e) {
            try {
                EMPLog.log((String)EMPConstance.EMP_CORE, (int)EMPLog.ERROR, (int)0, (String)("The CMISSequenceService4Oracle occur an error:" + e.getMessage()));
                throw new EMPException((Throwable)e);
            }
            catch (Throwable throwable) {
                CMISSequenceService4JXXD.closeResource(state, rs);
                if (conn != null) {
                    CMISSequenceService4JXXD.releaseConnection(conn);
                }
                throw throwable;
            }
        }
        CMISSequenceService4JXXD.closeResource(state, rs);
        if (conn != null) {
            CMISSequenceService4JXXD.releaseConnection(conn);
        }
        return string;
    }

    public static String querySequenceFromDB(String aType, String owner, String dbfs, Connection connection, Context context) throws EMPException {
        String string;
        String sqlStr = null;
        Connection conn = CMISSequenceService4JXXD.getConnection(context);
        PreparedStatement state = null;
        String cur_sernum = null;
        String initcycle = null;
        String zero_flg = null;
        String serStyle = null;
        String org = "";
        try {
            org = context.getDataValue("organNo").toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        String date = context.getDataValue(OPENDAY).toString();
        ResultSet rs = null;
        try {
            String year = date.substring(0, 4);
            String month = date.substring(5, 7);
            sqlStr = "select cur_sernum,initcycle,zero_flg,sequencestyle from s_autocode where atype=? and owner=?";
            state = conn.prepareStatement(sqlStr);
            state.setObject(1, aType);
            state.setObject(2, owner);
            rs = state.executeQuery();
            if (rs.next()) {
                cur_sernum = rs.getString(1);
                initcycle = rs.getString(2);
                zero_flg = rs.getString(3);
                serStyle = rs.getString(4);
            }
            CMISSequenceService4JXXD.closeResource(state, rs);
            if (cur_sernum != null && "1".equals(initcycle)) {
                sqlStr = "select cur_sernum from s_autocode where atype=? and owner=? for update";
                state = conn.prepareStatement(sqlStr);
                state.setObject(1, aType);
                state.setObject(2, owner);
                rs = state.executeQuery();
                if (rs.next()) {
                    cur_sernum = rs.getString(1);
                }
            } else {
                EMPLog.log((String)EMPConstance.EMP_CORE, (int)EMPLog.ERROR, (int)0, (String)("Can not found the sequence style for aType[" + aType + "] and owner[" + owner + "]"));
                throw new EMPException("Can not found the sequence number for aType[" + aType + "] and owner[" + owner + "]");
            }
            CMISSequenceService4JXXD.closeResource(state, rs);
            sqlStr = "update s_autocode set cur_sernum=? where  atype=? and owner=?";
            state = conn.prepareStatement(sqlStr);
            long num = Long.valueOf(cur_sernum);
            state.setObject(1, ++num);
            state.setObject(2, aType);
            state.setObject(3, owner);
            state.executeUpdate();
            CMISSequenceService4JXXD.closeResource(state, null);
            if (serStyle == null || "".equals(serStyle)) {
                EMPLog.log((String)EMPConstance.EMP_CORE, (int)EMPLog.ERROR, (int)0, (String)("Can not found the sequence style for aType[" + aType + "] and owner[" + owner + "]"));
                throw new EMPException("Can not found the sequence style for aType[" + aType + "] and owner[" + owner + "]");
            }
            cur_sernum = CMISSequenceService4JXXD.numFormatToSeq(Integer.parseInt(zero_flg), Integer.parseInt(cur_sernum));
            date = CMISSequenceService4JXXD.replace(date, "-", "");
            serStyle = CMISSequenceService4JXXD.replace(serStyle, "$ORG$", org);
            serStyle = CMISSequenceService4JXXD.replace(serStyle, "$YEAR$", year);
            serStyle = CMISSequenceService4JXXD.replace(serStyle, "$MONTH$", month);
            serStyle = CMISSequenceService4JXXD.replace(serStyle, "$SER$", cur_sernum);
            serStyle = CMISSequenceService4JXXD.replace(serStyle, "$DATE$", date);
            serStyle = CMISSequenceService4JXXD.replace(serStyle, "$ORGAPP$", owner);
            string = serStyle = CMISSequenceService4JXXD.replace(serStyle, "$DBFS$", dbfs);
        }
        catch (Exception e) {
            try {
                EMPLog.log((String)EMPConstance.EMP_CORE, (int)EMPLog.ERROR, (int)0, (String)("The CMISSequenceService4Oracle occur an error:" + e.getMessage()));
                throw new EMPException((Throwable)e);
            }
            catch (Throwable throwable) {
                CMISSequenceService4JXXD.closeResource(state, rs);
                if (conn != null) {
                    CMISSequenceService4JXXD.releaseConnection(conn);
                }
                throw throwable;
            }
        }
        CMISSequenceService4JXXD.closeResource(state, rs);
        if (conn != null) {
            CMISSequenceService4JXXD.releaseConnection(conn);
        }
        return string;
    }

    private static void closeResource(PreparedStatement stmt, ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public String getDefaultOwner() {
        return defaultOwner;
    }

    public void setDefaultOwner(String defaultOwner1) {
        defaultOwner = defaultOwner1;
    }

    public static String numFormatToSeq(int len, int value) {
        if (len <= 0) {
            return "";
        }
        StringBuffer seq = new StringBuffer();
        int i = 0;
        while (i < len) {
            seq.append('0');
            ++i;
        }
        seq.append(value);
        return seq.substring(seq.length() - len);
    }

    private static String replace(String strSource, String strFrom, String strTo) {
        if (strSource == null) {
            return null;
        }
        int i = 0;
        if ((i = strSource.indexOf(strFrom, i)) >= 0) {
            char[] cSrc = strSource.toCharArray();
            char[] cTo = strTo.toCharArray();
            int len = strFrom.length();
            StringBuffer buf = new StringBuffer(cSrc.length);
            buf.append(cSrc, 0, i).append(cTo);
            int j = i += len;
            while ((i = strSource.indexOf(strFrom, i)) > 0) {
                buf.append(cSrc, j, i - j).append(cTo);
                j = i += len;
            }
            buf.append(cSrc, j, cSrc.length - j);
            return buf.toString();
        }
        return strSource;
    }
}

