/*
 * Decompiled with CFR 0.152.
 */
package com.yucheng.cmis.view;

import com.ecc.emp.core.Context;
import com.ecc.emp.core.EMPConstance;
import com.ecc.emp.data.DataElement;
import com.ecc.emp.data.DataField;
import com.ecc.emp.data.KeyedCollection;
import com.ecc.emp.log.EMPLog;
import com.ecc.emp.web.servlet.view.AbstractView;
import com.yucheng.cmis.pub.CMISDomain;
import com.yucheng.cmis.util.CMISJSONUtil;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class JQueryJSONTreeView
extends AbstractView {
    private KeyedCollection output;

    public void render(Map model, HttpServletRequest request, HttpServletResponse response, String jspRootPath) {
        try {
            Context context = (Context)model.get(EMPConstance.ATTR_CONTEXT);
            KeyedCollection outputKColl = this.output;
            if (outputKColl == null) {
                outputKColl = (KeyedCollection)context.getDataElement();
            }
            StringBuffer buffer = new StringBuffer();
            Object[] dataNames = outputKColl.keySet().toArray();
            int i = 0;
            while (i < dataNames.length) {
                DataElement dataElement;
                String dataName = dataNames[i].toString();
                if ("rows".equalsIgnoreCase(dataName) && (dataElement = outputKColl.getDataElement(dataName)) instanceof DataField) {
                    DataField field = (DataField)context.getDataElement(dataElement.getName());
                    this.getDataFieldJson(field, buffer);
                }
                ++i;
            }
            System.out.println(buffer.toString());
            response.addHeader("Cache-Control", "no-cache");
            response.getOutputStream().write(buffer.toString().getBytes("UTF-8"));
        }
        catch (Exception e) {
            EMPLog.log((String)EMPConstance.EMP_MVC, (int)EMPLog.ERROR, (int)0, (String)"Failed to return the jsonView!", (Throwable)e);
        }
    }

    public void getDataFieldJson(DataField field, StringBuffer buffer) throws Exception {
        Object value = field.getValue();
        if (value != null) {
            String className = value.getClass().getName();
            if (JQueryJSONTreeView.isBasicDataType(className)) {
                buffer.append("\"" + CMISJSONUtil.normalizeString(value.toString()) + "\"");
            } else if (value instanceof List) {
                List objectList = (List)value;
                buffer.append("[");
                if (objectList != null && objectList.size() > 0) {
                    int i = 0;
                    while (i < objectList.size()) {
                        Object dataField = objectList.get(i);
                        if (dataField instanceof CMISDomain) {
                            buffer.append("{");
                            CMISDomain dd = (CMISDomain)dataField;
                            Object[] names = dd.getDataMap().keySet().toArray();
                            int k = 0;
                            while (k < names.length) {
                                String name = names[k].toString();
                                Object fieldValue = dd.getDataMap().get(name);
                                buffer.append("\"" + name + "\":");
                                if (fieldValue != null) {
                                    buffer.append("\"" + CMISJSONUtil.normalizeString(fieldValue.toString()) + "\"");
                                } else {
                                    buffer.append("\"\"");
                                }
                                if (k < names.length - 1) {
                                    buffer.append(",");
                                }
                                ++k;
                            }
                            buffer.append("}");
                            if (i < objectList.size() - 1) {
                                buffer.append(",");
                            }
                        }
                        ++i;
                    }
                }
                buffer.append("]");
            } else if (value instanceof CMISDomain) {
                buffer.append("{");
                CMISDomain dd = (CMISDomain)value;
                Object[] names = dd.getDataMap().keySet().toArray();
                int k = 0;
                while (k < names.length) {
                    String name = names[k].toString();
                    Object fieldValue = dd.getDataMap().get(name);
                    buffer.append("\"" + name + "\":");
                    if (fieldValue != null) {
                        buffer.append("\"" + CMISJSONUtil.normalizeString(fieldValue.toString()) + "\"");
                    } else {
                        buffer.append("\"\"");
                    }
                    if (k < names.length - 1) {
                        buffer.append(",");
                    }
                    ++k;
                }
                buffer.append("}");
            }
        } else {
            buffer.append("\"\"");
        }
    }

    private static boolean isBasicDataType(String Classname) {
        return Classname.equals("java.lang.Double") || Classname.equals("java.lang.Integer") || Classname.equals("java.lang.Float") || Classname.equals("java.lang.String") || Classname.equals("java.math.BigDecimal") || Classname.equals("java.lang.Boolean");
    }

    public KeyedCollection getOutput() {
        return this.output;
    }

    public void setOutput(KeyedCollection output) {
        this.output = output;
    }
}

