/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.emp.ide.biz.debug;

import com.ecc.emp.data.DataElement;
import com.ecc.emp.data.DataElementSerializer;
import com.ecc.emp.data.DataField;
import com.ecc.emp.data.IndexedCollection;
import com.ecc.emp.data.KeyedCollection;
import com.ecc.emp.ide.biz.debug.DebugBizInfo;
import com.ecc.ide.base.IDEContent;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.emp.propertyeditor.ImplClassSelectEditor;
import com.ecc.ide.plugin.ECCIDEPlugin;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Properties;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;

public class BizDebugPage
extends WizardPage {
    private Text text_2;
    private Combo combo;
    private Tree tree;
    private Text text_1;
    private Text text;
    private IFile bizFile;
    private XMLNode bizNode;
    private Vector ops = new Vector();
    private TreeViewer treeViewer;
    private String testClassName;

    public BizDebugPage(IFile bizFile, String testClassName) {
        super("wizardPage");
        this.bizFile = bizFile;
        this.testClassName = testClassName;
        this.setTitle("EMP Application");
        this.setDescription("\u4e1a\u52a1\u6784\u4ef6\u6d4b\u8bd5");
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout());
        this.setControl((Control)container);
        Composite composite = new Composite(container, 0);
        composite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        GridLayout gridLayout = new GridLayout();
        gridLayout.makeColumnsEqualWidth = true;
        gridLayout.numColumns = 4;
        composite.setLayout((Layout)gridLayout);
        Label label_3 = new Label(composite, 0);
        label_3.setText("\u6d4b\u8bd5\u7c7b");
        this.text_2 = new Text(composite, 2048);
        this.text_2.setEnabled(false);
        this.text_2.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        Button button = new Button(composite, 0);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BizDebugPage.this.selectClass();
            }
        });
        button.setText("\u9009\u62e9");
        Label label = new Label(composite, 0);
        label.setLayoutData((Object)new GridData());
        label.setText("\u6784\u4ef6ID");
        this.text = new Text(composite, 2048);
        this.text.setEnabled(false);
        this.text.setLayoutData((Object)new GridData());
        Label label_1 = new Label(composite, 0);
        label_1.setLayoutData((Object)new GridData());
        label_1.setText("\u6784\u4ef6\u540d\u79f0");
        this.text_1 = new Text(composite, 2048);
        this.text_1.setEnabled(false);
        this.text_1.setLayoutData((Object)new GridData());
        Group group = new Group(container, 0);
        GridLayout gridLayout_1 = new GridLayout();
        group.setLayout((Layout)gridLayout_1);
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite composite_1 = new Composite((Composite)group, 0);
        composite_1.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        composite_1.setLayout((Layout)new FillLayout());
        Label label_2 = new Label(composite_1, 0);
        label_2.setText("\u4e1a\u52a1\u903b\u8f91");
        this.combo = new Combo(composite_1, 8);
        this.combo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BizDebugPage.this.selectOp();
            }
        });
        Composite composite_2 = new Composite((Composite)group, 0);
        composite_2.setLayoutData((Object)new GridData(4, 4, true, true));
        composite_2.setLayout((Layout)new FillLayout());
        this.treeViewer = new TreeViewer(composite_2, 67584);
        this.tree = this.treeViewer.getTree();
        this.tree.setHeaderVisible(true);
        this.tree.setLinesVisible(true);
        this.tree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                BizDebugPage.this.editField();
            }
        });
        TreeColumn idColumn = new TreeColumn(this.tree, 0);
        idColumn.setWidth(100);
        idColumn.setText("\u8f93\u5165\u6570\u636eID");
        TreeColumn valueColumn = new TreeColumn(this.tree, 0);
        valueColumn.setWidth(100);
        valueColumn.setText("\u6d4b\u8bd5\u503c");
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new NodeLabelProvider());
        this.treeViewer.setContentProvider((IContentProvider)new NodeContentProvider());
        this.init();
    }

    private void selectClass() {
        String str = ImplClassSelectEditor.selectClass(this.bizFile.getProject(), "com.ecc.emp.ide.biz.debug.EMPDebugger", this.getShell());
        this.text_2.setText(str);
    }

    private void init() {
        this.bizNode = IDEContent.loadXMLContent(this.bizFile);
        if (this.bizNode == null) {
            return;
        }
        this.text.setText(this.bizNode.getAttrValue("trxCode"));
        this.text_1.setText(this.bizNode.getAttrValue("trxName"));
        int i = 0;
        while (i < this.bizNode.getChilds().size()) {
            XMLNode child = (XMLNode)this.bizNode.getChilds().elementAt(i);
            if ("operation".equals(child.getNodeName())) {
                this.ops.add(child);
            }
            ++i;
        }
        String[] opsName = new String[this.ops.size()];
        int i2 = 0;
        while (i2 < this.ops.size()) {
            XMLNode child = (XMLNode)this.ops.elementAt(i2);
            opsName[i2] = child.getAttrValue("id");
            ++i2;
        }
        this.combo.setItems(opsName);
        if (this.ops.size() > 0) {
            this.combo.setText(opsName[0]);
            this.selectOp();
        }
        try {
            this.text_2.setText(this.testClassName);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private KeyedCollection getInputKColl(XMLNode defineNode, String savedDatas) {
        KeyedCollection resultKColl = new KeyedCollection("input");
        if (defineNode == null) {
            return resultKColl;
        }
        KeyedCollection refKColl = null;
        try {
            refKColl = (KeyedCollection)DataElementSerializer.serializeFrom((String)savedDatas);
        }
        catch (Exception exception) {
            // empty catch block
        }
        int i = 0;
        while (i < defineNode.getChilds().size()) {
            XMLNode child = (XMLNode)defineNode.getChilds().elementAt(i);
            if ("refData".equals(child.getNodeName())) {
                DataField field = new DataField(child.getAttrValue("refId"));
                try {
                    Object value;
                    if (refKColl != null && (value = refKColl.getDataValue(child.getAttrValue("refId"))) != null) {
                        field.setValue(value);
                    }
                    resultKColl.addDataElement((DataElement)field);
                }
                catch (Exception value) {
                    // empty catch block
                }
            }
            if ("refColl".equals(child.getNodeName())) {
                if (refKColl != null && refKColl.get((Object)child.getAttrValue("refId")) != null && refKColl.get((Object)child.getAttrValue("refId")) instanceof IndexedCollection) {
                    try {
                        resultKColl.addIndexedCollection((IndexedCollection)refKColl.get((Object)child.getAttrValue("refId")));
                    }
                    catch (Exception field) {}
                } else {
                    IndexedCollection icoll = new IndexedCollection(child.getAttrValue("refId"));
                    KeyedCollection kcoll = new KeyedCollection();
                    icoll.add((Object)kcoll);
                    int w = 0;
                    while (w < child.getChilds().size()) {
                        XMLNode childchild = (XMLNode)child.getChilds().elementAt(w);
                        if ("refData".equals(childchild.getNodeName())) {
                            DataField field = new DataField(childchild.getAttrValue("refId"));
                            try {
                                try {
                                    Object value;
                                    if (refKColl != null && (value = refKColl.getDataValue(childchild.getAttrValue("refId"))) != null) {
                                        field.setValue(value);
                                    }
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                kcoll.addDataElement((DataElement)field);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        ++w;
                    }
                    try {
                        resultKColl.addIndexedCollection(icoll);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            ++i;
        }
        return resultKColl;
    }

    private void selectOp() {
        String opId = this.combo.getText();
        int i = 0;
        while (i < this.ops.size()) {
            XMLNode node = (XMLNode)this.ops.elementAt(i);
            if (opId.equals(node.getAttrValue("id"))) {
                XMLNode defineNode = node.getChild("input");
                String savedDatas = this.getSavedInputData(this.bizFile, opId);
                KeyedCollection kcoll = this.getInputKColl(defineNode, savedDatas);
                this.treeViewer.setInput((Object)kcoll);
                return;
            }
            ++i;
        }
    }

    private void editField() {
        StructuredSelection select = (StructuredSelection)this.treeViewer.getSelection();
        Object object = select.getFirstElement();
        if (object instanceof DataField) {
            DataField field = (DataField)object;
            String str = "";
            try {
                str = (String)field.getValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
            InputDialog dia = new InputDialog(this.getShell(), "\u8bbe\u5b9a\u6d4b\u8bd5\u503c", field.getName(), str, null);
            if (dia.open() == 0) {
                field.setValue(dia.getValue());
                this.treeViewer.refresh();
            }
        }
        boolean cfr_ignored_0 = object instanceof KeyedCollection;
    }

    public DebugBizInfo getDebugBizInfo() {
        DebugBizInfo info = new DebugBizInfo();
        info.bizId = this.text.getText();
        info.opId = this.combo.getText();
        info.testClassName = this.text_2.getText();
        KeyedCollection kcoll = (KeyedCollection)this.treeViewer.getInput();
        info.inputDatas = DataElementSerializer.doSerialize((DataElement)kcoll);
        try {
            DataElementSerializer.serializeFrom((String)info.inputDatas);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.saveInputData(this.bizFile, info.opId, info.inputDatas);
        return info;
    }

    private String getTempPath() {
        String str = String.valueOf(this.bizFile.getProject().getLocation().toOSString()) + "\\designFiles\\.debug\\bizs\\";
        File folder = new File(str);
        if (!folder.exists()) {
            folder.mkdirs();
        }
        return str;
    }

    public String getSavedInputData(IFile bizfile, String opId) {
        try {
            Properties properties = new Properties();
            File propertyFile = new File(String.valueOf(this.getTempPath()) + "\\" + bizfile.getName() + ".properties");
            if (!propertyFile.exists()) {
                propertyFile.createNewFile();
            }
            properties.load(new FileInputStream(propertyFile));
            return properties.getProperty(opId);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private void saveInputData(IFile bizfile, String opId, String inputDatas) {
        try {
            Properties properties = new Properties();
            File propertyFile = new File(String.valueOf(this.getTempPath()) + "\\" + bizfile.getName() + ".properties");
            if (!propertyFile.exists()) {
                propertyFile.createNewFile();
            }
            properties.load(new FileInputStream(propertyFile));
            properties.setProperty(opId, inputDatas);
            FileOutputStream os = new FileOutputStream(propertyFile);
            properties.save(os, "");
            os.flush();
            os.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    class NodeContentProvider
    implements ITreeContentProvider {
        NodeContentProvider() {
        }

        public Object[] getChildren(Object obj) {
            return this.getElements(obj);
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof KeyedCollection) {
                return true;
            }
            return element instanceof IndexedCollection;
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof KeyedCollection) {
                return ((KeyedCollection)inputElement).values().toArray();
            }
            if (inputElement instanceof IndexedCollection) {
                Vector<Object> result = new Vector<Object>();
                IndexedCollection icoll = (IndexedCollection)inputElement;
                if (icoll.size() > 0) {
                    int i = 0;
                    while (i < icoll.size()) {
                        result.add(icoll.get(i));
                        ++i;
                    }
                } else {
                    result.add(icoll.getDataElement());
                }
                return result.toArray();
            }
            return null;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class NodeLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        NodeLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            block6: {
                if (columnIndex != 0 || !(element instanceof DataElement)) break block6;
                try {
                    return ((DataElement)element).getName();
                }
                catch (Exception e1) {
                    return "";
                }
            }
            try {
                if (columnIndex == 1 && element instanceof DataField) {
                    return ((DataField)element).getValue().toString();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return "";
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0) {
                return new Image(null, ECCIDEPlugin.getFile("/icons/page_white_gear.png"));
            }
            return null;
        }
    }
}

