/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.emp.ide.biz.debug;

import com.ecc.emp.component.factory.ComponentFactory;
import com.ecc.emp.component.factory.EMPFlowComponentFactory;
import com.ecc.emp.component.xml.ComponentParser;
import com.ecc.emp.component.xml.GeneralComponentParser;
import com.ecc.emp.core.Context;
import com.ecc.emp.core.EMPConstance;
import com.ecc.emp.core.EMPException;
import com.ecc.emp.data.DataElement;
import com.ecc.emp.data.DataField;
import com.ecc.emp.data.IndexedCollection;
import com.ecc.emp.data.KeyedCollection;
import com.ecc.emp.datatype.DataType;
import com.ecc.emp.datatype.InvalidDataException;
import com.ecc.emp.flow.EMPBusinessLogic;
import com.ecc.emp.flow.EMPFlow;
import com.ecc.emp.ide.biz.debug.BizDebuggerImpl;
import com.ecc.emp.log.EMPLog;
import com.ecc.util.formula.function.FunctionManager;
import java.util.Map;
import java.util.Properties;

public class DefaultBizDebuggerImpl
implements BizDebuggerImpl {
    public EMPFlowComponentFactory factory;
    static /* synthetic */ Class class$0;

    public void contextInitialized(Properties properties) throws Exception {
        String rootPath = properties.getProperty("rootPath");
        String logImplClass = properties.getProperty("logImplClass", "com.ecc.emp.log.EMPLog4jLog");
        String logSettingFile = properties.getProperty("logSettingFile");
        String factoryName = properties.getProperty("factoryName");
        String empIniFileName = properties.getProperty("empIniFileName", "WEB-INF/bizs/" + factoryName + "/settings.xml");
        String rootContextName = properties.getProperty("rootContextName", "rootCtx");
        String resourceFileName = properties.getProperty("resourceFileName", "WEB-INF/commons/resource.xml");
        String functionFileName = properties.getProperty("functionFileName", "WEB-INF/commons/function.xml");
        this.contextInitialized(rootPath, logImplClass, logSettingFile, factoryName, empIniFileName, rootContextName, resourceFileName, functionFileName);
    }

    public void contextInitialized(String rootPath, String logImplClass, String logSettingFile, String factoryName, String empIniFileName, String rootContextName, String resourceFileName, String functionFileName) {
        System.setProperty("ROOTPATH", rootPath);
        if (logSettingFile != null) {
            try {
                EMPLog.log((String)EMPConstance.EMP_CORE, (int)EMPLog.INFO, (int)0, (String)("Initialize emp log from:" + logSettingFile));
                EMPLog.init((String)logImplClass, (String)logSettingFile);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (factoryName != null && empIniFileName != null) {
            this.factory = new EMPFlowComponentFactory();
            EMPLog.log((String)EMPConstance.EMP_CORE, (int)EMPLog.INFO, (int)0, (String)("Initialize EMP Flow Context from " + empIniFileName));
            this.factory.setName(factoryName);
            this.factory.setRootContextName(rootContextName);
            this.factory.initializeComponentFactory(factoryName, String.valueOf(rootPath) + empIniFileName);
            try {
                Context rootContext = this.factory.getContextNamed(rootContextName);
            }
            catch (Exception e) {
                EMPLog.log((String)EMPConstance.EMP_CORE, (int)EMPLog.ERROR, (int)0, (String)"StartupListener Failed to get rootContext!", (Throwable)e);
            }
        }
        this.initializeFunctionDef(String.valueOf(rootPath) + "/" + functionFileName);
    }

    private void initializeFunctionDef(String fileName) {
        EMPLog.log((String)EMPConstance.EMP_CORE, (int)EMPLog.INFO, (int)0, (String)("Initialize Function define from " + fileName + " ..."));
        try {
            ComponentFactory factory = new ComponentFactory();
            GeneralComponentParser parser = new GeneralComponentParser();
            factory.setComponentParser((ComponentParser)parser);
            factory.initializeComponentFactory("functions", fileName);
            ComponentFactory.removeComponentFactory((String)"functions");
            FunctionManager manager = (FunctionManager)factory.getComponent("Functions");
            EMPLog.log((String)EMPConstance.EMP_CORE, (int)EMPLog.INFO, (int)0, (String)("Initialize Function define from " + fileName + " OK!"));
        }
        catch (Exception e) {
            EMPLog.log((String)EMPConstance.EMP_CORE, (int)EMPLog.ERROR, (int)0, (String)("Initialize Function define from " + fileName + " failed."), (Throwable)e);
        }
    }

    public KeyedCollection runBiz(String bizId, String opId, KeyedCollection input) throws Exception {
        EMPFlow biz = this.factory.getEMPFlow(bizId);
        Context context = (Context)biz.getContext().clone();
        try {
            KeyedCollection kColl = (KeyedCollection)((EMPBusinessLogic)biz).getInput(opId);
            DefaultBizDebuggerImpl.updateContextWithKeyedCollection(input, kColl, context, this.factory.getDataTypeDefine());
        }
        catch (Exception e) {
            EMPLog.log((String)EMPConstance.EMP_CORE, (int)EMPLog.ERROR, (int)0, (String)e.toString());
            e.printStackTrace();
        }
        biz.execute(context, opId);
        return (KeyedCollection)context.getDataElement();
    }

    private static void updateContextWithKeyedCollection(KeyedCollection inputKColl, KeyedCollection kColl, Context context, Map dataTypeDefs) throws EMPException {
        boolean haveInputException = false;
        Object[] keys = kColl.keySet().toArray();
        int i = 0;
        while (i < keys.length) {
            String name = (String)keys[i];
            DataElement field = kColl.getDataElement(name);
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("com.ecc.emp.data.IndexedCollection");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz.isAssignableFrom(field.getClass())) {
                IndexedCollection iColl = (IndexedCollection)field;
            } else {
                DataField dataField = (DataField)field;
                String dataName = field.getName();
                Object value = inputKColl.getValueAt(dataName);
                String dstFieldName = dataField.getName();
                DataField dstDataElement = (DataField)context.getDataElement(dstFieldName);
                if ((value == null || value == "") && dataField.isRequired()) {
                    haveInputException = true;
                    EMPLog.log((String)EMPConstance.EMP_MVC, (int)EMPLog.DEBUG, (int)0, (String)("Required field  " + dataName + "Not posted!"));
                } else {
                    String dataType = dstDataElement.getDataType();
                    if (dataType != null && value != null) {
                        try {
                            DataType dataTypeDef = (DataType)dataTypeDefs.get(dataType);
                            if (dataTypeDef == null) {
                                throw new EMPException("DataType named [" + dataType + "] not defined in update dataModel for data [" + dataName + "]!");
                            }
                            Object objValue = dataTypeDef.convertFromString(value.toString(), null);
                            context.setDataValue(dstFieldName, objValue);
                        }
                        catch (InvalidDataException e) {
                            haveInputException = true;
                            String msg = e.getMessage();
                            EMPLog.log((String)EMPConstance.EMP_MVC, (int)EMPLog.DEBUG, (int)0, (String)("Invalid dataValue DataField  " + dataName + " = " + value), (Throwable)e);
                        }
                    } else {
                        context.setDataValue(dstFieldName, value);
                    }
                    EMPLog.log((String)EMPConstance.EMP_MVC, (int)EMPLog.DEBUG, (int)0, (String)("Posted DataField  " + name + " = " + value));
                }
            }
            ++i;
        }
        if (haveInputException) {
            throw new EMPException("");
        }
    }
}

