/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.emp.ide.biz.debug;

import com.ecc.emp.core.EMPConstance;
import com.ecc.emp.data.DataElementSerializer;
import com.ecc.emp.data.KeyedCollection;
import com.ecc.emp.ide.biz.debug.BizDebuggerImpl;
import com.ecc.emp.log.EMPLog;
import java.io.File;
import java.io.FileInputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;

public class RunBizDebuger {
    private static String getTime() {
        Date date = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat("", Locale.SIMPLIFIED_CHINESE);
        formatter.applyPattern("yyyy\u5e74MM\u6708dd\u65e5HH\u65f6mm\u5206ss\u79d2");
        String time = formatter.format(date);
        return time;
    }

    public static void main(String[] args) {
        try {
            String argstr = "";
            argstr = String.valueOf(argstr) + "BIZ ID:" + args[1] + "\n";
            argstr = String.valueOf(argstr) + "OP  ID:" + args[1] + "\n";
            EMPLog.log((String)"UNITTEST", (int)EMPLog.INFO, (int)0, (String)("\n\n|-----------------------------------------------|\n|                Debug EMP BIZ                  |\n|-----------------------------------------------|\n" + RunBizDebuger.getTime() + "\n" + argstr));
            Properties properties = RunBizDebuger.getProperties(args[0]);
            BizDebuggerImpl start = null;
            String className = properties.getProperty("class");
            try {
                start = (BizDebuggerImpl)Class.forName(className).newInstance();
            }
            catch (Exception e) {
                EMPLog.log((String)"UNITTEST", (int)EMPLog.ERROR, (int)0, (String)("Class [" + className + "] instance exception!" + e.toString()));
            }
            start.contextInitialized(properties);
            String kcollstr = properties.getProperty("kcoll");
            KeyedCollection input = (KeyedCollection)DataElementSerializer.serializeFrom((String)kcollstr);
            EMPLog.log((String)"UNITTEST", (int)EMPLog.INFO, (int)0, (String)("Call :" + args[1] + "." + args[2] + "\nINPUT Datas:\n" + input.toString() + "\n"));
            KeyedCollection kcoll = start.runBiz(args[1], args[2], input);
            EMPLog.log((String)"UNITTEST", (int)EMPLog.INFO, (int)0, (String)("\nOUTPUT Datas:\n" + kcoll.toString() + "\n"));
        }
        catch (Exception e) {
            EMPLog.log((String)EMPConstance.EMP_CORE, (int)EMPLog.ERROR, (int)0, (String)e.toString());
            e.printStackTrace();
        }
        EMPLog.log((String)"UNITTEST", (int)EMPLog.INFO, (int)0, (String)("\n\n|-----------------------------------------------|\n|                Debug EMP BIZ FINISHED         |\n|-----------------------------------------------|\n" + RunBizDebuger.getTime() + "\n"));
    }

    public static Properties getProperties(String path) throws Exception {
        System.setProperty("logFile", String.valueOf(path) + "emp.log");
        File file = new File(String.valueOf(path) + "biz_run.properties");
        FileInputStream is = new FileInputStream(file);
        Properties properties = new Properties();
        properties.load(is);
        return properties;
    }
}

