/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.emp.ide.builder;

import com.ecc.ide.base.IDEConstance;
import com.ecc.ide.base.IDEContent;
import com.ecc.ide.base.IDEProfile;
import com.ecc.ide.builder.BuildProblemReporter;
import com.ecc.ide.builder.format.FormatGenerator;
import com.ecc.ide.classloader.DynamicClassLoader;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editorprofile.EditorProfile;
import com.ecc.ide.module.ModuleUtility;
import com.ecc.ide.plugin.properties.IDEProjectSettings;
import java.io.File;
import java.io.FileOutputStream;
import org.eclipse.core.resources.IProject;

public abstract class EMPBuilder {
    protected IProject project;
    protected BuildProblemReporter reporter;

    public abstract XMLNode compile(XMLNode var1, String var2) throws Exception;

    public EditorProfile getEditorProfile(int profileId) {
        try {
            return IDEProfile.getEditorProfile(this.project, profileId);
        }
        catch (Exception e) {
            return null;
        }
    }

    public final void saveXMLFile(IProject project, String fileName, XMLNode node, String id) throws Exception {
        this.project = project;
        node = this.compile(node, id);
        try {
            File file;
            String xmlEncoding = "GBK";
            IDEProjectSettings prjSettings = IDEContent.getPRJSettings(project);
            if (prjSettings.getSetXMLEncodeManually()) {
                xmlEncoding = prjSettings.getXMLEncoding();
            }
            if (!(file = new File(fileName)).exists()) {
                file.createNewFile();
            }
            StringBuffer strBuf = new StringBuffer();
            if (xmlEncoding != null) {
                node.setEncoding(xmlEncoding);
            }
            node.toXMLContent(0, strBuf, true);
            FileOutputStream fo = new FileOutputStream(fileName);
            if (xmlEncoding != null) {
                fo.write(strBuf.toString().getBytes(xmlEncoding));
            } else {
                fo.write(strBuf.toString().getBytes(IDEConstance.encoding));
            }
            fo.close();
        }
        catch (Exception e) {
            this.reporter.reportProblem(0, "", fileName, fileName, e);
        }
    }

    public XMLNode genPackageFmt(String headMsgID, XMLNode aNode) throws Exception {
        String pkgType = aNode.getAttrValue("packageType");
        if (pkgType == null) {
            return null;
        }
        XMLNode packageType = ModuleUtility.getPackageTypeNode(this.project);
        XMLNode pkgNode = packageType.findChildNode(pkgType);
        String fmtBuilderClass = pkgNode.getAttrValue("fmtGenClass");
        XMLNode dict = IDEContent.getSettingNode(this.project, 0);
        FormatGenerator fmtGen = null;
        try {
            fmtGen = (FormatGenerator)Class.forName(fmtBuilderClass).newInstance();
        }
        catch (ClassNotFoundException e) {
            fmtGen = (FormatGenerator)DynamicClassLoader.loadDynamicObject(this.project, fmtBuilderClass);
        }
        fmtGen.setMessageHeadID(headMsgID);
        XMLNode fmtNode = null;
        fmtNode = fmtGen.generateFormatNode(aNode, dict, this.project);
        return fmtNode;
    }

    public void setProblemReporter(BuildProblemReporter reporter) {
        this.reporter = reporter;
    }

    public void filterAttr(XMLNode source, String attrName) {
        try {
            source.setAttrValue(attrName, null);
            int i = 0;
            while (i < source.getChilds().size()) {
                XMLNode child = (XMLNode)source.getChilds().elementAt(i);
                this.filterAttr(child, attrName);
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

