/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.emp.ide.callbiz;

import com.ecc.emp.ide.callbiz.TreeDragListener;
import com.ecc.emp.ide.callbiz.TreeDropListener;
import com.ecc.ide.base.IDEContent;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.plugin.ECCIDEPlugin;
import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.views.navigator.LocalSelectionTransfer;

public class MapDataPanel
extends Composite {
    private Tree dataTableTree;
    private XMLNode dataDictionary;
    private XMLNode datasNode;
    private XMLNode tempNode;
    private XMLNode editNode;
    private DragSource source;
    private DropTarget target;
    private final TreeViewer treeViewer;
    private boolean showButton = true;
    private Button button;
    private boolean selfFlag = true;

    public MapDataPanel(Composite parent, int style, boolean selfFlag) {
        super(parent, style);
        this.selfFlag = selfFlag;
        GridLayout gridLayout = new GridLayout();
        this.setLayout((Layout)gridLayout);
        this.treeViewer = new TreeViewer((Composite)this, 67584);
        this.dataTableTree = this.treeViewer.getTree();
        this.dataTableTree.setLayoutData((Object)new GridData(4, 4, true, true));
        this.treeViewer.setContentProvider((IContentProvider)new TreeNodeContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new TreeNodeLabelProvider());
        this.dataTableTree.setHeaderVisible(true);
        this.dataTableTree.setLinesVisible(true);
        this.dataTableTree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MapDataPanel.this.isButtonShow();
            }
        });
        TreeColumn idColumn = new TreeColumn(this.dataTableTree, 0);
        idColumn.setWidth(150);
        if (selfFlag) {
            idColumn.setText("\u672c\u65b9Context");
        } else {
            idColumn.setText("\u5bf9\u65b9Context");
        }
        TreeColumn nameColumn = new TreeColumn(this.dataTableTree, 0);
        nameColumn.setWidth(100);
        nameColumn.setText("--->");
        TreeColumn mapColumn = new TreeColumn(this.dataTableTree, 0);
        mapColumn.setWidth(100);
        if (selfFlag) {
            mapColumn.setText("\u6620\u5c04\u5230\u5bf9\u65b9");
        } else {
            mapColumn.setText("\u6620\u5c04\u5230\u672c\u65b9");
        }
        this.button = new Button((Composite)this, 0);
        this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MapDataPanel.this.deleteMap();
            }
        });
        this.button.setText("\u5220\u9664\u6620\u5c04");
    }

    private void isButtonShow() {
        this.showButton = true;
        TreeItem[] items = this.dataTableTree.getSelection();
        if (items.length != 1) {
            return;
        }
        XMLNode node = (XMLNode)items[0].getData();
        if (node.getAttrValue("destName") == null) {
            this.showButton = false;
        }
        this.button.setEnabled(this.showButton);
    }

    public void setDatas(IProject project, XMLNode destBizNode, XMLNode editNode, String inf) {
        if (destBizNode == null) {
            return;
        }
        this.editNode = editNode;
        try {
            XMLNode node;
            this.dataDictionary = node = IDEContent.getSettingNode(project, 0);
            this.datasNode = destBizNode.getChild("datas");
            if (this.datasNode == null || this.datasNode.getChilds() == null) {
                return;
            }
            this.tempNode = this.composeNode(this.datasNode, editNode, inf);
            this.treeViewer.setInput((Object)this.tempNode);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private XMLNode composeNode(XMLNode datasNode, XMLNode editNode, String inf) {
        XMLNode cloneDatasNode = (XMLNode)datasNode.clone();
        try {
            int i = 0;
            while (i < cloneDatasNode.getChilds().size()) {
                XMLNode datasChild = (XMLNode)cloneDatasNode.getChilds().elementAt(i);
                String refIdValue = datasChild.getAttrValue("refId");
                XMLNode dictNode = this.dataDictionary.findChildNode(refIdValue);
                XMLNode cloneDictNode = null;
                if (dictNode != null && "dataCollection".equals(dictNode.getNodeName())) {
                    cloneDictNode = (XMLNode)dictNode.clone();
                }
                if (!"#text".equals(datasChild.getNodeName())) {
                    XMLNode inOutNode = editNode.getChild(inf);
                    if (inOutNode == null) {
                        inOutNode = new XMLNode(inf);
                        editNode.add(inOutNode);
                    }
                    int j = 0;
                    while (j < inOutNode.getChilds().size()) {
                        XMLNode inOutputChild = (XMLNode)inOutNode.getChilds().elementAt(j);
                        if (!inOutputChild.getNodeName().equals("text")) {
                            if (inOutputChild.getNodeName().equals("iColl")) {
                                if (cloneDictNode != null) {
                                    this.composeIcollNode(cloneDictNode, cloneDatasNode, datasChild, inOutputChild);
                                }
                            } else if (inOutputChild.getNodeName().equals("kColl")) {
                                this.composeGroupNode(cloneDatasNode, datasChild, inOutputChild);
                            } else if (inOutputChild.getNodeName().equals("field")) {
                                String idValue = inOutputChild.getAttrValue("id");
                                String destNameValue = inOutputChild.getAttrValue("destName");
                                if (destNameValue == null) {
                                    destNameValue = "";
                                }
                                if (refIdValue != null && idValue != null && refIdValue.equals(idValue)) {
                                    datasChild.setAttrValue("destName", destNameValue);
                                }
                            }
                        }
                        ++j;
                    }
                    if (cloneDictNode != null) {
                        cloneDatasNode.remove(datasChild);
                        cloneDatasNode.add(cloneDictNode);
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return cloneDatasNode;
    }

    public void composeGroupNode(XMLNode cloneDatasNode, XMLNode datasChild, XMLNode inOutputChild) {
        try {
            String kcollName = inOutputChild.getAttrValue("destName");
            String grpChildId = datasChild.getAttrValue("id");
            String inOutputId = inOutputChild.getAttrValue("id");
            if (kcollName != null && grpChildId != null && inOutputId != null && grpChildId.equals(inOutputId)) {
                datasChild.setAttrValue("destName", kcollName);
            }
            if (datasChild.getNodeName().equals("dataGroup")) {
                int i = 0;
                while (i < inOutputChild.getChilds().size()) {
                    XMLNode kCollChild = (XMLNode)inOutputChild.getChilds().elementAt(i);
                    String kCollId = kCollChild.getAttrValue("id");
                    String kCollName = kCollChild.getAttrValue("destName");
                    if (kCollName == null) {
                        kCollName = "";
                    }
                    int j = 0;
                    while (j < datasChild.getChilds().size()) {
                        XMLNode childNode = (XMLNode)datasChild.getChilds().elementAt(j);
                        String refId = childNode.getAttrValue("refId");
                        if (refId != null && kCollId != null && refId.equals(kCollId)) {
                            childNode.setAttrValue("destName", kCollName);
                        }
                        ++j;
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void composeIcollNode(XMLNode cloneDictNode, XMLNode cloneDatasNode, XMLNode datasChild, XMLNode inOutputChild) {
        try {
            String icollName = inOutputChild.getAttrValue("destName");
            String dictId = cloneDictNode.getAttrValue("id");
            String icollId = inOutputChild.getAttrValue("id");
            if (icollName != null && dictId.equals(icollId)) {
                cloneDictNode.setAttrValue("destName", icollName);
            }
            int k = 0;
            while (k < cloneDictNode.getChilds().size()) {
                XMLNode dictChild = (XMLNode)cloneDictNode.getChilds().elementAt(k);
                if (!dictChild.getNodeName().equals("text")) {
                    String refId = dictChild.getAttrValue("refId");
                    int m = 0;
                    while (m < inOutputChild.getChilds().size()) {
                        XMLNode icollChild = (XMLNode)inOutputChild.getChilds().elementAt(m);
                        String id = icollChild.getAttrValue("id");
                        String name = icollChild.getAttrValue("destName");
                        if (name == null) {
                            name = "";
                        }
                        if (refId != null && id != null && refId.equals(id)) {
                            dictChild.setAttrValue("destName", name);
                        }
                        ++m;
                    }
                }
                ++k;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    public void saveBizNode() {
        this.saveNode(this.editNode.getChild("input"));
    }

    public void saveDestNode() {
        this.saveNode(this.editNode.getChild("output"));
    }

    public void saveNode(XMLNode node) {
        try {
            if (node.getChilds() != null) {
                node.removeAllChilds();
            }
            int i = 0;
            while (i < this.tempNode.getChilds().size()) {
                XMLNode childNode = (XMLNode)this.tempNode.getChilds().elementAt(i);
                if (!"#text".equals(childNode.getNodeName())) {
                    String refId;
                    String destName;
                    XMLNode childDatasNode;
                    int j;
                    boolean canAdd;
                    String name;
                    String id;
                    XMLNode inOutputChild;
                    if ("refData".equals(childNode.getNodeName())) {
                        inOutputChild = new XMLNode("field");
                        String destName2 = childNode.getAttrValue("destName");
                        String refId2 = childNode.getAttrValue("refId");
                        if (destName2 != null) {
                            inOutputChild.setAttrValue("id", refId2);
                            inOutputChild.setAttrValue("destName", destName2);
                            node.add(inOutputChild);
                        }
                    } else if ("dataCollection".equals(childNode.getNodeName())) {
                        inOutputChild = new XMLNode("iColl");
                        id = childNode.getAttrValue("id");
                        name = childNode.getAttrValue("destName");
                        canAdd = false;
                        if (id != null) {
                            inOutputChild.setAttrValue("id", id);
                        }
                        if (name != null) {
                            inOutputChild.setAttrValue("destName", name);
                            canAdd = true;
                        }
                        j = 0;
                        while (j < childNode.getChilds().size()) {
                            childDatasNode = (XMLNode)childNode.getChilds().elementAt(j);
                            destName = childDatasNode.getAttrValue("destName");
                            refId = childDatasNode.getAttrValue("refId");
                            if (destName != null) {
                                XMLNode iCollChild = new XMLNode("field");
                                iCollChild.setAttrValue("id", refId);
                                iCollChild.setAttrValue("destName", destName);
                                inOutputChild.add(iCollChild);
                                canAdd = true;
                            }
                            ++j;
                        }
                        if (canAdd) {
                            node.add(inOutputChild);
                        }
                    } else if ("dataGroup".equals(childNode.getNodeName())) {
                        inOutputChild = new XMLNode("kColl");
                        id = childNode.getAttrValue("id");
                        name = childNode.getAttrValue("destName");
                        canAdd = false;
                        if (id != null) {
                            inOutputChild.setAttrValue("id", id);
                        }
                        if (name != null) {
                            inOutputChild.setAttrValue("destName", name);
                            canAdd = true;
                        }
                        j = 0;
                        while (j < childNode.getChilds().size()) {
                            childDatasNode = (XMLNode)childNode.getChilds().elementAt(j);
                            destName = childDatasNode.getAttrValue("destName");
                            refId = childDatasNode.getAttrValue("refId");
                            if (destName != null) {
                                XMLNode kCollChild = new XMLNode("field");
                                kCollChild.setAttrValue("id", refId);
                                kCollChild.setAttrValue("destName", destName);
                                inOutputChild.add(kCollChild);
                                canAdd = true;
                            }
                            ++j;
                        }
                        if (canAdd) {
                            node.add(inOutputChild);
                        }
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void deleteMap() {
        try {
            TreeItem[] items = this.dataTableTree.getSelection();
            if (items.length != 1) {
                return;
            }
            TreeItem item = items[0];
            XMLNode delNode = (XMLNode)item.getData();
            delNode.setAttrValue("destName", null);
            if (delNode.getChilds() != null) {
                int i = 0;
                while (i < delNode.getChilds().size()) {
                    XMLNode delChildNode = (XMLNode)delNode.getChilds().elementAt(i);
                    delChildNode.setAttrValue("destName", null);
                    ++i;
                }
            }
            this.treeViewer.refresh();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setDragAndDrop(TreeViewer sourceTree, TreeViewer targetTree) {
        Transfer[] types = new Transfer[]{LocalSelectionTransfer.getInstance()};
        this.source = new DragSource((Control)sourceTree.getTree(), 3);
        this.source.setTransfer(types);
        this.source.addDragListener((DragSourceListener)new TreeDragListener(sourceTree));
        this.target = new DropTarget((Control)targetTree.getTree(), 3);
        this.target.setTransfer(types);
        this.target.addDropListener((DropTargetListener)new TreeDropListener(targetTree));
    }

    class TreeNodeContentProvider
    implements ITreeContentProvider {
        TreeNodeContentProvider() {
        }

        public Object[] getChildren(Object obj) {
            return this.getElements(obj);
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            XMLNode node = (XMLNode)element;
            if ("dataCollection".equals(node.getNodeName())) {
                return true;
            }
            if ("dataGroup".equals(node.getNodeName())) {
                return true;
            }
            if ("refData".equals(node.getNodeName())) {
                return false;
            }
            return false;
        }

        public Object[] getElements(Object inputElement) {
            Vector<XMLNode> result = new Vector<XMLNode>();
            XMLNode node = (XMLNode)inputElement;
            int i = 0;
            while (i < node.getChilds().size()) {
                XMLNode child = (XMLNode)node.getChilds().elementAt(i);
                if ("refData".equals(child.getNodeName())) {
                    result.add(child);
                } else if ("dataCollection".equals(child.getNodeName())) {
                    result.add(child);
                } else if ("dataGroup".equals(child.getNodeName())) {
                    result.add(child);
                }
                ++i;
            }
            return result.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class TreeNodeLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        TreeNodeLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            XMLNode node;
            if (columnIndex == 0) {
                if (!(element instanceof XMLNode)) {
                    return "";
                }
                node = (XMLNode)element;
                if (node.getAttrValue("refId") != null) {
                    return node.getAttrValue("refId");
                }
                if (node.getAttrValue("id") != null) {
                    return node.getAttrValue("id");
                }
            }
            if (columnIndex == 1) {
                if (!(element instanceof XMLNode)) {
                    return "";
                }
                node = (XMLNode)element;
                String refId = node.getAttrValue("refId");
                XMLNode dataNode = null;
                if (refId != null) {
                    dataNode = MapDataPanel.this.dataDictionary.findChildNode(refId);
                    return dataNode.getAttrValue("label");
                }
                String id = node.getAttrValue("id");
                if (id != null) {
                    dataNode = MapDataPanel.this.dataDictionary.findChildNode(id);
                    if (dataNode != null) {
                        return dataNode.getAttrValue("label");
                    }
                    return node.getAttrValue("name");
                }
            }
            if (columnIndex == 2) {
                if (!(element instanceof XMLNode)) {
                    return "";
                }
                node = (XMLNode)element;
                if (node.getAttrValue("destName") != null) {
                    return node.getAttrValue("destName");
                }
            }
            return "";
        }

        public Image getColumnImage(Object element, int columnIndex) {
            String str = this.getColumnText(element, columnIndex);
            if (str == null || str.length() == 0) {
                return null;
            }
            if (MapDataPanel.this.selfFlag) {
                if (columnIndex == 0) {
                    return new Image(null, ECCIDEPlugin.getFile("/icons/tag_green.png"));
                }
                if (columnIndex == 2) {
                    return new Image(null, ECCIDEPlugin.getFile("/icons/tag_red.png"));
                }
            } else {
                if (columnIndex == 0) {
                    return new Image(null, ECCIDEPlugin.getFile("/icons/tag_red.png"));
                }
                if (columnIndex == 2) {
                    return new Image(null, ECCIDEPlugin.getFile("/icons/tag_green.png"));
                }
            }
            return null;
        }
    }
}

