/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.emp.ide.callbiz;

import com.ecc.ide.editor.XMLNode;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.views.navigator.LocalSelectionTransfer;

public class TreeDropListener
implements DropTargetListener {
    private TreeViewer treeViewer;
    private Tree tree;
    private LocalSelectionTransfer transfer;

    public TreeDropListener(TreeViewer treeViewer) {
        this.treeViewer = treeViewer;
    }

    public void dragEnter(DropTargetEvent event) {
        if (event.detail == 16) {
            event.detail = (event.operations & 1) != 0 ? 1 : 0;
        }
    }

    public void dragOver(DropTargetEvent event) {
        this.transfer = LocalSelectionTransfer.getInstance();
        if (this.transfer.isSupportedType(event.currentDataType)) {
            IStructuredSelection selection = (IStructuredSelection)this.transfer.getSelection();
            XMLNode soureNode = (XMLNode)selection.getFirstElement();
            String sourceStr = soureNode.getAttrValue("refId");
            if (sourceStr == null) {
                sourceStr = soureNode.getAttrValue("id");
            }
            try {
                this.tree = this.treeViewer.getTree();
                TreeItem item = this.tree.getItem(this.tree.toControl(new Point(event.x, event.y)));
                XMLNode tarNode = null;
                if (item != null && !this.canDrop(soureNode, tarNode = (XMLNode)item.getData())) {
                    event.detail = 0;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private boolean canDrop(XMLNode sNode, XMLNode tNode) {
        if (tNode.equals(sNode)) {
            return false;
        }
        XMLNode sParent = sNode.getParent();
        XMLNode tParent = tNode.getParent();
        String sParentName = sParent.getNodeName();
        String tParentName = tParent.getNodeName();
        String sName = sNode.getNodeName();
        String tName = tNode.getNodeName();
        if (tNode.equals(sParent)) {
            return false;
        }
        if (sParent.equals(tParent)) {
            return false;
        }
        if (sParent.getParent().equals(tParent)) {
            return false;
        }
        if (tParent.getParent().equals(sParent)) {
            return false;
        }
        if ("dataCollection".equals(sParentName) && !"dataCollection".equals(tParentName)) {
            return false;
        }
        if ("dataCollection".equals(tParentName) && !"dataCollection".equals(sParentName)) {
            return false;
        }
        if ("dataGroup".equals(tParentName) && !"dataGroup".equals(sParentName)) {
            return false;
        }
        if ("dataGroup".equals(sParentName) && !"dataGroup".equals(tParentName)) {
            return false;
        }
        if ("dataCollection".equals(sName) && !"dataCollection".equals(tName)) {
            return false;
        }
        if ("dataCollection".equals(tName) && !"dataCollection".equals(sName)) {
            return false;
        }
        if ("dataGroup".equals(tName) && !"dataGroup".equals(sName)) {
            return false;
        }
        if ("dataGroup".equals(sName) && !"dataGroup".equals(tName)) {
            return false;
        }
        return !tParent.getParent().equals(sParent.getParent());
    }

    public void drop(DropTargetEvent event) {
        this.transfer = LocalSelectionTransfer.getInstance();
        if (this.transfer.isSupportedType(event.currentDataType)) {
            IStructuredSelection selection = (IStructuredSelection)this.transfer.getSelection();
            XMLNode soureNode = (XMLNode)selection.getFirstElement();
            String sourceStr = soureNode.getAttrValue("refId");
            if (sourceStr == null) {
                sourceStr = soureNode.getAttrValue("id");
            }
            try {
                this.tree = this.treeViewer.getTree();
                TreeItem item = this.tree.getItem(this.tree.toControl(new Point(event.x, event.y)));
                XMLNode tarNode = null;
                if (item != null && this.canDrop(soureNode, tarNode = (XMLNode)item.getData())) {
                    tarNode.setAttrValue("destName", sourceStr);
                    if (soureNode.getNodeName().equals("dataGroup") || soureNode.getNodeName().equals("dataCollection")) {
                        this.copyChilds(soureNode, tarNode);
                    }
                    item.setText(2, sourceStr);
                    this.treeViewer.refresh();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void copyChilds(XMLNode sNode, XMLNode tNode) {
        try {
            int i = 0;
            while (i < sNode.getChilds().size()) {
                XMLNode childSNode = (XMLNode)sNode.getChilds().elementAt(i);
                int j = 0;
                while (j < tNode.getChilds().size()) {
                    XMLNode childTNode = (XMLNode)tNode.getChilds().elementAt(j);
                    String sRefId = childSNode.getAttrValue("refId");
                    String tRefId = childTNode.getAttrValue("refId");
                    if (sRefId != null && tRefId != null && sRefId.equalsIgnoreCase(tRefId)) {
                        childTNode.setAttrValue("destName", sRefId);
                    }
                    ++j;
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void dropAccept(DropTargetEvent event) {
    }

    public void dragLeave(DropTargetEvent event) {
    }

    public void dragOperationChanged(DropTargetEvent event) {
    }
}

