/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.emp.ide.componentwizard;

import com.ecc.ide.ant.AntObject;
import com.ecc.ide.ant.RunAntInIDE;
import com.ecc.ide.base.IDEContent;
import com.ecc.ide.base.IDEProfile;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editorprofile.EditorProfile;
import com.ecc.ide.editorprofile.Element;
import com.ecc.ide.editorprofile.ElementAttribute;
import com.ecc.ide.editorprofile.ElementCatalog;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class TypeModel
extends Element {
    public IProject project;
    public String pkgName = "";
    public String className = "Action";
    public String states = "0=\u6210\u529f;-1=\u5f02\u5e38;";
    public boolean defineChild = false;
    public EditorProfile profile = null;
    public int modelType = 0;
    public static int EMP_INITIALIZER = 9001;
    public static int EMP_CONTROLLER = 9002;
    public static int EMP_MODELUPDATER = 9003;
    public static int EMP_FUNCTION = 9004;
    public static int EMP_ACCESSCONTROLLER = 9005;
    public static int EMP_FORMATGENERATER = 9006;

    public TypeModel(IProject project, int modelType) {
        this.project = project;
        this.modelType = modelType;
        try {
            if (this.useProfile()) {
                this.profile = IDEProfile.getEditorProfile(project, modelType);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean checkFinish() {
        if (this.pkgName.length() == 0) {
            MessageDialog.openError((Shell)new Shell(), (String)"error", (String)"\u5305\u540d\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
            return false;
        }
        if (this.pkgName.endsWith(".")) {
            MessageDialog.openError((Shell)new Shell(), (String)"error", (String)"\u5305\u540d\u683c\u5f0f\u4e0d\u6b63\u786e");
            return false;
        }
        if (this.className.length() == 0) {
            MessageDialog.openError((Shell)new Shell(), (String)"error", (String)"\u7ec4\u4ef6ID\uff08\u7c7b\u540d\uff09\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
            return false;
        }
        if (this.getElementName().length() == 0 && this.useProfile()) {
            MessageDialog.openError((Shell)new Shell(), (String)"error", (String)"\u7ec4\u4ef6\u540d\u79f0\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
            return false;
        }
        if (this.destCatalog == null || this.destCatalog.length() == 0) {
            this.destCatalog = "extendedElements";
        }
        if (this.useProfile() && this.isNewCatalog()) {
            boolean flag = MessageDialog.openQuestion((Shell)new Shell(), (String)"error", (String)"\u7ec4\u4ef6\u5206\u7ec4\u4e0d\u5b58\u5728\uff0c\u73b0\u5728\u521b\u5efa\uff1f");
            if (flag) {
                this.addCatalog();
            } else {
                return false;
            }
        }
        try {
            IJavaProject javaProject = JavaCore.create((IProject)this.project);
            if (javaProject.findType(String.valueOf(this.pkgName) + "." + this.className) != null) {
                MessageDialog.openError((Shell)new Shell(), (String)"error", (String)(String.valueOf(this.className) + "\u7c7b\u5df2\u7ecf\u5b58\u5728"));
                return false;
            }
        }
        catch (Exception javaProject) {
            // empty catch block
        }
        try {
            this.doFinish();
        }
        catch (Exception e) {
            PrintStream ps = IDEContent.getConsole();
            ps.print("\n\u751f\u6210\u4ee3\u7801[" + this.className + "]\u65f6\u51fa\u73b0\u9519\u8bef\n");
            e.printStackTrace(ps);
        }
        return true;
    }

    public String[] getAttrs() {
        Vector attrs = this.getAttributes();
        String[] result = new String[attrs.size()];
        int i = 0;
        while (i < attrs.size()) {
            result[i] = ((ElementAttribute)attrs.elementAt(i)).getAttrID();
            ++i;
        }
        return result;
    }

    public ElementAttribute getAttr(String id) {
        Vector attrs = this.getAttributes();
        ElementAttribute attr = null;
        int i = 0;
        while (i < attrs.size()) {
            if (id.equals(((ElementAttribute)attrs.elementAt(i)).getAttrID())) {
                attr = (ElementAttribute)attrs.elementAt(i);
                return attr;
            }
            ++i;
        }
        return null;
    }

    public void removeAttr(String id) {
        this.attrs.remove(this.getAttr(id));
    }

    public void doFinish() throws CoreException {
        IJavaProject javaProject = JavaCore.create((IProject)this.project);
        String srcPath = "src";
        try {
            srcPath = IDEContent.getPRJSettings(this.project).getSrcPath();
        }
        catch (Exception exception) {
            // empty catch block
        }
        IPackageFragment pkgFragment = javaProject.getPackageFragmentRoot((IResource)this.project.getFolder(srcPath)).createPackageFragment(this.pkgName, false, null);
        String content = "";
        if (this.modelType == 5) {
            content = this.openEMPActionContent();
        }
        if (this.modelType == 13) {
            content = this.openEMPServiceContent();
        }
        if (this.modelType == EMP_INITIALIZER) {
            content = this.openEMPInitializerContent();
        }
        if (this.modelType == EMP_FUNCTION) {
            content = this.openEMPFuncContent();
        }
        if (this.modelType == EMP_CONTROLLER) {
            content = this.openEMPController();
        }
        if (this.modelType == EMP_ACCESSCONTROLLER) {
            content = this.openAccessControllerContent();
        }
        if (this.modelType == EMP_MODELUPDATER) {
            content = this.openModelUpdaterContent();
        }
        if (this.modelType == EMP_FORMATGENERATER) {
            content = this.openFormatGeneraterContent();
        }
        ICompilationUnit compUnit = pkgFragment.createCompilationUnit(String.valueOf(this.className) + ".java", content, false, null);
        String fileName = compUnit.getResource().getProjectRelativePath().toString();
        AntObject antObject = new AntObject("compliercomponent", "\u7f16\u8bd1\u7ec4\u4ef6", this.project, null);
        antObject.setProperty("srcFile", fileName);
        RunAntInIDE.run(antObject);
        final IFile file = this.project.getFile((IPath)new Path(fileName));
        Display.getCurrent().asyncExec(new Runnable(){

            public void run() {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                }
                catch (PartInitException partInitException) {
                    // empty catch block
                }
            }
        });
    }

    private String openEMPController() {
        String method = this.getSetAndGetMethod();
        String editorClassDef = "";
        if (this.defineChild) {
            editorClassDef = " * @emp:editClass com.ecc.emp.ide.mvc.editor.XMLObjectEditor\n";
        }
        String src = "import com.ecc.emp.web.servlet.mvc.EMPRequestController;\n\n/**\n * " + this.className + ".java<br>\n" + " * EMP MVC Controller\u7ec4\u4ef6<br>\n" + " * Extends class EMPRequestController<br>\n" + " * Created on  " + this.getTime() + "<br>\n" + " * @autor        <br>\n" + "\n" + " * @emp:name " + this.getLabel() + "\n" + editorClassDef + "\n" + " * @emp:document " + this.getDocument() + "\n" + " */\n" + "public class TestAction extends EMPRequestController{\n\t" + method + "\n}\n";
        src = "package " + this.pkgName + ";\n\n" + src.replaceAll("TestAction", this.className);
        return src;
    }

    private String openModelUpdaterContent() {
        String method = this.getSetAndGetMethod();
        String editorClassDef = "";
        if (this.defineChild) {
            editorClassDef = " * @emp:editClass com.ecc.emp.ide.mvc.editor.XMLObjectEditor\n";
        }
        String src = "import java.util.Map;\n\nimport javax.servlet.http.HttpServletRequest;\n\nimport com.ecc.emp.core.Context;\nimport com.ecc.emp.core.EMPException;\nimport com.ecc.emp.flow.EMPFlow;\nimport com.ecc.emp.web.servlet.mvc.ModelUpdater;\n/**\n * " + this.className + ".java<br>\n" + " * EMP \u6570\u636e\u6a21\u578b\u66f4\u65b0\u5668<br>\n" + " * implements interface ModelUpdater<br>\n" + " * Created on  " + this.getTime() + "<br>\n" + " * @autor        <br>\n" + "\n" + " * @emp:name " + this.getLabel() + "\n" + editorClassDef + "\n" + " * " + this.getDocument() + "\n" + " */\n" + "public class TestAction implements ModelUpdater {\n\t" + "public String getViewName() {\n\t\treturn null;\n\t}\n\t" + "public void updateModel(HttpServletRequest request, Context context,EMPFlow flow, String opId, Map dataTypeDefs, boolean append)throws EMPException {\n\t}\n\t" + "public void updateModel(HttpServletRequest request, Context context,Map dataTypeDefs, boolean append) throws EMPException {\n\t}\n\t" + "public void updateModel(HttpServletRequest request, Context context,EMPFlow flow, String opId, Map dataTypeDefs) throws EMPException {\n\t}\n\t" + "public void updateModel(HttpServletRequest request, Context context,Map dataTypeDefs) throws EMPException {\n\t}\n\t" + method + "\n}\n";
        src = "package " + this.pkgName + ";\n\n" + src.replaceAll("TestAction", this.className);
        return src;
    }

    private String openFormatGeneraterContent() {
        String src = "import com.ecc.ide.editor.XMLNode;\n\nimport com.ecc.ide.builder.format.FormatBuilder;\n\n/**\n * " + this.className + ".java<br>\n" + " * EMP IDE Format\u7f16\u8bd1\u5668<br>\n" + " * extends FormatBuilder<br>\n" + " * Created on  " + this.getTime() + "<br>\n" + " * @autor        <br>\n" + "\n" + "\n" + " * " + this.getDocument() + "\n" + " */\n" + "public class TestAction extends FormatBuilder {\n\t" + "public XMLNode compile(XMLNode node, String id) throws Exception{\n\t\treturn null;\n\t}\n\t" + "\n}\n";
        src = "package " + this.pkgName + ";\n\n" + src.replaceAll("TestAction", this.className);
        return src;
    }

    private String openAccessControllerContent() {
        String method = this.getSetAndGetMethod();
        String editorClassDef = "";
        if (this.defineChild) {
            editorClassDef = " * @emp:editClass com.ecc.emp.ide.mvc.editor.XMLObjectEditor\n";
        }
        String src = "import com.ecc.emp.accesscontrol.AccessController;\nimport com.ecc.emp.core.Context;\nimport com.ecc.emp.core.EMPException;\n/**\n * " + this.className + ".java<br>\n" + " * EMP \u8bbf\u95ee\u63a7\u5236\u5668<br>\n" + " * implements interface AccessController<br>\n" + " * Created on  " + this.getTime() + "<br>\n" + " * @autor        <br>\n" + "\n" + " * @emp:name " + this.getLabel() + "\n" + editorClassDef + "\n" + " * @emp:document " + this.getDocument() + "\n" + " */\n" + "public class TestAction implements AccessController {\n\t" + "public void beginAccess(Object accessInfo) {\n\t}\n\t" + "public Object checkAccess(Context context, Object requestObj,String actionId) throws EMPException {\n\t\treturn null;\n\t}\n\t" + "public void endAccess(Object accessInfo, long beginTimeStamp) {\n\t}\n\t" + method + "\n}\n";
        src = "package " + this.pkgName + ";\n\n" + src.replaceAll("TestAction", this.className);
        return src;
    }

    private String openEMPFuncContent() {
        String method = this.getSetAndGetMethod();
        String src = "import java.util.List;\n\nimport com.ecc.util.formula.FormulaException;\nimport com.ecc.util.formula.FormulaValue;\nimport com.ecc.util.formula.function.Function;\n/**\n * " + this.className + ".java<br>\n" + " * EMP Function\u7ec4\u4ef6<br>\n" + " * Extends class Function<br>\n" + " * Created on  " + this.getTime() + "<br>\n" + " * @autor        <br>\n" + "\n" + " * @emp:name " + this.getLabel() + "\n" + " * @emp:catalog " + this.destCatalog + "\n" + " * @emp:document " + this.getDocument() + "\n" + " */\n" + "public class TestAction extends Function {\n\t" + "public FormulaValue getValue(List argList) throws FormulaException {\n\t\treturn null;\n\t}" + method + "\n}\n";
        src = "package " + this.pkgName + ";\n\n" + src.replaceAll("TestAction", this.className);
        return src;
    }

    private String openEMPInitializerContent() {
        String method = this.getSetAndGetMethod();
        String src = "import com.ecc.emp.component.factory.EMPFlowComponentFactory;\nimport com.ecc.emp.web.servlet.Initializer;\n\n/**\n * " + this.className + ".java<br>\n" + " * EMP \u521d\u59cb\u5316\u7ec4\u4ef6<br>\n" + " * implements Initializer<br>\n" + " * Created on  " + this.getTime() + "<br>\n" + " * @autor        <br>\n" + "\n" + " * " + this.getDocument() + "\n" + " */\n" + "public class TestAction implements Initializer {\n\t" + "public void initialize(EMPFlowComponentFactory factory) throws Exception {\n\t}" + method + "\n}\n";
        src = "package " + this.pkgName + ";\n\n" + src.replaceAll("TestAction", this.className);
        return src;
    }

    private String openEMPServiceContent() {
        String method = this.getSetAndGetMethod();
        String editorClassDef = "";
        if (this.defineChild) {
            editorClassDef = " * @emp:editClass com.ecc.emp.ide.mvc.editor.XMLObjectEditor\n";
        }
        String src = "import com.ecc.emp.core.Context;\nimport com.ecc.emp.service.EMPService;\n\n/**\n * " + this.className + ".java<br>\n" + " * EMP \u670d\u52a1\u6269\u5c55<br>\n" + " * Extends class EMPService<br>\n" + " * Created on  " + this.getTime() + "<br>\n" + " * @autor        <br>\n" + "\n" + " * @emp:name " + this.getLabel() + "\n" + " * @emp:catalog " + this.destCatalog + "\n" + " * @emp:document " + this.getDocument() + "\n" + " */\n" + "public class TestAction extends EMPService {\n" + method + "\n}\n";
        src = "package " + this.pkgName + ";\n\n" + src.replaceAll("TestAction", this.className);
        return src;
    }

    private String openEMPActionContent() {
        String method = this.getSetAndGetMethod();
        String editorClassDef = "";
        if (this.defineChild) {
            editorClassDef = " * @emp:editClass com.ecc.emp.ide.mvc.editor.XMLObjectEditor\n";
        }
        String src = "import com.ecc.emp.core.Context;\nimport com.ecc.emp.flow.EMPAction;\n\nimport com.ecc.emp.core.EMPException;\n\n/**\n * " + this.className + ".java<br>\n" + " * EMP \u4ea4\u6613\u6b65\u9aa4\u6269\u5c55<br>\n" + " * Extends class EMPAction<br>\n" + " * Created on  " + this.getTime() + "<br>\n" + " * @autor        <br>\n" + "\n" + " * @emp:name " + this.getLabel() + "\n" + " * @emp:catalog " + this.destCatalog + "\n" + editorClassDef + " * @emp:states " + this.states + "\n" + " * @emp:document " + this.getDocument() + "\n" + " */\n" + "public class TestAction extends EMPAction {\n" + "\n\t/*\u4e1a\u52a1\u903b\u8f91\u64cd\u4f5c\u5355\u5143\u7684\u6267\u884c\u5165\u53e3*/\n" + "\tpublic String execute(Context context) throws EMPException\n" + "\t{\n\t\treturn \"0\";\n\t}" + method + "\n}\n";
        src = "package " + this.pkgName + ";\n\n" + src.replaceAll("TestAction", this.className);
        return src;
    }

    private String getSetAndGetMethod() {
        String attributes = " ";
        Vector attrs = this.getAttributes();
        if (attrs == null) {
            return "";
        }
        String attrStr = "";
        int i = 0;
        while (i < attrs.size()) {
            ElementAttribute attr = (ElementAttribute)attrs.elementAt(i);
            String attrId = attr.getAttrID();
            String str = attrId.substring(0, 1).toUpperCase();
            str = String.valueOf(str) + attrId.substring(1, attrId.length());
            String arg = "new" + str;
            attrStr = String.valueOf(attrStr) + "\n\tprivate " + this.getAttrType(attr) + " " + attrId + ";\n";
            attrStr = String.valueOf(attrStr) + this.getJavaDoc(attr);
            attrStr = String.valueOf(attrStr) + "\n\tpublic void ";
            attrStr = String.valueOf(attrStr) + "set" + str + "(" + this.getAttrType(attr) + " " + arg + ") {";
            attributes = String.valueOf(attributes) + "set" + str + "(" + this.getAttrType(attr) + " " + arg + ") ";
            attrStr = String.valueOf(attrStr) + "\n\t\t" + attrId + " = " + arg + ";\n\t}";
            attrStr = String.valueOf(attrStr) + "\n\tpublic " + this.getAttrType(attr) + " get" + str + "() {";
            attrStr = String.valueOf(attrStr) + "\n\t\treturn " + attrId + ";\n\t}";
            ++i;
        }
        return attrStr;
    }

    private String getAttrType(ElementAttribute attr) {
        if ("boolean".equals(attr.getAttrType())) {
            return "boolean";
        }
        return "String";
    }

    private String getJavaDoc(ElementAttribute attr) {
        String javaDoc = "\n /**\n";
        javaDoc = String.valueOf(javaDoc) + "  * @emp:name " + attr.getAttrName() + "\n" + "  * @emp:desc " + attr.getDocument() + "\n" + "  * @emp:mustSet " + new Boolean(attr.getMustSet()).toString() + "\n" + "  * @emp:attrType " + attr.getAttrType() + "\n" + "  * @emp:isAttribute " + "true\n" + "  * @emp:valueList " + attr.getValueListStr() + "\n";
        javaDoc = String.valueOf(javaDoc) + " */";
        return javaDoc;
    }

    private String getTime() {
        Date date = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat("", Locale.SIMPLIFIED_CHINESE);
        formatter.applyPattern("yyyy\u5e74MM\u6708dd\u65e5HH\u65f6mm\u5206ss\u79d2");
        String time = formatter.format(date);
        return time;
    }

    public String[] getCatalogs() {
        if (this.modelType == EMP_FUNCTION) {
            try {
                XMLNode functionDefines = IDEContent.getSettingNode(this.project, 29);
                if (functionDefines == null) {
                    return new String[0];
                }
                Vector<String> temp = new Vector<String>();
                int i = 0;
                while (i < functionDefines.getChilds().size()) {
                    XMLNode child = (XMLNode)functionDefines.getChilds().elementAt(i);
                    if ("FuncGroup".equals(child.getNodeName())) {
                        temp.add(child.getAttrValue("id"));
                    }
                    ++i;
                }
                String[] result = new String[temp.size()];
                int i2 = 0;
                while (i2 < temp.size()) {
                    result[i2] = (String)temp.elementAt(i2);
                    ++i2;
                }
                return result;
            }
            catch (Exception functionDefines) {
                return new String[0];
            }
        }
        if (this.profile == null) {
            return new String[0];
        }
        try {
            String[] result = new String[this.profile.getCagalogs().size()];
            int i = 0;
            while (i < this.profile.getCagalogs().size()) {
                ElementCatalog catalog = (ElementCatalog)this.profile.getCagalogs().elementAt(i);
                result[i] = catalog.getCatalogName();
                ++i;
            }
            return result;
        }
        catch (Exception exception) {
            return new String[0];
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isNewCatalog() {
        try {
            String[] catas = this.getCatalogs();
            int i = 0;
            while (true) {
                if (i >= catas.length) {
                    return true;
                }
                if (this.destCatalog.equals(catas[i])) {
                    return false;
                }
                ++i;
            }
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void addCatalog() {
        if (this.modelType == EMP_FUNCTION) {
            try {
                XMLNode functionDefines = IDEContent.getSettingNode(this.project, 29);
                XMLNode node = new XMLNode("FuncGroup");
                node.setAttrValue("id", this.destCatalog);
                functionDefines.add(node);
                IDEContent.saveSettingNode(this.project, 29);
            }
            catch (Exception functionDefines) {
                // empty catch block
            }
            return;
        }
        ElementCatalog extendCatalog = new ElementCatalog();
        extendCatalog.setCatalogName(this.destCatalog);
        extendCatalog.setLabel(this.destCatalog);
        this.profile.add(extendCatalog);
        IDEProfile.saveEditorProfile(this.project, this.modelType, this.profile);
    }

    public String getDefaultClassname() {
        if (this.modelType == 5) {
            return "MyEMPAction";
        }
        if (this.modelType == 13) {
            return "MyEMPService";
        }
        if (this.modelType == EMP_INITIALIZER) {
            return "MyInitializer";
        }
        if (this.modelType == EMP_CONTROLLER) {
            return "MyController";
        }
        if (this.modelType == EMP_FUNCTION) {
            return "MyFunction";
        }
        if (this.modelType == EMP_MODELUPDATER) {
            return "MyModelUpdater";
        }
        if (this.modelType == EMP_ACCESSCONTROLLER) {
            return "MyAccessController";
        }
        if (this.modelType == EMP_FORMATGENERATER) {
            return "MyFormatGenerater";
        }
        return "";
    }

    public String getTitle() {
        if (this.modelType == 5) {
            return "EMP\u4e1a\u52a1\u903b\u8f91\u6267\u884c\u6b65\u9aa4\u6269\u5c55\uff08EMP Action\uff09";
        }
        if (this.modelType == 13) {
            return "EMP\u670d\u52a1\u7ec4\u4ef6\u6269\u5c55\uff08EMP Service\uff09";
        }
        if (this.modelType == EMP_INITIALIZER) {
            return "EMP\u521d\u59cb\u5316\u7ec4\u4ef6\uff08EMP Initializer\uff09";
        }
        if (this.modelType == EMP_CONTROLLER) {
            return "EMP\u8868\u73b0\u903b\u8f91\u63a7\u5236\u5668\u6269\u5c55\uff08EMP MVC Controller\uff09";
        }
        if (this.modelType == EMP_FUNCTION) {
            return "EMP\u516c\u5f0f\u7ec4\u4ef6\u6269\u5c55\uff08EMP Function\uff09";
        }
        if (this.modelType == EMP_MODELUPDATER) {
            return "EMP\u8868\u73b0\u903b\u8f91MODEL UPDATER\u6269\u5c55";
        }
        if (this.modelType == EMP_ACCESSCONTROLLER) {
            return "EMP\u8bbf\u95ee\u63a7\u5236\u5668\uff08EMP Access Controller\uff09";
        }
        if (this.modelType == EMP_FORMATGENERATER) {
            return "EMP IDE\u62a5\u6587\u5b9a\u4e49\u7f16\u8bd1\u5668\uff08Format Generater\uff09";
        }
        return "";
    }

    public boolean useProfile() {
        if (this.modelType == 5) {
            return true;
        }
        if (this.modelType == 13) {
            return true;
        }
        return this.modelType == EMP_FUNCTION;
    }

    public boolean useStatus() {
        return this.modelType == 5;
    }
}

