/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.emp.ide.mbean;

import com.ecc.emp.ide.mbean.MbeanSetMainAttr;
import com.ecc.emp.ide.mbean.MbeanWizardPage;
import com.ecc.ide.base.IDEConstance;
import com.ecc.ide.editor.XMLElementObjectMaker;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editorprofile.EditorProfile;
import com.ecc.ide.editorprofile.Element;
import com.ecc.ide.module.ModuleUtility;
import com.ecc.util.xmlloader.ObjectMaker;
import com.ecc.util.xmlloader.XMLLoader;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;

public class MbeanWizard
extends Wizard {
    private EditorProfile serviceProfile;
    private IProject project = null;
    private Element elment = null;
    private String javaFileSrc;
    private String serviceName;
    private MbeanWizardPage page;
    private XMLNode MbeanNode = null;
    private XMLNode serviceClassBeanNode = null;
    private IType type;
    private String[] opreationList;
    private String className;
    private String MbeanSrc;
    private String xmlEncoding = null;
    private String bizGrup;
    private String MbeanId;
    private String MbeanName;
    private HashMap mainMap;
    private static ArrayList membersAttrList = new ArrayList();

    public MbeanWizard(IProject project, String serviceName, String bizGrup) {
        this.project = project;
        this.serviceProfile = ModuleUtility.getServiceProfile(project);
        this.serviceName = serviceName;
        this.bizGrup = bizGrup;
        this.init();
    }

    public void addPages() {
        this.page = new MbeanWizardPage(this.type);
        this.addPage((IWizardPage)this.page);
    }

    public void init() {
        this.elment = this.serviceProfile.getElement(this.serviceName);
        this.javaFileSrc = this.elment.getImplClass();
        this.type = this.getJavaFile();
    }

    public boolean performFinish() {
        this.addMbean();
        membersAttrList.clear();
        return true;
    }

    public void addMbean() {
        this.setServiceClassBeanNode();
        this.setMBeanSrc();
        this.MbeanNode = this.loadXMLContent(this.MbeanSrc);
        XMLNode classMapNode = this.MbeanNode.findChild("classMap");
        XMLNode mbeanExportornode = this.MbeanNode.findChild("mbeanExportor");
        this.addServiceNode(mbeanExportornode, this.serviceClassBeanNode);
        this.MbeanNode.removeAllChilds();
        this.MbeanNode.add(classMapNode);
        this.MbeanNode.add(mbeanExportornode);
        this.saveXMLFile(this.MbeanSrc, this.MbeanNode);
    }

    public IType getJavaFile() {
        try {
            System.out.println(this.javaFileSrc);
            IJavaProject javaProject = JavaCore.create((IProject)this.project);
            IType type = javaProject.findType(this.javaFileSrc);
            return type;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void setServiceClassBeanNode() {
        this.className = this.page.getClassName();
        try {
            this.mainMap = MbeanSetMainAttr.getMainMap();
            if (this.mainMap.isEmpty()) {
                this.mainMap.put("id", this.className);
                this.mainMap.put("name", this.className);
                this.mainMap.put("objectId", this.className);
                this.mainMap.put("description", "EMPMbean\uff1a" + this.className);
                this.mainMap.put("type", "Service");
            }
            this.serviceClassBeanNode = new XMLNode("EMPMBean");
            this.serviceClassBeanNode.setAttrValue("id", this.mainMap.get("id").toString());
            this.serviceClassBeanNode.setAttrValue("name", this.mainMap.get("name").toString());
            this.serviceClassBeanNode.setAttrValue("objectId", this.mainMap.get("objectId").toString());
            this.serviceClassBeanNode.setAttrValue("description", this.mainMap.get("description").toString());
            this.serviceClassBeanNode.setAttrValue("type", this.mainMap.get("type").toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int i = 0;
        while (i < membersAttrList.size()) {
            HashMap attrMap = (HashMap)membersAttrList.get(i);
            XMLNode attrNode = new XMLNode("attr");
            attrNode.setAttrValue("id", attrMap.get("id").toString());
            attrNode.setAttrValue("name", attrMap.get("name").toString());
            attrNode.setAttrValue("displayName", attrMap.get("displayName").toString());
            attrNode.setAttrValue("description", attrMap.get("desc").toString());
            attrNode.setAttrValue("access", attrMap.get("access").toString());
            this.serviceClassBeanNode.add(attrNode);
            ++i;
        }
        this.opreationList = this.page.getSelectOpreation();
        i = 0;
        while (i < this.opreationList.length) {
            XMLNode opNode = new XMLNode("op");
            opNode.setAttrValue("id", this.opreationList[i]);
            opNode.setAttrValue("name", this.opreationList[i]);
            opNode.setAttrValue("displayName", "displayName");
            opNode.setAttrValue("description", "description");
            opNode.setAttrValue("paramNameStr", "value");
            this.serviceClassBeanNode.add(opNode);
            ++i;
        }
    }

    public void setMBeanSrc() {
        IFolder folder = this.project.getFolder("designFiles");
        String fileSrc = folder.getLocation().toString();
        this.MbeanSrc = fileSrc = String.valueOf(fileSrc) + "/bizs/" + this.bizGrup + "/mbeans.xml";
    }

    public void addServiceNode(XMLNode mainNode, XMLNode childNode) {
        String childNodeID = childNode.getAttrValue("id");
        int i = 0;
        while (i < mainNode.getChilds().size()) {
            XMLNode node = (XMLNode)mainNode.getChilds().elementAt(i);
            String nodeID = node.getAttrValue("id");
            if (childNodeID.equals(nodeID)) {
                mainNode.remove(node);
                break;
            }
            ++i;
        }
        mainNode.add(childNode);
    }

    public void saveXMLFile(String fileName, XMLNode node) {
        try {
            File file = new File(fileName);
            if (!file.exists()) {
                file.createNewFile();
            }
            StringBuffer strBuf = new StringBuffer();
            if (this.xmlEncoding != null) {
                node.setEncoding(this.xmlEncoding);
            }
            node.toXMLContent(0, strBuf, true);
            FileOutputStream fo = new FileOutputStream(fileName);
            if (this.xmlEncoding != null) {
                fo.write(strBuf.toString().getBytes(this.xmlEncoding));
            } else {
                fo.write(strBuf.toString().getBytes(IDEConstance.encoding));
            }
            fo.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public XMLNode loadXMLContent(String file) {
        XMLLoader xmlLoader = new XMLLoader();
        xmlLoader.addObjectMaker((ObjectMaker)new XMLElementObjectMaker());
        try {
            XMLNode node = (XMLNode)xmlLoader.loadXMLFile(file);
            return node;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void initMembersAttrList(HashMap map) {
        membersAttrList.add(map);
    }

    public static void setMemebersAtrrList(HashMap map) {
        int i = 0;
        while (i < membersAttrList.size()) {
            HashMap attrMap = (HashMap)membersAttrList.get(i);
            if (attrMap.get("attr").equals(map.get("attr"))) {
                membersAttrList.remove(i);
                membersAttrList.add(map);
                System.out.println(membersAttrList.size());
                return;
            }
            ++i;
        }
        membersAttrList.add(map);
        System.out.println(membersAttrList.size());
    }
}

