/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.emp.ide.mvc;

import com.ecc.emp.ide.mvc.ExceptionHandlerPanel;
import com.ecc.emp.ide.mvc.MVCViewPanel;
import com.ecc.emp.ide.mvc.ModelUpdaterPanel;
import com.ecc.emp.ide.mvc.SelectBizWizard;
import com.ecc.ide.base.IDEContent;
import com.ecc.ide.base.IDEProfile;
import com.ecc.ide.editor.EditorBeanPropertyPanel;
import com.ecc.ide.editor.XMLElementObjectMaker;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editorprofile.Element;
import com.ecc.ide.refactor.editor.XMLElementWrapper;
import com.ecc.util.xmlloader.ObjectMaker;
import com.ecc.util.xmlloader.XMLLoader;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class MVCOverviewPanel
extends Composite {
    private IProject project;
    private XMLNode mvcNode;
    private IFile mvcFile;
    private Text bizIdField;
    private Text mvcIdField;
    private MVCViewPanel mvcViewPanel;
    private EditorBeanPropertyPanel editorBeanPropertyPanel;
    private ExceptionHandlerPanel exceptionHandlerPanel;
    private ModelUpdaterPanel modelUpdaterPanel;
    private FormToolkit toolkit = new FormToolkit(Display.getCurrent());
    private Label modelUpdaterLabel = null;

    public MVCOverviewPanel(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout());
        Form form = this.toolkit.createForm((Composite)this);
        Composite body = form.getBody();
        body.setLayout((Layout)new FillLayout());
        this.toolkit.paintBordersFor(body);
        SashForm sashFormPanel = new SashForm(body, 512);
        this.toolkit.adapt((Control)sashFormPanel, true, true);
        SashForm sashForm_2 = new SashForm((Composite)sashFormPanel, 0);
        sashForm_2.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.toolkit.adapt((Control)sashForm_2, true, true);
        Section section = this.toolkit.createSection((Composite)sashForm_2, 256);
        section.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        section.setText("\u57fa\u672c\u4fe1\u606f");
        Composite composite = this.toolkit.createComposite((Composite)section, 0);
        GridLayout gridLayout_1 = new GridLayout();
        gridLayout_1.numColumns = 2;
        composite.setLayout((Layout)gridLayout_1);
        this.toolkit.paintBordersFor(composite);
        section.setClient((Control)composite);
        Label label = this.toolkit.createLabel(composite, "\u8868\u73b0\u6784\u4ef6ID", 0);
        this.mvcIdField = this.toolkit.createText(composite, null, 0);
        this.mvcIdField.setEnabled(false);
        this.mvcIdField.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.toolkit.createLabel(composite, "\u4e1a\u52a1\u6784\u4ef6ID", 0);
        this.bizIdField = this.toolkit.createText(composite, null, 0);
        this.bizIdField.setEnabled(false);
        this.bizIdField.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        new Label(composite, 0);
        Button button = this.toolkit.createButton(composite, "\u9009\u62e9\u4e1a\u52a1\u6784\u4ef6", 0);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MVCOverviewPanel.this.selectBiz();
            }
        });
        Section section_1 = this.toolkit.createSection((Composite)sashForm_2, 256);
        GridData gridData_2 = new GridData(4, 4, true, false);
        gridData_2.heightHint = 300;
        section_1.setLayoutData((Object)gridData_2);
        section_1.setText("\u9ad8\u7ea7\u4fe1\u606f");
        ScrolledComposite composite_1 = new ScrolledComposite((Composite)section_1, 512);
        composite_1.setLayout((Layout)new FillLayout());
        this.toolkit.adapt((Composite)composite_1);
        section_1.setClient((Control)composite_1);
        this.editorBeanPropertyPanel = new EditorBeanPropertyPanel((Composite)composite_1, 2048);
        composite_1.setContent((Control)this.editorBeanPropertyPanel);
        this.toolkit.adapt((Composite)this.editorBeanPropertyPanel);
        SashForm sashForm_1 = new SashForm((Composite)sashFormPanel, 0);
        sashForm_1.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        sashForm_1.setOrientation(512);
        Section section_2 = this.toolkit.createSection((Composite)sashForm_1, 256);
        section_2.setText("\u9875\u9762\u5f15\u7528");
        SashForm sashForm = new SashForm((Composite)section_2, 0);
        this.toolkit.adapt((Control)sashForm, true, true);
        section_2.setClient((Control)sashForm);
        this.mvcViewPanel = new MVCViewPanel((Composite)sashForm, 0);
        this.toolkit.adapt((Composite)this.mvcViewPanel);
        Composite composite_5 = this.toolkit.createComposite((Composite)sashForm, 0);
        composite_5.setLayout((Layout)new GridLayout());
        this.toolkit.paintBordersFor(composite_5);
        this.modelUpdaterLabel = this.toolkit.createLabel(composite_5, "\u9875\u9762\u5411Context\u6a21\u578b\u66f4\u65b0\u5b9a\u4e49", 0);
        this.modelUpdaterLabel.setLayoutData((Object)new GridData(4, 1, true, false));
        this.modelUpdaterPanel = new ModelUpdaterPanel(composite_5, 0);
        this.modelUpdaterPanel.setLayoutData(new GridData(4, 4, true, true));
        this.toolkit.adapt((Composite)this.modelUpdaterPanel);
        sashForm.setWeights(new int[]{1, 1});
        this.toolkit.adapt((Control)sashForm_1, true, true);
        Section section_3 = this.toolkit.createSection((Composite)sashForm_1, 256);
        section_3.setText("\u5f02\u5e38\u7ba1\u7406");
        this.exceptionHandlerPanel = new ExceptionHandlerPanel((Composite)section_3, 0, null);
        this.toolkit.adapt((Composite)this.exceptionHandlerPanel);
        section_3.setClient((Control)this.exceptionHandlerPanel);
        sashFormPanel.setWeights(new int[]{1, 3});
        sashForm_2.setWeights(new int[]{1, 1});
        sashForm_1.setWeights(new int[]{5, 2});
        form.setText("EMP MVC\u5b9a\u4e49");
        this.mvcViewPanel.tree_1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MVCOverviewPanel.this.editModelUpdater();
            }
        });
    }

    public void dispose() {
        super.dispose();
    }

    protected void checkSubclass() {
    }

    public void selectBiz() {
        boolean result;
        if (this.bizIdField.getText().length() != 0 && !(result = MessageDialog.openConfirm(null, (String)"\u786e\u8ba4", (String)"\u786e\u8ba4\u4fee\u6539\u4e1a\u52a1\u6784\u4ef6?\u73b0\u6709\u5b9a\u4e49\u5c06\u4e0d\u518d\u9002\u7528"))) {
            return;
        }
        SelectBizWizard wizard = new SelectBizWizard();
        wizard.setXMLNode(this.mvcNode);
        wizard.getXMLNode();
        this.checkBizField();
    }

    public void editModelUpdater() {
        try {
            XMLNode viewNode = (XMLNode)this.mvcViewPanel.tree_1.getSelection()[0].getData();
            this.modelUpdaterLabel.setText("\u9875\u9762[" + viewNode.getAttrValue("id") + "]\u5411Context\u6a21\u578b\u66f4\u65b0\u5b9a\u4e49");
            this.modelUpdaterPanel.init(this.project, this.getBizDatas(), viewNode);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void init(IProject project, IFile mvcFile, XMLNode mvcNode) {
        this.project = project;
        this.mvcFile = mvcFile;
        this.mvcNode = mvcNode;
        String mvcId = mvcFile.getName();
        mvcId = mvcId.substring(0, mvcId.indexOf(mvcFile.getFileExtension()) - 1);
        this.mvcIdField.setText(mvcId);
        try {
            this.bizIdField.setText(mvcNode.getAttrValue("bizId"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            Element element = IDEProfile.getEditorProfile(project, 33).getElement(mvcNode.getNodeName());
            XMLElementWrapper wrapper = new XMLElementWrapper(mvcNode, element);
            this.editorBeanPropertyPanel.showWrapperProperties(wrapper);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.mvcViewPanel.setInput(project, mvcNode.getChild("views"), true);
        this.exceptionHandlerPanel.setExceptionHandlerNode(mvcNode.getChild("exceptionHandler"));
    }

    private XMLNode getBizDatas() {
        try {
            IFile bizFile = IDEContent.getFile(this.project, IDEContent.getBizGroupIdFromMVCFile(this.project, this.mvcFile.getLocation().toOSString()), this.mvcNode.getAttrValue("bizId"), "biz");
            XMLLoader xmlLoader = new XMLLoader();
            xmlLoader.addObjectMaker((ObjectMaker)new XMLElementObjectMaker());
            XMLNode bizNode = (XMLNode)xmlLoader.loadXMLFile(bizFile.getLocation().toOSString());
            return bizNode;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void checkBizField() {
        try {
            if (this.mvcNode.getAttrValue("bizId") == null || this.mvcNode.getAttrValue("bizId").length() == 0) {
                return;
            }
            String bizId = this.mvcNode.getAttrValue("bizId");
            if (bizId.equals(this.bizIdField.getText())) {
                return;
            }
            this.bizIdField.setText(bizId);
            this.editModelUpdater();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

