/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.emp.ide.plugin.editors.jsp;

import com.ecc.emp.ide.plugin.editors.jsp.ColorManager;
import com.ecc.emp.ide.plugin.editors.jsp.IJSPColorConstants;
import com.ecc.emp.ide.plugin.editors.jsp.JSPDoubleClickStrategy;
import com.ecc.emp.ide.plugin.editors.jsp.JSPTextEditor;
import com.ecc.emp.ide.plugin.editors.jsp.contentassistant.CompletionProcessor;
import com.ecc.emp.ide.plugin.editors.jsp.formatter.XmlDocumentFormattingStrategy;
import com.ecc.emp.ide.plugin.editors.jsp.scanner.JSPScanner;
import com.ecc.emp.ide.plugin.editors.jsp.scanner.JSPTagScanner;
import com.ecc.emp.ide.plugin.editors.jsp.scanner.JavaTagScanner;
import com.ecc.emp.ide.plugin.editors.jsp.tagrule.NonRuleBasedDamagerRepairer;
import com.ecc.ide.base.IDEProfile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.formatter.IContentFormatter;
import org.eclipse.jface.text.formatter.IFormattingStrategy;
import org.eclipse.jface.text.formatter.MultiPassContentFormatter;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;

public class JSPConfiguration
extends SourceViewerConfiguration {
    private JSPDoubleClickStrategy doubleClickStrategy;
    private JSPTagScanner tagScanner;
    private JSPScanner scanner;
    private JavaTagScanner javaScanner;
    private ColorManager colorManager;
    private JSPTextEditor editor;
    private IProject project;

    public JSPConfiguration(ColorManager colorManager, JSPTextEditor editor) {
        this.colorManager = colorManager;
        this.editor = editor;
        this.project = editor.getProject();
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return new String[]{"__dftl_partition_content_type", "__xml_comment", "__xml_tag", "__java_source"};
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
        if (this.doubleClickStrategy == null) {
            this.doubleClickStrategy = new JSPDoubleClickStrategy();
        }
        return this.doubleClickStrategy;
    }

    protected JSPScanner getXMLScanner() {
        if (this.scanner == null) {
            this.scanner = new JSPScanner(this.colorManager);
            this.scanner.setDefaultReturnToken((IToken)new Token((Object)new TextAttribute(this.colorManager.getColor(IJSPColorConstants.DEFAULT))));
        }
        return this.scanner;
    }

    protected JSPTagScanner getXMLTagScanner() {
        if (this.tagScanner == null) {
            this.tagScanner = new JSPTagScanner(this.colorManager);
            this.tagScanner.setDefaultReturnToken((IToken)new Token((Object)new TextAttribute(this.colorManager.getColor(IJSPColorConstants.TAG))));
        }
        return this.tagScanner;
    }

    private JavaTagScanner getJavaTagScanner() {
        if (this.javaScanner == null) {
            this.javaScanner = new JavaTagScanner(this.colorManager);
            this.javaScanner.setDefaultReturnToken((IToken)new Token((Object)new TextAttribute(this.colorManager.getColor(IJSPColorConstants.DEFAULT))));
        }
        return this.javaScanner;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)this.getXMLTagScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__xml_tag");
        reconciler.setRepairer((IPresentationRepairer)dr, "__xml_tag");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getJavaTagScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__java_source");
        reconciler.setRepairer((IPresentationRepairer)dr, "__java_source");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getXMLScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        NonRuleBasedDamagerRepairer ndr = new NonRuleBasedDamagerRepairer(new TextAttribute(this.colorManager.getColor(IJSPColorConstants.XML_COMMENT)));
        reconciler.setDamager((IPresentationDamager)ndr, "__xml_comment");
        reconciler.setRepairer((IPresentationRepairer)ndr, "__xml_comment");
        return reconciler;
    }

    public IContentAssistant getContentAssistant(ISourceViewer sv) {
        ContentAssistant contentAssistant = new ContentAssistant();
        CompletionProcessor cap = new CompletionProcessor(this.editor);
        try {
            cap.setEmpTagProfile(IDEProfile.getEditorProfile(this.project, 27));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        contentAssistant.setContentAssistProcessor((IContentAssistProcessor)cap, "__dftl_partition_content_type");
        contentAssistant.setContentAssistProcessor((IContentAssistProcessor)cap, "__xml_tag");
        contentAssistant.setInformationControlCreator(this.getInformationControlCreator(sv));
        return contentAssistant;
    }

    public IContentFormatter getContentFormatter(ISourceViewer sourceViewer) {
        MultiPassContentFormatter formatter = new MultiPassContentFormatter(this.getConfiguredDocumentPartitioning(sourceViewer), "__dftl_partition_content_type");
        formatter.setMasterStrategy((IFormattingStrategy)new XmlDocumentFormattingStrategy());
        return formatter;
    }
}

