/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.emp.ide.plugin.editors.jsp;

import com.ecc.emp.ide.plugin.editors.jsp.JSPTextEditor;
import com.ecc.ide.base.IDEContent;
import com.ecc.ide.base.IDEProfile;
import com.ecc.ide.builder.BuildProblemObject;
import com.ecc.ide.editor.ContentChangedEvent;
import com.ecc.ide.editor.ContentChangedListener;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editor.visualJsp.VisualJSPFramePanel;
import com.ecc.ide.editor.visualJsp.VisualKJavaFormFramePanel;
import com.ecc.ide.editor.visualWML.VisualWMLFramePanel;
import com.ecc.ide.editorprofile.EditorProfile;
import com.ecc.ide.plugin.ECCIDEPlugin;
import com.ecc.ide.plugin.properties.IDEProjectSettings;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.PrintStream;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.texteditor.IStatusField;
import org.eclipse.ui.texteditor.ITextEditorExtension;

public class JSPEditor
extends MultiPageEditorPart
implements IResourceChangeListener,
ContentChangedListener,
ITextEditorExtension {
    private JSPTextEditor editor;
    private VisualJSPFramePanel visualPanel;
    private VisualWMLFramePanel wmlPanel;
    private VisualKJavaFormFramePanel kjavaPanel;
    private int editingType = 0;
    private static final int JSP = 0;
    private static final int WML = 1;
    private static final int KJAVA = 2;
    protected IProject project;
    private String rootPath = "";
    private String jspFileName;
    private String jspRootPath;
    private int currentPage = 0;
    boolean isDirtSaved = false;
    private boolean isChanged = false;

    public JSPEditor() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    void createPage0() {
        try {
            this.editor = new JSPTextEditor();
            int index = this.addPage((IEditorPart)this.editor, this.getEditorInput());
            this.setPageText(index, this.editor.getTitle());
        }
        catch (PartInitException e) {
            ErrorDialog.openError((Shell)this.getSite().getShell(), (String)"Error creating nested text editor", null, (IStatus)e.getStatus());
        }
    }

    void createKJavaVisualPage() {
        try {
            Composite composite = new Composite(this.getContainer(), 0);
            FillLayout layout = new FillLayout();
            composite.setLayout((Layout)layout);
            this.kjavaPanel = new VisualKJavaFormFramePanel(composite, 0);
            EditorProfile editorProfile = IDEProfile.getEditorProfile(this.project, 25);
            this.kjavaPanel.setEditorProfile(editorProfile);
            EditorProfile aDataProfile = IDEProfile.getEditorProfile(this.project, 1);
            this.kjavaPanel.setDataEditorProfile(aDataProfile);
            XMLNode node = IDEContent.getSettingNode(this.project, 0);
            this.kjavaPanel.setDataDictionary(node);
            this.kjavaPanel.setRootPath(this.project.getLocation().toString());
            this.kjavaPanel.setJspRootPath(this.jspRootPath);
            this.kjavaPanel.setJspFileName(this.jspFileName);
            XMLNode patternnode = IDEContent.getSettingNode(this.project, 15);
            this.kjavaPanel.setPatternNode(patternnode);
            this.kjavaPanel.setPatternProfile(IDEProfile.getEditorProfile(this.project, 15));
            XMLNode channelSettingsNode = IDEContent.getSettingNode(this.project, 19);
            this.kjavaPanel.setChannelSettings(channelSettingsNode);
            this.kjavaPanel.addContentChangedListener(this);
            XMLNode externResource = IDEContent.getSettingNode(this.project, 30);
            this.kjavaPanel.setExternResource(externResource);
            XMLNode dataTypeNode = IDEContent.getSettingNode(this.project, 33);
            this.kjavaPanel.setDataType(dataTypeNode);
            XMLNode dataTypeDefNode = IDEContent.getSettingNode(this.project, 34);
            this.kjavaPanel.setDataTypeDef(dataTypeDefNode);
            FileEditorInput input = (FileEditorInput)this.getEditorInput();
            InputStream content = input.getFile().getContents();
            this.kjavaPanel.loadWMLContent(content);
            int index = this.addPage((Control)composite);
            this.setPageText(index, "VisualEdit");
        }
        catch (Exception e) {
            this.reportProblem(BuildProblemObject.ERROR, "Exception while construct the WML visual editor, Exception: " + e.getMessage(), "");
        }
    }

    void createWMLVisualPage() {
        try {
            Composite composite = new Composite(this.getContainer(), 0);
            FillLayout layout = new FillLayout();
            composite.setLayout((Layout)layout);
            this.wmlPanel = new VisualWMLFramePanel(composite, 0);
            EditorProfile editorProfile = IDEProfile.getEditorProfile(this.project, 29);
            this.wmlPanel.setEditorProfile(editorProfile);
            EditorProfile aDataProfile = IDEProfile.getEditorProfile(this.project, 1);
            this.wmlPanel.setDataEditorProfile(aDataProfile);
            XMLNode node = IDEContent.getSettingNode(this.project, 0);
            this.wmlPanel.setDataDictionary(node);
            this.wmlPanel.setRootPath(this.project.getLocation().toString());
            this.wmlPanel.setJspRootPath(this.jspRootPath);
            this.wmlPanel.setJspFileName(this.jspFileName);
            XMLNode patternnode = IDEContent.getSettingNode(this.project, 15);
            this.wmlPanel.setPatternNode(patternnode);
            this.wmlPanel.setPatternProfile(IDEProfile.getEditorProfile(this.project, 15));
            XMLNode channelSettingsNode = IDEContent.getSettingNode(this.project, 19);
            this.wmlPanel.setChannelSettings(channelSettingsNode);
            this.wmlPanel.addContentChangedListener(this);
            XMLNode externResource = IDEContent.getSettingNode(this.project, 30);
            this.wmlPanel.setExternResource(externResource);
            XMLNode dataTypeNode = IDEContent.getSettingNode(this.project, 33);
            this.wmlPanel.setDataType(dataTypeNode);
            XMLNode dataTypeDefNode = IDEContent.getSettingNode(this.project, 34);
            this.wmlPanel.setDataTypeDef(dataTypeDefNode);
            FileEditorInput input = (FileEditorInput)this.getEditorInput();
            InputStream content = input.getFile().getContents();
            this.wmlPanel.loadWMLContent(content);
            int index = this.addPage((Control)composite);
            this.setPageText(index, "VisualEdit");
        }
        catch (Exception e) {
            this.reportProblem(BuildProblemObject.ERROR, "Exception while construct the WML visual editor, Exception: " + e.getMessage(), "");
        }
    }

    void createJSPVisualPage() {
        try {
            Composite composite = new Composite(this.getContainer(), 0);
            FillLayout layout = new FillLayout();
            composite.setLayout((Layout)layout);
            this.visualPanel = new VisualJSPFramePanel(composite, 0);
            EditorProfile editorProfile = IDEProfile.getEditorProfile(this.project, 27);
            this.visualPanel.setEditorProfile(editorProfile);
            EditorProfile aDataProfile = IDEProfile.getEditorProfile(this.project, 1);
            this.visualPanel.setDataEditorProfile(aDataProfile);
            XMLNode node = IDEContent.getSettingNode(this.project, 0);
            this.visualPanel.setDataDictionary(node);
            this.visualPanel.setRootPath(this.project.getLocation().toString());
            this.visualPanel.setJspRootPath(this.jspRootPath);
            this.visualPanel.setJspFileName(this.jspFileName);
            XMLNode patternnode = IDEContent.getSettingNode(this.project, 15);
            this.visualPanel.setPatternNode(patternnode);
            this.visualPanel.setPatternProfile(IDEProfile.getEditorProfile(this.project, 15));
            XMLNode channelSettingsNode = IDEContent.getSettingNode(this.project, 19);
            this.visualPanel.setChannelSettings(channelSettingsNode);
            this.visualPanel.addContentChangedListener(this);
            XMLNode externResource = IDEContent.getSettingNode(this.project, 30);
            this.visualPanel.setExternResource(externResource);
            XMLNode dataTypeNode = IDEContent.getSettingNode(this.project, 33);
            this.visualPanel.setDataType(dataTypeNode);
            XMLNode dataTypeDefNode = IDEContent.getSettingNode(this.project, 34);
            this.visualPanel.setDataTypeDef(dataTypeDefNode);
            FileEditorInput input = (FileEditorInput)this.getEditorInput();
            InputStream content = input.getFile().getContents();
            this.visualPanel.loadJSPContent(content);
            int index = this.addPage((Control)composite);
            this.setPageText(index, "VisualEdit");
        }
        catch (Exception e) {
            this.reportProblem(BuildProblemObject.ERROR, "Exception while construct the JSP visual editor, Exception: " + e.getMessage(), "");
        }
    }

    protected void createPages() {
        this.createPage0();
        IDocument document = this.editor.getDocumentProvider().getDocument((Object)this.editor.getEditorInput());
        String editorText = document.get();
        if (editorText.indexOf("<!-- CTP WML JSP File -->") != -1) {
            this.createWMLVisualPage();
            this.editingType = 1;
        } else if (editorText.indexOf("<!-- CTP KJava JSP File -->") != -1) {
            this.createKJavaVisualPage();
            this.editingType = 2;
        } else {
            this.createJSPVisualPage();
        }
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        super.dispose();
    }

    public void doSave(IProgressMonitor monitor) {
        if (this.isChanged) {
            this.loadVisualEditingContent();
        }
        if (this.editor.isDirty()) {
            this.isDirtSaved = true;
        }
        this.getEditor(0).doSave(monitor);
    }

    public void doSaveAs() {
        if (this.isChanged) {
            this.loadVisualEditingContent();
        }
        if (this.editor.isDirty()) {
            this.isDirtSaved = true;
        }
        IEditorPart editor = this.getEditor(0);
        editor.doSaveAs();
        this.setPageText(0, editor.getTitle());
        this.setInput(editor.getEditorInput());
    }

    public void gotoMarker(IMarker marker) {
        this.setActivePage(0);
        IDE.gotoMarker((IEditorPart)this.getEditor(0), (IMarker)marker);
    }

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        if (!(editorInput instanceof IFileEditorInput)) {
            throw new PartInitException("Invalid Input: Must be IFileEditorInput");
        }
        super.init(site, editorInput);
        this.project = ((FileEditorInput)editorInput).getFile().getProject();
        String relativeFilePath = ((FileEditorInput)editorInput).getFile().getProjectRelativePath().toString();
        IEditorInput input = this.getEditorInput();
        FileEditorInput finput = (FileEditorInput)input;
        String editingFileName = finput.getFile().getName();
        this.setPartName(editingFileName);
        this.setTitleToolTip(String.valueOf(this.project.getLocation().toString()) + "/" + finput.getFile().getName());
        editingFileName = String.valueOf(this.project.getLocation().toString()) + "/" + relativeFilePath;
        this.rootPath = this.project.getLocation().toString();
        IDEProjectSettings settings = IDEContent.getPRJSettings(this.project);
        this.jspRootPath = String.valueOf(settings.getWebContentPath()) + "/" + settings.getJspRootPath();
        int idx = relativeFilePath.indexOf(this.jspRootPath);
        this.jspFileName = relativeFilePath.substring(idx + this.jspRootPath.length() + 1);
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    protected void pageChange(int newPageIndex) {
        super.pageChange(newPageIndex);
        try {
            if (this.currentPage == 0) {
                if (newPageIndex == 1 && (this.editor.isDirty() || this.isDirtSaved)) {
                    this.isDirtSaved = false;
                    IDocument document = this.editor.getDocumentProvider().getDocument((Object)this.editor.getEditorInput());
                    String editorText = document.get();
                    ByteArrayInputStream content = new ByteArrayInputStream(editorText.getBytes());
                    if (this.editingType == 0) {
                        this.visualPanel.loadJSPContent(content);
                    } else if (this.editingType == 1) {
                        this.wmlPanel.loadWMLContent(content);
                    } else if (this.editingType == 2) {
                        this.kjavaPanel.loadWMLContent(content);
                    }
                    ((InputStream)content).close();
                }
            } else if (this.currentPage == 1) {
                if (this.isChanged) {
                    this.loadVisualEditingContent();
                }
                Point location = null;
                if (this.editingType == 0) {
                    location = this.visualPanel.getCurrentLocation();
                } else if (this.editingType == 1) {
                    location = this.wmlPanel.getCurrentLocation();
                } else if (this.editingType == 2) {
                    location = this.kjavaPanel.getCurrentLocation();
                }
                if (location != null) {
                    this.editor.setHighlightRange(location.x, location.y, true);
                }
            }
            this.currentPage = newPageIndex;
        }
        catch (Exception e) {
            this.reportProblem(BuildProblemObject.ERROR, "Exception while construct the JSP visual editor, Exception: " + e.getMessage(), "");
        }
    }

    public void resourceChanged(final IResourceChangeEvent event) {
        if (event.getType() == 2) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    IWorkbenchPage[] pages = JSPEditor.this.getSite().getWorkbenchWindow().getPages();
                    int i = 0;
                    while (i < pages.length) {
                        if (((FileEditorInput)JSPEditor.this.editor.getEditorInput()).getFile().getProject().equals((Object)event.getResource())) {
                            IEditorPart editorPart = pages[i].findEditor(JSPEditor.this.editor.getEditorInput());
                            pages[i].closeEditor(editorPart, true);
                        }
                        ++i;
                    }
                }
            });
        }
    }

    public void reportProblem(int type, String msg, String location) {
        BuildProblemObject obj = new BuildProblemObject(type, msg, null, this.project.getName(), location, "");
        ECCIDEPlugin.getDefault().addProblemElement(obj);
    }

    public void reportProblem(int type, String msg, String location, Exception e) {
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        e.printStackTrace(new PrintStream(bo));
        String detailMsg = new String(bo.toByteArray());
        BuildProblemObject obj = new BuildProblemObject(type, msg, detailMsg, this.project.getName(), location, "");
        ECCIDEPlugin.getDefault().addProblemElement(obj);
    }

    public void contentChanged(ContentChangedEvent event) {
        this.isChanged = true;
        this.firePropertyChange(257);
    }

    public boolean isDirty() {
        if (this.isChanged) {
            return true;
        }
        try {
            IEditorPart editor = this.getEditor(0);
            return editor.isDirty();
        }
        catch (Exception exception) {
            return false;
        }
    }

    private void loadVisualEditingContent() {
        try {
            this.isChanged = false;
            if (this.editingType == 0) {
                String content = this.visualPanel.getJSPStringContent();
                IDocument document = this.editor.getDocumentProvider().getDocument((Object)this.editor.getEditorInput());
                document.set(content);
            } else if (this.editingType == 1) {
                String content = this.wmlPanel.getJSPStringContent();
                IDocument document = this.editor.getDocumentProvider().getDocument((Object)this.editor.getEditorInput());
                document.set(content);
            } else if (this.editingType == 2) {
                String content = this.kjavaPanel.getJSPStringContent();
                IDocument document = this.editor.getDocumentProvider().getDocument((Object)this.editor.getEditorInput());
                document.set(content);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setStatusField(IStatusField field, String category) {
        this.editor.setStatusField(field, category);
    }

    public boolean isEditorInputReadOnly() {
        return this.editor.isEditorInputReadOnly();
    }

    public void addRulerContextMenuListener(IMenuListener listener) {
        this.editor.addRulerContextMenuListener(listener);
    }

    public void removeRulerContextMenuListener(IMenuListener listener) {
        this.editor.removeRulerContextMenuListener(listener);
    }
}

