/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.emp.ide.plugin.editors.jsp;

import com.ecc.emp.ide.plugin.editors.jsp.ColorManager;
import com.ecc.emp.ide.plugin.editors.jsp.JSPConfiguration;
import com.ecc.emp.ide.plugin.editors.jsp.JSPDocumentProvider;
import com.ecc.ide.base.IDEContent;
import com.ecc.ide.base.IDEProfile;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editorprofile.EditorProfile;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.ContentAssistAction;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextOperationAction;

public class JSPTextEditor
extends TextEditor {
    private ColorManager colorManager = new ColorManager();
    private IProject project;
    private IFile jspFile;
    private EditorProfile jspEditorProfile;
    private EditorProfile dataEditorProfile;
    private XMLNode dataDictionary;
    private XMLNode commonDataNode;
    private XMLNode channelSettings;
    private XMLNode externResource;

    public JSPTextEditor() {
        this.setDocumentProvider((IDocumentProvider)new JSPDocumentProvider());
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (!(input instanceof IFileEditorInput)) {
            throw new PartInitException("Invalid Input: Must be IFileEditorInput");
        }
        super.init(site, input);
        this.jspFile = ((FileEditorInput)input).getFile();
        this.project = this.jspFile.getProject();
        this.setSourceViewerConfiguration(new JSPConfiguration(this.colorManager, this));
        try {
            this.jspEditorProfile = IDEProfile.getEditorProfile(this.project, 27);
            this.dataEditorProfile = IDEProfile.getEditorProfile(this.project, 1);
            this.dataDictionary = IDEContent.getSettingNode(this.project, 0);
            String bizGrp = IDEContent.getBizGroupIdFromMVCFile(this.project, this.jspFile.getProjectRelativePath().toString());
            this.channelSettings = IDEContent.getSettingNode(this.project, bizGrp, 19);
            this.externResource = IDEContent.getSettingNode(this.project, 30);
            this.commonDataNode = this.channelSettings.findChild("CommonData");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void dispose() {
        this.colorManager.dispose();
        super.dispose();
    }

    public void fireContentChangedEvent() {
        super.firePropertyChange(257);
        this.firePropertyChange(258);
    }

    protected void createActions() {
        super.createActions();
        ResourceBundle bundle = ResourceBundle.getBundle("com.ecc.ide.plugin.plugin");
        ContentAssistAction action = new ContentAssistAction(bundle, "ContentAssistProposal", (ITextEditor)this);
        action.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
        this.setAction("ContentAssistProposal", (IAction)action);
        action = new TextOperationAction(bundle, "ContentFormat", (ITextEditor)this, 15);
        action.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.format");
        this.setAction("ContentFormat", (IAction)action);
    }

    protected void initializeKeyBindingScopes() {
        this.setKeyBindingScopes(new String[]{"com.ecc.ide.plugin.editors.jsp.context"});
    }

    public EditorProfile getJspEditorProfile() {
        return this.jspEditorProfile;
    }

    public EditorProfile getDataEditorProfile() {
        return this.dataEditorProfile;
    }

    public XMLNode getDataDictionary() {
        return this.dataDictionary;
    }

    public XMLNode getChannelSettings() {
        return this.channelSettings;
    }

    public XMLNode getCommonDataNode() {
        return this.commonDataNode;
    }

    public XMLNode getExternResource() {
        return this.externResource;
    }

    public IProject getProject() {
        return this.project;
    }

    public IFile getJspFile() {
        return this.jspFile;
    }
}

