/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.emp.ide.plugin.editors.jsp.contentassistant;

import com.ecc.emp.ide.plugin.editors.jsp.JSPTextEditor;
import com.ecc.emp.ide.plugin.editors.jsp.documentModel.CompletionProposalFactory;
import com.ecc.emp.ide.plugin.editors.jsp.documentModel.JspDocumentModel;
import com.ecc.ide.editorprofile.EditorProfile;
import java.util.List;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;

public class CompletionProcessor
implements IContentAssistProcessor {
    private final int NO_PROPOSAL = 0;
    private final int EMPTAG_PROPOSAL = 1;
    private final int ATTRIBUTE_PROPOSAL = 2;
    private final int VALUE_PROPOSAL = 3;
    private final IContextInformation[] NO_CONTEXTS = new IContextInformation[0];
    private final char[] PROPOSAL_ACTIVATION_CHARS = new char[]{'s', 'f', 'p', 'n', 'm'};
    private ICompletionProposal[] NO_COMPLETIONS = new ICompletionProposal[0];
    private JSPTextEditor editor;
    private EditorProfile empTagProfile;
    private String currentPrefix;
    private CompletionProposalFactory proposalFactory;

    public CompletionProcessor(JSPTextEditor editor) {
        this.editor = editor;
        this.proposalFactory = new CompletionProposalFactory(editor);
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        try {
            IDocument document = viewer.getDocument();
            String contentType = document.getContentType(offset);
            JspDocumentModel jspModel = JspDocumentModel.createJspDocMode(document, offset);
            List proposalList = this.proposalFactory.getProposalList(jspModel, contentType);
            return proposalList.toArray(new ICompletionProposal[proposalList.size()]);
        }
        catch (Exception e) {
            return this.NO_COMPLETIONS;
        }
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return this.NO_CONTEXTS;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return this.PROPOSAL_ACTIVATION_CHARS;
    }

    public void setEmpTagProfile(EditorProfile empTagProfile) {
        this.empTagProfile = empTagProfile;
        this.proposalFactory.setEmpTagProfile(empTagProfile);
    }
}

