/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.emp.ide.plugin.editors.jsp.documentModel;

import com.ecc.emp.ide.plugin.editors.jsp.JSPTextEditor;
import com.ecc.emp.ide.plugin.editors.jsp.contentassistant.AttributeProposal;
import com.ecc.emp.ide.plugin.editors.jsp.contentassistant.EMPTagProposal;
import com.ecc.emp.ide.plugin.editors.jsp.contentassistant.ReferenceBizProposal;
import com.ecc.emp.ide.plugin.editors.jsp.contentassistant.ValueProposal;
import com.ecc.emp.ide.plugin.editors.jsp.documentModel.JspDocumentModel;
import com.ecc.emp.ide.plugin.editors.jsp.editor.PropertyEditorSuport;
import com.ecc.ide.base.IDEContent;
import com.ecc.ide.editor.XMLElementObjectMaker;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editorprofile.EditorProfile;
import com.ecc.ide.editorprofile.Element;
import com.ecc.ide.editorprofile.ElementAttribute;
import com.ecc.ide.editorprofile.ElementChild;
import com.ecc.util.xmlloader.ObjectMaker;
import com.ecc.util.xmlloader.XMLLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;

public class CompletionProposalFactory {
    private JspDocumentModel jspModel = null;
    private String contentType = null;
    private XMLNode bizDataNode = null;
    private JSPTextEditor editor = null;
    private EditorProfile empTagProfile = null;
    private IProject project = null;

    public CompletionProposalFactory(JSPTextEditor editor) {
        this.editor = editor;
        this.project = editor.getProject();
    }

    public void setEmpTagProfile(EditorProfile empTagProfile) {
        this.empTagProfile = empTagProfile;
    }

    public List getProposalList(JspDocumentModel jspModel, String contentType) {
        this.jspModel = jspModel;
        this.contentType = contentType;
        this.bizDataNode = this.getRelativeBizDatas();
        ArrayList proposalList = new ArrayList();
        if ("__xml_tag".equals(contentType)) {
            proposalList = this.getEMPProposalList();
        } else if ("__dftl_partition_content_type".equals(contentType)) {
            proposalList = this.getEMPTagProposal();
            proposalList.add(0, new ReferenceBizProposal(jspModel.getOffset(), this.editor));
        }
        return proposalList;
    }

    private ArrayList getEMPProposalList() {
        int pType = this.jspModel.getProposalType();
        System.out.println(String.valueOf(pType) + "=" + this.jspModel.getCurrentPrefix());
        ArrayList result = new ArrayList();
        switch (pType) {
            case 4: {
                result = this.getEMPTagProposal();
                break;
            }
            case 1: {
                result = this.getEMPTagProposal();
                break;
            }
            case 2: {
                result = this.getAttributeProposal();
                break;
            }
            case 3: {
                result = this.getValueProposal();
                break;
            }
        }
        return result;
    }

    private ArrayList getValueProposal() {
        try {
            String tagName = this.jspModel.getTagName();
            String attrName = this.jspModel.getCurAttrName();
            Element empTag = this.empTagProfile.getElement(tagName);
            Vector attrs = empTag.getAttributes();
            ArrayList valueList = new ArrayList();
            int i = 0;
            while (i < attrs.size()) {
                ElementAttribute attr = (ElementAttribute)attrs.elementAt(i);
                if (attr.getAttrID().equals(attrName)) {
                    int length = this.jspModel.getValueLength();
                    valueList = this.getValueList(attr, this.jspModel.getOffset() - this.jspModel.getCurrentPrefix().length() - 1, length + 1);
                    return valueList;
                }
                ++i;
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ArrayList getValueList(ElementAttribute attr, int start, int length) {
        ArrayList valueList = new ArrayList();
        ValueProposal valueProposal = null;
        if (attr.getAttrType() != null && attr.getAttrType().equals("boolean")) {
            valueProposal = new ValueProposal("true", start, length);
            valueList.add(valueProposal);
            valueProposal = new ValueProposal("false", start, length);
            valueList.add(valueProposal);
            return valueList;
        } else if (attr.getValueMapList() != null) {
            int i = 0;
            while (i < attr.getValueMapList().size()) {
                String aValue = (String)attr.getValueMapList().elementAt(i);
                String aDesc = (String)attr.getValueList().elementAt(i);
                valueProposal = new ValueProposal(aValue, aDesc, start, length);
                valueList.add(valueProposal);
                ++i;
            }
            return valueList;
        } else if (attr.getValueList() != null) {
            int i = 0;
            while (i < attr.getValueList().size()) {
                String aValue = (String)attr.getValueList().elementAt(i);
                valueProposal = new ValueProposal(aValue, start, length);
                valueList.add(valueProposal);
                ++i;
            }
            return valueList;
        } else {
            if (attr.getAttrEditorClass() == null) return valueList;
            try {
                String editorClass = attr.getAttrEditorClass();
                if (editorClass == null) return valueList;
                PropertyEditorSuport editorSuport = (PropertyEditorSuport)Class.forName(editorClass).newInstance();
                editorSuport.setDataEditorProfile(this.editor.getDataEditorProfile());
                editorSuport.setDataDictionary(this.editor.getDataDictionary());
                editorSuport.setChannelSettings(this.editor.getChannelSettings());
                editorSuport.setCommonDataNode(this.editor.getCommonDataNode());
                editorSuport.setExternResource(this.editor.getExternResource());
                editorSuport.setRefDataNode(this.bizDataNode);
                return editorSuport.getPropertyValueList(this.jspModel.getCurrentPrefix(), start, length);
            }
            catch (InstantiationException e) {
                e.printStackTrace();
                return valueList;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                return valueList;
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        return valueList;
    }

    private ArrayList getEMPTagProposal() {
        String currentPrefix = this.jspModel.getCurrentPrefix();
        Vector empTags = this.getAllowEMPTags();
        ArrayList<EMPTagProposal> result = new ArrayList<EMPTagProposal>();
        int i = 0;
        while (i < empTags.size()) {
            block4: {
                int length;
                int start;
                Element tag;
                block3: {
                    tag = (Element)empTags.elementAt(i);
                    start = this.jspModel.getOffset();
                    length = 0;
                    if (currentPrefix == null) break block3;
                    if (currentPrefix.length() != 0 && !tag.getElementName().startsWith(currentPrefix)) break block4;
                    start -= currentPrefix.length() + 1;
                    length = currentPrefix.length() + 1;
                }
                EMPTagProposal cp = new EMPTagProposal(tag, start, length, this.editor);
                cp.setBizDataNode(this.bizDataNode);
                result.add(cp);
            }
            ++i;
        }
        return result;
    }

    private Vector getAllowEMPTags() {
        Vector<Element> allowChilds = new Vector<Element>();
        String pTagName = this.jspModel.getParentTagName();
        Element parentTag = this.empTagProfile.getElement(pTagName);
        if (parentTag == null) {
            parentTag = this.empTagProfile.getElement("BODY");
        }
        Vector childs = parentTag.getChilds();
        int i = 0;
        while (i < childs.size()) {
            ElementChild eChild = (ElementChild)childs.elementAt(i);
            allowChilds.add(this.empTagProfile.getElement(eChild.getChildElementId()));
            ++i;
        }
        return allowChilds;
    }

    private ArrayList getAttributeProposal() {
        try {
            String currentPrefix = this.jspModel.getCurrentPrefix();
            Element empTag = this.empTagProfile.getElement(this.jspModel.getTagName());
            Vector attrs = empTag.getAttributes();
            ArrayList<AttributeProposal> result = new ArrayList<AttributeProposal>();
            int i = 0;
            while (i < attrs.size()) {
                block5: {
                    int length;
                    int start;
                    ElementAttribute attr;
                    block6: {
                        attr = (ElementAttribute)attrs.elementAt(i);
                        if (this.jspModel.getAttributes().contains(attr.getAttrID())) break block5;
                        start = this.jspModel.getOffset();
                        length = 0;
                        if (currentPrefix == null) break block6;
                        if (currentPrefix.length() != 0 && !attr.getAttrID().startsWith(currentPrefix)) break block5;
                        start -= currentPrefix.length();
                        length = currentPrefix.length();
                    }
                    AttributeProposal cp = new AttributeProposal(attr, start, length, this.editor);
                    result.add(cp);
                }
                ++i;
            }
            return result;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public XMLNode getRelativeBizDatas() {
        XMLNode datasNode = new XMLNode("datas");
        List bizFiles = this.jspModel.getRelativeBizFile();
        int i = 0;
        while (i < bizFiles.size()) {
            XMLNode bizDatas = this.getDatasFromBiz((String)bizFiles.get(i));
            if (bizDatas != null) {
                int j = 0;
                while (j < bizDatas.getChilds().size()) {
                    XMLNode aNode = (XMLNode)bizDatas.getChilds().elementAt(j);
                    if ("dataGroup".equals(aNode.getNodeName())) {
                        datasNode.add(aNode);
                    } else if (("refData".equals(aNode.getNodeName()) || "refCommData".equals(aNode.getNodeName())) && datasNode.getChildNode("refId", aNode.getAttrValue("refId")) == null) {
                        datasNode.add(aNode);
                    }
                    ++j;
                }
            }
            ++i;
        }
        return datasNode;
    }

    private XMLNode getDatasFromBiz(String bizFile) {
        try {
            IFile biz = IDEContent.getFile(this.project, bizFile, "biz");
            XMLLoader xmlLoader = new XMLLoader();
            xmlLoader.addObjectMaker((ObjectMaker)new XMLElementObjectMaker());
            XMLNode bizNode = (XMLNode)xmlLoader.loadXMLFile(biz.getLocation().toString());
            return bizNode.getChild("datas");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

