/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.emp.ide.plugin.editors.jsp.documentModel;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.FindReplaceDocumentAdapter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;

public class JspDocumentModel {
    public static final int NO_PROPOSAL = 0;
    public static final int EMPTAG_PROPOSAL = 1;
    public static final int ATTRIBUTE_PROPOSAL = 2;
    public static final int VALUE_PROPOSAL = 3;
    public static final int BEFORETAG_PROPOSAL = 4;
    private IDocument document = null;
    private int offset = 0;
    private int startOffset = -1;
    private int endOffset = -1;
    private FindReplaceDocumentAdapter docAdapter;
    private int proposalType = 0;
    private String currentPrefix = null;
    private String curAttrName = null;
    private String curValue = null;
    private int valueLength = 0;
    private String tagName = null;
    private List attributes = new ArrayList();

    public JspDocumentModel(IDocument document, int offset) {
        this.document = document;
        this.offset = offset;
        this.docAdapter = new FindReplaceDocumentAdapter(document);
    }

    public static JspDocumentModel createJspDocMode(IDocument document, int offset) {
        JspDocumentModel model = new JspDocumentModel(document, offset);
        try {
            if ("__xml_tag".equals(document.getContentType(offset))) {
                model.createJspDocMode();
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        return model;
    }

    public void createJspDocMode() {
        this.proposalType = this.determiningProposalType();
        if (this.proposalType != 0 && this.proposalType != 4) {
            this.analyseTagNode();
        }
        if (this.proposalType == 3) {
            this.analyseEditingdAttribute();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int determiningProposalType() {
        try {
            if (this.docAdapter.charAt(this.offset) == '<') {
                this.startOffset = this.offset;
                this.valueLength = 0;
                this.currentPrefix = null;
                return 4;
            }
            int separator = this.findSeparatorIdx(this.docAdapter, this.offset, true);
            char sepChar = this.docAdapter.charAt(separator);
            this.currentPrefix = this.docAdapter.subSequence(separator + 1, this.offset).toString();
            switch (sepChar) {
                case ' ': {
                    return 2;
                }
                case '\"': {
                    int idx = this.findSeparatorIdx(this.docAdapter, separator, false);
                    if (this.docAdapter.charAt(separator - 1) == '=' && idx >= 0 && this.docAdapter.charAt(idx) == '\"') {
                        this.valueLength = idx - separator;
                        return 3;
                    }
                    this.valueLength = 0;
                    this.currentPrefix = null;
                    return 0;
                }
                case '<': {
                    return 1;
                }
            }
            this.valueLength = 0;
            this.currentPrefix = null;
            return 0;
        }
        catch (Exception e) {
            this.valueLength = 0;
            this.currentPrefix = null;
            return 0;
        }
    }

    private int findSeparatorIdx(FindReplaceDocumentAdapter docAdapter, int idx, boolean backward) {
        try {
            char curChar = '\u0000';
            curChar = backward ? docAdapter.charAt(--idx) : docAdapter.charAt(++idx);
            while (true) {
                if (curChar == ' ' || curChar == '/' || curChar == '=' || curChar == '\"' || curChar == '<' || curChar == '>' || curChar == '\r') {
                    return idx;
                }
                if (backward) {
                    curChar = docAdapter.charAt(--idx);
                    continue;
                }
                curChar = docAdapter.charAt(++idx);
            }
        }
        catch (Exception e) {
            return -1;
        }
    }

    private void analyseTagNode() {
        try {
            int separator;
            this.startOffset = this.docAdapter.find(this.offset, "<", false, true, false, true).getOffset();
            int idx = separator = this.findSeparatorIdx(this.docAdapter, this.startOffset + 1, false);
            if (this.docAdapter.charAt(separator) == ' ' || this.docAdapter.charAt(separator) == '/' || this.docAdapter.charAt(separator) == '>') {
                this.tagName = this.docAdapter.subSequence(this.startOffset + 1, separator).toString();
                if (this.docAdapter.charAt(separator) == '>') {
                    --separator;
                }
            } else {
                return;
            }
            String attrName = null;
            Object value = null;
            boolean isSingleTag = true;
            while (true) {
                char ch;
                if ((ch = this.docAdapter.charAt(idx = this.findSeparatorIdx(this.docAdapter, separator, false))) == '=') {
                    attrName = this.docAdapter.subSequence(separator + 1, idx).toString();
                    this.attributes.add(attrName);
                    separator = idx;
                    continue;
                }
                if (ch == ' ') {
                    separator = idx;
                    continue;
                }
                if (ch == '>') {
                    isSingleTag = this.docAdapter.charAt(idx - 1) == '/';
                    this.endOffset = idx + 1;
                    break;
                }
                if (ch == '<' || this.document.getContentType(idx) != "__xml_tag") break;
                ++separator;
            }
            if (!isSingleTag) {
                IRegion region = this.docAdapter.find(this.endOffset, "</" + this.tagName + ">", true, true, false, true);
                this.endOffset = region == null ? -1 : region.getOffset() + this.tagName.length() + 3;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public int getEndOffset() {
        return this.endOffset;
    }

    private void analyseEditingdAttribute() {
        try {
            int sepIdx = this.docAdapter.find(this.offset, "=\"", false, true, false, true).getOffset();
            int endIdx = this.findSeparatorIdx(this.docAdapter, sepIdx + 2, false);
            int startIdx = this.findSeparatorIdx(this.docAdapter, sepIdx, true);
            if (this.docAdapter.charAt(startIdx) != ' ') {
                return;
            }
            this.curAttrName = this.docAdapter.subSequence(startIdx + 1, sepIdx).toString();
            this.curValue = this.docAdapter.subSequence(sepIdx + 2, endIdx).toString();
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public List getRelativeBizFile() {
        ArrayList<String> bizList = new ArrayList<String>();
        try {
            IRegion region;
            int idx = 0;
            while ((region = this.docAdapter.find(idx, "relativeBizFile=\"", true, true, false, true)) != null) {
                int startIdx = region.getOffset() + region.getLength();
                int endIdx = this.findSeparatorIdx(this.docAdapter, startIdx, false);
                if (this.document.getContentType(startIdx) != "__xml_comment") {
                    idx = startIdx + 1;
                    continue;
                }
                String bizFilePath = this.docAdapter.subSequence(startIdx, endIdx).toString();
                bizList.add(bizFilePath);
                idx = endIdx + 1;
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        return bizList;
    }

    public String getParentTagName() {
        String pTagName = null;
        try {
            int idx = this.offset;
            idx = this.proposalType != 0 ? this.docAdapter.find(this.startOffset - 1, "<", false, true, false, true).getOffset() : this.docAdapter.find(idx, "<", false, true, false, true).getOffset();
            while (idx >= 0) {
                JspDocumentModel pTagModel;
                int endIdx;
                if (this.docAdapter.charAt(idx + 1) != '/' && "__xml_tag".equals(this.document.getContentType(idx)) && (endIdx = (pTagModel = JspDocumentModel.createJspDocMode(this.document, idx + 1)).getEndOffset()) > this.offset) {
                    pTagName = pTagModel.getTagName();
                    break;
                }
                --idx;
                idx = this.docAdapter.find(idx, "<", false, true, false, true).getOffset();
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        return pTagName;
    }

    public List getAttributes() {
        return this.attributes;
    }

    public String getCurAttrName() {
        return this.curAttrName;
    }

    public String getCurrentPrefix() {
        return this.currentPrefix;
    }

    public String getCurValue() {
        return this.curValue;
    }

    public int getProposalType() {
        return this.proposalType;
    }

    public String getTagName() {
        return this.tagName;
    }

    public int getValueLength() {
        return this.valueLength;
    }

    public int getOffset() {
        return this.offset;
    }

    public IDocument getDocument() {
        return this.document;
    }
}

