/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.emp.ide.plugin.editors.jsp.formatter;

import com.ecc.emp.ide.plugin.editors.jsp.formatter.XmlDocumentFormatter;
import java.util.LinkedList;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.formatter.ContextBasedFormattingStrategy;
import org.eclipse.jface.text.formatter.IFormattingContext;

public class XmlDocumentFormattingStrategy
extends ContextBasedFormattingStrategy {
    private final LinkedList fDocuments = new LinkedList();
    private int indent = -1;

    public XmlDocumentFormattingStrategy() {
    }

    public XmlDocumentFormattingStrategy(int indent) {
        this.indent = indent;
    }

    public void format() {
        super.format();
        IDocument document = (IDocument)this.fDocuments.removeFirst();
        if (document != null) {
            String documentText = document.get();
            XmlDocumentFormatter formatter = new XmlDocumentFormatter();
            if (this.indent != -1) {
                formatter.setInitialIndent(this.indent);
            }
            formatter.setDefaultLineDelimiter(TextUtilities.getDefaultLineDelimiter((IDocument)document));
            String formattedText = formatter.format(documentText);
            if (formattedText != null && !formattedText.equals(documentText)) {
                document.set(formattedText);
            }
        }
    }

    public void formatterStarts(IFormattingContext context) {
        super.formatterStarts(context);
        this.fDocuments.addLast(context.getProperty((Object)"formatting.context.medium"));
    }

    public void formatterStops() {
        super.formatterStops();
        this.fDocuments.clear();
    }
}

