/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.emp.ide.rule.debug;

import com.ecc.emp.ide.rule.debug.DebugRuleInfo;
import com.ecc.emp.ide.rule.debug.RuleDebugPage;
import com.ecc.shufflestudio.editor.RuleSetWrapper;
import com.ecc.shufflestudio.editor.param.Parameter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.util.Iterator;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;

public class RuleDebugWizard
extends Wizard {
    private RuleDebugPage ruleDebugPage = null;
    private DebugRuleInfo ruleInfo = null;
    private IProject project = null;
    private RuleSetWrapper ruleSet = null;

    public DebugRuleInfo getDebugBizInfo(IFile ruleFile) {
        this.project = ruleFile.getProject();
        try {
            ObjectInputStream in = new ObjectInputStream(ruleFile.getContents());
            this.ruleSet = (RuleSetWrapper)in.readObject();
        }
        catch (Exception in) {
            // empty catch block
        }
        if (this.ruleSet == null) {
            return null;
        }
        this.loadDebugRuleInfo();
        this.ruleDebugPage = new RuleDebugPage(this.project, this.ruleSet, this.ruleInfo);
        this.addPage((IWizardPage)this.ruleDebugPage);
        WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)this);
        int retValue = dialog.open();
        if (retValue == 0) {
            return this.ruleInfo;
        }
        return null;
    }

    public boolean performFinish() {
        this.ruleInfo = this.ruleDebugPage.getDebugRuleInfo();
        if (this.ruleInfo.testClassName == null || this.ruleInfo.testClassName.length() == 0) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)"\u63d0\u793a", (String)"\u8bf7\u9009\u62e9\u6d4b\u8bd5\u5b9e\u73b0\u7c7b\u540d\uff01");
            return false;
        }
        this.saveDebugRuleInfo();
        return true;
    }

    public boolean isSelfWizard() {
        return true;
    }

    public IWizardPage getNextPage(IWizardPage apage) {
        return null;
    }

    private void loadDebugRuleInfo() {
        String testClassName;
        this.ruleInfo = new DebugRuleInfo();
        Properties commonProp = this.getProperties("rule_run");
        if (commonProp == null) {
            MessageDialog.openError((Shell)this.getShell(), (String)"\u9519\u8bef", (String)"\u8def\u5f84\u914d\u7f6e\u4e0d\u6b63\u786e");
            return;
        }
        this.ruleInfo.testClassName = testClassName = commonProp.getProperty("class", DebugRuleInfo.defaultTestClass);
        this.ruleInfo.tempPath = this.getTempPath();
        this.ruleInfo.ruleSetId = this.ruleSet.getName();
        Properties ruleSetProp = this.getProperties(this.ruleSet.getName());
        if (ruleSetProp == null) {
            MessageDialog.openError((Shell)this.getShell(), (String)"\u9519\u8bef", (String)"\u8def\u5f84\u914d\u7f6e\u4e0d\u6b63\u786e");
            return;
        }
        int i = 0;
        while (i < this.ruleSet.getParamWrapper().getParamListSize()) {
            String key = this.ruleSet.getParamWrapper().getParamListValue(i).getName();
            String value = ruleSetProp.getProperty(key);
            if (value != null) {
                this.ruleInfo.paramValues.put(this.ruleSet.getParamWrapper().getParamListValue(i), value);
            }
            ++i;
        }
    }

    private void saveDebugRuleInfo() {
        Properties commonProp = new Properties();
        commonProp.setProperty("class", this.ruleInfo.testClassName);
        this.saveProperties(commonProp, "rule_run");
        Properties ruleSetProp = new Properties();
        Iterator it = this.ruleInfo.paramValues.keySet().iterator();
        while (it.hasNext()) {
            Parameter key = (Parameter)it.next();
            String value = (String)this.ruleInfo.paramValues.get(key);
            ruleSetProp.setProperty(key.getName(), value);
        }
        this.saveProperties(ruleSetProp, this.ruleInfo.ruleSetId);
    }

    private Properties getProperties(String name) {
        try {
            Properties properties = new Properties();
            File propertyFile = new File(String.valueOf(this.getTempPath()) + "\\" + name + ".properties");
            if (!propertyFile.exists()) {
                propertyFile.createNewFile();
            }
            properties.load(new FileInputStream(propertyFile));
            return properties;
        }
        catch (Exception e) {
            return null;
        }
    }

    private void saveProperties(Properties properties, String name) {
        try {
            File propertyFile = new File(String.valueOf(this.getTempPath()) + "\\" + name + ".properties");
            if (!propertyFile.exists()) {
                propertyFile.createNewFile();
            }
            FileOutputStream os = new FileOutputStream(propertyFile);
            properties.store(os, "");
            os.flush();
            os.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String getTempPath() {
        String str = String.valueOf(this.project.getLocation().toOSString()) + "\\designFiles\\.debug\\rules\\";
        File folder = new File(str);
        if (!folder.exists()) {
            folder.mkdirs();
        }
        return str;
    }
}

