/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.emp.ide.table;

import com.ecc.emp.ide.table.FieldWrapper;
import com.ecc.emp.ide.table.One2MultiWrapper;
import com.ecc.emp.ide.table.One2OneWrapper;
import com.ecc.ide.editor.XMLElementObjectMaker;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editorprofile.EditorProfile;
import com.ecc.ide.editorprofile.Element;
import com.ecc.ide.editorprofile.ElementAttribute;
import com.ecc.ide.editorprofile.ElementCatalog;
import com.ecc.ide.editorprofile.ProfileObjectMaker;
import com.ecc.util.xmlloader.ObjectMaker;
import com.ecc.util.xmlloader.XMLLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;

public class TableModelWrapper {
    private IFile modelFile = null;
    private XMLNode xmlNode = null;
    public String tableId = null;
    public String tableCnname = null;
    public String dbTableName = null;
    public boolean isPaged = false;
    public int pageSize = 10;
    public boolean workFlow = false;
    public boolean isPrimaryTable = false;
    public String relatedField = null;
    public String primaryRelatedField = null;
    public String primaryTableName = null;
    public boolean commitWay = false;
    public String tableInfo = "";
    public List conditionFields = new ArrayList();
    public String filterFieldStr = "";
    public List filterFields = new ArrayList();
    public Map recordRestrict = new HashMap();
    public String orderFieldStr = "";
    public String orderString = "";
    private List fieldsList = new ArrayList();
    private List one2oneList = new ArrayList();
    private List one2multiList = new ArrayList();

    private TableModelWrapper(IFile modelFile) {
        this.modelFile = modelFile;
    }

    private TableModelWrapper(XMLNode xmlNode) {
        this.xmlNode = xmlNode;
    }

    public static TableModelWrapper getModelWraInstance(IFile modelFile) throws Exception {
        TableModelWrapper wrapper = new TableModelWrapper(modelFile);
        wrapper.initial();
        return wrapper;
    }

    private void initial() throws Exception {
        XMLNode one2MultiNode;
        XMLNode restrictNode;
        String orderStr;
        String filter;
        int i;
        String[] array;
        String conFilds;
        if (this.xmlNode == null) {
            this.xmlNode = this.loadXMLContent(this.modelFile.getLocation().toOSString());
        }
        XMLNode tableModelNode = this.xmlNode.getChild("TableModel");
        this.tableId = tableModelNode.getAttrValue("id");
        this.tableCnname = tableModelNode.getAttrValue("cnname");
        this.dbTableName = tableModelNode.getAttrValue("dbTableName");
        String wFlow = tableModelNode.getAttrValue("workFlow");
        this.workFlow = "true".equals(wFlow);
        String isp = tableModelNode.getAttrValue("isPaged");
        this.isPaged = "true".equals(isp);
        try {
            this.pageSize = Integer.parseInt(tableModelNode.getAttrValue("pageSize"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        XMLNode aNode = tableModelNode.findChild("TableInfo");
        if (aNode != null && aNode.getChild("#text") != null) {
            this.tableInfo = aNode.getChild("#text").getTextValue();
        }
        if ((aNode = tableModelNode.findChild("ConditionFields")) != null && aNode.getChild("#text") != null && (conFilds = aNode.getChild("#text").getTextValue()) != null && conFilds.trim().length() > 0) {
            array = conFilds.split(";");
            i = 0;
            while (i < array.length) {
                this.conditionFields.add(array[i]);
                ++i;
            }
        }
        if ((aNode = tableModelNode.findChild("FilterFields")) != null && aNode.getChild("#text") != null && (filter = aNode.getChild("#text").getTextValue()) != null && filter.trim().length() > 0) {
            this.filterFieldStr = filter;
            array = filter.split(";");
            i = 0;
            while (i < array.length) {
                this.filterFields.add(array[i]);
                ++i;
            }
        }
        if ((aNode = tableModelNode.findChild("OrderFields")) != null && aNode.getChild("#text") != null && (orderStr = aNode.getChild("#text").getTextValue()) != null && orderStr.trim().length() > 0) {
            this.orderFieldStr = orderStr;
            array = orderStr.split(";");
            this.orderString = "order by ";
            i = 0;
            while (i < array.length) {
                String id = "";
                String con = "";
                int x = array[i].indexOf("[");
                if (x != -1) {
                    id = array[i].substring(0, array[i].indexOf("["));
                    con = array[i].substring(array[i].indexOf("[") + 1, array[i].lastIndexOf("]"));
                    this.orderString = String.valueOf(this.orderString) + id + " " + con + ",";
                } else {
                    id = array[i];
                    this.orderString = String.valueOf(this.orderString) + id + " desc,";
                }
                ++i;
            }
            this.orderString = this.orderString.substring(0, this.orderString.lastIndexOf(",")).trim();
        }
        if ((restrictNode = tableModelNode.findChild("RecordRestrict")) != null) {
            String query = restrictNode.getAttrValue("query");
            String delete = restrictNode.getAttrValue("delete");
            String update = restrictNode.getAttrValue("update");
            if ("true".equals(query)) {
                this.recordRestrict.put("query", "true");
            } else {
                this.recordRestrict.put("query", "false");
            }
            if ("true".equals(delete)) {
                this.recordRestrict.put("delete", "true");
            } else {
                this.recordRestrict.put("delete", "false");
            }
            if ("true".equals(update)) {
                this.recordRestrict.put("update", "true");
            } else {
                this.recordRestrict.put("update", "false");
            }
        }
        this.isPrimaryTable = true;
        this.fieldsList = this.parseFieldNode(this.xmlNode);
        XMLNode One2OneNode = tableModelNode.getChild("One2OneRef");
        if (One2OneNode != null) {
            this.parseOne2OneNode();
        }
        if ((one2MultiNode = tableModelNode.getChild("One2MultiRef")) != null) {
            this.parseOne2MultiNode();
        }
        int i2 = 0;
        while (i2 < this.conditionFields.size()) {
            String conField = (String)this.conditionFields.get(i2);
            if (conField.startsWith("*")) {
                conField = conField.substring(1);
                this.conditionFields.set(i2, conField);
                FieldWrapper conFieldWra = this.getFieldById(conField);
                conFieldWra.setInterzoneCon(true);
            }
            ++i2;
        }
    }

    public List parseFieldNode(XMLNode node) {
        Vector fieldNodeList = node.findChild("TableModel").getChilds();
        String tableModelName = this.xmlNode.getChild("TableModel").getAttrValue("id");
        String one2one2ModelName = node.getChild("TableModel").getAttrValue("id");
        ArrayList<FieldWrapper> list = new ArrayList<FieldWrapper>();
        int i = 0;
        while (i < fieldNodeList.size()) {
            XMLNode fieldNode = (XMLNode)fieldNodeList.get(i);
            if (fieldNode.getNodeName().equals("Field")) {
                String JSPTag;
                String isPk;
                String columnName;
                FieldWrapper fieldWra = new FieldWrapper();
                fieldWra.tableModelName = tableModelName;
                String id = fieldNode.getAttrValue("id");
                if (id != null && this.isPrimaryTable) {
                    fieldWra.id = id;
                } else if (id != null && !this.isPrimaryTable) {
                    fieldWra.id = String.valueOf(one2one2ModelName) + "." + id;
                }
                String cnname = fieldNode.getAttrValue("cnname");
                if (cnname != null) {
                    fieldWra.cnname = cnname;
                }
                if ((columnName = fieldNode.getAttrValue("columnName")) != null) {
                    fieldWra.columnName = columnName;
                }
                if ((isPk = fieldNode.getAttrValue("isPK")) != null && isPk.equals("true")) {
                    fieldWra.isPK = true;
                    String pkGen = fieldNode.getAttrValue("pkGenerator");
                    fieldWra.pkGenerator = pkGen != null && pkGen.trim().length() > 0;
                } else {
                    fieldWra.isPK = false;
                }
                String canBeNull = fieldNode.getAttrValue("canBeNull");
                fieldWra.canBeNull = canBeNull != null && canBeNull.equals("true");
                String length = fieldNode.getAttrValue("length");
                if (length != null) {
                    fieldWra.length = Integer.valueOf(length);
                }
                if ((JSPTag = fieldNode.getAttrValue("JSPTag")) != null) {
                    Vector attrList;
                    Element element;
                    ElementCatalog catalog;
                    fieldWra.JSPTag = JSPTag;
                    IProject project = this.modelFile.getProject();
                    String filePath = project.getLocation() + "/designFiles/commons/ModelTagProfile.xml";
                    XMLLoader loader = new XMLLoader();
                    loader.addObjectMaker((ObjectMaker)new ProfileObjectMaker());
                    EditorProfile modelTagProfile = null;
                    try {
                        modelTagProfile = (EditorProfile)loader.loadXMLFile(filePath);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (modelTagProfile != null && (catalog = modelTagProfile.getElementCatalog("JspTagConfigure")) != null && (element = catalog.getElement(JSPTag)) != null && (attrList = element.getAttributes()) != null) {
                        int j = 0;
                        while (j < attrList.size()) {
                            ElementAttribute attr = (ElementAttribute)attrList.get(j);
                            String attrId = attr.getAttrID();
                            String attrValue = fieldNode.getAttrValue(attrId);
                            if (attrId.equals("dictname")) {
                                if (attrValue == null) {
                                    attrValue = fieldNode.getAttrValue("dict");
                                }
                                if (attrValue != null) {
                                    int x = attrValue.indexOf("[");
                                    if (x == -1) {
                                        fieldWra.extAttrMap.put(attrId, attrValue);
                                    } else {
                                        fieldWra.extAttrMap.put(attrId, attrValue.substring(0, x));
                                        String defaultStr = attrValue.substring(x + 1, attrValue.lastIndexOf("]"));
                                        fieldWra.extAttrMap.put("defvalue", defaultStr.substring(0, defaultStr.indexOf("=")));
                                    }
                                }
                            } else if (attrValue != null && attrValue.trim().length() > 0) {
                                fieldWra.extAttrMap.put(attrId, attrValue);
                            }
                            ++j;
                        }
                    }
                }
                list.add(fieldWra);
            }
            ++i;
        }
        return list;
    }

    private void parseOne2OneNode() throws Exception {
        Vector childsNode = this.xmlNode.findChild("TableModel").getChilds();
        int i = 0;
        while (i < childsNode.size()) {
            XMLNode node = (XMLNode)childsNode.get(i);
            if (node.getNodeName().equals("One2OneRef")) {
                List list;
                String toField;
                String fromField;
                One2OneWrapper one2oneWra = new One2OneWrapper();
                String refModelId = node.getAttrValue("refModelId");
                if (refModelId != null) {
                    one2oneWra.refModelId = refModelId;
                }
                if ((fromField = node.getAttrValue("fromField")) != null) {
                    one2oneWra.fromField = fromField;
                }
                if ((toField = node.getAttrValue("toField")) != null) {
                    one2oneWra.toField = toField;
                }
                IFile refModelFile = TableModelWrapper.searchRefModel((IResource)this.modelFile.getParent(), refModelId);
                XMLNode one2oneTableNode = this.loadXMLContent(refModelFile.getLocation().toOSString());
                this.isPrimaryTable = false;
                one2oneWra.fieldsList = list = this.parseFieldNode(one2oneTableNode);
                this.one2oneList.add(one2oneWra);
            }
            ++i;
        }
        i = 0;
        while (i < this.one2oneList.size()) {
            One2OneWrapper one2oneWra = (One2OneWrapper)this.one2oneList.get(i);
            FieldWrapper field_1 = this.getFieldById(one2oneWra.fromField);
            FieldWrapper field_2 = this.getFieldById(String.valueOf(one2oneWra.refModelId) + "." + one2oneWra.toField);
            if (field_1 != null && field_2 != null && field_1.isPK() && field_2.isPK()) {
                one2oneWra.primaryKeyRelated = true;
            }
            ++i;
        }
    }

    private void parseOne2MultiNode() throws Exception {
        Vector childsNode = this.xmlNode.findChild("TableModel").getChilds();
        int i = 0;
        while (i < childsNode.size()) {
            XMLNode node = (XMLNode)childsNode.get(i);
            if (node.getNodeName().equals("One2MultiRef")) {
                List list;
                String toField;
                String fromField;
                One2MultiWrapper one2multiWra = new One2MultiWrapper();
                String refModelId = node.getAttrValue("refModelId");
                if (refModelId != null) {
                    one2multiWra.refModelId = refModelId;
                }
                if ((fromField = node.getAttrValue("fromField")) != null) {
                    one2multiWra.fromField = fromField;
                }
                if ((toField = node.getAttrValue("toField")) != null) {
                    one2multiWra.toField = toField;
                }
                IFile refModelFile = TableModelWrapper.searchRefModel((IResource)this.modelFile.getParent(), refModelId);
                String subPath = refModelFile.getParent().getLocation().toString();
                one2multiWra.subPath = subPath = subPath.substring(subPath.indexOf("designFiles/tables/") + "designFiles/tables/".length());
                XMLNode one2multiTableNode = this.loadXMLContent(refModelFile.getLocation().toOSString());
                this.isPrimaryTable = false;
                one2multiWra.fieldsList = list = this.parseFieldNode(one2multiTableNode);
                Vector childs = one2multiTableNode.getChild("TableModel").getChilds();
                int j = 0;
                while (j < childs.size()) {
                    XMLNode aNode = (XMLNode)childs.get(j);
                    if ("One2OneRef".equals(aNode.getNodeName())) {
                        one2multiTableNode.getChild("TableModel").remove(aNode);
                    } else if ("One2MultiRef".equals(aNode.getNodeName())) {
                        one2multiTableNode.getChild("TableModel").remove(aNode);
                    }
                    ++j;
                }
                TableModelWrapper childModel = new TableModelWrapper(one2multiTableNode);
                childModel.setModelFile(refModelFile);
                childModel.initial();
                childModel.setRelatedField(one2multiWra.toField);
                childModel.setPrimaryRelatedField(one2multiWra.fromField);
                childModel.setPrimaryTableName(this.tableId);
                one2multiWra.setModelWra(childModel);
                this.one2multiList.add(one2multiWra);
            }
            ++i;
        }
        i = 0;
        while (i < this.one2multiList.size()) {
            One2MultiWrapper one2multiWra = (One2MultiWrapper)this.one2multiList.get(i);
            FieldWrapper field_1 = this.getFieldById(one2multiWra.fromField);
            FieldWrapper field_2 = this.getFieldById(String.valueOf(one2multiWra.refModelId) + "." + one2multiWra.toField);
            if (field_1 != null && field_2 != null && field_1.isPK() && field_2.isPK()) {
                one2multiWra.primaryKeyRelated = true;
            }
            ++i;
        }
    }

    public static IFile searchRefModel(IResource parent, String refModelId) {
        if (!(parent instanceof IFolder)) {
            return null;
        }
        IFolder pFolder = (IFolder)parent;
        if ("tables".equals(pFolder.getName())) {
            return TableModelWrapper.searchRefModel2((IResource)pFolder, refModelId);
        }
        IResource res = pFolder.findMember(String.valueOf(refModelId) + ".table");
        if (res == null) {
            res = TableModelWrapper.searchRefModel((IResource)pFolder.getParent(), refModelId);
        }
        return (IFile)res;
    }

    private static IFile searchRefModel2(IResource parent, String refModelId) {
        if (!(parent instanceof IFolder)) {
            return null;
        }
        IFolder pFolder = (IFolder)parent;
        IResource res = pFolder.findMember(String.valueOf(refModelId) + ".table");
        if (res != null) {
            return (IFile)res;
        }
        try {
            IResource[] resources = pFolder.members();
            int i = 0;
            while (i < resources.length) {
                IFile retFile;
                if (resources[i] instanceof IFolder && (retFile = TableModelWrapper.searchRefModel2(resources[i], refModelId)) != null) {
                    return retFile;
                }
                ++i;
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return null;
    }

    public XMLNode loadXMLContent(String file) throws Exception {
        XMLLoader xmlLoader = new XMLLoader();
        xmlLoader.addObjectMaker((ObjectMaker)new XMLElementObjectMaker());
        XMLNode node = (XMLNode)xmlLoader.loadXMLFile(file);
        return node;
    }

    public String getDbTableName() {
        return this.dbTableName;
    }

    public List getFieldsList() {
        return this.fieldsList;
    }

    public Map getRecordRestrict() {
        return this.recordRestrict;
    }

    public String getTableCnname() {
        if (this.tableCnname == null) {
            return "";
        }
        return this.tableCnname;
    }

    public String getTableId() {
        return this.tableId;
    }

    public XMLNode getXmlNode() {
        return this.xmlNode;
    }

    public List getOne2multiList() {
        return this.one2multiList;
    }

    public List getOne2oneList() {
        return this.one2oneList;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public boolean isPaged() {
        return this.isPaged;
    }

    public IFile getModelFile() {
        return this.modelFile;
    }

    public List getConditionFields() {
        return this.conditionFields;
    }

    public List getFilterFields() {
        return this.filterFields;
    }

    public boolean getRecordRestrict(String key) {
        String value = (String)this.recordRestrict.get(key);
        return "true".equals(value);
    }

    public String getTableInfo() {
        if (this.tableInfo == null) {
            return "";
        }
        return this.tableInfo;
    }

    public int getFilterFieldsSize() {
        return this.filterFields.size();
    }

    public int getConditionFieldsSize() {
        return this.conditionFields.size();
    }

    public List getPks() {
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        while (i < this.fieldsList.size()) {
            FieldWrapper fieldWra = (FieldWrapper)this.fieldsList.get(i);
            if (fieldWra.isPK()) {
                list.add(fieldWra.getId());
            }
            ++i;
        }
        return list;
    }

    public String getPkString() {
        String pkString = "";
        int i = 0;
        while (i < this.fieldsList.size()) {
            FieldWrapper fieldWra = (FieldWrapper)this.fieldsList.get(i);
            if (fieldWra.isPK()) {
                pkString = String.valueOf(pkString) + "'" + fieldWra.getId() + "',";
            }
            ++i;
        }
        pkString = pkString.substring(0, pkString.lastIndexOf(","));
        return pkString;
    }

    public FieldWrapper getFieldById(String id) {
        FieldWrapper fieldWra;
        int j;
        List fieldsList;
        FieldWrapper wra = null;
        int i = 0;
        while (i < this.fieldsList.size()) {
            FieldWrapper fieldWra2 = (FieldWrapper)this.fieldsList.get(i);
            if (id.equals(fieldWra2.getId())) {
                wra = fieldWra2;
                break;
            }
            ++i;
        }
        if (wra == null && this.one2oneList.size() > 0) {
            i = 0;
            while (i < this.one2oneList.size()) {
                One2OneWrapper one2oneWra = (One2OneWrapper)this.one2oneList.get(i);
                fieldsList = one2oneWra.getFieldsList();
                j = 0;
                while (j < fieldsList.size()) {
                    fieldWra = (FieldWrapper)fieldsList.get(j);
                    if (id.equals(fieldWra.getId())) {
                        wra = fieldWra;
                        break;
                    }
                    ++j;
                }
                if (wra != null) break;
                ++i;
            }
        }
        if (wra == null && this.one2multiList.size() > 0) {
            i = 0;
            while (i < this.one2multiList.size()) {
                One2MultiWrapper one2multiWra = (One2MultiWrapper)this.one2multiList.get(i);
                fieldsList = one2multiWra.getFieldsList();
                j = 0;
                while (j < fieldsList.size()) {
                    fieldWra = (FieldWrapper)fieldsList.get(j);
                    if (id.equals(fieldWra.getId())) {
                        wra = fieldWra;
                        break;
                    }
                    ++j;
                }
                if (wra != null) break;
                ++i;
            }
        }
        return wra;
    }

    public String getRelatedField() {
        return this.relatedField;
    }

    public void setRelatedField(String relatedField) {
        this.relatedField = relatedField;
    }

    public String getPrimaryRelatedField() {
        return this.primaryRelatedField;
    }

    public void setPrimaryRelatedField(String primaryRelatedField) {
        this.primaryRelatedField = primaryRelatedField;
    }

    public String getPrimaryTableName() {
        return this.primaryTableName;
    }

    public void setPrimaryTableName(String primaryTableName) {
        this.primaryTableName = primaryTableName;
    }

    public String getOrderString() {
        return this.orderString;
    }

    public void setOrderString(String orderString) {
        this.orderString = orderString;
    }

    public boolean isFK4one2one(FieldWrapper fieldWra) {
        if (fieldWra.isPK()) {
            return false;
        }
        String id = fieldWra.getId();
        int i = 0;
        while (i < this.one2oneList.size()) {
            One2OneWrapper oneWra = (One2OneWrapper)this.one2oneList.get(i);
            String fromField = oneWra.getFromField();
            if (id.equals(fromField)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isCommitWay() {
        return this.commitWay;
    }

    public void setCommitWay(String commitWay) {
        this.commitWay = "true".equals(commitWay);
    }

    public void setChildTableName2Field() {
        int i = 0;
        while (i < this.one2multiList.size()) {
            One2MultiWrapper one2multiWra = (One2MultiWrapper)this.one2multiList.get(i);
            TableModelWrapper childModel = one2multiWra.getModelWra();
            int k = 0;
            while (k < childModel.fieldsList.size()) {
                FieldWrapper fieldWra = (FieldWrapper)childModel.fieldsList.get(k);
                fieldWra.setPrimaryTableName(this.tableId);
                ++k;
            }
            ++i;
        }
    }

    public List getPKOutFilter() {
        ArrayList<FieldWrapper> returnList = new ArrayList<FieldWrapper>();
        List pkList = this.getPks();
        if (this.filterFields.size() <= 0 || pkList.size() <= 0) {
            return returnList;
        }
        int i = 0;
        while (i < pkList.size()) {
            String pk = (String)pkList.get(i);
            String returnPk = null;
            int j = 0;
            while (j < this.filterFields.size()) {
                String filter = (String)this.filterFields.get(j);
                if (pk.equals(filter)) {
                    returnPk = pk;
                    break;
                }
                ++j;
            }
            if (returnPk == null) {
                FieldWrapper pkWra = this.getFieldById(pk);
                returnList.add(pkWra);
            }
            ++i;
        }
        return returnList;
    }

    public boolean isWorkFlow() {
        return this.workFlow;
    }

    public void setWorkFlow(boolean workFlow) {
        this.workFlow = workFlow;
    }

    public String getFilterFieldStr() {
        return this.filterFieldStr;
    }

    public String getOrderFieldStr() {
        return this.orderFieldStr;
    }

    private void setModelFile(IFile file) {
        this.modelFile = file;
    }
}

