/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.emp.ide.table.upgrade;

import com.ecc.emp.ide.table.upgrade.ExtendPropEditDialog;
import com.ecc.ide.base.IDEContent;
import com.ecc.ide.plugin.properties.IDEProjectSettings;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class DictionarySelectDialog
extends ExtendPropEditDialog {
    private String type;
    private String defaultItem;
    private static ArrayList dictList;
    private ArrayList dataList;
    private List rightList;
    private List leftList;

    protected void doWhileOkPressed() {
        String type = this.getType();
        if (type != null) {
            String defaultItem = this.getDefaultItem();
            if (defaultItem == null) {
                defaultItem = "";
            }
            this.returnValue = String.valueOf(type) + defaultItem;
        }
    }

    public DictionarySelectDialog(Shell parentShell, IProject prj) {
        super(parentShell, prj);
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        this.setTitle("\u6570\u636e\u5b57\u5178\u9009\u62e9");
        this.setMessage("\u9009\u62e9\u6570\u636e\u5b57\u5178\u9879,\u53f3\u4fa7\u9009\u4e2d\u53ef\u4ee5\u8bbe\u4e3adefault\u9009\u9879\uff0c\u9ed8\u8ba4\u4e3a\"\"");
        Composite root = new Composite(area, 0);
        root.setLayout((Layout)new GridLayout(1, true));
        root.setLayoutData((Object)new GridData(1808));
        Label labelfilter = new Label(root, 0);
        labelfilter.setText("\u6839\u636e\u5b57\u5178\u6570\u636e\u8fc7\u6ee4\u5b57\u5178\u9879");
        Text textfilter = new Text(root, 2048);
        textfilter.setLayoutData((Object)new GridData(768));
        textfilter.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DictionarySelectDialog.this.patternChanged((Text)e.widget);
            }
        });
        textfilter.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000002) {
                    DictionarySelectDialog.this.leftList.setFocus();
                }
            }
        });
        Composite container = new Composite(root, 0);
        container.setLayout((Layout)new GridLayout(2, true));
        container.setLayoutData((Object)new GridData(1808));
        Label label = new Label(container, 0);
        label.setText("\u5b57\u5178\u9879");
        Label label_1 = new Label(container, 0);
        label_1.setText("\u5b57\u5178\u6570\u636e");
        this.leftList = new List(container, 2820);
        GridData gd_leftList = new GridData(4, 4, true, true);
        this.leftList.setLayoutData((Object)gd_leftList);
        this.leftList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                List list = (List)e.getSource();
                if (list.getSelection() != null) {
                    DictionarySelectDialog.this.rightList.removeAll();
                    String type = list.getSelection()[0];
                    int x = type.indexOf("(");
                    if (x != -1) {
                        type = type.substring(0, x);
                    }
                    Map dataMap = (Map)list.getData(type);
                    DictionarySelectDialog.this.rightList.add("");
                    DictionarySelectDialog.this.rightList.setData((Object)dataMap);
                    Iterator iterator = dataMap.keySet().iterator();
                    while (iterator.hasNext()) {
                        String cnname = (String)iterator.next();
                        DictionarySelectDialog.this.rightList.add(cnname);
                    }
                }
            }
        });
        this.rightList = new List(container, 2820);
        GridData gd_rightList = new GridData(4, 4, true, true);
        this.rightList.setLayoutData((Object)gd_rightList);
        this.initData(this.leftList);
        return area;
    }

    private void patternChanged(Text text) {
        String value = text.getText();
        this.leftList.removeAll();
        this.rightList.removeAll();
        if (value.length() > 0) {
            int i = 0;
            while (i < dictList.size()) {
                DictType dictType = (DictType)dictList.get(i);
                if (dictType.cnname.indexOf(value) != -1) {
                    boolean exist = false;
                    int j = 0;
                    while (j < this.leftList.getItemCount()) {
                        if (this.leftList.getItem(j).equals(String.valueOf(dictType.type) + dictType.memo)) {
                            exist = true;
                            break;
                        }
                        ++j;
                    }
                    if (!exist) {
                        this.leftList.add(String.valueOf(dictType.type) + dictType.memo);
                    }
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.dataList.size()) {
                this.leftList.add((String)this.dataList.get(i));
                ++i;
            }
        }
    }

    protected void initData(List list) {
        if (dictList == null) {
            dictList = new ArrayList();
            IProject currentProject = IDEContent.getCurrentProject();
            IDEProjectSettings settings = IDEContent.getPRJSettings(currentProject);
            String driverName = settings.getSettingsNode().findChild("driverName").getNodeValue();
            String dbURL = settings.getSettingsNode().findChild("dbURL").getNodeValue();
            String userId = settings.getSettingsNode().findChild("userName").getNodeValue();
            String password = settings.getSettingsNode().findChild("password").getNodeValue();
            try {
                Class<?> aclass = Class.forName(driverName);
                Driver driver = (Driver)aclass.newInstance();
                DriverManager.registerDriver(driver);
                Connection connection = DriverManager.getConnection(dbURL, userId, password);
                Statement statement = connection.createStatement();
                ResultSet result = statement.executeQuery("select count(*) from S_DIC");
                result = statement.executeQuery("select ENNAME,OPTTYPE,CNNAME,MEMO from S_DIC order by OPTTYPE,CNNAME");
                while (result.next()) {
                    DictType dictType = new DictType();
                    dictType.enname = result.getString("ENNAME");
                    dictType.type = result.getString("OPTTYPE");
                    dictType.memo = result.getString("MEMO") == null ? "" : "( " + result.getString("MEMO") + " )";
                    dictType.cnname = result.getString("CNNAME");
                    dictList.add(dictType);
                }
                result.close();
                statement.close();
                connection.close();
            }
            catch (Exception e) {
                final String s = e.toString();
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        MessageDialog.openError((Shell)DictionarySelectDialog.this.getShell(), (String)"ERROR", (String)("DB Connection failed:" + s));
                    }
                });
                e.printStackTrace();
            }
        }
        this.dataList = new ArrayList();
        int i = 0;
        while (i < dictList.size()) {
            DictType dictType = (DictType)dictList.get(i);
            if (list.getData(dictType.type) == null) {
                list.add(String.valueOf(dictType.type) + dictType.memo);
                this.dataList.add(String.valueOf(dictType.type) + dictType.memo);
                list.setData(dictType.type, new HashMap());
            }
            Map dataMap = (Map)list.getData(dictType.type);
            dataMap.put(dictType.cnname, dictType.enname);
            ++i;
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void okPressed() {
        String cnname;
        if (this.leftList.getSelectionIndex() >= 0) {
            String dicStr = this.leftList.getSelection()[0];
            int x = dicStr.indexOf("(");
            if (x != -1) {
                dicStr = dicStr.substring(0, x);
            }
            this.setType(dicStr);
        }
        if (this.rightList.getSelectionIndex() >= 0 && (cnname = this.rightList.getSelection()[0]) != null && cnname.trim().length() > 0) {
            Map map = (Map)this.rightList.getData();
            String enname = (String)map.get(cnname);
            String defaultItem = "[" + enname + "=" + cnname + "]";
            this.setDefaultItem(defaultItem);
        }
        super.okPressed();
    }

    protected Point getInitialSize() {
        return new Point(600, 375);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("\u6570\u636e\u5b57\u5178");
    }

    public String getType() {
        return this.type;
    }

    public String getDefaultItem() {
        return this.defaultItem;
    }

    public void setDefaultItem(String defaultItem) {
        this.defaultItem = defaultItem;
    }

    public void setType(String type) {
        this.type = type;
    }

    class DictType {
        String enname;
        String type;
        String memo;
        String cnname;

        DictType() {
        }
    }
}

