/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.emp.ide.table.upgrade;

import com.ecc.emp.ide.table.upgrade.RefFieldSelectComp;
import com.ecc.ide.base.IDEContent;
import com.ecc.ide.editor.XMLElementObjectMaker;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.plugin.properties.IDEProjectSettings;
import com.ecc.util.xmlloader.ObjectMaker;
import com.ecc.util.xmlloader.XMLLoader;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class RefFieldSelectDialog
extends TitleAreaDialog {
    private RefFieldSelectComp comp = null;
    private XMLNode masterNode = null;
    private XMLNode servantNode = null;
    private XMLNode refNode = null;
    private IProject project = null;

    public RefFieldSelectDialog(XMLNode mModel, IProject project, Shell parentShell) {
        super(parentShell);
        this.masterNode = mModel;
        this.project = project;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle("\u5173\u8054\u5b57\u6bb5\u4fee\u6539");
        this.comp = new RefFieldSelectComp(this.masterNode, parent, 0);
        this.comp.setLayoutData(new GridData(4, 4, true, true));
        this.comp.setServantModel(this.servantNode);
        this.comp.setFromToField(this.refNode.getAttrValue("fromField"), this.refNode.getAttrValue("toField"));
        return this.comp;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Point getInitialSize() {
        return new Point(600, 400);
    }

    public void setServantModel(String servantId) {
        try {
            IDEProjectSettings settings = IDEContent.getPRJSettings(this.project);
            String webContentPath = settings.getWebContentPath();
            IFolder tablesForder = this.project.getFolder(String.valueOf(webContentPath) + "\\WEB-INF\\tables");
            IFile sFile = tablesForder.getFile(String.valueOf(servantId) + ".xml");
            XMLLoader loader = new XMLLoader();
            loader.addObjectMaker((ObjectMaker)new XMLElementObjectMaker());
            XMLNode sModel = (XMLNode)loader.loadXMLFile(sFile.getLocation().toOSString());
            this.servantNode = sModel.getChild("TableModel");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setRefNode(XMLNode refNode) {
        this.refNode = refNode;
    }

    protected void okPressed() {
        this.refNode.setAttrValue("fromField", this.comp.getFromField());
        this.refNode.setAttrValue("toField", this.comp.getToField());
        super.okPressed();
    }
}

