/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.emp.ide.table.upgrade;

import com.ecc.ide.editor.XMLElementObjectMaker;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.plugin.ECCIDEPlugin;
import com.ecc.util.xmlloader.ObjectMaker;
import com.ecc.util.xmlloader.XMLLoader;
import com.swtdesigner.ResourceManager;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;

public class RefModelSelectPage
extends WizardPage {
    private Text infoText;
    private Text dbTableText;
    private Text cnnameText;
    private Text idText;
    private Tree tree;
    private IProject project = null;
    private XMLLoader xmlLoader = null;
    private XMLNode selectModel = null;

    public RefModelSelectPage(IProject project) {
        super("wizardPage");
        this.setTitle("Wizard Page title");
        this.setDescription("Wizard Page description");
        this.project = project;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(2, true));
        this.setControl((Control)container);
        final TreeViewer treeViewer = new TreeViewer(container, 2048);
        this.tree = treeViewer.getTree();
        this.tree.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite composite = new Composite(container, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite.setLayout((Layout)gridLayout);
        Label label = new Label(composite, 0);
        label.setText("\u6a21\u578bID\uff1a");
        this.idText = new Text(composite, 2048);
        GridData gd_idText = new GridData(4, 0x1000000, true, false);
        this.idText.setLayoutData((Object)gd_idText);
        Label label_1 = new Label(composite, 0);
        label_1.setText("\u4e2d\u6587\u540d\u79f0\uff1a");
        this.cnnameText = new Text(composite, 2048);
        GridData gd_cnnameText = new GridData(4, 0x1000000, true, false);
        this.cnnameText.setLayoutData((Object)gd_cnnameText);
        Label label_2 = new Label(composite, 0);
        label_2.setText("\u7269\u7406\u8868\u540d\uff1a");
        this.dbTableText = new Text(composite, 2048);
        GridData gd_dbTableText = new GridData(4, 0x1000000, true, false);
        this.dbTableText.setLayoutData((Object)gd_dbTableText);
        Label label_3 = new Label(composite, 0);
        label_3.setLayoutData((Object)new GridData(16384, 128, false, false));
        label_3.setText("\u63cf\u8ff0\u540d\u79f0\uff1a");
        this.infoText = new Text(composite, 2048);
        GridData gd_infoText = new GridData(4, 0x1000000, true, false);
        gd_infoText.heightHint = 99;
        this.infoText.setLayoutData((Object)gd_infoText);
        treeViewer.setContentProvider((IContentProvider)new TreeContentProvider());
        treeViewer.setLabelProvider((IBaseLabelProvider)new TreeLabelProvider());
        treeViewer.setInput((Object)this.project);
        treeViewer.expandAll();
        treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selections = (IStructuredSelection)treeViewer.getSelection();
                Object obj = selections.getFirstElement();
                if (obj == null || !(obj instanceof IFile)) {
                    RefModelSelectPage.this.idText.setText("");
                    RefModelSelectPage.this.cnnameText.setText("");
                    RefModelSelectPage.this.dbTableText.setText("");
                    RefModelSelectPage.this.infoText.setText("");
                    RefModelSelectPage.this.selectModel = null;
                    return;
                }
                IFile file = (IFile)obj;
                file.getLocation().toOSString();
                XMLNode modelNode = RefModelSelectPage.this.loadXMLContent(file.getLocation().toOSString());
                if (modelNode == null || modelNode.getChild("TableModel") == null) {
                    RefModelSelectPage.this.idText.setText("");
                    RefModelSelectPage.this.cnnameText.setText("");
                    RefModelSelectPage.this.dbTableText.setText("");
                    RefModelSelectPage.this.infoText.setText("");
                    RefModelSelectPage.this.selectModel = null;
                    return;
                }
                modelNode = modelNode.getChild("TableModel");
                RefModelSelectPage.this.selectModel = modelNode;
                RefModelSelectPage.this.idText.setText(String.valueOf(modelNode.getAttrValue("id")));
                RefModelSelectPage.this.cnnameText.setText(String.valueOf(modelNode.getAttrValue("cnname")));
                RefModelSelectPage.this.dbTableText.setText(String.valueOf(modelNode.getAttrValue("dbTableName")));
                try {
                    RefModelSelectPage.this.infoText.setText(modelNode.getChild("TableInfo").getChild("#text").getTextValue());
                }
                catch (Exception e) {
                    RefModelSelectPage.this.infoText.setText("");
                }
            }
        });
    }

    private XMLNode loadXMLContent(String filePath) {
        if (this.xmlLoader == null) {
            this.xmlLoader = new XMLLoader();
            this.xmlLoader.addObjectMaker((ObjectMaker)new XMLElementObjectMaker());
        }
        try {
            return (XMLNode)this.xmlLoader.loadXMLFile(filePath);
        }
        catch (Exception e) {
            return null;
        }
    }

    public XMLNode getSelectModel() {
        return this.selectModel;
    }

    public void setWizardType(String wizardType) {
        if ("One2OneRef".equals(wizardType)) {
            this.setTitle("\u4ece\u8868\u9009\u62e9");
            this.setDescription("\u8bf7\u9009\u62e9\u9700\u8981\u5173\u8054\u7684\u4ece\u8868\uff1a1-1\u5173\u8054");
        } else if ("One2MultiRef".equals(wizardType)) {
            this.setTitle("\u5b50\u8868\u9009\u62e9");
            this.setDescription("\u8bf7\u9009\u62e9\u9700\u8981\u5173\u8054\u7684\u5b50\u8868\uff1a1-n\u5173\u8054");
        }
    }

    class TreeLabelProvider
    extends LabelProvider {
        TreeLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof IFile) {
                return ((IFile)element).getName();
            }
            if (element instanceof IFolder) {
                return ((IFolder)element).getName();
            }
            return super.getText(element);
        }

        public Image getImage(Object element) {
            if (element instanceof IFile) {
                return ResourceManager.getPluginImage((Object)ECCIDEPlugin.getDefault(), "icons/tablemodel/table.gif");
            }
            if (element instanceof IFolder) {
                return ResourceManager.getPluginImage((Object)ECCIDEPlugin.getDefault(), "icons/tablemodel/folder.gif");
            }
            return super.getImage(element);
        }
    }

    class TreeContentProvider
    implements IStructuredContentProvider,
    ITreeContentProvider {
        TreeContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof IProject) {
                IProject project = (IProject)inputElement;
                IFolder folder = project.getFolder("designFiles/tables");
                return new Object[]{folder};
            }
            if (inputElement instanceof IFolder) {
                IFolder folder = (IFolder)inputElement;
                try {
                    ArrayList<IResource> retObjs = new ArrayList<IResource>();
                    IResource[] res = folder.members();
                    int i = 0;
                    while (i < res.length) {
                        if (res[i] instanceof IFolder) {
                            retObjs.add(res[i]);
                        } else if (res[i] instanceof IFile && "table".equals(((IFile)res[i]).getFileExtension())) {
                            retObjs.add(res[i]);
                        }
                        ++i;
                    }
                    return retObjs.toArray();
                }
                catch (CoreException e) {
                    return null;
                }
            }
            return null;
        }

        public Object[] getChildren(Object parentElement) {
            return this.getElements(parentElement);
        }

        public boolean hasChildren(Object element) {
            return element instanceof IProject || element instanceof IFolder;
        }

        public Object getParent(Object element) {
            return null;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

