/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.emp.ide.table.upgrade;

import com.ecc.ide.editor.XMLNode;
import java.util.Vector;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class SortFieldSelectDialog
extends TitleAreaDialog {
    private Table table;
    private TableViewer tableViewer;
    private XMLNode modelNode = null;
    private String orderFields = null;

    public SortFieldSelectDialog(Shell parentShell, XMLNode xmlNode, String orderFields) {
        super(parentShell);
        this.modelNode = xmlNode;
        this.orderFields = orderFields;
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        this.setTitle("\u6392\u5e8f\u5b57\u6bb5\u9009\u62e9");
        this.setMessage("\u9009\u62e9\u9700\u8981\u7684\u6392\u5e8f\u5b57\u6bb5\uff0c\u8bbe\u5b9a\u6392\u5e8f\u65b9\u5f0f\uff0c\u9ed8\u8ba4\u4e3a\u6392\u5e8f\u65b9\u5f0f\u4e3a\u964d\u5e8f");
        Composite container = new Composite(area, 0);
        GridLayout layout = new GridLayout(1, true);
        layout.marginLeft = 10;
        layout.marginRight = 10;
        layout.marginTop = 10;
        layout.marginBottom = 10;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(1808));
        Label label = new Label(container, 0);
        label.setText("\u6392\u5e8f\u5b57\u6bb5");
        this.table = new Table(container, 68388);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        TableColumn sortColumn = new TableColumn(this.table, 0);
        sortColumn.setWidth(70);
        sortColumn.setText("\u53c2\u4e0e\u6392\u5e8f");
        TableColumn idColumn = new TableColumn(this.table, 0);
        idColumn.setWidth(100);
        idColumn.setText("\u5b57\u6bb5\u540d\u79f0");
        TableColumn nameColumn = new TableColumn(this.table, 0);
        nameColumn.setWidth(200);
        nameColumn.setText("\u5b57\u6bb5\u63cf\u8ff0");
        TableColumn styleColumn = new TableColumn(this.table, 0);
        styleColumn.setWidth(100);
        styleColumn.setText("\u6392\u5e8f\u65b9\u5f0f");
        GridData gd_leftList = new GridData(4, 4, true, true);
        this.table.setLayoutData((Object)gd_leftList);
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
        this.tableViewer = new TableViewer(this.table);
        ComboBoxCellEditor modeEditor = new ComboBoxCellEditor((Composite)this.table, new String[]{"", "asc", "desc"}, 8);
        CellEditor[] cellEditorArray = new CellEditor[4];
        cellEditorArray[3] = modeEditor;
        this.tableViewer.setCellEditors(cellEditorArray);
        this.tableViewer.setColumnProperties(new String[]{"", "", "", "sort"});
        this.tableViewer.setCellModifier(new ICellModifier(){

            public void modify(Object element, String property, Object value) {
                TableItem item = (TableItem)element;
                if (value != null) {
                    if (value.equals(new Integer(0))) {
                        item.setText(3, "");
                    } else if (value.equals(new Integer(1))) {
                        item.setText(3, "asc");
                    } else if (value.equals(new Integer(2))) {
                        item.setText(3, "desc");
                    }
                }
            }

            public Object getValue(Object element, String property) {
                if (element != null) {
                    if (element.equals("")) {
                        return new Integer(0);
                    }
                    if (element.equals("asc")) {
                        return new Integer(1);
                    }
                    if (element.equals("desc")) {
                        return new Integer(2);
                    }
                }
                return new Integer(0);
            }

            public boolean canModify(Object element, String property) {
                return true;
            }
        });
        this.initData(this.table);
        return area;
    }

    protected void initData(Table table) {
        Vector fieldNodeVector = this.modelNode.getChilds();
        int i = 0;
        while (i < fieldNodeVector.size()) {
            XMLNode fieldNode = (XMLNode)fieldNodeVector.get(i);
            if (fieldNode.getNodeName().equals("Field")) {
                TableItem item = new TableItem(table, 0);
                String id = fieldNode.getAttrValue("id");
                String name = fieldNode.getAttrValue("cnname");
                String[] rolData = new String[]{"", id, name, ""};
                item.setText(rolData);
                String[] orderField = this.orderFields.split(";");
                int j = 0;
                while (j < orderField.length) {
                    String fvalue = orderField[j];
                    String svalue = "";
                    if (fvalue.indexOf("[") > 0) {
                        svalue = fvalue.substring(fvalue.indexOf("[") + 1, fvalue.indexOf("]"));
                        fvalue = fvalue.substring(0, fvalue.indexOf("["));
                    }
                    if (id.equals(fvalue)) {
                        item.setChecked(true);
                        item.setText(3, svalue);
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void okPressed() {
        String orderString = "";
        TableItem[] items = this.table.getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i].getChecked()) {
                orderString = String.valueOf(orderString) + items[i].getText(1);
                if (items[i].getText(3) != null && items[i].getText(3).length() > 0) {
                    orderString = String.valueOf(orderString) + "[" + items[i].getText(3) + "]";
                }
                orderString = String.valueOf(orderString) + ";";
            }
            ++i;
        }
        this.setOrderFields(orderString);
        super.okPressed();
    }

    protected Point getInitialSize() {
        return new Point(600, 375);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("\u6392\u5e8f\u5b57\u6bb5");
    }

    public String getOrderFields() {
        return this.orderFields;
    }

    public void setOrderFields(String orderFields) {
        this.orderFields = orderFields;
    }
}

