/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.emp.ide.table.upgrade;

import com.ecc.emp.ide.table.upgrade.FieldEditorPage;
import com.ecc.emp.ide.table.upgrade.ModelEditorPage;
import com.ecc.ide.base.IDEConstance;
import com.ecc.ide.base.IDEContent;
import com.ecc.ide.editor.ContentChangedEvent;
import com.ecc.ide.editor.ContentChangedListener;
import com.ecc.ide.editor.XMLElementObjectMaker;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.plugin.properties.IDEProjectSettings;
import com.ecc.util.xmlloader.ObjectMaker;
import com.ecc.util.xmlloader.XMLLoader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.MultiPageEditorPart;

public class TableModelEditor
extends MultiPageEditorPart
implements ContentChangedListener {
    private ModelEditorPage modelPage = null;
    private FieldEditorPage fieldPage = null;
    private IFile tmFile = null;
    private boolean isChanged = false;
    private XMLNode tableModelNode = null;
    private IDEProjectSettings prjSettings = null;
    private IProject project = null;
    private XMLLoader loader = null;
    private XMLNode serviceNode = null;

    protected void createPages() {
        try {
            this.tableModelNode = this.loadXMLNode(this.tmFile);
            this.tableModelNode.addContentChangedListener(this, this.tmFile.getProject(), 0);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        XMLNode modelNode = this.tableModelNode.getChild("TableModel");
        this.modelPage = new ModelEditorPage(modelNode, this.project, this.getContainer(), 0);
        int idx = this.addPage((Control)this.modelPage);
        this.setPageText(idx, "\u6570\u636e\u6a21\u578b\u5b9a\u4e49");
        this.fieldPage = new FieldEditorPage(this.tableModelNode, this.project, this.getContainer(), 0);
        this.fieldPage.setDefaultPkGenerators(this.serviceNode);
        idx = this.addPage((Control)this.fieldPage);
        this.setPageText(idx, "\u5b57\u6bb5\u5b9a\u4e49");
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        if (!(input instanceof IFileEditorInput)) {
            throw new PartInitException("Invalid Input: Must be IFileEditorInput");
        }
        super.init(site, input);
        IFileEditorInput fileInput = (IFileEditorInput)input;
        this.tmFile = fileInput.getFile();
        this.project = this.tmFile.getProject();
        this.setTitle(this.tmFile.getName());
        try {
            XMLNode prjSettingsNode = IDEContent.getSettingNode(this.project, 35);
            this.prjSettings = new IDEProjectSettings(prjSettingsNode);
        }
        catch (Exception e) {
            throw new PartInitException("PrjSettings\u52a0\u8f7d\u5931\u8d25\uff01", (Throwable)e);
        }
        try {
            IFile svcDesignFile = IDEContent.getFile(this.project, "services", "xml");
            String bizGrpId = IDEContent.getGroupId(svcDesignFile.getLocation().toOSString());
            String webContentPath = this.prjSettings.getWebContentPath();
            IFile svcContentFile = this.project.getFile(String.valueOf(webContentPath) + "/WEB-INF/bizs/" + bizGrpId + "/services.xml");
            this.serviceNode = this.loadXMLNode(svcContentFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void doSave(IProgressMonitor monitor) {
        if (this.tableModelNode == null) {
            return;
        }
        StringBuffer strBuf = new StringBuffer();
        String encoding = IDEConstance.encoding;
        if (this.prjSettings.getSetXMLEncodeManually()) {
            this.tableModelNode.setEncoding(this.prjSettings.getXMLEncoding());
            encoding = this.prjSettings.getXMLEncoding();
        }
        this.tableModelNode.toXMLContent(0, strBuf);
        try {
            FileEditorInput input = (FileEditorInput)this.getEditorInput();
            input.getFile().setContents((InputStream)new ByteArrayInputStream(strBuf.toString().getBytes(encoding)), 1, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.isChanged = false;
        this.firePropertyChange(257);
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isDirty() {
        return this.isChanged;
    }

    public void contentChanged(ContentChangedEvent event) {
        if (!this.isChanged) {
            this.isChanged = true;
            this.firePropertyChange(257);
            this.firePropertyChange(258);
        }
    }

    private XMLNode loadXMLNode(IFile file) throws CoreException, Exception {
        if (this.loader == null) {
            this.loader = new XMLLoader();
            this.loader.addObjectMaker((ObjectMaker)new XMLElementObjectMaker());
        }
        return (XMLNode)this.loader.loadXMLContent(file.getContents());
    }
}

