/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.emp.ide.table.upgrade;

import com.ecc.ide.base.IDEContent;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.plugin.ECCIDEPlugin;
import com.ecc.ide.plugin.properties.IDEProjectSettings;
import com.swtdesigner.ResourceManager;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

public class TableSynchDialog
extends TitleAreaDialog {
    private Table table;
    private Text dbTableText;
    private Text dbUrlText;
    private XMLNode modelNode = null;
    private IProject project = null;
    private TableViewer columnTableViewer = null;
    private List synchList = new ArrayList();
    private Button synchButton = null;

    public TableSynchDialog(Shell parentShell, IProject prj, XMLNode mNode) {
        super(parentShell);
        this.project = prj;
        this.modelNode = mNode.getChild("TableModel");
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayout((Layout)new GridLayout(3, false));
        container.setLayoutData((Object)new GridData(1808));
        Label label = new Label(container, 0);
        label.setText("\u6570\u636e\u5e93\u8fde\u63a5\uff1a");
        this.dbUrlText = new Text(container, 2048);
        this.dbUrlText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.dbUrlText.setEnabled(false);
        IDEProjectSettings settings = IDEContent.getPRJSettings(this.project);
        String url = settings.getSettingsNode().findChild("dbURL").getNodeValue();
        this.dbUrlText.setText(url);
        Label label_1 = new Label(container, 0);
        label_1.setText("\u7269\u7406\u8868\u540d\uff1a");
        this.dbTableText = new Text(container, 2048);
        this.dbTableText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.dbTableText.setEnabled(false);
        String tableName = this.modelNode.getAttrValue("dbTableName");
        this.dbTableText.setText(tableName);
        final Button button = new Button(container, 0);
        button.setLayoutData((Object)new GridData());
        button.setText("   \u6bd4\u5bf9   ");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableSynchDialog.this.setMessage("\u6570\u636e\u5e93\u6bd4\u5bf9\u6b63\u5728\u8fdb\u884c\uff0c\u8bf7\u7a0d\u540e...");
                button.setEnabled(false);
                TableSynchDialog.this.synchTableModel();
            }
        });
        Label label_2 = new Label(container, 0);
        label_2.setText("\u540c\u6b65\u5217\u8868\uff1a");
        label_2.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 3, 1));
        this.columnTableViewer = new TableViewer(container, 67586);
        this.columnTableViewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        this.columnTableViewer.setContentProvider((IContentProvider)new TableContentProvider());
        this.columnTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)TableSynchDialog.this.columnTableViewer.getSelection();
                if (!selection.isEmpty()) {
                    TableSynchDialog.this.synchButton.setEnabled(true);
                }
            }
        });
        this.table = this.columnTableViewer.getTable();
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        this.table.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        TableColumn imageCol = new TableColumn(this.table, 0);
        imageCol.setWidth(25);
        imageCol.setText("");
        TableColumn idCol = new TableColumn(this.table, 0);
        idCol.setWidth(85);
        idCol.setText("ID");
        TableColumn cnnameCol = new TableColumn(this.table, 0);
        cnnameCol.setWidth(100);
        cnnameCol.setText("\u4e2d\u6587\u540d\u79f0");
        TableColumn dbFieldCol = new TableColumn(this.table, 0);
        dbFieldCol.setWidth(100);
        dbFieldCol.setText("\u7269\u7406\u5b57\u6bb5");
        TableColumn typeCol = new TableColumn(this.table, 0);
        typeCol.setWidth(80);
        typeCol.setText("\u5b57\u6bb5\u7c7b\u578b");
        TableColumn lengthCol = new TableColumn(this.table, 0);
        lengthCol.setWidth(80);
        lengthCol.setText("\u5b57\u6bb5\u957f\u5ea6");
        this.synchButton = new Button(container, 0);
        this.synchButton.setText("\u540c\u6b65\u9009\u5b9a\u5b57\u6bb5");
        this.synchButton.setEnabled(false);
        this.synchButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection select = (IStructuredSelection)TableSynchDialog.this.columnTableViewer.getSelection();
                XMLNode node = (XMLNode)select.getFirstElement();
                if (node == null) {
                    return;
                }
                if ("ColumnInfo".equals(node.getNodeName())) {
                    String columnName = node.getAttrValue("columnName");
                    XMLNode fieldNode = new XMLNode("Field");
                    fieldNode.setAttrValue("id", columnName.toLowerCase());
                    fieldNode.setAttrValue("columnName", columnName.toLowerCase());
                    fieldNode.setAttrValue("cnname", columnName);
                    fieldNode.setAttrValue("JDBCType", node.getAttrValue("JDBCType"));
                    fieldNode.setAttrValue("length", node.getAttrValue("length"));
                    fieldNode.setAttrValue("JSPTag", "text");
                    TableSynchDialog.this.modelNode.add(fieldNode);
                    TableSynchDialog.this.synchList.remove(node);
                    TableSynchDialog.this.columnTableViewer.refresh();
                } else if ("Field".equals(node.getNodeName())) {
                    TableSynchDialog.this.modelNode.remove(node);
                    TableSynchDialog.this.synchList.remove(node);
                    TableSynchDialog.this.columnTableViewer.refresh();
                }
                super.widgetSelected(e);
            }
        });
        Group noteComp = new Group(container, 0);
        noteComp.setLayoutData((Object)new GridData(4, 1, true, false, 3, 2));
        noteComp.setFont(new Font(null, "Tahoma", 10, 1));
        noteComp.setText("Note:");
        noteComp.setLayout((Layout)new GridLayout(1, false));
        CLabel lable_1 = new CLabel((Composite)noteComp, 0);
        lable_1.setImage(ResourceManager.getPluginImage((Object)ECCIDEPlugin.getDefault(), "icons/tablemodel/update.png"));
        lable_1.setText(": \u66f4\u65b0\u8868\u6a21\u578b\u7684\u7f3a\u5c11\u9879");
        CLabel lable_2 = new CLabel((Composite)noteComp, 0);
        lable_2.setImage(ResourceManager.getPluginImage((Object)ECCIDEPlugin.getDefault(), "icons/tablemodel/delete.png"));
        lable_2.setText(": \u5220\u9664\u8868\u6a21\u578b\u7684\u591a\u4f59\u9879");
        this.setTitle("\u6570\u636e\u5e93\u7269\u7406\u8868\u540c\u6b65");
        return area;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1, IDialogConstants.CLOSE_LABEL, true);
    }

    protected Point getInitialSize() {
        return new Point(500, 500);
    }

    private void synchTableModel() {
        try {
            ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.getShell());
            IRunnableWithProgress thread = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        Connection connection = TableSynchDialog.this.getDBConnection(TableSynchDialog.this.project);
                        String tableName = TableSynchDialog.this.modelNode.getAttrValue("dbTableName");
                        XMLNode tableInfo = TableSynchDialog.this.loadTableDataMeta(connection, tableName);
                        int i = 0;
                        while (i < tableInfo.getChilds().size()) {
                            XMLNode columnInfo = (XMLNode)tableInfo.getChilds().elementAt(i);
                            if ("ColumnInfo".equals(columnInfo.getNodeName()) && TableSynchDialog.this.modelNode.findChildNodeWithAttrValue("Field", "columnName", columnInfo.getAttrValue("columnName").toLowerCase()) == null) {
                                TableSynchDialog.this.synchList.add(columnInfo);
                            }
                            ++i;
                        }
                        i = 0;
                        while (i < TableSynchDialog.this.modelNode.getChilds().size()) {
                            XMLNode fieldNode = (XMLNode)TableSynchDialog.this.modelNode.getChilds().elementAt(i);
                            if ("Field".equals(fieldNode.getNodeName()) && tableInfo.findChildNodeWithAttrValue("ColumnInfo", "columnName", fieldNode.getAttrValue("columnName").toUpperCase()) == null) {
                                TableSynchDialog.this.synchList.add(fieldNode);
                            }
                            ++i;
                        }
                        Display.getDefault().asyncExec(new Runnable(this){
                            final /* synthetic */ 4 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            public void run() {
                                TableSynchDialog.access$1(4.access$0(this.this$1)).setInput((Object)TableSynchDialog.access$4(4.access$0(this.this$1)));
                                4.access$0(this.this$1).setMessage("\u6570\u636e\u5e93\u6bd4\u5bf9\u5b8c\u6210\uff01");
                            }
                        });
                    }
                    catch (Exception e) {
                        String s = e.toString();
                        Display.getDefault().asyncExec(new Runnable(this, s){
                            final /* synthetic */ 4 this$1;
                            private final /* synthetic */ String val$s;
                            {
                                this.this$1 = var1_1;
                                this.val$s = string;
                            }

                            public void run() {
                                MessageDialog.openError((Shell)4.access$0(this.this$1).getShell(), (String)"ERROR", (String)("DB Connection failed:" + this.val$s));
                            }
                        });
                        e.printStackTrace();
                    }
                }

                static /* synthetic */ TableSynchDialog access$0(4 var0) {
                    return var0.TableSynchDialog.this;
                }
            };
            dialog.run(true, true, thread);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private Connection getDBConnection(IProject prj) throws Exception {
        IDEProjectSettings settings = IDEContent.getPRJSettings(prj);
        String driverName = settings.getSettingsNode().findChild("driverName").getNodeValue();
        String dbURL = settings.getSettingsNode().findChild("dbURL").getNodeValue();
        String userId = settings.getSettingsNode().findChild("userName").getNodeValue();
        String password = settings.getSettingsNode().findChild("password").getNodeValue();
        Class<?> aclass = Class.forName(driverName);
        Driver driver = (Driver)aclass.newInstance();
        DriverManager.registerDriver(driver);
        return DriverManager.getConnection(dbURL, userId, password);
    }

    private XMLNode loadTableDataMeta(Connection connection, String tableName) throws Exception {
        XMLNode tableInfo = new XMLNode("TableInfo");
        tableInfo.setAttrValue("id", tableName);
        Statement state = connection.createStatement();
        HashMap columnMap = new HashMap();
        String strSQL = "Select * from " + tableName + " Where 1=0";
        ResultSet rs = state.executeQuery(strSQL);
        ResultSetMetaData metaData = rs.getMetaData();
        DatabaseMetaData dbMetaData = connection.getMetaData();
        ResultSet rs_pk = dbMetaData.getPrimaryKeys(null, null, tableName);
        HashMap pkMap = new HashMap();
        while (rs_pk.next()) {
            pkMap.put(rs_pk.getString(4), null);
        }
        int i = 1;
        while (i <= metaData.getColumnCount()) {
            String columnName = metaData.getColumnName(i);
            String columnTypeName = metaData.getColumnTypeName(i);
            int precision = metaData.getPrecision(i);
            int nullable = metaData.isNullable(i);
            XMLNode columnInfo = new XMLNode("ColumnInfo");
            tableInfo.add(columnInfo);
            columnInfo.setAttrValue("id", columnName);
            columnInfo.setAttrValue("columnName", columnName);
            columnInfo.setAttrValue("cnname", columnName);
            columnInfo.setAttrValue("JDBCType", columnTypeName);
            columnInfo.setAttrValue("length", String.valueOf(precision));
            columnInfo.setAttrValue("JSPTag", "text");
            if (nullable == 0) {
                columnInfo.setAttrValue("canBeNull", "true");
            }
            if (pkMap.containsKey(columnName)) {
                columnInfo.setAttrValue("isPK", "true");
            }
            ++i;
        }
        rs.close();
        if (this.getDataBaseType(connection).equals("ORACLE")) {
            strSQL = "select column_name, comments from sys.user_col_comments where table_name='" + tableName.toUpperCase() + "'";
            rs = state.executeQuery(strSQL);
            while (rs.next()) {
                String columnName = rs.getString(1);
                String comment = rs.getString(2);
                XMLNode colInfo = tableInfo.findChildNodeWithAttrValue("ColumnInfo", "columnName", columnName);
                if (colInfo == null || comment == null || comment.trim().length() <= 0) continue;
                colInfo.setAttrValue("cnname", comment);
            }
            rs.close();
        }
        state.close();
        return tableInfo;
    }

    private String getDataBaseType(Connection con) {
        if (con == null) {
            return "";
        }
        String dbType = con.toString().toUpperCase();
        if (dbType.indexOf("ORACLE") > -1) {
            return "ORACLE";
        }
        if (dbType.indexOf("DB2") > -1) {
            return "DB2";
        }
        return "";
    }

    class TableLabelProvider
    implements ITableLabelProvider {
        TableLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof XMLNode) {
                XMLNode node = (XMLNode)element;
                if (columnIndex == 1) {
                    return node.getAttrValue("id").toLowerCase();
                }
                if (columnIndex == 2) {
                    return node.getAttrValue("cnname");
                }
                if (columnIndex == 3) {
                    return node.getAttrValue("columnName").toLowerCase();
                }
                if (columnIndex == 4) {
                    return node.getAttrValue("JDBCType");
                }
                if (columnIndex == 5) {
                    return node.getAttrValue("length");
                }
            }
            return null;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (element instanceof XMLNode) {
                XMLNode node = (XMLNode)element;
                if ("Field".equals(node.getNodeName()) && columnIndex == 0) {
                    return ResourceManager.getPluginImage((Object)ECCIDEPlugin.getDefault(), "icons/tablemodel/delete.png");
                }
                if ("ColumnInfo".equals(node.getNodeName()) && columnIndex == 0) {
                    return ResourceManager.getPluginImage((Object)ECCIDEPlugin.getDefault(), "icons/tablemodel/update.png");
                }
            }
            return null;
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void dispose() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    class TableContentProvider
    implements IStructuredContentProvider {
        TableContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof List) {
                ArrayList inputList = (ArrayList)inputElement;
                return inputList.toArray();
            }
            return null;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }
}

