/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.ant;

import com.ecc.ide.base.IDEContent;
import com.ecc.ide.plugin.properties.IDEProjectSettings;
import com.ecc.ide.plugin.views.PrjViewPanel;
import java.util.Hashtable;
import org.apache.tools.ant.BuildListener;
import org.eclipse.core.resources.IProject;

public class AntObject {
    protected Hashtable properties = new Hashtable();
    public PrjViewPanel panel;
    private BuildListener buildListener;
    protected String file = "";
    protected String target = "";
    protected String title = "EMP IDE Output";
    protected IProject project = null;

    public AntObject(String target, String title, IProject project, BuildListener listener) {
        this.target = target;
        this.title = title;
        this.project = project;
        this.buildListener = listener;
        this.initProperties();
    }

    public AntObject(String file, String target, String title, IProject project, BuildListener listener) {
        this.file = file;
        this.target = target;
        this.title = title;
        this.project = project;
        this.buildListener = listener;
        this.initProperties();
    }

    private void initProperties() {
        String srcPath;
        if (this.project == null) {
            return;
        }
        IDEProjectSettings settings = IDEContent.getPRJSettings(this.project);
        String webContentPath = settings.getWebContentPath();
        if (webContentPath != null && webContentPath.length() > 0) {
            this.setProperty("destPath", webContentPath);
        }
        if ((srcPath = settings.getSrcPath()) != null && srcPath.length() > 0) {
            this.setProperty("javaSrcPath", srcPath);
        }
    }

    public void setProperty(String name, String value) {
        this.properties.put(name, value);
    }

    public BuildListener getBuildListener() {
        return this.buildListener;
    }
}

