/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.ant;

import com.ecc.emp.ide.builder.EMPBuilder;
import com.ecc.ide.ant.BuildTask;
import com.ecc.ide.base.IDEProfile;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editorprofile.EditorProfile;
import org.eclipse.core.resources.IFile;

public class BuildChannelAccessTask
extends BuildTask {
    public static String compileType = "acc";

    protected void compile(IFile file) {
        if (compileType.equals(file.getFileExtension())) {
            try {
                String outputFolder = String.valueOf(this.destPath) + "/";
                String fileName = file.getName();
                String channelName = fileName.substring(0, fileName.lastIndexOf("."));
                BuildChannelAccessTask.makeFolder(this.getEclipseProject(), outputFolder);
                String outFile = String.valueOf(this.getEclipseProject().getLocation().toString()) + "/" + outputFolder + channelName + ".xml";
                XMLNode curNode = this.loadXMLContent(file.getLocation().toOSString());
                String className = curNode.getAttrValue("builder");
                if (className == null || className.length() == 0) {
                    className = "com.ecc.emp.ide.builder.ChannelBuilder";
                }
                EMPBuilder builder = this.getBuilder(className);
                builder.saveXMLFile(this.getEclipseProject(), outFile, curNode, "");
                this.toConsole(String.valueOf(file.getFullPath().toOSString()) + " is build.");
                try {
                    this.buildWebXML(channelName, curNode);
                    this.getEclipseProject().refreshLocal(2, null);
                }
                catch (Exception exception) {}
            }
            catch (Exception e) {
                this.toConsole(String.valueOf(file.getName()) + " is build fail." + e);
            }
        }
    }

    private void buildWebXML(String channelName, XMLNode xmlNode) throws Exception {
        XMLNode webxmlNode = this.getWebXmlNode();
        if (this.getServletNode(webxmlNode, channelName) != null) {
            this.toConsole("web.xml is ignored.");
            return;
        }
        webxmlNode.add(this.getServletNode(channelName, xmlNode));
        webxmlNode.add(this.getServletMappingNode(channelName));
        this.sortAndSaveWebXml(webxmlNode);
    }

    public XMLNode getServletNode(String channelName, XMLNode xmlNode) throws Exception {
        EditorProfile profile = IDEProfile.getEditorProfile(this.getEclipseProject(), 31);
        String servletClassName = profile.getElement(xmlNode.getNodeName()).getImplClass();
        XMLNode servletNode = null;
        String factoryName = xmlNode.getAttrValue("factoryName");
        String sessionIdField = xmlNode.getAttrValue("sessionIdField");
        try {
            servletNode = new XMLNode("servlet");
            XMLNode child1Node = new XMLNode("servlet-name");
            XMLNode child2Node = new XMLNode("servlet-class");
            XMLNode child3Node = new XMLNode("init-param");
            XMLNode child4Node = new XMLNode("param-name");
            XMLNode child5Node = new XMLNode("param-value");
            XMLNode child6Node = new XMLNode("init-param");
            XMLNode child7Node = new XMLNode("param-name");
            XMLNode child8Node = new XMLNode("param-value");
            XMLNode child9Node = new XMLNode("init-param");
            XMLNode child10Node = new XMLNode("param-name");
            XMLNode child11Node = new XMLNode("param-value");
            XMLNode child12Node = new XMLNode("init-param");
            XMLNode child13Node = new XMLNode("param-name");
            XMLNode child14Node = new XMLNode("param-value");
            XMLNode child15Node = new XMLNode("load-on-startup");
            XMLNode servlet_name = new XMLNode("#text");
            XMLNode servlet_class = new XMLNode("#text");
            XMLNode param_name1 = new XMLNode("#text");
            XMLNode param_value1 = new XMLNode("#text");
            XMLNode param_name2 = new XMLNode("#text");
            XMLNode param_value2 = new XMLNode("#text");
            XMLNode param_name3 = new XMLNode("#text");
            XMLNode param_value3 = new XMLNode("#text");
            XMLNode param_name4 = new XMLNode("#text");
            XMLNode param_value4 = new XMLNode("#text");
            XMLNode load_on_startup = new XMLNode("#text");
            servlet_name.setTextValue(channelName);
            servlet_class.setTextValue(servletClassName);
            param_name1.setTextValue("factoryName");
            param_value1.setTextValue(factoryName);
            param_name2.setTextValue("servletContextFile");
            param_value2.setTextValue("WEB-INF/channels/" + channelName + ".xml");
            param_name3.setTextValue("sessionIdField");
            param_value3.setTextValue(sessionIdField);
            param_name4.setTextValue("iniFile");
            param_value4.setTextValue("WEB-INF/bizs/" + factoryName + "/settings.xml");
            load_on_startup.setTextValue("1");
            servletNode.add(child1Node);
            servletNode.add(child2Node);
            servletNode.add(child3Node);
            servletNode.add(child6Node);
            servletNode.add(child9Node);
            servletNode.add(child12Node);
            servletNode.add(child15Node);
            child3Node.add(child4Node);
            child3Node.add(child5Node);
            child6Node.add(child7Node);
            child6Node.add(child8Node);
            child9Node.add(child10Node);
            child9Node.add(child11Node);
            child12Node.add(child13Node);
            child12Node.add(child14Node);
            child1Node.add(servlet_name);
            child2Node.add(servlet_class);
            child4Node.add(param_name1);
            child5Node.add(param_value1);
            child7Node.add(param_name2);
            child8Node.add(param_value2);
            child10Node.add(param_name3);
            child11Node.add(param_value3);
            child13Node.add(param_name4);
            child14Node.add(param_value4);
            child15Node.add(load_on_startup);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return servletNode;
    }

    private XMLNode getServletMappingNode(String str) {
        XMLNode servletMappingNode = new XMLNode();
        XMLNode child1Node = new XMLNode();
        XMLNode child2Node = new XMLNode();
        XMLNode servlet_name = new XMLNode();
        XMLNode url_pattern = new XMLNode();
        servletMappingNode.setNodeName("servlet-mapping");
        child1Node.setNodeName("servlet-name");
        child2Node.setNodeName("url-pattern");
        servlet_name.setNodeName("#text");
        url_pattern.setNodeName("#text");
        servlet_name.setTextValue(str);
        url_pattern.setTextValue("/" + str + "/*");
        servletMappingNode.add(child1Node);
        servletMappingNode.add(child2Node);
        child1Node.add(servlet_name);
        child2Node.add(url_pattern);
        return servletMappingNode;
    }
}

