/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.ant;

import com.ecc.emp.ide.builder.EMPBuilder;
import com.ecc.ide.ant.BuildTask;
import com.ecc.ide.ant.RunAntInIDE;
import com.ecc.ide.classloader.DynamicClassLoader;
import com.ecc.ide.editor.XMLNode;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;

public class BuildEMPFilesTask
extends BuildTask {
    private String compileType;
    private String outputFolder;

    public void setOutputFolder(String str) {
        this.outputFolder = str;
    }

    public void setCompileType(String type) {
        this.compileType = type;
    }

    protected void compile(IFile file) {
        if (this.compileType.equals(file.getFileExtension())) {
            IFolder folder = null;
            try {
                folder = this.getEclipseProject().getFolder(this.destPath);
                BuildTask.makeFolder(this.getEclipseProject(), this.destPath);
                if (!folder.exists()) {
                    folder.create(true, true, null);
                }
                if (!folder.exists()) {
                    folder.create(true, true, null);
                }
                this.outputFolder = folder.getLocation().toOSString();
            }
            catch (Exception exception) {
                // empty catch block
            }
            XMLNode curNode = this.loadXMLContent(file.getLocation().toOSString());
            if (curNode.getAttrValue("builder") != null) {
                try {
                    String fileId = file.getName();
                    fileId = fileId.substring(0, fileId.indexOf(file.getFileExtension()) - 1);
                    String className = curNode.getAttrValue("builder");
                    EMPBuilder builder = null;
                    try {
                        builder = (EMPBuilder)Class.forName(className).newInstance();
                    }
                    catch (Exception e) {
                        builder = (EMPBuilder)DynamicClassLoader.loadDynamicObject(this.getEclipseProject(), className);
                    }
                    String fileName = file.getName();
                    fileName = fileName.substring(0, fileName.lastIndexOf("."));
                    String outputFileName = String.valueOf(folder.getLocation().toOSString()) + "\\" + fileName + ".xml";
                    builder.saveXMLFile(this.getEclipseProject(), outputFileName, curNode, fileId);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ++RunAntInIDE.buildCounter;
            this.toConsole("\"" + file.getFullPath().toOSString() + "\" is build.");
            try {
                folder.refreshLocal(2, null);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
    }
}

