/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.ant;

import com.ecc.ide.ant.BuildJspTask;
import com.ecc.ide.ant.RunAntInIDE;
import com.ecc.ide.base.IDEContent;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;

public class BuildFileTaskByRename
extends BuildJspTask {
    private String fileSet = "";
    private String targetExt = "xml";
    private String appendPath = "";

    protected void compile(IFile file) {
        String extName = file.getFileExtension();
        String[] exts = this.getArrayFromStr(this.fileSet);
        boolean flag = false;
        int i = 0;
        while (i < exts.length) {
            if (exts[i].equals(extName)) {
                flag = true;
                break;
            }
            ++i;
        }
        if (!flag) {
            return;
        }
        String newFileName = String.valueOf(file.getName().substring(0, file.getName().lastIndexOf("."))) + "." + this.targetExt;
        this.subFolder = IDEContent.getSubFolder(file.getFullPath().toOSString(), file.getName());
        String groupId = IDEContent.getGroupId(file.getFullPath().toOSString());
        String outputFolder = String.valueOf(this.destPath) + "/" + groupId + "/";
        if (this.subFolder.length() > 0) {
            outputFolder = String.valueOf(outputFolder) + this.subFolder + "/";
        }
        if (this.appendPath != null && this.appendPath.length() > 0) {
            outputFolder = String.valueOf(outputFolder) + this.appendPath + "/";
        }
        BuildFileTaskByRename.makeFolder(this.getEclipseProject(), outputFolder);
        boolean result = this.copy(file.getLocation().toOSString(), String.valueOf(this.getEclipseProject().getLocation().toOSString()) + "/" + outputFolder + newFileName);
        ++RunAntInIDE.buildCounter;
        if (result) {
            this.getProject().log("\"" + file.getFullPath().toOSString() + "\" is build.", 0);
        } else {
            this.getProject().log("\"" + file.getFullPath().toOSString() + "\" is build fail.", 0);
        }
        try {
            IFolder folder = null;
            folder = this.getEclipseProject().getFolder(outputFolder);
            folder.refreshLocal(2, null);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    public void setFileSet(String str) {
        this.fileSet = str;
    }

    public void setTargetExt(String str) {
        this.targetExt = str;
    }

    public void setAppendPath(String appendPath) {
        this.appendPath = appendPath;
    }

    private String[] getArrayFromStr(String str) {
        if (str == null) {
            return null;
        }
        if (str.length() == 0) {
            return null;
        }
        Vector<String> temp = new Vector<String>();
        while (str.indexOf(",") != -1) {
            String value = str.substring(0, str.indexOf(","));
            temp.add(value);
            str = str.substring(str.indexOf(",") + 1);
        }
        temp.add(str);
        String[] result = new String[temp.size()];
        int i = 0;
        while (i < temp.size()) {
            result[i] = (String)temp.elementAt(i);
            ++i;
        }
        return result;
    }
}

